/*
 * Decompiled with CFR 0.152.
 */
package spray.json;

import java.io.Serializable;
import scala.Char$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.math.BigDecimal;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import spray.json.JsFalse$;
import spray.json.JsNull$;
import spray.json.JsNumber;
import spray.json.JsNumber$;
import spray.json.JsString;
import spray.json.JsString$;
import spray.json.JsTrue$;
import spray.json.JsValue;
import spray.json.JsonPrinter$;

public interface JsonPrinter
extends Function1<JsValue, String> {
    public static boolean requiresEncoding(char c) {
        return JsonPrinter$.MODULE$.requiresEncoding(c);
    }

    public static String apply$(JsonPrinter $this, JsValue x) {
        return $this.apply(x);
    }

    @Override
    default public String apply(JsValue x) {
        return this.apply(x, None$.MODULE$, this.apply$default$3());
    }

    public static String apply$(JsonPrinter $this, JsValue x, Option jsonpCallback, StringBuilder sb) {
        return $this.apply(x, jsonpCallback, sb);
    }

    default public String apply(JsValue x, Option<String> jsonpCallback, StringBuilder sb) {
        Serializable serializable;
        Option<String> option = jsonpCallback;
        if (option instanceof Some) {
            String callback = (String)((Some)option).value();
            sb.append(callback).append('(');
            this.print(x, sb);
            serializable = sb.append(')');
        } else if (None$.MODULE$.equals(option)) {
            this.print(x, sb);
            serializable = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        return sb.toString();
    }

    public static Option apply$default$2$(JsonPrinter $this) {
        return $this.apply$default$2();
    }

    default public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    public static StringBuilder apply$default$3$(JsonPrinter $this) {
        return $this.apply$default$3();
    }

    default public StringBuilder apply$default$3() {
        return new StringBuilder(256);
    }

    public void print(JsValue var1, StringBuilder var2);

    public static void printLeaf$(JsonPrinter $this, JsValue x, StringBuilder sb) {
        $this.printLeaf(x, sb);
    }

    default public void printLeaf(JsValue x, StringBuilder sb) {
        JsValue jsValue = x;
        if (JsNull$.MODULE$.equals(jsValue)) {
            sb.append("null");
        } else if (JsTrue$.MODULE$.equals(jsValue)) {
            sb.append("true");
        } else if (JsFalse$.MODULE$.equals(jsValue)) {
            sb.append("false");
        } else if (jsValue instanceof JsNumber) {
            BigDecimal bigDecimal;
            JsNumber jsNumber = JsNumber$.MODULE$.unapply((JsNumber)jsValue);
            BigDecimal x2 = bigDecimal = jsNumber._1();
            sb.append(x2);
        } else if (jsValue instanceof JsString) {
            String string2;
            JsString jsString = JsString$.MODULE$.unapply((JsString)jsValue);
            String x3 = string2 = jsString._1();
            this.printString(x3, sb);
        } else {
            throw new IllegalStateException();
        }
    }

    public static void printString$(JsonPrinter $this, String s2, StringBuilder sb) {
        $this.printString(s2, sb);
    }

    default public void printString(String s2, StringBuilder sb) {
        Serializable serializable;
        sb.append('\"');
        int n = JsonPrinter.firstToBeEncoded$1(s2, JsonPrinter.firstToBeEncoded$default$1$1());
        if (-1 == n) {
            serializable = sb.append(s2);
        } else {
            int first = n;
            sb.append(s2, 0, first);
            JsonPrinter.append$1(s2, sb, first);
            serializable = BoxedUnit.UNIT;
        }
        sb.append('\"');
    }

    public static void printSeq$(JsonPrinter $this, Iterable iterable, Function0 printSeparator, Function1 f) {
        $this.printSeq(iterable, printSeparator, f);
    }

    default public <A> void printSeq(Iterable<A> iterable, Function0<BoxedUnit> printSeparator, Function1<A, BoxedUnit> f) {
        BooleanRef first = BooleanRef.create(true);
        iterable.foreach(a -> {
            if (first$1.elem) {
                boolean bl;
                first$1.elem = bl = false;
            } else {
                printSeparator.apply$mcV$sp();
            }
            f.apply(a);
        });
    }

    private static int firstToBeEncoded$1(String s$1, int ix) {
        int n;
        int n2 = ix;
        while (true) {
            if (n2 == s$1.length()) {
                n = -1;
                break;
            }
            if (JsonPrinter$.MODULE$.requiresEncoding(s$1.charAt(n2))) {
                n = n2;
                break;
            }
            ++n2;
        }
        return n;
    }

    private static int firstToBeEncoded$default$1$1() {
        return 0;
    }

    private static void append$1(String s$2, StringBuilder sb$1, int ix) {
        block9: for (int i = ix; i < s$2.length(); ++i) {
            StringBuilder stringBuilder;
            char c = s$2.charAt(i);
            char c2 = c;
            if (!JsonPrinter$.MODULE$.requiresEncoding(c2)) {
                stringBuilder = sb$1.append(c2);
                continue;
            }
            switch (c) {
                case '\"': {
                    stringBuilder = sb$1.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    stringBuilder = sb$1.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    stringBuilder = sb$1.append("\\b");
                    continue block9;
                }
                case '\f': {
                    stringBuilder = sb$1.append("\\f");
                    continue block9;
                }
                case '\n': {
                    stringBuilder = sb$1.append("\\n");
                    continue block9;
                }
                case '\r': {
                    stringBuilder = sb$1.append("\\r");
                    continue block9;
                }
                case '\t': {
                    stringBuilder = sb$1.append("\\t");
                    continue block9;
                }
                default: {
                    char x = c;
                    if (x <= '\u000f') {
                        stringBuilder = sb$1.append("\\u000").append(Integer.toHexString(Char$.MODULE$.char2int(x)));
                        continue block9;
                    }
                    char x2 = c;
                    if (x2 <= '\u00ff') {
                        stringBuilder = sb$1.append("\\u00").append(Integer.toHexString(Char$.MODULE$.char2int(x2)));
                        continue block9;
                    }
                    char x3 = c;
                    if (x3 <= '\u0fff') {
                        stringBuilder = sb$1.append("\\u0").append(Integer.toHexString(Char$.MODULE$.char2int(x3)));
                        continue block9;
                    }
                    char x4 = c;
                    stringBuilder = sb$1.append("\\u").append(Integer.toHexString(Char$.MODULE$.char2int(x4)));
                    continue block9;
                }
            }
        }
    }
}

