/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.transform;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem$;
import scala.xml.Group;
import scala.xml.Group$;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq$;

public abstract class BasicTransformer
implements Function1<Node, Node> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean unchanged(Node n, Seq<Node> ns) {
        if (ns.length() != 1) return false;
        Object a = ns.head();
        Node node = n;
        if (a != null) {
            if (!a.equals(node)) return false;
            return true;
        }
        if (node == null) return true;
        return false;
    }

    public Seq<Node> transform(Iterator<Node> it, NodeBuffer nb) {
        return it.foldLeft(nb, (Function2<NodeBuffer, Node, NodeBuffer> & Serializable)(_$1, _$2) -> (NodeBuffer)_$1.$plus$plus$eq(this.transform((Node)_$2)));
    }

    public Seq<Node> transform(Seq<Node> ns) {
        Seq changed = (Seq)ns.flatMap((Function1<Node, IterableOnce> & Serializable)n -> this.transform((Node)n));
        if (changed.length() != ns.length() || ((IterableOnceOps)changed.zip(ns)).exists((Function1<Tuple2, boolean> & Serializable)p -> !BoxesRunTime.equals(p._1(), p._2()))) {
            return changed;
        }
        return ns;
    }

    public Seq<Node> transform(Node n) {
        if (n.doTransform()) {
            Seq<Node> nch;
            Node node = n;
            if (node instanceof Group) {
                Seq<Node> seq;
                Group group = Group$.MODULE$.unapply((Group)node);
                Seq<Node> xs = seq = group._1();
                return Group$.MODULE$.apply(this.transform(xs));
            }
            Seq<Node> ch = n.child();
            if (ch == (nch = this.transform(ch))) {
                return n;
            }
            return Elem$.MODULE$.apply(n.prefix(), n.label(), n.attributes(), n.scope(), nch.isEmpty(), NodeSeq$.MODULE$.seqToNodeSeq(nch));
        }
        return n;
    }

    @Override
    public Node apply(Node n) {
        Seq<Node> seq = this.transform(n);
        if (seq.length() > 1) {
            throw new UnsupportedOperationException("transform must return single node for root");
        }
        return (Node)seq.head();
    }
}

