/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.include.sax;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;
import scala.xml.include.CircularIncludeException;
import scala.xml.include.UnavailableResourceException;
import scala.xml.include.sax.EncodingHeuristics$;
import scala.xml.package$;

public class XIncludeFilter
extends XMLFilterImpl {
    private final String XINCLUDE_NAMESPACE;
    private final Stack<URL> bases = new Stack();
    private final Stack<Locator> locators = new Stack();
    private int level = 0;
    private int depth = 0;
    private boolean atRoot = false;

    public XIncludeFilter() {
        this.XINCLUDE_NAMESPACE = "http://www.w3.org/2001/XInclude";
    }

    public final String XINCLUDE_NAMESPACE() {
        return this.XINCLUDE_NAMESPACE;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locators.push(locator);
        String base = locator.getSystemId();
        try {
            this.bases.push(new URL(base));
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnsupportedOperationException(new StringBuilder(24).append("Unrecognized SYSTEM ID: ").append(base).toString());
        }
        super.setDocumentLocator(locator);
    }

    public boolean insideIncludeElement() {
        return this.level != 0;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts1) {
        Attributes atts = atts1;
        if (this.level == 0) {
            URL parentBase;
            String base = atts.getValue("http://www.w3.org/XML/1998/namespace", "base");
            URL currentBase = parentBase = this.bases.peek();
            if (base != null) {
                try {
                    currentBase = new URL(parentBase, base);
                }
                catch (MalformedURLException e) {
                    throw new SAXException(new StringBuilder(20).append("Malformed base URL: ").append(currentBase).toString(), e);
                }
            }
            this.bases.push(currentBase);
            String string2 = uri;
            String string3 = this.XINCLUDE_NAMESPACE();
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                String string4 = localName;
                String string5 = "include";
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    String href = atts.getValue("href");
                    if (href == null) {
                        throw new SAXException("Missing href attribute");
                    }
                    String parse = atts.getValue("parse");
                    if (parse == null) {
                        parse = "xml";
                    }
                    String string6 = parse;
                    String string7 = "text";
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        this.includeTextDocument(href, atts.getValue("encoding"));
                    } else {
                        String string8 = parse;
                        String string9 = "xml";
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            this.includeXMLDocument(href);
                        } else {
                            throw new SAXException(new StringBuilder(35).append("Illegal value for parse attribute: ").append(parse).toString());
                        }
                    }
                    ++this.level;
                    return;
                }
            }
            if (this.atRoot) {
                AttributesImpl attsImpl = new AttributesImpl(atts);
                attsImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "base", "xml:base", "CDATA", currentBase.toExternalForm());
                atts = attsImpl;
                this.atRoot = false;
            }
            super.startElement(uri, localName, qName, atts);
            return;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        String string2 = uri;
        String string3 = this.XINCLUDE_NAMESPACE();
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String string4 = localName;
            String string5 = "include";
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                --this.level;
                return;
            }
        }
        if (this.level == 0) {
            this.bases.pop();
            super.endElement(uri, localName, qName);
            return;
        }
    }

    @Override
    public void startDocument() {
        this.level = 0;
        if (this.depth == 0) {
            super.startDocument();
        }
        ++this.depth;
    }

    @Override
    public void endDocument() {
        this.locators.pop();
        this.bases.pop();
        --this.depth;
        if (this.depth == 0) {
            super.endDocument();
            return;
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.level == 0) {
            super.startPrefixMapping(prefix, uri);
            return;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
        if (this.level == 0) {
            super.endPrefixMapping(prefix);
            return;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.level == 0) {
            super.characters(ch, start, length);
            return;
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
        if (this.level == 0) {
            super.ignorableWhitespace(ch, start, length);
            return;
        }
    }

    @Override
    public void processingInstruction(String target, String data) {
        if (this.level == 0) {
            super.processingInstruction(target, data);
            return;
        }
    }

    @Override
    public void skippedEntity(String name) {
        if (this.level == 0) {
            super.skippedEntity(name);
            return;
        }
    }

    private String getLocation() {
        String locationString = "";
        Locator locator = this.locators.peek();
        String publicID = "";
        String systemID = "";
        int column = -1;
        int line = -1;
        if (locator != null) {
            publicID = locator.getPublicId();
            systemID = locator.getSystemId();
            line = locator.getLineNumber();
            column = locator.getColumnNumber();
        }
        locationString = new StringBuilder(49).append(" in document included from ").append(publicID).append(" at ").append(systemID).append(" at line ").append(line).append(", column ").append(column).toString();
        return locationString;
    }

    private void includeTextDocument(String url, String encoding1) {
        String encoding = encoding1;
        if (encoding == null || encoding.trim().isEmpty()) {
            encoding = "UTF-8";
        }
        URL source = null;
        try {
            URL base = this.bases.peek();
            source = new URL(base, url);
        }
        catch (MalformedURLException e) {
            UnavailableResourceException ex = new UnavailableResourceException(new StringBuilder(17).append("Unresolvable URL ").append(url).append(this.getLocation()).toString());
            ex.setRootCause(e);
            throw new SAXException(new StringBuilder(17).append("Unresolvable URL ").append(url).append(this.getLocation()).toString(), ex);
        }
        try {
            BufferedInputStream in;
            block11: {
                block12: {
                    String contentType;
                    block10: {
                        URLConnection uc = source.openConnection();
                        in = new BufferedInputStream(uc.getInputStream());
                        String encodingFromHeader = uc.getContentEncoding();
                        contentType = uc.getContentType();
                        if (encodingFromHeader == null) break block10;
                        encoding = encodingFromHeader;
                        break block11;
                    }
                    if (contentType == null) break block11;
                    String string2 = contentType = contentType.toLowerCase();
                    String string3 = "text/xml";
                    if (!(string2 == null ? string3 != null : !string2.equals(string3))) break block12;
                    String string4 = contentType;
                    String string5 = "application/xml";
                    if ((string4 == null ? string5 != null : !string4.equals(string5)) && (!contentType.startsWith("text/") || !contentType.endsWith("+xml")) && (!contentType.startsWith("application/") || !contentType.endsWith("+xml"))) break block11;
                }
                encoding = EncodingHeuristics$.MODULE$.readEncodingFromStream(in);
            }
            InputStreamReader reader = new InputStreamReader((InputStream)in, encoding);
            char[] c = new char[1024];
            int charsRead = 0;
            do {
                if ((charsRead = reader.read(c, 0, 1024)) <= 0) continue;
                this.characters(c, 0, charsRead);
            } while (charsRead != -1);
        }
        catch (UnsupportedEncodingException e) {
            throw new SAXException(new StringBuilder(22).append("Unsupported encoding: ").append(encoding).append(this.getLocation()).toString(), e);
        }
        catch (IOException e) {
            throw new SAXException(new StringBuilder(20).append("Document not found: ").append(source.toExternalForm()).append(this.getLocation()).toString(), e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void includeXMLDocument(String url) {
        try {
            v0 = new URL(this.bases.peek(), url);
        }
        catch (MalformedURLException e) {
            ex = new UnavailableResourceException(new StringBuilder(17).append("Unresolvable URL ").append(url).append(this.getLocation()).toString());
            ex.setRootCause(e);
            throw new SAXException(new StringBuilder(17).append("Unresolvable URL ").append(url).append(this.getLocation()).toString(), ex);
        }
        source = v0;
        try {
            v1 = XMLReaderFactory.createXMLReader();
            ** GOTO lbl-1000
        }
        catch (SAXException v2) {
            try {
                v1 = XMLReaderFactory.createXMLReader(package$.MODULE$.XercesClassName());
            }
            catch (SAXException v3) {
                System.err.println("Could not find an XML parser");
                return;
            }
            try lbl-1000:
            // 2 sources

            {
                parser = v1;
                parser.setContentHandler(this);
                resolver = this.getEntityResolver();
                if (resolver != null) {
                    parser.setEntityResolver(resolver);
                }
                previousLevel = this.level;
                this.level = 0;
                if (this.bases.contains(source)) {
                    throw new SAXException("Circular XInclude Reference", new CircularIncludeException(new StringBuilder(31).append("Circular XInclude Reference to ").append(source).append(this.getLocation()).toString()));
                }
                this.bases.push(source);
                this.atRoot = true;
                parser.parse(source.toExternalForm());
                this.level = previousLevel;
                this.bases.pop();
            }
            catch (IOException e) {
                throw new SAXException(new StringBuilder(20).append("Document not found: ").append(source.toExternalForm()).append(this.getLocation()).toString(), e);
            }
        }
    }
}

