/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$ES256$;
import pdi.jwt.JwtAlgorithm$ES384$;
import pdi.jwt.JwtAlgorithm$ES512$;
import pdi.jwt.JwtArrayUtils$;
import pdi.jwt.JwtBase64$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtECDSAAlgorithm;
import pdi.jwt.algorithms.JwtEdDSAAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.algorithms.JwtRSAAlgorithm;
import pdi.jwt.algorithms.JwtUnknownAlgorithm;
import pdi.jwt.exceptions.JwtNonSupportedAlgorithm;
import pdi.jwt.exceptions.JwtSignatureFormatException;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractIterable;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer$;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;

public final class JwtUtils$
implements Serializable {
    private static final String ENCODING;
    private static final String RSA;
    private static final String ECDSA;
    private static final String EdDSA;
    public static final JwtUtils$ MODULE$;

    private JwtUtils$() {
    }

    static {
        MODULE$ = new JwtUtils$();
        ENCODING = "UTF-8";
        RSA = "RSA";
        ECDSA = "EC";
        EdDSA = "EdDSA";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JwtUtils$.class);
    }

    public String ENCODING() {
        return ENCODING;
    }

    public String RSA() {
        return RSA;
    }

    public String ECDSA() {
        return ECDSA;
    }

    public String EdDSA() {
        return EdDSA;
    }

    public String stringify(byte[] arr) {
        return new String(arr, this.ENCODING());
    }

    public byte[] bytify(String str) {
        return str.getBytes(this.ENCODING());
    }

    private String escape(String value) {
        return value.replaceAll("\"", "\\\\\"");
    }

    public String seqToJson(Seq<Object> seq) {
        return ((IterableOnceOps)seq.map((Function1<Object, String> & Serializable)x$1 -> {
            Tuple2 tuple2;
            Object T1;
            Object object = x$1;
            if (object instanceof String) {
                String value = (String)object;
                return new StringBuilder(2).append("\"").append(MODULE$.escape(value)).append("\"").toString();
            }
            if (object instanceof Boolean) {
                boolean value = BoxesRunTime.unboxToBoolean(object);
                if (value) {
                    return "true";
                }
                return "false";
            }
            if (object instanceof Double) {
                double value = BoxesRunTime.unboxToDouble(object);
                return BoxesRunTime.boxToDouble(value).toString();
            }
            if (object instanceof Short) {
                short value = BoxesRunTime.unboxToShort(object);
                return BoxesRunTime.boxToShort(value).toString();
            }
            if (object instanceof Float) {
                float value = BoxesRunTime.unboxToFloat(object);
                return BoxesRunTime.boxToFloat(value).toString();
            }
            if (object instanceof Long) {
                long value = BoxesRunTime.unboxToLong(object);
                return BoxesRunTime.boxToLong(value).toString();
            }
            if (object instanceof Integer) {
                int value = BoxesRunTime.unboxToInt(object);
                return BoxesRunTime.boxToInteger(value).toString();
            }
            if (object instanceof BigDecimal) {
                BigDecimal value = (BigDecimal)object;
                return value.toString();
            }
            if (object instanceof BigInt) {
                BigInt value = (BigInt)object;
                return value.toString();
            }
            if (object instanceof Tuple2 && (T1 = (tuple2 = (Tuple2)object)._1()) instanceof String) {
                String key2 = (String)T1;
                Object value = tuple2._2();
                String string2 = Predef$.MODULE$.ArrowAssoc(key2);
                return MODULE$.hashToJson((Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string2, value)), Nil$.MODULE$)));
            }
            if (object instanceof Object) {
                Object value = object;
                return new StringBuilder(2).append("\"").append(MODULE$.escape(value.toString())).append("\"").toString();
            }
            throw new MatchError(object);
        })).mkString("[", ",", "]");
    }

    public String hashToJson(Seq<Tuple2<String, Object>> hash) {
        return ((IterableOnceOps)hash.map((Function1<Tuple2, String> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Tuple2 tuple22;
                Object T1;
                String string2 = (String)tuple2._1();
                Object T2 = tuple2._2();
                String key2 = string2;
                if (T2 instanceof String) {
                    String value = (String)T2;
                    return new StringBuilder(5).append("\"").append(MODULE$.escape(key2)).append("\":\"").append(MODULE$.escape(value)).append("\"").toString();
                }
                String key3 = string2;
                if (T2 instanceof Boolean) {
                    boolean value = BoxesRunTime.unboxToBoolean(T2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key3)).append("\":").append(value ? "true" : "false").toString();
                }
                String key4 = string2;
                if (T2 instanceof Double) {
                    double value = BoxesRunTime.unboxToDouble(T2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key4)).append("\":").append(BoxesRunTime.boxToDouble(value).toString()).toString();
                }
                String key5 = string2;
                if (T2 instanceof Short) {
                    short value = BoxesRunTime.unboxToShort(T2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key5)).append("\":").append(BoxesRunTime.boxToShort(value).toString()).toString();
                }
                String key6 = string2;
                if (T2 instanceof Float) {
                    float value = BoxesRunTime.unboxToFloat(T2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key6)).append("\":").append(BoxesRunTime.boxToFloat(value).toString()).toString();
                }
                String key7 = string2;
                if (T2 instanceof Long) {
                    long value = BoxesRunTime.unboxToLong(T2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key7)).append("\":").append(BoxesRunTime.boxToLong(value).toString()).toString();
                }
                String key8 = string2;
                if (T2 instanceof Integer) {
                    int value = BoxesRunTime.unboxToInt(T2);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key8)).append("\":").append(BoxesRunTime.boxToInteger(value).toString()).toString();
                }
                String key9 = string2;
                if (T2 instanceof BigDecimal) {
                    BigDecimal value = (BigDecimal)T2;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key9)).append("\":").append(value.toString()).toString();
                }
                String key10 = string2;
                if (T2 instanceof BigInt) {
                    BigInt value = (BigInt)T2;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key10)).append("\":").append(value.toString()).toString();
                }
                String key11 = string2;
                if (T2 instanceof Tuple2 && (T1 = (tuple22 = (Tuple2)T2)._1()) instanceof String) {
                    String vKey = (String)T1;
                    Object vValue = tuple22._2();
                    String string3 = Predef$.MODULE$.ArrowAssoc(vKey);
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key11)).append("\":").append(MODULE$.hashToJson((Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(string3, vValue)), Nil$.MODULE$)))).toString();
                }
                String key12 = string2;
                if (T2 instanceof Seq) {
                    Seq value = (Seq)T2;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key12)).append("\":").append(MODULE$.seqToJson(value)).toString();
                }
                String key13 = string2;
                if (T2 instanceof Set) {
                    Set value = (Set)T2;
                    return new StringBuilder(3).append("\"").append(MODULE$.escape(key13)).append("\":").append(MODULE$.seqToJson(value.toSeq())).toString();
                }
                String key14 = string2;
                if (T2 instanceof Object) {
                    Object value = T2;
                    return new StringBuilder(5).append("\"").append(MODULE$.escape(key14)).append("\":\"").append(MODULE$.escape(value.toString())).append("\"").toString();
                }
            }
            throw new MatchError(tuple2);
        })).mkString("{", ",", "}");
    }

    public String mergeJson(String json, Seq<String> jsonSeq) {
        String string2;
        String string3 = json.trim();
        if ("".equals(string3)) {
            string2 = "";
        } else {
            String value = string3;
            string2 = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(value), 1)), 1);
        }
        String initJson = string2;
        return new StringBuilder(2).append("{").append((Object)((IterableOnceOps)jsonSeq.map((Function1<String, String> & Serializable)_$1 -> _$1.trim())).fold(initJson, (Function2<String, String, String> & Serializable)(x$1, x$2) -> {
            Tuple2<String, String> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                String string2 = tuple2._1();
                String string3 = tuple2._2();
                String j1 = string2;
                String result = string3;
                if (j1.length() < 5) {
                    return StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(result), 1)), 1);
                }
                String result2 = string2;
                String j2 = string3;
                if (j2.length() < 7) {
                    return result2;
                }
                String j12 = string2;
                String j22 = string3;
                return new StringBuilder(1).append(j12).append(",").append(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(j22), 1)), 1)).toString();
            }
            throw new MatchError(tuple2);
        })).append("}").toString();
    }

    private byte[] parseKey(String key2) {
        return JwtBase64$.MODULE$.decodeNonSafe(key2.replaceAll("-----BEGIN ([^-]*)-----|-----END ([^-]*)-----|\\s*", ""));
    }

    private PrivateKey parsePrivateKey(String key2, String keyAlgo) {
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(this.parseKey(key2));
        return KeyFactory.getInstance(keyAlgo).generatePrivate(spec);
    }

    private PublicKey parsePublicKey(String key2, String keyAlgo) {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(this.parseKey(key2));
        return KeyFactory.getInstance(keyAlgo).generatePublic(spec);
    }

    public byte[] sign(byte[] data, SecretKey key2, JwtHmacAlgorithm algorithm) {
        Mac mac = Mac.getInstance(algorithm.fullName());
        mac.init(key2);
        return mac.doFinal(data);
    }

    public byte[] sign(String data, SecretKey key2, JwtHmacAlgorithm algorithm) {
        return this.sign(this.bytify(data), key2, algorithm);
    }

    public byte[] sign(byte[] data, PrivateKey key2, JwtAsymmetricAlgorithm algorithm) {
        Signature signer = Signature.getInstance(algorithm.fullName());
        signer.initSign(key2);
        signer.update(data);
        JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm = algorithm;
        if (jwtAsymmetricAlgorithm instanceof JwtRSAAlgorithm) {
            return signer.sign();
        }
        if (jwtAsymmetricAlgorithm instanceof JwtECDSAAlgorithm) {
            JwtECDSAAlgorithm algorithm2 = (JwtECDSAAlgorithm)jwtAsymmetricAlgorithm;
            return this.transcodeSignatureToConcat(signer.sign(), this.getSignatureByteArrayLength(algorithm2));
        }
        if (jwtAsymmetricAlgorithm instanceof JwtEdDSAAlgorithm) {
            return signer.sign();
        }
        throw new MatchError(jwtAsymmetricAlgorithm);
    }

    public byte[] sign(String data, PrivateKey key2, JwtAsymmetricAlgorithm algorithm) {
        return this.sign(this.bytify(data), key2, algorithm);
    }

    public byte[] sign(byte[] data, String key2, JwtAlgorithm algorithm) {
        JwtAlgorithm jwtAlgorithm = algorithm;
        if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
            JwtHmacAlgorithm algo = (JwtHmacAlgorithm)jwtAlgorithm;
            return this.sign(data, (SecretKey)new SecretKeySpec(this.bytify(key2), algo.fullName()), algo);
        }
        if (jwtAlgorithm instanceof JwtRSAAlgorithm) {
            JwtRSAAlgorithm algo = (JwtRSAAlgorithm)jwtAlgorithm;
            return this.sign(data, this.parsePrivateKey(key2, this.RSA()), (JwtAsymmetricAlgorithm)algo);
        }
        if (jwtAlgorithm instanceof JwtECDSAAlgorithm) {
            JwtECDSAAlgorithm algo = (JwtECDSAAlgorithm)jwtAlgorithm;
            return this.sign(data, this.parsePrivateKey(key2, this.ECDSA()), (JwtAsymmetricAlgorithm)algo);
        }
        if (jwtAlgorithm instanceof JwtEdDSAAlgorithm) {
            JwtEdDSAAlgorithm algo = (JwtEdDSAAlgorithm)jwtAlgorithm;
            return this.sign(data, this.parsePrivateKey(key2, this.EdDSA()), (JwtAsymmetricAlgorithm)algo);
        }
        if (jwtAlgorithm instanceof JwtUnknownAlgorithm) {
            JwtUnknownAlgorithm algo = (JwtUnknownAlgorithm)jwtAlgorithm;
            throw new JwtNonSupportedAlgorithm(algo.fullName());
        }
        throw new MatchError(jwtAlgorithm);
    }

    public byte[] sign(String data, String key2, JwtAlgorithm algorithm) {
        return this.sign(this.bytify(data), key2, algorithm);
    }

    public boolean verify(byte[] data, byte[] signature, SecretKey key2, JwtHmacAlgorithm algorithm) {
        return JwtArrayUtils$.MODULE$.constantTimeAreEqual(this.sign(data, key2, algorithm), signature);
    }

    public boolean verify(byte[] data, byte[] signature, PublicKey key2, JwtAsymmetricAlgorithm algorithm) {
        Signature signer = Signature.getInstance(algorithm.fullName());
        signer.initVerify(key2);
        signer.update(data);
        JwtAsymmetricAlgorithm jwtAsymmetricAlgorithm = algorithm;
        if (jwtAsymmetricAlgorithm instanceof JwtRSAAlgorithm) {
            return signer.verify(signature);
        }
        if (jwtAsymmetricAlgorithm instanceof JwtECDSAAlgorithm) {
            return signer.verify(this.transcodeSignatureToDER(signature));
        }
        if (jwtAsymmetricAlgorithm instanceof JwtEdDSAAlgorithm) {
            return signer.verify(signature);
        }
        throw new MatchError(jwtAsymmetricAlgorithm);
    }

    public boolean verify(byte[] data, byte[] signature, String key2, JwtAlgorithm algorithm) {
        JwtAlgorithm jwtAlgorithm = algorithm;
        if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
            JwtHmacAlgorithm algo = (JwtHmacAlgorithm)jwtAlgorithm;
            return this.verify(data, signature, new SecretKeySpec(this.bytify(key2), algo.fullName()), algo);
        }
        if (jwtAlgorithm instanceof JwtRSAAlgorithm) {
            JwtRSAAlgorithm algo = (JwtRSAAlgorithm)jwtAlgorithm;
            return this.verify(data, signature, this.parsePublicKey(key2, this.RSA()), algo);
        }
        if (jwtAlgorithm instanceof JwtECDSAAlgorithm) {
            JwtECDSAAlgorithm algo = (JwtECDSAAlgorithm)jwtAlgorithm;
            return this.verify(data, signature, this.parsePublicKey(key2, this.ECDSA()), algo);
        }
        if (jwtAlgorithm instanceof JwtEdDSAAlgorithm) {
            JwtEdDSAAlgorithm algo = (JwtEdDSAAlgorithm)jwtAlgorithm;
            return this.verify(data, signature, this.parsePublicKey(key2, this.EdDSA()), algo);
        }
        if (jwtAlgorithm instanceof JwtUnknownAlgorithm) {
            JwtUnknownAlgorithm algo = (JwtUnknownAlgorithm)jwtAlgorithm;
            throw new JwtNonSupportedAlgorithm(algo.fullName());
        }
        throw new MatchError(jwtAlgorithm);
    }

    public boolean verify(String data, String signature, String key2, JwtAlgorithm algorithm) {
        return this.verify(this.bytify(data), this.bytify(signature), key2, algorithm);
    }

    public int getSignatureByteArrayLength(JwtECDSAAlgorithm algorithm) {
        JwtECDSAAlgorithm jwtECDSAAlgorithm = algorithm;
        if (JwtAlgorithm$ES256$.MODULE$.equals(jwtECDSAAlgorithm)) {
            return 64;
        }
        if (JwtAlgorithm$ES384$.MODULE$.equals(jwtECDSAAlgorithm)) {
            return 96;
        }
        if (JwtAlgorithm$ES512$.MODULE$.equals(jwtECDSAAlgorithm)) {
            return 132;
        }
        throw new MatchError(jwtECDSAAlgorithm);
    }

    public byte[] transcodeSignatureToConcat(byte[] derSignature, int outputLength) throws JwtSignatureFormatException {
        int sLength;
        int j;
        int rLength;
        int i;
        int n;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new JwtSignatureFormatException("Invalid ECDSA signature format");
        }
        byte by = derSignature[1];
        byte s2 = by;
        if (s2 > 0) {
            n = 2;
        } else {
            byte s3 = by;
            if (s3 == (byte)129) {
                n = 3;
            } else {
                throw new JwtSignatureFormatException("Invalid ECDSA signature format");
            }
        }
        int offset = n;
        for (i = rLength = derSignature[offset + 1]; i > 0 && derSignature[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derSignature[offset + 2 + rLength + 1]; j > 0 && derSignature[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(Math.max(i, j), outputLength / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset] != 2 || derSignature[offset + 2 + rLength] != 2) {
            throw new JwtSignatureFormatException("Invalid ECDSA signature format");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset + 2 + rLength - i, concatSignature, rawLen - i, i);
        System.arraycopy(derSignature, offset + 2 + rLength + 2 + sLength - j, concatSignature, 2 * rawLen - j, j);
        return concatSignature;
    }

    public byte[] transcodeSignatureToDER(byte[] signature) throws JwtSignatureFormatException {
        int signatureLength;
        Object object;
        Object object2 = Predef$.MODULE$.byteArrayOps(signature);
        Tuple2<Object, Object> tuple2 = ArrayOps$.MODULE$.splitAt$extension(object2, signature.length / 2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        byte[] r = (byte[])tuple2._1();
        byte[] s2 = (byte[])tuple2._2();
        Tuple2<byte[], byte[]> tuple22 = Tuple2$.MODULE$.apply(r, s2);
        byte[] r2 = tuple22._1();
        byte[] s3 = tuple22._2();
        Object object3 = Predef$.MODULE$.byteArrayOps(r2);
        r2 = (byte[])ArrayOps$.MODULE$.dropWhile$extension(object3, (Function1<Object, boolean> & Serializable)_$2 -> JwtUtils$.transcodeSignatureToDER$$anonfun$1(BoxesRunTime.unboxToByte(_$2)));
        if (r2.length > 0 && r2[0] < 0) {
            Object object4 = Predef$.MODULE$.byteArrayOps(r2);
            r2 = (byte[])ArrayOps$.MODULE$.$plus$colon$extension(object4, BoxesRunTime.boxToByte((byte)0), ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        if ((s3 = (byte[])ArrayOps$.MODULE$.dropWhile$extension(object = Predef$.MODULE$.byteArrayOps(s3), (Function1<Object, boolean> & Serializable)_$3 -> JwtUtils$.transcodeSignatureToDER$$anonfun$2(BoxesRunTime.unboxToByte(_$3)))).length > 0 && s3[0] < 0) {
            Object object5 = Predef$.MODULE$.byteArrayOps(s3);
            s3 = (byte[])ArrayOps$.MODULE$.$plus$colon$extension(object5, BoxesRunTime.boxToByte((byte)0), ClassTag$.MODULE$.apply(Byte.TYPE));
        }
        if ((signatureLength = 2 + r2.length + 2 + s3.length) > 255) {
            throw new JwtSignatureFormatException("Invalid ECDSA signature format");
        }
        Object signatureDER = ListBuffer$.MODULE$.empty();
        ((AbstractBuffer)signatureDER).$plus$eq(BoxesRunTime.boxToByte((byte)48));
        if (signatureLength >= 128) {
            ((AbstractBuffer)signatureDER).$plus$eq(BoxesRunTime.boxToByte((byte)129));
        }
        ((AbstractBuffer)signatureDER).$plus$eq(BoxesRunTime.boxToByte((byte)signatureLength));
        ((AbstractBuffer)signatureDER).$plus$plus$eq((IterableOnce)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)BoxesRunTime.boxToByte((byte)2)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)BoxesRunTime.boxToByte((byte)r2.length)), Nil$.MODULE$))).$plus$plus(Predef$.MODULE$.wrapByteArray(r2)));
        ((AbstractBuffer)signatureDER).$plus$plus$eq((IterableOnce)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)BoxesRunTime.boxToByte((byte)2)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)BoxesRunTime.boxToByte((byte)s3.length)), Nil$.MODULE$))).$plus$plus(Predef$.MODULE$.wrapByteArray(s3)));
        return (byte[])((AbstractIterable)signatureDER).toArray(ClassTag$.MODULE$.apply(Byte.TYPE));
    }

    public String[] splitString(String input, char separator) {
        Object builder = ArrayBuffer$.MODULE$.empty();
        int lastIndex = 0;
        int index = input.indexOf(separator, lastIndex);
        while (index != -1) {
            ((AbstractBuffer)builder).$plus$eq(input.substring(lastIndex, index));
            lastIndex = index + 1;
            index = input.indexOf(separator, lastIndex);
        }
        if (lastIndex < input.length()) {
            ((AbstractBuffer)builder).$plus$eq(input.substring(lastIndex, input.length()));
        }
        return (String[])((AbstractIterable)builder).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private static final /* synthetic */ boolean transcodeSignatureToDER$$anonfun$1(byte _$2) {
        return _$2 == 0;
    }

    private static final /* synthetic */ boolean transcodeSignatureToDER$$anonfun$2(byte _$3) {
        return _$3 == 0;
    }
}

