/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import pdi.jwt.exceptions.JwtExpirationException;
import pdi.jwt.exceptions.JwtNotBeforeException;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Failure$;
import scala.util.Success$;
import scala.util.Try;

public final class JwtTime$
implements Serializable {
    public static final JwtTime$ MODULE$ = new JwtTime$();

    private JwtTime$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JwtTime$.class);
    }

    public long now(Clock clock) {
        return clock.instant().toEpochMilli();
    }

    public long nowSeconds(Clock clock) {
        return this.now(clock) / 1000L;
    }

    public String format(long time) {
        return Instant.ofEpochMilli(time).toString();
    }

    public boolean nowIsBetween(Option<Object> start, Option<Object> end, Clock clock) {
        return this.validateNowIsBetween(start, end, clock).isSuccess();
    }

    public boolean nowIsBetweenSeconds(Option<Object> start, Option<Object> end, Clock clock) {
        return this.nowIsBetween(start.map(_$1 -> _$1 * 1000L), end.map(_$2 -> _$2 * 1000L), clock);
    }

    public Try<BoxedUnit> validateNowIsBetween(Option<Object> start, Option<Object> end, Clock clock) {
        long timeNow = this.now(clock);
        Tuple2<Option<Object>, Option<Object>> tuple2 = Tuple2$.MODULE$.apply(start, end);
        if (tuple2 != null) {
            long e;
            long s2;
            Option<Object> option = tuple2._1();
            Option<Object> option2 = tuple2._2();
            if (option instanceof Some && (s2 = BoxesRunTime.unboxToLong(((Some)option).value())) > timeNow) {
                return Failure$.MODULE$.apply(new JwtNotBeforeException(s2));
            }
            if (option2 instanceof Some && (e = BoxesRunTime.unboxToLong(((Some)option2).value())) <= timeNow) {
                return Failure$.MODULE$.apply(new JwtExpirationException(e));
            }
        }
        return Success$.MODULE$.apply(BoxedUnit.UNIT);
    }

    public Try<BoxedUnit> validateNowIsBetweenSeconds(Option<Object> start, Option<Object> end, Clock clock) {
        return this.validateNowIsBetween(start.map(_$3 -> _$3 * 1000L), end.map(_$4 -> _$4 * 1000L), clock);
    }
}

