/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.time.Clock;
import javax.crypto.SecretKey;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.JwtBase64$;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtHeader$;
import pdi.jwt.JwtOptions;
import pdi.jwt.JwtOptions$;
import pdi.jwt.JwtTime$;
import pdi.jwt.JwtUtils$;
import pdi.jwt.algorithms.JwtAsymmetricAlgorithm;
import pdi.jwt.algorithms.JwtHmacAlgorithm;
import pdi.jwt.algorithms.JwtUnknownAlgorithm;
import pdi.jwt.algorithms.JwtUnknownAlgorithm$;
import pdi.jwt.exceptions.JwtEmptyAlgorithmException;
import pdi.jwt.exceptions.JwtEmptySignatureException;
import pdi.jwt.exceptions.JwtLengthException;
import pdi.jwt.exceptions.JwtNonEmptyAlgorithmException;
import pdi.jwt.exceptions.JwtNonEmptySignatureException;
import pdi.jwt.exceptions.JwtNonSupportedAlgorithm;
import pdi.jwt.exceptions.JwtValidationException;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple5;
import scala.Tuple5$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public interface JwtCore<H, C> {
    public Clock clock();

    public H parseHeader(String var1);

    public C parseClaim(String var1);

    public Option<JwtAlgorithm> extractAlgorithm(H var1);

    public Option<Object> extractExpiration(C var1);

    public Option<Object> extractNotBefore(C var1);

    public static String encode$(JwtCore $this, String header, String claim) {
        return $this.encode(header, claim);
    }

    default public String encode(String header, String claim) {
        return new StringBuilder(2).append(JwtBase64$.MODULE$.encodeString(header)).append(".").append(JwtBase64$.MODULE$.encodeString(claim)).append(".").toString();
    }

    public static String encode$(JwtCore $this, String header, String claim, String key2, JwtAlgorithm algorithm) {
        return $this.encode(header, claim, key2, algorithm);
    }

    default public String encode(String header, String claim, String key2, JwtAlgorithm algorithm) {
        String data = new StringBuilder(1).append(JwtBase64$.MODULE$.encodeString(header)).append(".").append(JwtBase64$.MODULE$.encodeString(claim)).toString();
        return new StringBuilder(1).append(data).append(".").append(JwtBase64$.MODULE$.encodeString(JwtUtils$.MODULE$.sign(data, key2, algorithm))).toString();
    }

    public static String encode$(JwtCore $this, String header, String claim, SecretKey key2, JwtHmacAlgorithm algorithm) {
        return $this.encode(header, claim, key2, algorithm);
    }

    default public String encode(String header, String claim, SecretKey key2, JwtHmacAlgorithm algorithm) {
        String data = new StringBuilder(1).append(JwtBase64$.MODULE$.encodeString(header)).append(".").append(JwtBase64$.MODULE$.encodeString(claim)).toString();
        return new StringBuilder(1).append(data).append(".").append(JwtBase64$.MODULE$.encodeString(JwtUtils$.MODULE$.sign(data, key2, algorithm))).toString();
    }

    public static String encode$(JwtCore $this, String header, String claim, PrivateKey key2, JwtAsymmetricAlgorithm algorithm) {
        return $this.encode(header, claim, key2, algorithm);
    }

    default public String encode(String header, String claim, PrivateKey key2, JwtAsymmetricAlgorithm algorithm) {
        String data = new StringBuilder(1).append(JwtBase64$.MODULE$.encodeString(header)).append(".").append(JwtBase64$.MODULE$.encodeString(claim)).toString();
        return new StringBuilder(1).append(data).append(".").append(JwtBase64$.MODULE$.encodeString(JwtUtils$.MODULE$.sign(data, key2, algorithm))).toString();
    }

    public static String encode$(JwtCore $this, String claim) {
        return $this.encode(claim);
    }

    default public String encode(String claim) {
        return this.encode(JwtHeader$.MODULE$.apply(JwtHeader$.MODULE$.apply$default$1(), JwtHeader$.MODULE$.apply$default$2(), JwtHeader$.MODULE$.apply$default$3(), JwtHeader$.MODULE$.apply$default$4()).toJson(), claim);
    }

    public static String encode$(JwtCore $this, String claim, String key2, JwtAlgorithm algorithm) {
        return $this.encode(claim, key2, algorithm);
    }

    default public String encode(String claim, String key2, JwtAlgorithm algorithm) {
        return this.encode(JwtHeader$.MODULE$.apply(algorithm).toJson(), claim, key2, algorithm);
    }

    public static String encode$(JwtCore $this, String claim, SecretKey key2, JwtHmacAlgorithm algorithm) {
        return $this.encode(claim, key2, algorithm);
    }

    default public String encode(String claim, SecretKey key2, JwtHmacAlgorithm algorithm) {
        return this.encode(JwtHeader$.MODULE$.apply(algorithm).toJson(), claim, key2, algorithm);
    }

    public static String encode$(JwtCore $this, String claim, PrivateKey key2, JwtAsymmetricAlgorithm algorithm) {
        return $this.encode(claim, key2, algorithm);
    }

    default public String encode(String claim, PrivateKey key2, JwtAsymmetricAlgorithm algorithm) {
        return this.encode(JwtHeader$.MODULE$.apply(algorithm).toJson(), claim, key2, algorithm);
    }

    public static String encode$(JwtCore $this, JwtClaim claim) {
        return $this.encode(claim);
    }

    default public String encode(JwtClaim claim) {
        return this.encode(claim.toJson());
    }

    public static String encode$(JwtCore $this, JwtClaim claim, String key2, JwtAlgorithm algorithm) {
        return $this.encode(claim, key2, algorithm);
    }

    default public String encode(JwtClaim claim, String key2, JwtAlgorithm algorithm) {
        return this.encode(claim.toJson(), key2, algorithm);
    }

    public static String encode$(JwtCore $this, JwtClaim claim, SecretKey key2, JwtHmacAlgorithm algorithm) {
        return $this.encode(claim, key2, algorithm);
    }

    default public String encode(JwtClaim claim, SecretKey key2, JwtHmacAlgorithm algorithm) {
        return this.encode(claim.toJson(), key2, algorithm);
    }

    public static String encode$(JwtCore $this, JwtClaim claim, PrivateKey key2, JwtAsymmetricAlgorithm algorithm) {
        return $this.encode(claim, key2, algorithm);
    }

    default public String encode(JwtClaim claim, PrivateKey key2, JwtAsymmetricAlgorithm algorithm) {
        return this.encode(claim.toJson(), key2, algorithm);
    }

    public static String encode$(JwtCore $this, JwtHeader header, JwtClaim claim) {
        return $this.encode(header, claim);
    }

    default public String encode(JwtHeader header, JwtClaim claim) {
        Option<JwtAlgorithm> option = header.algorithm();
        if (None$.MODULE$.equals(option)) {
            return this.encode(header.toJson(), claim.toJson());
        }
        throw new JwtNonEmptyAlgorithmException();
    }

    public static String encode$(JwtCore $this, JwtHeader header, JwtClaim claim, String key2) {
        return $this.encode(header, claim, key2);
    }

    default public String encode(JwtHeader header, JwtClaim claim, String key2) {
        JwtAlgorithm jwtAlgorithm;
        Option<JwtAlgorithm> option = header.algorithm();
        if (option instanceof Some && (jwtAlgorithm = (JwtAlgorithm)((Some)option).value()) != null) {
            JwtAlgorithm algo = jwtAlgorithm;
            return this.encode(header.toJson(), claim.toJson(), key2, algo);
        }
        throw new JwtEmptyAlgorithmException();
    }

    public static String encode$(JwtCore $this, JwtHeader header, JwtClaim claim, Key key2) {
        return $this.encode(header, claim, key2);
    }

    default public String encode(JwtHeader header, JwtClaim claim, Key key2) {
        Tuple2<Option<JwtAlgorithm>, Key> tuple2 = Tuple2$.MODULE$.apply(header.algorithm(), key2);
        if (tuple2 != null) {
            Option<JwtAlgorithm> option = tuple2._1();
            Key key3 = tuple2._2();
            if (option instanceof Some) {
                JwtAlgorithm jwtAlgorithm = (JwtAlgorithm)((Some)option).value();
                if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
                    JwtHmacAlgorithm algo = (JwtHmacAlgorithm)jwtAlgorithm;
                    if (key3 instanceof SecretKey) {
                        SecretKey k = (SecretKey)key3;
                        return this.encode(header.toJson(), claim.toJson(), k, algo);
                    }
                }
                if (jwtAlgorithm instanceof JwtAsymmetricAlgorithm) {
                    JwtAsymmetricAlgorithm algo = (JwtAsymmetricAlgorithm)jwtAlgorithm;
                    if (key3 instanceof PrivateKey) {
                        PrivateKey k = (PrivateKey)key3;
                        return this.encode(header.toJson(), claim.toJson(), k, algo);
                    }
                }
            }
        }
        throw new JwtValidationException("The key type doesn't match the algorithm type. It's either a SecretKey and a HMAC algorithm or a PrivateKey and a RSA or ECDSA algorithm. And an algorithm is required of course.");
    }

    private Tuple5<String, String, String, String, String> splitToken(String token) {
        String string2;
        String[] parts = JwtUtils$.MODULE$.splitString(token, '.');
        int n = parts.length;
        if (2 == n) {
            string2 = "";
        } else if (3 == n) {
            string2 = parts[2];
        } else {
            throw new JwtLengthException(new StringBuilder(67).append("Expected token [").append(token).append("] to be composed of 2 or 3 parts separated by dots.").toString());
        }
        String signature = string2;
        return Tuple5$.MODULE$.apply(parts[0], JwtBase64$.MODULE$.decodeString(parts[0]), parts[1], JwtBase64$.MODULE$.decodeString(parts[1]), signature);
    }

    public static Try decodeRawAll$(JwtCore $this, String token, JwtOptions options) {
        return $this.decodeRawAll(token, options);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, JwtOptions options) {
        return Try$.MODULE$.apply(() -> this.decodeRawAll$$anonfun$1(token, options));
    }

    public static Try decodeRawAll$(JwtCore $this, String token) {
        return $this.decodeRawAll(token);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token) {
        return this.decodeRawAll(token, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRawAll$(JwtCore $this, String token, String key2, Seq algorithms, JwtOptions options) {
        return $this.decodeRawAll(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply(() -> this.decodeRawAll$$anonfun$2(token, key2, algorithms, options));
    }

    public static Try decodeRawAll$(JwtCore $this, String token, String key2, Seq algorithms) {
        return $this.decodeRawAll(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key2, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decodeRawAll(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRawAll$(JwtCore $this, String token, String key2, Function0 algorithms, JwtOptions options) {
        return $this.decodeRawAll(token, key2, algorithms, options);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply(() -> this.decodeRawAll$$anonfun$3(token, key2, algorithms, options));
    }

    public static Try decodeRawAll$(JwtCore $this, String token, String key2, Function0 algorithms) {
        return $this.decodeRawAll(token, key2, algorithms);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return this.decodeRawAll(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRawAll$(JwtCore $this, String token, SecretKey key2, Seq algorithms, JwtOptions options) {
        return $this.decodeRawAll(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply(() -> this.decodeRawAll$$anonfun$4(token, key2, algorithms, options));
    }

    public static Try decodeRawAll$(JwtCore $this, String token, SecretKey key2, Seq algorithms) {
        return $this.decodeRawAll(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decodeRawAll(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRawAll$(JwtCore $this, String token, SecretKey key2, JwtOptions options) {
        return $this.decodeRawAll(token, key2, options);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key2, JwtOptions options) {
        return this.decodeRawAll(token, key2, JwtAlgorithm$.MODULE$.allHmac(), options);
    }

    public static Try decodeRawAll$(JwtCore $this, String token, SecretKey key2) {
        return $this.decodeRawAll(token, key2);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, SecretKey key2) {
        return this.decodeRawAll(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRawAll$(JwtCore $this, String token, PublicKey key2, Seq algorithms, JwtOptions options) {
        return $this.decodeRawAll(token, key2, algorithms, options);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply(() -> this.decodeRawAll$$anonfun$5(token, key2, algorithms, options));
    }

    public static Try decodeRawAll$(JwtCore $this, String token, PublicKey key2, Seq algorithms) {
        return $this.decodeRawAll(token, key2, algorithms);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return this.decodeRawAll(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRawAll$(JwtCore $this, String token, PublicKey key2, JwtOptions options) {
        return $this.decodeRawAll(token, key2, options);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key2, JwtOptions options) {
        return this.decodeRawAll(token, key2, JwtAlgorithm$.MODULE$.allAsymmetric(), options);
    }

    public static Try decodeRawAll$(JwtCore $this, String token, PublicKey key2) {
        return $this.decodeRawAll(token, key2);
    }

    default public Try<Tuple3<String, String, String>> decodeRawAll(String token, PublicKey key2) {
        return this.decodeRawAll(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRaw$(JwtCore $this, String token, JwtOptions options) {
        return $this.decodeRaw(token, options);
    }

    default public Try<String> decodeRaw(String token, JwtOptions options) {
        return this.decodeRawAll(token, options).map((Function1<Tuple3, String> & Serializable)_$1 -> (String)_$1._2());
    }

    public static Try decodeRaw$(JwtCore $this, String token) {
        return $this.decodeRaw(token);
    }

    default public Try<String> decodeRaw(String token) {
        return this.decodeRaw(token, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRaw$(JwtCore $this, String token, String key2, Seq algorithms, JwtOptions options) {
        return $this.decodeRaw(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<String> decodeRaw(String token, String key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return this.decodeRawAll(token, key2, algorithms, options).map((Function1<Tuple3, String> & Serializable)_$2 -> (String)_$2._2());
    }

    public static Try decodeRaw$(JwtCore $this, String token, String key2, Seq algorithms) {
        return $this.decodeRaw(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<String> decodeRaw(String token, String key2, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decodeRaw(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRaw$(JwtCore $this, String token, String key2, Function0 algorithms, JwtOptions options) {
        return $this.decodeRaw(token, key2, algorithms, options);
    }

    default public Try<String> decodeRaw(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return this.decodeRawAll(token, key2, algorithms, options).map((Function1<Tuple3, String> & Serializable)_$3 -> (String)_$3._2());
    }

    public static Try decodeRaw$(JwtCore $this, String token, String key2, Function0 algorithms) {
        return $this.decodeRaw(token, key2, algorithms);
    }

    default public Try<String> decodeRaw(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return this.decodeRaw(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRaw$(JwtCore $this, String token, SecretKey key2, Seq algorithms, JwtOptions options) {
        return $this.decodeRaw(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<String> decodeRaw(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return this.decodeRawAll(token, key2, algorithms, options).map((Function1<Tuple3, String> & Serializable)_$4 -> (String)_$4._2());
    }

    public static Try decodeRaw$(JwtCore $this, String token, SecretKey key2, Seq algorithms) {
        return $this.decodeRaw(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<String> decodeRaw(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decodeRaw(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRaw$(JwtCore $this, String token, SecretKey key2, JwtOptions options) {
        return $this.decodeRaw(token, key2, options);
    }

    default public Try<String> decodeRaw(String token, SecretKey key2, JwtOptions options) {
        return this.decodeRaw(token, key2, JwtAlgorithm$.MODULE$.allHmac(), options);
    }

    public static Try decodeRaw$(JwtCore $this, String token, SecretKey key2) {
        return $this.decodeRaw(token, key2);
    }

    default public Try<String> decodeRaw(String token, SecretKey key2) {
        return this.decodeRaw(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRaw$(JwtCore $this, String token, PublicKey key2, Seq algorithms, JwtOptions options) {
        return $this.decodeRaw(token, key2, algorithms, options);
    }

    default public Try<String> decodeRaw(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return this.decodeRawAll(token, key2, algorithms, options).map((Function1<Tuple3, String> & Serializable)_$5 -> (String)_$5._2());
    }

    public static Try decodeRaw$(JwtCore $this, String token, PublicKey key2, Seq algorithms) {
        return $this.decodeRaw(token, key2, algorithms);
    }

    default public Try<String> decodeRaw(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return this.decodeRaw(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeRaw$(JwtCore $this, String token, PublicKey key2, JwtOptions options) {
        return $this.decodeRaw(token, key2, options);
    }

    default public Try<String> decodeRaw(String token, PublicKey key2, JwtOptions options) {
        return this.decodeRaw(token, key2, JwtAlgorithm$.MODULE$.allAsymmetric(), options);
    }

    public static Try decodeRaw$(JwtCore $this, String token, PublicKey key2) {
        return $this.decodeRaw(token, key2);
    }

    default public Try<String> decodeRaw(String token, PublicKey key2) {
        return this.decodeRaw(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeAll$(JwtCore $this, String token, JwtOptions options) {
        return $this.decodeAll(token, options);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, JwtOptions options) {
        return Try$.MODULE$.apply(() -> this.decodeAll$$anonfun$1(token, options));
    }

    public static Try decodeAll$(JwtCore $this, String token) {
        return $this.decodeAll(token);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token) {
        return this.decodeAll(token, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeAll$(JwtCore $this, String token, String key2, Seq algorithms, JwtOptions options) {
        return $this.decodeAll(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, String key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply(() -> this.decodeAll$$anonfun$2(token, key2, algorithms, options));
    }

    public static Try decodeAll$(JwtCore $this, String token, String key2, Seq algorithms) {
        return $this.decodeAll(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, String key2, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decodeAll(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeAll$(JwtCore $this, String token, String key2, Function0 algorithms, JwtOptions options) {
        return $this.decodeAll(token, key2, algorithms, options);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply(() -> this.decodeAll$$anonfun$3(token, key2, algorithms, options));
    }

    public static Try decodeAll$(JwtCore $this, String token, String key2, Function0 algorithms) {
        return $this.decodeAll(token, key2, algorithms);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return this.decodeAll(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeAll$(JwtCore $this, String token, SecretKey key2, Seq algorithms, JwtOptions options) {
        return $this.decodeAll(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply(() -> this.decodeAll$$anonfun$4(token, key2, algorithms, options));
    }

    public static Try decodeAll$(JwtCore $this, String token, SecretKey key2, Seq algorithms) {
        return $this.decodeAll(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decodeAll(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeAll$(JwtCore $this, String token, SecretKey key2, JwtOptions options) {
        return $this.decodeAll(token, key2, options);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, SecretKey key2, JwtOptions options) {
        return this.decodeAll(token, key2, JwtAlgorithm$.MODULE$.allHmac(), options);
    }

    public static Try decodeAll$(JwtCore $this, String token, SecretKey key2) {
        return $this.decodeAll(token, key2);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, SecretKey key2) {
        return this.decodeAll(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeAll$(JwtCore $this, String token, PublicKey key2, Seq algorithms, JwtOptions options) {
        return $this.decodeAll(token, key2, algorithms, options);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply(() -> this.decodeAll$$anonfun$5(token, key2, algorithms, options));
    }

    public static Try decodeAll$(JwtCore $this, String token, PublicKey key2, Seq algorithms) {
        return $this.decodeAll(token, key2, algorithms);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return this.decodeAll(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decodeAll$(JwtCore $this, String token, PublicKey key2, JwtOptions options) {
        return $this.decodeAll(token, key2, options);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, PublicKey key2, JwtOptions options) {
        return this.decodeAll(token, key2, JwtAlgorithm$.MODULE$.allAsymmetric(), options);
    }

    public static Try decodeAll$(JwtCore $this, String token, PublicKey key2) {
        return $this.decodeAll(token, key2);
    }

    default public Try<Tuple3<H, C, String>> decodeAll(String token, PublicKey key2) {
        return this.decodeAll(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decode$(JwtCore $this, String token, JwtOptions options) {
        return $this.decode(token, options);
    }

    default public Try<C> decode(String token, JwtOptions options) {
        return this.decodeAll(token, options).map((Function1<Tuple3, Object> & Serializable)_$6 -> _$6._2());
    }

    public static Try decode$(JwtCore $this, String token) {
        return $this.decode(token);
    }

    default public Try<C> decode(String token) {
        return this.decode(token, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decode$(JwtCore $this, String token, String key2, Seq algorithms, JwtOptions options) {
        return $this.decode(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<C> decode(String token, String key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return this.decodeAll(token, key2, algorithms, options).map((Function1<Tuple3, Object> & Serializable)_$7 -> _$7._2());
    }

    public static Try decode$(JwtCore $this, String token, String key2, Seq algorithms) {
        return $this.decode(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<C> decode(String token, String key2, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decode(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decode$(JwtCore $this, String token, String key2, Function0 algorithms, JwtOptions options) {
        return $this.decode(token, key2, algorithms, options);
    }

    default public Try<C> decode(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return this.decodeAll(token, key2, algorithms, options).map((Function1<Tuple3, Object> & Serializable)_$8 -> _$8._2());
    }

    public static Try decode$(JwtCore $this, String token, String key2, Function0 algorithms) {
        return $this.decode(token, key2, algorithms);
    }

    default public Try<C> decode(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return this.decode(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decode$(JwtCore $this, String token, SecretKey key2, Seq algorithms, JwtOptions options) {
        return $this.decode(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public Try<C> decode(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return this.decodeAll(token, key2, algorithms, options).map((Function1<Tuple3, Object> & Serializable)_$9 -> _$9._2());
    }

    public static Try decode$(JwtCore $this, String token, SecretKey key2, Seq algorithms) {
        return $this.decode(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public Try<C> decode(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms) {
        return this.decode(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decode$(JwtCore $this, String token, SecretKey key2, JwtOptions options) {
        return $this.decode(token, key2, options);
    }

    default public Try<C> decode(String token, SecretKey key2, JwtOptions options) {
        return this.decode(token, key2, JwtAlgorithm$.MODULE$.allHmac(), options);
    }

    public static Try decode$(JwtCore $this, String token, SecretKey key2) {
        return $this.decode(token, key2);
    }

    default public Try<C> decode(String token, SecretKey key2) {
        return this.decode(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decode$(JwtCore $this, String token, PublicKey key2, Seq algorithms, JwtOptions options) {
        return $this.decode(token, key2, algorithms, options);
    }

    default public Try<C> decode(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return this.decodeAll(token, key2, algorithms, options).map((Function1<Tuple3, Object> & Serializable)_$10 -> _$10._2());
    }

    public static Try decode$(JwtCore $this, String token, PublicKey key2, Seq algorithms) {
        return $this.decode(token, key2, algorithms);
    }

    default public Try<C> decode(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return this.decode(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try decode$(JwtCore $this, String token, PublicKey key2, JwtOptions options) {
        return $this.decode(token, key2, options);
    }

    default public Try<C> decode(String token, PublicKey key2, JwtOptions options) {
        return this.decode(token, key2, JwtAlgorithm$.MODULE$.allAsymmetric(), options);
    }

    public static Try decode$(JwtCore $this, String token, PublicKey key2) {
        return $this.decode(token, key2);
    }

    default public Try<C> decode(String token, PublicKey key2) {
        return this.decode(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static Try validateTiming$(JwtCore $this, Object claim, JwtOptions options) {
        return $this.validateTiming(claim, options);
    }

    default public Try<BoxedUnit> validateTiming(C claim, JwtOptions options) {
        None$ maybeExpiration = options.expiration() ? this.extractExpiration(claim) : None$.MODULE$;
        None$ maybeNotBefore = options.notBefore() ? this.extractNotBefore(claim) : None$.MODULE$;
        return JwtTime$.MODULE$.validateNowIsBetweenSeconds(maybeNotBefore.map(_$11 -> _$11 - options.leeway()), maybeExpiration.map(_$12 -> _$12 + options.leeway()), this.clock());
    }

    public static boolean validateHmacAlgorithm$(JwtCore $this, JwtHmacAlgorithm algorithm, Seq algorithms) {
        return $this.validateHmacAlgorithm(algorithm, algorithms);
    }

    default public boolean validateHmacAlgorithm(JwtHmacAlgorithm algorithm, Seq<JwtHmacAlgorithm> algorithms) {
        return algorithms.contains(algorithm);
    }

    public static boolean validateAsymmetricAlgorithm$(JwtCore $this, JwtAsymmetricAlgorithm algorithm, Seq algorithms) {
        return $this.validateAsymmetricAlgorithm(algorithm, algorithms);
    }

    default public boolean validateAsymmetricAlgorithm(JwtAsymmetricAlgorithm algorithm, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return algorithms.contains(algorithm);
    }

    public static void validate$(JwtCore $this, Object header, Object claim, String signature, JwtOptions options) {
        $this.validate(header, claim, signature, options);
    }

    default public void validate(H header, C claim, String signature, JwtOptions options) {
        if (options.signature()) {
            if (!signature.isEmpty()) {
                throw new JwtNonEmptySignatureException();
            }
            this.extractAlgorithm(header).foreach((Function1<JwtAlgorithm, Object> & Serializable)x$1 -> {
                JwtAlgorithm jwtAlgorithm = x$1;
                if (jwtAlgorithm instanceof JwtUnknownAlgorithm) {
                    String string2;
                    JwtUnknownAlgorithm jwtUnknownAlgorithm = JwtUnknownAlgorithm$.MODULE$.unapply((JwtUnknownAlgorithm)jwtAlgorithm);
                    String name = string2 = jwtUnknownAlgorithm._1();
                    throw new JwtNonSupportedAlgorithm(name);
                }
                throw new JwtNonEmptyAlgorithmException();
            });
        }
        this.validateTiming(claim, options).get();
    }

    public static void validate$(JwtCore $this, String header64, Object header, String claim64, Object claim, String signature, JwtOptions options, Function3 verify) {
        $this.validate(header64, header, claim64, claim, signature, options, verify);
    }

    default public void validate(String header64, H header, String claim64, C claim, String signature, JwtOptions options, Function3<byte[], byte[], JwtAlgorithm, Object> verify) {
        if (options.signature()) {
            Option<JwtAlgorithm> maybeAlgo = this.extractAlgorithm(header);
            if (options.signature() && signature.isEmpty()) {
                throw new JwtEmptySignatureException();
            }
            if (maybeAlgo.isEmpty()) {
                throw new JwtEmptyAlgorithmException();
            }
            if (!BoxesRunTime.unboxToBoolean(verify.apply(JwtUtils$.MODULE$.bytify(new StringBuilder(1).append(header64).append(".").append(claim64).toString()), JwtBase64$.MODULE$.decode(signature), maybeAlgo.get()))) {
                throw new JwtValidationException("Invalid signature for this token or wrong algorithm.");
            }
        }
        this.validateTiming(claim, options).get();
    }

    public static void validate$(JwtCore $this, String header64, Object header, String claim64, Object claim, String signature, String key2, Seq algorithms, JwtOptions options) {
        $this.validate(header64, header, claim64, claim, signature, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public void validate(String header64, H header, String claim64, C claim, String signature2, String key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        this.validate(header64, header, claim64, claim, signature2, options, (Function3<byte[], byte[], JwtAlgorithm, Object>)(Function3<byte[], byte[], JwtAlgorithm, boolean> & Serializable)(data, signature, algorithm) -> {
            JwtAlgorithm jwtAlgorithm = algorithm;
            if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
                JwtHmacAlgorithm algo = (JwtHmacAlgorithm)jwtAlgorithm;
                return this.validateHmacAlgorithm(algo, algorithms) && JwtUtils$.MODULE$.verify((byte[])data, (byte[])signature, key2, (JwtAlgorithm)algo);
            }
            return false;
        });
    }

    public static void validate$(JwtCore $this, String header64, Object header, String claim64, Object claim, String signature, String key2, Function0 algorithms, JwtOptions options) {
        $this.validate(header64, header, claim64, claim, signature, key2, algorithms, options);
    }

    default public void validate(String header64, H header, String claim64, C claim, String signature2, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        this.validate(header64, header, claim64, claim, signature2, options, (Function3<byte[], byte[], JwtAlgorithm, Object>)(Function3<byte[], byte[], JwtAlgorithm, boolean> & Serializable)(data, signature, algorithm) -> {
            JwtAlgorithm jwtAlgorithm = algorithm;
            if (jwtAlgorithm instanceof JwtAsymmetricAlgorithm) {
                JwtAsymmetricAlgorithm algo = (JwtAsymmetricAlgorithm)jwtAlgorithm;
                return this.validateAsymmetricAlgorithm(algo, (Seq)algorithms.apply()) && JwtUtils$.MODULE$.verify((byte[])data, (byte[])signature, key2, (JwtAlgorithm)algo);
            }
            return false;
        });
    }

    public static void validate$(JwtCore $this, String header64, Object header, String claim64, Object claim, String signature, SecretKey key2, Seq algorithms, JwtOptions options) {
        $this.validate(header64, header, claim64, claim, signature, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public void validate(String header64, H header, String claim64, C claim, String signature2, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        this.validate(header64, header, claim64, claim, signature2, options, (Function3<byte[], byte[], JwtAlgorithm, Object>)(Function3<byte[], byte[], JwtAlgorithm, boolean> & Serializable)(data, signature, algorithm) -> {
            JwtAlgorithm jwtAlgorithm = algorithm;
            if (jwtAlgorithm instanceof JwtHmacAlgorithm) {
                JwtHmacAlgorithm algo = (JwtHmacAlgorithm)jwtAlgorithm;
                return this.validateHmacAlgorithm(algo, algorithms) && JwtUtils$.MODULE$.verify((byte[])data, (byte[])signature, key2, algo);
            }
            return false;
        });
    }

    public static void validate$(JwtCore $this, String header64, Object header, String claim64, Object claim, String signature, PublicKey key2, Seq algorithms, JwtOptions options) {
        $this.validate(header64, header, claim64, claim, signature, key2, algorithms, options);
    }

    default public void validate(String header64, H header, String claim64, C claim, String signature2, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        this.validate(header64, header, claim64, claim, signature2, options, (Function3<byte[], byte[], JwtAlgorithm, Object>)(Function3<byte[], byte[], JwtAlgorithm, boolean> & Serializable)(data, signature, algorithm) -> {
            JwtAlgorithm jwtAlgorithm = algorithm;
            if (jwtAlgorithm instanceof JwtAsymmetricAlgorithm) {
                JwtAsymmetricAlgorithm algo = (JwtAsymmetricAlgorithm)jwtAlgorithm;
                return this.validateAsymmetricAlgorithm(algo, algorithms) && JwtUtils$.MODULE$.verify((byte[])data, (byte[])signature, key2, algo);
            }
            return false;
        });
    }

    public static void validate$(JwtCore $this, String token, JwtOptions options) {
        $this.validate(token, options);
    }

    default public void validate(String token, JwtOptions options) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header = tuple5._2();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple3<String, String, String> tuple3 = Tuple3$.MODULE$.apply(header, claim, signature);
        String header2 = tuple3._1();
        String claim2 = tuple3._2();
        String signature2 = tuple3._3();
        this.validate(this.parseHeader(header2), this.parseClaim(claim2), signature2, options);
    }

    public static void validate$(JwtCore $this, String token) {
        $this.validate(token);
    }

    default public void validate(String token) {
        this.validate(token, JwtOptions$.MODULE$.DEFAULT());
    }

    public static void validate$(JwtCore $this, String token, String key2, Seq algorithms, JwtOptions options) {
        $this.validate(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public void validate(String token, String key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        this.validate(header642, this.parseHeader(header2), claim642, this.parseClaim(claim2), signature2, key2, algorithms, options);
    }

    public static void validate$(JwtCore $this, String token, String key2, Seq algorithms) {
        $this.validate(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public void validate(String token, String key2, Seq<JwtHmacAlgorithm> algorithms) {
        this.validate(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static void validate$(JwtCore $this, String token, String key2, Function0 algorithms, JwtOptions options) {
        $this.validate(token, key2, algorithms, options);
    }

    default public void validate(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        this.validate(header642, this.parseHeader(header2), claim642, this.parseClaim(claim2), signature2, key2, algorithms, options);
    }

    public static void validate$(JwtCore $this, String token, String key2, Function0 algorithms) {
        $this.validate(token, key2, algorithms);
    }

    default public void validate(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        this.validate(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static void validate$(JwtCore $this, String token, SecretKey key2, Seq algorithms, JwtOptions options) {
        $this.validate(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public void validate(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        this.validate(header642, this.parseHeader(header2), claim642, this.parseClaim(claim2), signature2, key2, algorithms, options);
    }

    public static void validate$(JwtCore $this, String token, SecretKey key2, Seq algorithms) {
        $this.validate(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public void validate(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms) {
        this.validate(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static void validate$(JwtCore $this, String token, SecretKey key2, JwtOptions options) {
        $this.validate(token, key2, options);
    }

    default public void validate(String token, SecretKey key2, JwtOptions options) {
        this.validate(token, key2, JwtAlgorithm$.MODULE$.allHmac(), options);
    }

    public static void validate$(JwtCore $this, String token, SecretKey key2) {
        $this.validate(token, key2);
    }

    default public void validate(String token, SecretKey key2) {
        this.validate(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static void validate$(JwtCore $this, String token, PublicKey key2, Seq algorithms, JwtOptions options) {
        $this.validate(token, key2, algorithms, options);
    }

    default public void validate(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        this.validate(header642, this.parseHeader(header2), claim642, this.parseClaim(claim2), signature2, key2, algorithms, options);
    }

    public static void validate$(JwtCore $this, String token, PublicKey key2, Seq algorithms) {
        $this.validate(token, key2, algorithms);
    }

    default public void validate(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms) {
        this.validate(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static void validate$(JwtCore $this, String token, PublicKey key2, JwtOptions options) {
        $this.validate(token, key2, options);
    }

    default public void validate(String token, PublicKey key2, JwtOptions options) {
        this.validate(token, key2, JwtAlgorithm$.MODULE$.allAsymmetric(), options);
    }

    public static void validate$(JwtCore $this, String token, PublicKey key2) {
        $this.validate(token, key2);
    }

    default public void validate(String token, PublicKey key2) {
        this.validate(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static boolean isValid$(JwtCore $this, String token, JwtOptions options) {
        return $this.isValid(token, options);
    }

    default public boolean isValid(String token, JwtOptions options) {
        return Try$.MODULE$.apply((Function0<Object> & Serializable)() -> {
            this.isValid$$anonfun$1(token, options);
            return BoxedUnit.UNIT;
        }).isSuccess();
    }

    public static boolean isValid$(JwtCore $this, String token) {
        return $this.isValid(token);
    }

    default public boolean isValid(String token) {
        return this.isValid(token, JwtOptions$.MODULE$.DEFAULT());
    }

    public static boolean isValid$(JwtCore $this, String token, String key2, Seq algorithms, JwtOptions options) {
        return $this.isValid(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public boolean isValid(String token, String key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply((Function0<Object> & Serializable)() -> {
            this.isValid$$anonfun$2(token, key2, algorithms, options);
            return BoxedUnit.UNIT;
        }).isSuccess();
    }

    public static boolean isValid$(JwtCore $this, String token, String key2, Seq algorithms) {
        return $this.isValid(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public boolean isValid(String token, String key2, Seq<JwtHmacAlgorithm> algorithms) {
        return this.isValid(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static boolean isValid$(JwtCore $this, String token, String key2, Function0 algorithms, JwtOptions options) {
        return $this.isValid(token, key2, algorithms, options);
    }

    default public boolean isValid(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply((Function0<Object> & Serializable)() -> {
            this.isValid$$anonfun$3(token, key2, algorithms, options);
            return BoxedUnit.UNIT;
        }).isSuccess();
    }

    public static boolean isValid$(JwtCore $this, String token, String key2, Function0 algorithms) {
        return $this.isValid(token, key2, algorithms);
    }

    default public boolean isValid(String token, String key2, Function0<Seq<JwtAsymmetricAlgorithm>> algorithms) {
        return this.isValid(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static boolean isValid$(JwtCore $this, String token, SecretKey key2, Seq algorithms, JwtOptions options) {
        return $this.isValid(token, key2, (Seq<JwtHmacAlgorithm>)algorithms, options);
    }

    default public boolean isValid(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply((Function0<Object> & Serializable)() -> {
            this.isValid$$anonfun$4(token, key2, algorithms, options);
            return BoxedUnit.UNIT;
        }).isSuccess();
    }

    public static boolean isValid$(JwtCore $this, String token, SecretKey key2, Seq algorithms) {
        return $this.isValid(token, key2, (Seq<JwtHmacAlgorithm>)algorithms);
    }

    default public boolean isValid(String token, SecretKey key2, Seq<JwtHmacAlgorithm> algorithms) {
        return this.isValid(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static boolean isValid$(JwtCore $this, String token, SecretKey key2, JwtOptions options) {
        return $this.isValid(token, key2, options);
    }

    default public boolean isValid(String token, SecretKey key2, JwtOptions options) {
        return this.isValid(token, key2, JwtAlgorithm$.MODULE$.allHmac(), options);
    }

    public static boolean isValid$(JwtCore $this, String token, SecretKey key2) {
        return $this.isValid(token, key2);
    }

    default public boolean isValid(String token, SecretKey key2) {
        return this.isValid(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    public static boolean isValid$(JwtCore $this, String token, PublicKey key2, Seq algorithms, JwtOptions options) {
        return $this.isValid(token, key2, algorithms, options);
    }

    default public boolean isValid(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms, JwtOptions options) {
        return Try$.MODULE$.apply((Function0<Object> & Serializable)() -> {
            this.isValid$$anonfun$5(token, key2, algorithms, options);
            return BoxedUnit.UNIT;
        }).isSuccess();
    }

    public static boolean isValid$(JwtCore $this, String token, PublicKey key2, Seq algorithms) {
        return $this.isValid(token, key2, algorithms);
    }

    default public boolean isValid(String token, PublicKey key2, Seq<JwtAsymmetricAlgorithm> algorithms) {
        return this.isValid(token, key2, algorithms, JwtOptions$.MODULE$.DEFAULT());
    }

    public static boolean isValid$(JwtCore $this, String token, PublicKey key2, JwtOptions options) {
        return $this.isValid(token, key2, options);
    }

    default public boolean isValid(String token, PublicKey key2, JwtOptions options) {
        return this.isValid(token, key2, JwtAlgorithm$.MODULE$.allAsymmetric(), options);
    }

    public static boolean isValid$(JwtCore $this, String token, PublicKey key2) {
        return $this.isValid(token, key2);
    }

    default public boolean isValid(String token, PublicKey key2) {
        return this.isValid(token, key2, JwtOptions$.MODULE$.DEFAULT());
    }

    private Tuple3 decodeRawAll$$anonfun$1(String token$1, JwtOptions options$1) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$1);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header = tuple5._2();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple3<String, String, String> tuple3 = Tuple3$.MODULE$.apply(header, claim, signature);
        String header2 = tuple3._1();
        String claim2 = tuple3._2();
        String signature2 = tuple3._3();
        this.validate(this.parseHeader(header2), this.parseClaim(claim2), signature2, options$1);
        return Tuple3$.MODULE$.apply(header2, claim2, signature2);
    }

    private Tuple3 decodeRawAll$$anonfun$2(String token$2, String key$1, Seq algorithms$1, JwtOptions options$2) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$2);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        this.validate(header642, this.parseHeader(header2), claim642, this.parseClaim(claim2), signature2, key$1, (Seq<JwtHmacAlgorithm>)algorithms$1, options$2);
        return Tuple3$.MODULE$.apply(header2, claim2, signature2);
    }

    private Tuple3 decodeRawAll$$anonfun$3(String token$3, String key$2, Function0 algorithms$2, JwtOptions options$3) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$3);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        this.validate(header642, this.parseHeader(header2), claim642, this.parseClaim(claim2), signature2, key$2, algorithms$2, options$3);
        return Tuple3$.MODULE$.apply(header2, claim2, signature2);
    }

    private Tuple3 decodeRawAll$$anonfun$4(String token$4, SecretKey key$3, Seq algorithms$3, JwtOptions options$4) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$4);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        this.validate(header642, this.parseHeader(header2), claim642, this.parseClaim(claim2), signature2, key$3, (Seq<JwtHmacAlgorithm>)algorithms$3, options$4);
        return Tuple3$.MODULE$.apply(header2, claim2, signature2);
    }

    private Tuple3 decodeRawAll$$anonfun$5(String token$5, PublicKey key$4, Seq algorithms$4, JwtOptions options$5) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$5);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        this.validate(header642, this.parseHeader(header2), claim642, this.parseClaim(claim2), signature2, key$4, algorithms$4, options$5);
        return Tuple3$.MODULE$.apply(header2, claim2, signature2);
    }

    private Tuple3 decodeAll$$anonfun$1(String token$6, JwtOptions options$6) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$6);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header = tuple5._2();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple3<String, String, String> tuple3 = Tuple3$.MODULE$.apply(header, claim, signature);
        String header2 = tuple3._1();
        String claim2 = tuple3._2();
        String signature2 = tuple3._3();
        Tuple2<H, C> tuple2 = Tuple2$.MODULE$.apply(this.parseHeader(header2), this.parseClaim(claim2));
        H h = tuple2._1();
        C c = tuple2._2();
        this.validate(h, c, signature2, options$6);
        return Tuple3$.MODULE$.apply(h, c, signature2);
    }

    private Tuple3 decodeAll$$anonfun$2(String token$7, String key$5, Seq algorithms$5, JwtOptions options$7) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$7);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        Tuple2<H, C> tuple2 = Tuple2$.MODULE$.apply(this.parseHeader(header2), this.parseClaim(claim2));
        H h = tuple2._1();
        C c = tuple2._2();
        this.validate(header642, h, claim642, c, signature2, key$5, (Seq<JwtHmacAlgorithm>)algorithms$5, options$7);
        return Tuple3$.MODULE$.apply(h, c, signature2);
    }

    private Tuple3 decodeAll$$anonfun$3(String token$8, String key$6, Function0 algorithms$6, JwtOptions options$8) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$8);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        Tuple2<H, C> tuple2 = Tuple2$.MODULE$.apply(this.parseHeader(header2), this.parseClaim(claim2));
        H h = tuple2._1();
        C c = tuple2._2();
        this.validate(header642, h, claim642, c, signature2, key$6, algorithms$6, options$8);
        return Tuple3$.MODULE$.apply(h, c, signature2);
    }

    private Tuple3 decodeAll$$anonfun$4(String token$9, SecretKey key$7, Seq algorithms$7, JwtOptions options$9) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$9);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        Tuple2<H, C> tuple2 = Tuple2$.MODULE$.apply(this.parseHeader(header2), this.parseClaim(claim2));
        H h = tuple2._1();
        C c = tuple2._2();
        this.validate(header642, h, claim642, c, signature2, key$7, (Seq<JwtHmacAlgorithm>)algorithms$7, options$9);
        return Tuple3$.MODULE$.apply(h, c, signature2);
    }

    private Tuple3 decodeAll$$anonfun$5(String token$10, PublicKey key$8, Seq algorithms$8, JwtOptions options$10) {
        Tuple5<String, String, String, String, String> tuple5 = this.splitToken(token$10);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        String header64 = tuple5._1();
        String header = tuple5._2();
        String claim64 = tuple5._3();
        String claim = tuple5._4();
        String signature = tuple5._5();
        Tuple5<String, String, String, String, String> tuple52 = Tuple5$.MODULE$.apply(header64, header, claim64, claim, signature);
        String header642 = tuple52._1();
        String header2 = tuple52._2();
        String claim642 = tuple52._3();
        String claim2 = tuple52._4();
        String signature2 = tuple52._5();
        Tuple2<H, C> tuple2 = Tuple2$.MODULE$.apply(this.parseHeader(header2), this.parseClaim(claim2));
        H h = tuple2._1();
        C c = tuple2._2();
        this.validate(header642, h, claim642, c, signature2, key$8, algorithms$8, options$10);
        return Tuple3$.MODULE$.apply(h, c, signature2);
    }

    private void isValid$$anonfun$1(String token$11, JwtOptions options$13) {
        this.validate(token$11, options$13);
    }

    private void isValid$$anonfun$2(String token$12, String key$13, Seq algorithms$13, JwtOptions options$14) {
        this.validate(token$12, key$13, (Seq<JwtHmacAlgorithm>)algorithms$13, options$14);
    }

    private void isValid$$anonfun$3(String token$13, String key$14, Function0 algorithms$14, JwtOptions options$15) {
        this.validate(token$13, key$14, algorithms$14, options$15);
    }

    private void isValid$$anonfun$4(String token$14, SecretKey key$15, Seq algorithms$15, JwtOptions options$16) {
        this.validate(token$14, key$15, (Seq<JwtHmacAlgorithm>)algorithms$15, options$16);
    }

    private void isValid$$anonfun$5(String token$15, PublicKey key$16, Seq algorithms$16, JwtOptions options$17) {
        this.validate(token$15, key$16, algorithms$16, options$17);
    }
}

