/*
 * Decompiled with CFR 0.152.
 */
package pdi.jwt;

import java.io.Serializable;
import java.time.Clock;
import pdi.jwt.Jwt$;
import pdi.jwt.JwtAlgorithm;
import pdi.jwt.JwtAlgorithm$;
import pdi.jwt.JwtClaim;
import pdi.jwt.JwtClaim$;
import pdi.jwt.JwtCore;
import pdi.jwt.JwtHeader;
import pdi.jwt.JwtHeader$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public class Jwt
implements JwtCore<JwtHeader, JwtClaim> {
    private final Clock clock;
    private final Regex extractAlgorithmRegex;
    private final Regex extractIssuerRegex;
    private final Regex extractSubjectRegex;
    private final Regex extractExpirationRegex;
    private final Regex extractNotBeforeRegex;
    private final Regex extractIssuedAtRegex;
    private final Regex extractJwtIdRegex;
    private final Regex clearStartRegex;
    private final Regex clearMiddleRegex;
    private final Regex clearEndRegex;

    public static Jwt apply(Clock clock) {
        return Jwt$.MODULE$.apply(clock);
    }

    public Jwt(Clock clock) {
        this.clock = clock;
        this.extractAlgorithmRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"alg\" *: *\"([a-zA-Z0-9]+)\""));
        this.extractIssuerRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"iss\" *: *\"([\\-a-zA-Z0-9_]*)\""));
        this.extractSubjectRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"sub\" *: *\"([\\-a-zA-Z0-9]*)\""));
        this.extractExpirationRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"exp\" *: *([0-9]+)"));
        this.extractNotBeforeRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"nbf\" *: *([0-9]+)"));
        this.extractIssuedAtRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"iat\" *: *([0-9]+)"));
        this.extractJwtIdRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\"jti\" *: *\"([\\-a-zA-Z0-9_]*)\""));
        this.clearStartRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\{ *,"));
        this.clearMiddleRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(", *(?=,)"));
        this.clearEndRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(", *\\}"));
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public Option<JwtAlgorithm> extractAlgorithm(String header) {
        return this.extractAlgorithmRegex.findFirstMatchIn(header).map((Function1<Regex.Match, String> & Serializable)_$1 -> _$1.group(1)).flatMap((Function1<String, Option> & Serializable)x$1 -> {
            String string2 = x$1;
            if ("none".equals(string2)) {
                return None$.MODULE$;
            }
            if (string2 != null) {
                String name = string2;
                return Some$.MODULE$.apply(JwtAlgorithm$.MODULE$.fromString(name));
            }
            throw new MatchError((Object)string2);
        });
    }

    public Option<String> extractIssuer(String claim) {
        return this.extractIssuerRegex.findFirstMatchIn(claim).map((Function1<Regex.Match, String> & Serializable)_$2 -> _$2.group(1));
    }

    public Option<String> extractSubject(String claim) {
        return this.extractSubjectRegex.findFirstMatchIn(claim).map((Function1<Regex.Match, String> & Serializable)_$3 -> _$3.group(1));
    }

    @Override
    public Option<Object> extractExpiration(String claim) {
        return this.extractExpirationRegex.findFirstMatchIn(claim).map((Function1<Regex.Match, String> & Serializable)_$4 -> _$4.group(1)).map((Function1<String, long> & Serializable)_$5 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)_$5)));
    }

    @Override
    public Option<Object> extractNotBefore(String claim) {
        return this.extractNotBeforeRegex.findFirstMatchIn(claim).map((Function1<Regex.Match, String> & Serializable)_$6 -> _$6.group(1)).map((Function1<String, long> & Serializable)_$7 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)_$7)));
    }

    public Option<Object> extractIssuedAt(String claim) {
        return this.extractIssuedAtRegex.findFirstMatchIn(claim).map((Function1<Regex.Match, String> & Serializable)_$8 -> _$8.group(1)).map((Function1<String, long> & Serializable)_$9 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString((String)_$9)));
    }

    public Option<String> extractJwtId(String claim) {
        return this.extractJwtIdRegex.findFirstMatchIn(claim).map((Function1<Regex.Match, String> & Serializable)_$10 -> _$10.group(1));
    }

    public String clearStart(String json) {
        return this.clearStartRegex.replaceFirstIn(json, "{");
    }

    public String clearMiddle(String json) {
        return this.clearMiddleRegex.replaceAllIn((CharSequence)json, "");
    }

    public String clearEnd(String json) {
        return this.clearEndRegex.replaceFirstIn(json, "}");
    }

    public String clearRegex(String json, Regex regex) {
        return regex.replaceFirstIn(json, "");
    }

    public String clearAll(String json2) {
        String dirtyJson = ((LinearSeqOps)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)this.extractIssuerRegex), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.extractSubjectRegex), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.extractExpirationRegex), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.extractNotBeforeRegex), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.extractIssuedAtRegex), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.extractJwtIdRegex), Nil$.MODULE$)))))))).foldLeft(json2, (Function2<String, Regex, String> & Serializable)(json, regex) -> this.clearRegex((String)json, (Regex)regex));
        return this.clearStart(this.clearEnd(this.clearMiddle(dirtyJson)));
    }

    public String headerToJson(JwtHeader header) {
        return header.toJson();
    }

    public String claimToJson(JwtClaim claim) {
        return claim.toJson();
    }

    @Override
    public Option<JwtAlgorithm> extractAlgorithm(JwtHeader header) {
        return header.algorithm();
    }

    @Override
    public Option<Object> extractExpiration(JwtClaim claim) {
        return claim.expiration();
    }

    @Override
    public Option<Object> extractNotBefore(JwtClaim claim) {
        return claim.notBefore();
    }

    @Override
    public JwtHeader parseHeader(String header) {
        return JwtHeader$.MODULE$.apply(this.extractAlgorithm(header));
    }

    @Override
    public JwtClaim parseClaim(String claim) {
        String string2 = this.clearAll(claim);
        Option<String> option = this.extractIssuer(claim);
        Option<String> option2 = this.extractSubject(claim);
        Option<Object> option3 = this.extractExpiration(claim);
        Option<Object> option4 = this.extractNotBefore(claim);
        Option<Object> option5 = this.extractIssuedAt(claim);
        Option<String> option6 = this.extractJwtId(claim);
        Option<Set<String>> option7 = JwtClaim$.MODULE$.apply$default$4();
        return JwtClaim$.MODULE$.apply(string2, option, option2, option7, option3, option4, option5, option6);
    }
}

