/*
 * Decompiled with CFR 0.152.
 */
package org.tresql;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.tresql.CacheBase;
import scala.$less$colon$less$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;

public class SimpleCacheBase<E>
implements CacheBase<E> {
    private final int maxSize;
    private final String name;
    private final Map<String, E> cache;

    public SimpleCacheBase(int maxSize, String name) {
        this.maxSize = maxSize;
        this.name = name;
        this.cache = new ConcurrentHashMap<String, E>();
    }

    public int maxSize() {
        return this.maxSize;
    }

    public String name() {
        return this.name;
    }

    @Override
    public Option<E> get(String tresql) {
        return Option$.MODULE$.apply(this.cache.get(tresql));
    }

    @Override
    public void put(String tresql, E expr) {
        if (this.maxSize() != -1 && this.cache.size() >= this.maxSize()) {
            this.cache.clear();
            Predef$.MODULE$.println(new StringBuilder(31).append("[WARN] ").append(this.name()).append(" cleared, size exceeded ").append(this.maxSize()).toString());
        }
        this.cache.putIfAbsent(tresql, expr);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    public Set<String> exprs() {
        return this.cache.keySet();
    }

    @Override
    public scala.collection.immutable.Map<String, E> toMap() {
        return ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.cache).asScala()).toMap($less$colon$less$.MODULE$.refl());
    }

    @Override
    public void load(scala.collection.immutable.Map<String, E> cache) {
        this.cache.putAll(JavaConverters$.MODULE$.mapAsJavaMapConverter(cache).asJava());
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public String toString() {
        return new StringBuilder(33).append("Simple cache exprs: ").append(this.exprs()).append("\n").append("Cache size: ").append(this.size()).toString();
    }
}

