/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.utils;

import java.io.Serializable;
import org.quartz.utils.DirtyFlagMap;

public class StringKeyDirtyFlagMap
extends DirtyFlagMap<String, Object> {
    static final long serialVersionUID = -9076749120524952280L;
    private boolean allowsTransientData = false;

    public StringKeyDirtyFlagMap() {
    }

    public StringKeyDirtyFlagMap(int initialCapacity) {
        super(initialCapacity);
    }

    public StringKeyDirtyFlagMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.getWrappedMap().hashCode();
    }

    public String[] getKeys() {
        return this.keySet().toArray(new String[this.size()]);
    }

    public void setAllowsTransientData(boolean allowsTransientData) {
        if (this.containsTransientData() && !allowsTransientData) {
            throw new IllegalStateException("Cannot set property 'allowsTransientData' to 'false' when data map contains non-serializable objects.");
        }
        this.allowsTransientData = allowsTransientData;
    }

    public boolean getAllowsTransientData() {
        return this.allowsTransientData;
    }

    public boolean containsTransientData() {
        if (!this.getAllowsTransientData()) {
            return false;
        }
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Object o = super.get(keys[i]);
            if (o instanceof Serializable) continue;
            return true;
        }
        return false;
    }

    public void removeTransientData() {
        if (!this.getAllowsTransientData()) {
            return;
        }
        String[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Object o = super.get(keys[i]);
            if (o instanceof Serializable) continue;
            this.remove(keys[i]);
        }
    }

    @Override
    public void put(String key2, int value) {
        super.put(key2, value);
    }

    @Override
    public void put(String key2, long value) {
        super.put(key2, value);
    }

    @Override
    public void put(String key2, float value) {
        super.put(key2, Float.valueOf(value));
    }

    @Override
    public void put(String key2, double value) {
        super.put(key2, value);
    }

    @Override
    public void put(String key2, boolean value) {
        super.put(key2, value);
    }

    @Override
    public void put(String key2, char value) {
        super.put(key2, Character.valueOf(value));
    }

    @Override
    public void put(String key2, String value) {
        super.put(key2, value);
    }

    @Override
    public Object put(String key2, Object value) {
        return super.put(key2, value);
    }

    public int getInt(String key2) {
        Object obj = this.get(key2);
        try {
            if (obj instanceof Integer) {
                return (Integer)obj;
            }
            return Integer.parseInt((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not an Integer.");
        }
    }

    public long getLong(String key2) {
        Object obj = this.get(key2);
        try {
            if (obj instanceof Long) {
                return (Long)obj;
            }
            return Long.parseLong((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Long.");
        }
    }

    public float getFloat(String key2) {
        Object obj = this.get(key2);
        try {
            if (obj instanceof Float) {
                return ((Float)obj).floatValue();
            }
            return Float.parseFloat((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Float.");
        }
    }

    public double getDouble(String key2) {
        Object obj = this.get(key2);
        try {
            if (obj instanceof Double) {
                return (Double)obj;
            }
            return Double.parseDouble((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Double.");
        }
    }

    public boolean getBoolean(String key2) {
        Object obj = this.get(key2);
        try {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            return Boolean.parseBoolean((String)obj);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Boolean.");
        }
    }

    public char getChar(String key2) {
        Object obj = this.get(key2);
        try {
            if (obj instanceof Character) {
                return ((Character)obj).charValue();
            }
            return ((String)obj).charAt(0);
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a Character.");
        }
    }

    public String getString(String key2) {
        Object obj = this.get(key2);
        try {
            return (String)obj;
        }
        catch (Exception e) {
            throw new ClassCastException("Identified object is not a String.");
        }
    }
}

