/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled2;

import org.parboiled2.ValueStackOverflowException;
import org.parboiled2.ValueStackUnderflowException;
import org.parboiled2.support.hlist.$colon$colon;
import org.parboiled2.support.hlist.$colon$colon$;
import org.parboiled2.support.hlist.HList;
import org.parboiled2.support.hlist.HList$;
import org.parboiled2.support.hlist.HNil$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public class ValueStack
implements Iterable<Object> {
    private final int maxSize;
    private Object[] buffer;
    private int _size;

    public ValueStack(int initialSize, int maxSize) {
        this.maxSize = maxSize;
        IterableOnce.$init$(this);
        IterableOnceOps.$init$(this);
        IterableOps.$init$(this);
        IterableFactoryDefaults.$init$(this);
        Iterable.$init$(this);
        this.buffer = new Object[initialSize];
        this._size = 0;
    }

    public void size_$eq(int newSize) {
        this._size = newSize;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    public void clear() {
        this._size = 0;
    }

    public void push(Object value) {
        int oldSize = this._size;
        int newSize = oldSize + 1;
        this.ensureSize(newSize);
        this.buffer[oldSize] = value;
        this._size = newSize;
    }

    public final void pushAll(HList hlist2) {
        HList hList;
        while ((hList = hlist2) instanceof $colon$colon) {
            $colon$colon $colon$colon = $colon$colon$.MODULE$.unapply(($colon$colon)hList);
            Object h = $colon$colon._1();
            Object t = $colon$colon._2();
            Object head = h;
            Object tail = t;
            this.push(head);
            hlist2 = tail;
        }
        if (HNil$.MODULE$.equals(hList)) {
            return;
        }
        throw new MatchError(hList);
    }

    public void insert(int down, Object value) {
        int n = package$.MODULE$.signum(down);
        switch (n) {
            case -1: {
                throw new IllegalArgumentException("`down` must not be negative");
            }
            case 0: {
                this.push(value);
                return;
            }
            case 1: {
                if (down > this._size) {
                    throw new ValueStackUnderflowException();
                }
                int newSize = this._size + 1;
                this.ensureSize(newSize);
                int targetIx = this._size - down;
                System.arraycopy(this.buffer, targetIx, this.buffer, targetIx + 1, down);
                this.buffer[targetIx] = value;
                this._size = newSize;
                return;
            }
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    public Object pop() {
        if (this._size > 0) {
            int newSize;
            this._size = newSize = this._size - 1;
            return this.buffer[newSize];
        }
        throw new ValueStackUnderflowException();
    }

    public Object pullOut(int down) {
        int n = package$.MODULE$.signum(down);
        switch (n) {
            case -1: {
                throw new IllegalArgumentException("`down` must not be negative");
            }
            case 0: {
                return this.pop();
            }
            case 1: {
                if (down >= this._size) {
                    throw new ValueStackUnderflowException();
                }
                int newSize = this._size - 1;
                int targetIx = newSize - down;
                Object result = this.buffer[targetIx];
                System.arraycopy(this.buffer, targetIx + 1, this.buffer, targetIx, down);
                this._size = newSize;
                return result;
            }
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    public Object peek() {
        if (this._size > 0) {
            return this.buffer[this._size - 1];
        }
        throw new ValueStackUnderflowException();
    }

    public Object peek(int down) {
        int n = package$.MODULE$.signum(down);
        switch (n) {
            case -1: {
                throw new IllegalArgumentException("`down` must not be negative");
            }
            case 0: {
                return this.peek();
            }
            case 1: {
                if (down >= this._size) {
                    throw new ValueStackUnderflowException();
                }
                return this.buffer[this._size - down - 1];
            }
        }
        throw new MatchError(BoxesRunTime.boxToInteger(n));
    }

    public void poke(int down, Object value) {
        if (down >= this._size) {
            throw new ValueStackUnderflowException();
        }
        Predef$.MODULE$.require(down >= 0, ValueStack::poke$$anonfun$1);
        this.buffer[this._size - down - 1] = value;
    }

    public void swap() {
        if (this._size < 2) {
            throw new ValueStackUnderflowException();
        }
        Object temp = this.buffer[this._size - 1];
        this.buffer[this._size - 1] = this.buffer[this._size - 2];
        this.buffer[this._size - 2] = temp;
    }

    public void swap3() {
        if (this._size < 3) {
            throw new ValueStackUnderflowException();
        }
        Object temp = this.buffer[this._size - 1];
        this.buffer[this._size - 1] = this.buffer[this._size - 3];
        this.buffer[this._size - 3] = temp;
    }

    public void swap4() {
        if (this._size < 4) {
            throw new ValueStackUnderflowException();
        }
        Object temp = this.buffer[this._size - 1];
        this.buffer[this._size - 1] = this.buffer[this._size - 4];
        this.buffer[this._size - 4] = temp;
        temp = this.buffer[this._size - 2];
        this.buffer[this._size - 2] = this.buffer[this._size - 3];
        this.buffer[this._size - 3] = temp;
    }

    public void swap5() {
        if (this._size < 5) {
            throw new ValueStackUnderflowException();
        }
        Object temp = this.buffer[this._size - 1];
        this.buffer[this._size - 1] = this.buffer[this._size - 5];
        this.buffer[this._size - 5] = temp;
        temp = this.buffer[this._size - 2];
        this.buffer[this._size - 2] = this.buffer[this._size - 4];
        this.buffer[this._size - 4] = temp;
    }

    public Object[] toArray() {
        Object[] a = new Object[this._size];
        System.arraycopy(this.buffer, 0, a, 0, this._size);
        return a;
    }

    public final <L extends HList> L toHList(int start, int end, HList prependTo) {
        while (true) {
            Predef$.MODULE$.require(0 <= start && start <= end, ValueStack::toHList$$anonfun$1);
            if (start == end) {
                return (L)prependTo;
            }
            int n = end - 1;
            Object object = this.buffer[end - 1];
            $colon$colon<Object, HList> $colon$colon = HList$.MODULE$.hlistOps(prependTo).$colon$colon(object);
            end = n;
            prependTo = $colon$colon;
        }
    }

    public int toHList$default$1() {
        return 0;
    }

    public int toHList$default$2() {
        return this._size;
    }

    public <L extends HList> HList toHList$default$3() {
        return HNil$.MODULE$;
    }

    public String show() {
        return this.mkString("[", ", ", "]");
    }

    @Override
    public Iterator<Object> iterator() {
        Object object = Predef$.MODULE$.genericArrayOps(this.toArray());
        return ArrayOps$.MODULE$.iterator$extension(object);
    }

    private void ensureSize(int requiredSize) {
        if (this.buffer.length < requiredSize) {
            if (requiredSize <= this.maxSize) {
                int newSize = package$.MODULE$.min(package$.MODULE$.max(this.buffer.length * 2, requiredSize), this.maxSize);
                Object[] newBuffer = new Object[newSize];
                System.arraycopy(this.buffer, 0, newBuffer, 0, this._size);
                this.buffer = newBuffer;
                return;
            }
            throw new ValueStackOverflowException();
        }
    }

    private static final Object poke$$anonfun$1() {
        return "`down` must be >= 0";
    }

    private static final Object toHList$$anonfun$1() {
        return "`start` must be >= 0 and <= `end`";
    }
}

