/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled2;

import java.io.Serializable;
import org.parboiled2.CharPredicate;
import org.parboiled2.CharPredicate$;
import org.parboiled2.CharPredicate$ApplyMagnet$;
import org.parboiled2.package$;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class CharUtils$
implements Serializable {
    private static final char[] LongMinValueChars;
    private static final CharPredicate escapedChars;
    public static final CharUtils$ MODULE$;

    private CharUtils$() {
    }

    static {
        MODULE$ = new CharUtils$();
        LongMinValueChars = "-9223372036854775808".toCharArray();
        escapedChars = CharPredicate$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new CharPredicate.ApplyMagnet[]{CharPredicate$ApplyMagnet$.MODULE$.fromString("\t\r\n"), CharPredicate$ApplyMagnet$.MODULE$.fromChar(package$.MODULE$.EOI()), CharPredicate$ApplyMagnet$.MODULE$.fromPredicate((Function1<Object, Object>)(Function1<Object, boolean> & Serializable)x$0 -> this.$init$$$anonfun$1(BoxesRunTime.unboxToChar(x$0)))}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CharUtils$.class);
    }

    public int hexValue(char c) {
        return (c & 0x1F) + (c >> 6) * 25 - 16;
    }

    public int numberOfHexDigits(long l) {
        return (scala.math.package$.MODULE$.max(63 - Long.numberOfLeadingZeros(l), 0) >> 2) + 1;
    }

    public char lowerHexDigit(long l) {
        return this.lowerHexDigit_internal((int)(l & 0xFL));
    }

    public char lowerHexDigit(int n) {
        return this.lowerHexDigit_internal(n & 0xF);
    }

    private char lowerHexDigit_internal(int i) {
        return (char)(48 + i + (0x27 & 9 - i >> 31));
    }

    public char upperHexDigit(long l) {
        return this.upperHexDigit_internal((int)(l & 0xFL));
    }

    public char upperHexDigit(int n) {
        return this.upperHexDigit_internal(n & 0xF);
    }

    private char upperHexDigit_internal(int i) {
        return (char)(48 + i + (7 & 9 - i >> 31));
    }

    public String upperHexString(long l) {
        return this.appendUpperHexString(new StringBuilder(this.numberOfHexDigits(l)), l).toString();
    }

    public StringBuilder appendUpperHexString(StringBuilder sb, long l) {
        if (l != 0L) {
            return this.putChar$1(sb, l, 63 - Long.numberOfLeadingZeros(l) & 0xFC);
        }
        return sb.append('0');
    }

    public String lowerHexString(long l) {
        return this.appendLowerHexString(new StringBuilder(this.numberOfHexDigits(l)), l).toString();
    }

    public StringBuilder appendLowerHexString(StringBuilder sb, long l) {
        if (l != 0L) {
            return this.putChar$2(sb, l, 63 - Long.numberOfLeadingZeros(l) & 0xFC);
        }
        return sb.append('0');
    }

    public String signedDecimalString(long l) {
        return new String(this.signedDecimalChars(l));
    }

    public int numberOfDecimalDigits(long l) {
        if (l != Long.MIN_VALUE) {
            return this._numberOfDecimalDigits(l);
        }
        return 20;
    }

    private int _numberOfDecimalDigits(long l) {
        if (l < 0L) {
            return this.len$1(10L, -l, 2);
        }
        return this.len$1(10L, l, 1);
    }

    public char[] LongMinValueChars() {
        return LongMinValueChars;
    }

    public char[] signedDecimalChars(long l) {
        if (l != Long.MIN_VALUE) {
            int len = this._numberOfDecimalDigits(l);
            char[] buf = new char[len];
            this.getSignedDecimalChars(l, len, buf);
            return buf;
        }
        return this.LongMinValueChars();
    }

    public void getSignedDecimalChars(long l, int endIndex, char[] buf) {
        this.phase1$1(l, buf, scala.math.package$.MODULE$.abs(l), endIndex);
    }

    public char toLowerCase(char c) {
        if (CharPredicate$.MODULE$.UpperAlpha().apply(c)) {
            return (char)(c + 32);
        }
        return c;
    }

    public char toUpperCase(char c) {
        if (CharPredicate$.MODULE$.LowerAlpha().apply(c)) {
            return (char)(c + 32);
        }
        return c;
    }

    public String escape(char c) {
        char c2 = c;
        switch (c2) {
            case '\t': {
                return "\\t";
            }
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
        }
        if (package$.MODULE$.EOI() == c2) {
            return "EOI";
        }
        char x = c2;
        if (Character.isISOControl(x)) {
            return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(c)}));
        }
        char x2 = c2;
        return BoxesRunTime.boxToCharacter(x2).toString();
    }

    public CharPredicate escapedChars() {
        return escapedChars;
    }

    public String escape(String s2) {
        if (this.escapedChars().matchesAny(s2)) {
            return StringOps$.MODULE$.flatMap$extension(Predef$.MODULE$.augmentString(s2), (Function1<Object, String> & Serializable)_$1 -> this.escape$$anonfun$1(BoxesRunTime.unboxToChar(_$1)));
        }
        return s2;
    }

    private final /* synthetic */ boolean $init$$$anonfun$1(char x$0) {
        return Character.isISOControl(x$0);
    }

    private final StringBuilder putChar$1(StringBuilder sb$1, long long$1, int shift) {
        while (true) {
            sb$1.append(this.upperHexDigit(long$1 >>> shift));
            if (shift <= 0) break;
            shift -= 4;
        }
        return sb$1;
    }

    private final StringBuilder putChar$2(StringBuilder sb$2, long long$2, int shift) {
        while (true) {
            sb$2.append(this.lowerHexDigit(long$2 >>> shift));
            if (shift <= 0) break;
            shift -= 4;
        }
        return sb$2;
    }

    private final long mul10$1(long l) {
        return (l << 3) + (l << 1);
    }

    private final int len$1(long test, long l, int result) {
        while (test <= l && test >= 0L) {
            long l2 = this.mul10$1(test);
            int n = result + 1;
            test = l2;
            result = n;
        }
        return result;
    }

    private final int div10$1(int i) {
        int q = (i << 3) + (i << 2);
        q += (q << 12) + (q << 8) + (q << 4) + i;
        return q >>>= 19;
    }

    private final int mul10$2(int i) {
        return (i << 3) + (i << 1);
    }

    private final long mul100$1(long l) {
        return (l << 6) + (l << 5) + (l << 2);
    }

    private final void phase1$1(long long$3, char[] buf$1, long l, int ix) {
        while (l > 65535L) {
            long q = l / 100L;
            int r = (int)(l - this.mul100$1(q));
            int rq = this.div10$1(r);
            buf$1[ix - 2] = (char)(48 + rq);
            buf$1[ix - 1] = (char)(48 + r - this.mul10$2(rq));
            long l2 = q;
            int n = ix - 2;
            l = l2;
            ix = n;
        }
        this.phase2$1(long$3, buf$1, (int)l, ix);
    }

    private final void phase2$1(long long$4, char[] buf$2, int i, int ix) {
        while (true) {
            int q = this.div10$1(i);
            int r = i - this.mul10$2(q);
            buf$2[ix - 1] = (char)(48 + r);
            if (q == 0) break;
            int n = q;
            int n2 = ix - 1;
            i = n;
            ix = n2;
        }
        if (long$4 < 0L) {
            buf$2[ix - 2] = 45;
            return;
        }
    }

    private final /* synthetic */ String escape$$anonfun$1(char _$1) {
        return this.escape(_$1);
    }
}

