/*
 * Decompiled with CFR 0.152.
 */
package org.mojoz.metadata.out;

import org.mojoz.metadata.ColumnDef_;
import org.mojoz.metadata.TableMetadata;
import org.mojoz.metadata.Type;
import org.mojoz.metadata.TypeDef;
import org.mojoz.metadata.out.DdlGenerator;
import org.mojoz.metadata.out.StandardSqlDdlGenerator;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;

public class OracleDdlGenerator
extends StandardSqlDdlGenerator {
    private final String ddlWriteInfoKey;

    public OracleDdlGenerator(DdlGenerator.ConstraintNamingRules constraintNamingRules, Seq<TypeDef> typeDefs) {
        super(constraintNamingRules, typeDefs);
        this.ddlWriteInfoKey = "oracle sql";
    }

    @Override
    public String ddlWriteInfoKey() {
        return this.ddlWriteInfoKey;
    }

    @Override
    public String dbDefault(ColumnDef_<Type> c) {
        Tuple2<String, String> tuple2 = Tuple2$.MODULE$.apply(c.type_().name(), c.dbDefault());
        if (tuple2 != null) {
            String string2 = tuple2._2();
            if (string2 == null) {
                return null;
            }
            if ("boolean".equals(tuple2._1())) {
                String f = string2;
                if ("false".equalsIgnoreCase(f)) {
                    return "'N'";
                }
                String t = string2;
                if ("true".equalsIgnoreCase(t)) {
                    return "'Y'";
                }
            }
        }
        return super.dbDefault(c);
    }

    @Override
    public String colCheck(ColumnDef_<Type> c) {
        String string2 = c.type_().name();
        if ("boolean".equals(string2)) {
            return new StringBuilder(22).append(" check (").append(c.name()).append(" in ('N','Y'))").toString();
        }
        return super.colCheck(c);
    }

    @Override
    public String foreignKey(String tableName, TableMetadata.Ref r) {
        return super.foreignKey(tableName, r.onUpdateAction() != null ? r.copy(r.copy$default$1(), r.copy$default$2(), r.copy$default$3(), r.copy$default$4(), r.copy$default$5(), r.copy$default$6(), r.copy$default$7(), null) : r);
    }
}

