/*
 * Decompiled with CFR 0.152.
 */
package org.mojoz.metadata.out;

import java.io.Serializable;
import java.text.Normalizer;
import org.mojoz.metadata.ColumnDef_;
import org.mojoz.metadata.TableDef_;
import org.mojoz.metadata.TableMetadata;
import org.mojoz.metadata.TableMetadata$Index$;
import org.mojoz.metadata.Type;
import org.mojoz.metadata.TypeDef;
import org.mojoz.metadata.out.DdlGenerator;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Nothing$;

public class CassandraDdlGenerator
extends DdlGenerator
implements DdlGenerator.ConstraintNamingRules {
    private final DdlGenerator.ConstraintNamingRules constraintNamingRules;
    private final String ddlWriteInfoKey;
    private final int maxNameLen;

    public CassandraDdlGenerator(DdlGenerator.ConstraintNamingRules constraintNamingRules, Seq<TypeDef> typeDefs) {
        int n;
        this.constraintNamingRules = constraintNamingRules;
        super(typeDefs);
        this.ddlWriteInfoKey = "cql";
        DdlGenerator.ConstraintNamingRules constraintNamingRules2 = constraintNamingRules;
        if (constraintNamingRules2 instanceof DdlGenerator.SimpleConstraintNamingRules) {
            DdlGenerator.SimpleConstraintNamingRules sn = (DdlGenerator.SimpleConstraintNamingRules)constraintNamingRules2;
            n = sn.maxNameLen();
        } else {
            n = new DdlGenerator.CassandraConstraintNamingRules().maxNameLen();
        }
        this.maxNameLen = n;
    }

    @Override
    public String ddlWriteInfoKey() {
        return this.ddlWriteInfoKey;
    }

    @Override
    public String pkName(String tableName) {
        return this.constraintNamingRules.pkName(tableName);
    }

    @Override
    public String ukName(String tableName, TableMetadata.DbIndex uk2) {
        return this.constraintNamingRules.ukName(tableName, uk2);
    }

    @Override
    public String idxName(String tableName, TableMetadata.DbIndex idx) {
        return this.constraintNamingRules.idxName(tableName, idx);
    }

    @Override
    public String fkName(String tableName, TableMetadata.Ref ref) {
        return this.constraintNamingRules.fkName(tableName, ref);
    }

    @Override
    public String colCheck(ColumnDef_<Type> c) {
        return "";
    }

    @Override
    public Seq<String> columnComments(TableDef_<ColumnDef_<Type>> t) {
        return (Seq)super.columnComments(t).map((Function1<String, String> & Serializable)c -> new StringBuilder(3).append("-- ").append((String)c).toString());
    }

    @Override
    public String tableAndComments(TableDef_<ColumnDef_<Type>> t) {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)Option$.MODULE$.option2Iterable(Some$.MODULE$.apply(this.table(t)))), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.columnComments(t)), Nil$.MODULE$)))).flatten(Predef$.MODULE$.$conforms())).mkString("\n");
    }

    @Override
    public String keysAndIndexes(TableDef_<ColumnDef_<Type>> t) {
        return ((IterableOnceOps)((StrictOptimizedIterableOps)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)this.uniqueIndexes(t)), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.indexes(t)), Nil$.MODULE$)))).flatten(Predef$.MODULE$.$conforms())).mkString("\n");
    }

    public String dbName(String name) {
        String string2 = Normalizer.normalize(name, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        String s2 = string2;
        if (s2.length() > this.maxNameLen) {
            if (s2.indexOf(".") > 0) {
                Object object = Predef$.MODULE$.refArrayOps(s2.split("\\."));
                return ((IterableOnceOps)ArrayOps$.MODULE$.toSeq$extension(object).map((Function1<String, String> & Serializable)p -> {
                    if (p.length() > this.maxNameLen) {
                        return p.substring(0, this.maxNameLen);
                    }
                    return p;
                })).mkString(".");
            }
            return s2.substring(0, this.maxNameLen);
        }
        String s3 = string2;
        return s3;
    }

    public Seq<String> clusteringCols(TableDef_<ColumnDef_<Type>> t) {
        return (Seq)t.pk().map((Function1<TableMetadata.DbIndex, Seq> & Serializable)x$1 -> {
            TableMetadata.DbIndex dbIndex = x$1;
            if (dbIndex instanceof TableMetadata.ComplexKey) {
                TableMetadata.ComplexKey pk = (TableMetadata.ComplexKey)dbIndex;
                if (pk.part() == 0) {
                    return (Seq)pk.cols().tail();
                }
                if (pk.part() > 0 && pk.part() <= pk.cols().length()) {
                    return (Seq)pk.cols().drop(pk.part());
                }
                return package$.MODULE$.Nil();
            }
            TableMetadata.DbIndex pk = dbIndex;
            return (Seq)pk.cols().tail();
        }).getOrElse(CassandraDdlGenerator::clusteringCols$$anonfun$2);
    }

    public Seq<String> tableOptions(TableDef_<ColumnDef_<Type>> t) {
        return (Seq)((IterableOps)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)Option$.MODULE$.apply(this.clusteringCols(t)).filter((Function1<Seq<String>, Object>)(Function1<Seq, boolean> & Serializable)_$12 -> _$12.exists((Function1<String, boolean> & Serializable)_$13 -> _$13.endsWith(" desc"))).map((Function1<Seq, String> & Serializable)cCols -> {
            Seq cco = (Seq)cCols.map((Function1<String, String> & Serializable)x$1 -> {
                String string2 = x$1;
                String c = string2;
                if (c.toLowerCase().endsWith(" asc")) {
                    return c;
                }
                String c2 = string2;
                if (c2.toLowerCase().endsWith(" desc")) {
                    return c2;
                }
                String c3 = string2;
                return new StringBuilder(4).append(c3).append(" asc").toString();
            });
            return new StringBuilder(22).append("clustering order by (").append(cco.mkString(", ")).append(")").toString();
        })), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)this.tableComment(t)), Nil$.MODULE$))).filter((Function1<Option, boolean> & Serializable)_$14 -> _$14.nonEmpty())).map((Function1<Option, String> & Serializable)_$15 -> (String)_$15.get());
    }

    @Override
    public String table(TableDef_<ColumnDef_<Type>> t) {
        return new StringBuilder(1).append(((IterableOnceOps)((IterableOps)t.cols().map((Function1<ColumnDef_, String> & Serializable)c -> this.column(t, (ColumnDef_<Type>)c))).$plus$plus(this.primaryKey(t))).mkString(new StringBuilder(17).append("create table ").append(this.dbName(t.name())).append("(\n  ").toString(), ",\n  ", "\n)")).append(Option$.MODULE$.apply(this.tableOptions(t)).filter((Function1<Seq<String>, Object>)(Function1<Seq, boolean> & Serializable)_$16 -> _$16.nonEmpty()).map((Function1<Seq, String> & Serializable)_$17 -> _$17.mkString(" with ", "\n   and ", "")).getOrElse(CassandraDdlGenerator::table$$anonfun$5)).append(";").toString();
    }

    public Seq<String> pkCols(Seq<String> cols) {
        return (Seq)cols.map((Function1<String, String> & Serializable)x$1 -> {
            String string2 = x$1;
            String c = string2;
            if (c.toLowerCase().endsWith(" asc")) {
                return c.substring(0, c.length() - 4);
            }
            String c2 = string2;
            if (c2.toLowerCase().endsWith(" desc")) {
                return c2.substring(0, c2.length() - 5);
            }
            String c3 = string2;
            return c3;
        });
    }

    private String toDdl(Seq<String> cols, int part) {
        if (part > 0 && part <= cols.length()) {
            return new StringBuilder(0).append(((IterableOnceOps)cols.take(part)).mkString("(", ", ", ")")).append(part < cols.length() ? ((IterableOnceOps)cols.drop(part)).mkString(", ", ", ", "") : "").toString();
        }
        return cols.mkString(", ");
    }

    public Option<TableMetadata.DbIndex> pk(TableDef_<ColumnDef_<Type>> t) {
        return t.pk().orElse(() -> CassandraDdlGenerator.pk$$anonfun$1(t)).orElse(() -> CassandraDdlGenerator.pk$$anonfun$2(t));
    }

    public Seq<String> partitionCols(Seq<String> cols, int part) {
        if (part > 0 && part <= cols.length()) {
            return (Seq)cols.take(part);
        }
        return (Seq)cols.take(1);
    }

    public Seq<String> partitionCols(TableDef_<ColumnDef_<Type>> t) {
        return (Seq)this.pk(t).map((Function1<TableMetadata.DbIndex, Seq> & Serializable)x$1 -> {
            TableMetadata.DbIndex dbIndex = x$1;
            if (dbIndex instanceof TableMetadata.ComplexKey) {
                TableMetadata.ComplexKey pk = (TableMetadata.ComplexKey)dbIndex;
                return this.partitionCols(pk.cols(), pk.part());
            }
            if (dbIndex instanceof TableMetadata.Index) {
                TableMetadata.Index pk = (TableMetadata.Index)dbIndex;
                return this.partitionCols(pk.cols(), 0);
            }
            throw new MatchError(dbIndex);
        }).get();
    }

    @Override
    public Option<String> primaryKey(TableDef_<ColumnDef_<Type>> t) {
        return this.pk(t).map((Function1<TableMetadata.DbIndex, String> & Serializable)x$1 -> {
            TableMetadata.DbIndex dbIndex = x$1;
            if (dbIndex instanceof TableMetadata.ComplexKey) {
                TableMetadata.ComplexKey pk = (TableMetadata.ComplexKey)dbIndex;
                return new StringBuilder(14).append("primary key (").append(this.toDdl((Seq)this.pkCols(pk.cols()).map((Function1<String, String> & Serializable)name -> this.dbName((String)name)), pk.part())).append(")").toString();
            }
            if (dbIndex instanceof TableMetadata.Index) {
                TableMetadata.Index pk = (TableMetadata.Index)dbIndex;
                return new StringBuilder(14).append("primary key (").append(((IterableOnceOps)this.pkCols(pk.cols()).map((Function1<String, String> & Serializable)name -> this.dbName((String)name))).mkString(", ")).append(")").toString();
            }
            throw new MatchError(dbIndex);
        });
    }

    @Override
    public String uniqueIndex(TableDef_<ColumnDef_<Type>> t, TableMetadata.DbIndex uk2) {
        return new StringBuilder(20).append(uk2.cols().lengthCompare(1) > 0 ? "-- " : "").append("create index ").append(this.dbName((String)Option$.MODULE$.apply(uk2.name()).getOrElse(() -> this.uniqueIndex$$anonfun$2(t, uk2)))).append(" on ").append(this.dbName(t.name())).append("(").append(((IterableOnceOps)this.idxCols(uk2.cols()).map((Function1<String, String> & Serializable)name -> this.dbName((String)name))).mkString(", ")).append(");").toString();
    }

    @Override
    public Seq<String> uniqueIndexes(TableDef_<ColumnDef_<Type>> t) {
        return (Seq)t.uk().map((Function1<TableMetadata.DbIndex, String> & Serializable)uk2 -> this.uniqueIndex(t, (TableMetadata.DbIndex)uk2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValidIndex(TableDef_<ColumnDef_<Type>> t, TableMetadata.DbIndex idx) {
        if (idx.cols().lengthCompare(1) != 0) return false;
        Seq<String> seq = this.pkCols(idx.cols());
        Seq<String> seq2 = this.pkCols(this.partitionCols(t));
        if (seq == null) {
            if (seq2 == null) return false;
            return true;
        } else if (seq.equals(seq2)) return false;
        return true;
    }

    @Override
    public String index(TableDef_<ColumnDef_<Type>> t, TableMetadata.DbIndex idx) {
        return new StringBuilder(0).append(this.isValidIndex(t, idx) ? "" : "-- ").append(super.index(t, idx)).toString();
    }

    private String column(TableDef_<ColumnDef_<Type>> t, ColumnDef_<Type> c) {
        return new StringBuilder(1).append(this.dbName(c.name())).append(" ").append(this.dbType(c)).toString();
    }

    @Override
    public Option<String> tableComment(TableDef_<ColumnDef_<Type>> t) {
        return Option$.MODULE$.apply(t.comments()).map((Function1<String, String> & Serializable)c -> new StringBuilder(12).append("comment = '").append(c.replace("'", "''")).append("'").toString());
    }

    @Override
    public String foreignKey(String tableName, TableMetadata.Ref r) {
        return new StringBuilder(3).append("-- ").append(super.foreignKey(tableName, r)).toString();
    }

    @Override
    public String dbAraryType(ColumnDef_<Type> c) {
        return new StringBuilder(6).append("list<").append(this.dbElementType(c)).append(">").toString();
    }

    @Override
    public Seq<String> tableChecks(TableDef_<ColumnDef_<Type>> t) {
        return package$.MODULE$.Nil();
    }

    private static final Seq clusteringCols$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final String table$$anonfun$5() {
        return "";
    }

    private static final Option pk$$anonfun$1(TableDef_ t$18) {
        return t$18.uk().headOption();
    }

    private static final Option pk$$anonfun$2(TableDef_ t$19) {
        return Some$.MODULE$.apply(TableMetadata$Index$.MODULE$.apply(null, (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)((ColumnDef_)t$19.cols().head()).name()), Nil$.MODULE$)), null));
    }

    private final String uniqueIndex$$anonfun$2(TableDef_ t$20, TableMetadata.DbIndex uk$3) {
        return this.ukName(t$20.name(), uk$3);
    }
}

