/*
 * Decompiled with CFR 0.152.
 */
package org.mojoz.metadata.io;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.mojoz.metadata.ColumnDef_;
import org.mojoz.metadata.FieldDef_;
import org.mojoz.metadata.TableDef_;
import org.mojoz.metadata.TableMetadata;
import org.mojoz.metadata.TableMetadata$DbIndex$;
import org.mojoz.metadata.Type;
import org.mojoz.metadata.ViewDef_;
import org.mojoz.metadata.io.IoColumnType;
import org.mojoz.metadata.io.IoColumnType$;
import org.mojoz.metadata.io.MdConventions$;
import org.mojoz.metadata.io.MdConventions$Ends$;
import org.mojoz.metadata.io.MdConventions$Equals$;
import org.mojoz.metadata.io.MdConventions$PatternSource$;
import org.mojoz.metadata.io.MdConventions$SimplePatternMdConventions$;
import org.mojoz.metadata.io.MdConventions$Starts$;
import org.mojoz.metadata.out.DdlGenerator;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class MdConventions {
    private final DdlGenerator.ConstraintNamingRules naming;

    public static PatternSource defaultBooleanNamePatternSource() {
        return MdConventions$.MODULE$.defaultBooleanNamePatternSource();
    }

    public static PatternSource defaultDateNamePatternSource() {
        return MdConventions$.MODULE$.defaultDateNamePatternSource();
    }

    public static PatternSource defaultDateTimeNamePatternSource() {
        return MdConventions$.MODULE$.defaultDateTimeNamePatternSource();
    }

    public static Seq<String> namePatternsFromFile(Option<File> option, Seq<String> seq) {
        return MdConventions$.MODULE$.namePatternsFromFile(option, seq);
    }

    public static Seq<String> namePatternsFromResource(PatternSource patternSource) {
        return MdConventions$.MODULE$.namePatternsFromResource(patternSource);
    }

    public static Seq<String> namePatternsFromResource(PatternSource patternSource, Function1<String, InputStream> function1) {
        return MdConventions$.MODULE$.namePatternsFromResource(patternSource, function1);
    }

    public static Seq<String> namePatternsFromResource(String string2, Seq<String> seq) {
        return MdConventions$.MODULE$.namePatternsFromResource(string2, seq);
    }

    public static Seq<String> namePatternsFromResource(String string2, Seq<String> seq, Function1<String, InputStream> function1) {
        return MdConventions$.MODULE$.namePatternsFromResource(string2, seq, function1);
    }

    public static DdlGenerator.ConstraintNamingRules $lessinit$greater$default$1() {
        return MdConventions$.MODULE$.$lessinit$greater$default$1();
    }

    public MdConventions(DdlGenerator.ConstraintNamingRules naming) {
        this.naming = naming;
    }

    public String idTypeName() {
        return "long";
    }

    public boolean isIdName(String name) {
        String string2 = name.toLowerCase();
        String string3 = "id";
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public boolean isCodeName(String name) {
        String string2 = name.toLowerCase();
        String string3 = "code";
        return !(string2 != null ? !string2.equals(string3) : string3 != null);
    }

    public boolean isRefName(String name) {
        return name != null && name.contains(".");
    }

    public boolean isBooleanName(String name) {
        return name.toLowerCase().startsWith("is_") || name.toLowerCase().startsWith("has_");
    }

    public boolean isDateName(String name) {
        return name.toLowerCase().endsWith("_date");
    }

    public boolean isDateTimeName(String name) {
        return name.toLowerCase().endsWith("_time");
    }

    public boolean isIdRefName(String name) {
        return name.toLowerCase().endsWith("_id");
    }

    public boolean isTypedName(String name) {
        return this.isBooleanName(name) || this.isDateName(name) || this.isDateTimeName(name) || this.isIdName(name) || this.isIdRefName(name);
    }

    public TableDef_<ColumnDef_<Type>> fromExternal(TableDef_<ColumnDef_<IoColumnType>> table) {
        Option<TableMetadata.DbIndex> pk = this.fromExternalPk(table);
        Seq seq = (Seq)table.cols().map((Function1<ColumnDef_, ColumnDef_> & Serializable)col -> this.fromExternal((ColumnDef_<IoColumnType>)col, pk));
        String string2 = table.copy$default$1();
        String string3 = table.copy$default$2();
        String string4 = table.copy$default$3();
        Seq<TableMetadata.DbIndex> seq2 = table.copy$default$6();
        Seq<TableMetadata.CheckConstraint> seq3 = table.copy$default$7();
        Seq<TableMetadata.DbIndex> seq4 = table.copy$default$8();
        Seq<TableMetadata.Ref> seq5 = table.copy$default$9();
        Map<String, Object> map = table.copy$default$10();
        return table.copy(string2, string3, string4, seq, pk, seq2, seq3, seq4, seq5, map);
    }

    public Option<TableMetadata.DbIndex> fromExternalPk(TableDef_<ColumnDef_<?>> tableDef) {
        Seq cols = (Seq)tableDef.cols().map((Function1<ColumnDef_, String> & Serializable)_$1 -> _$1.name());
        if (tableDef.pk().isDefined()) {
            return tableDef.pk().filter((Function1<TableMetadata.DbIndex, Object>)(Function1<TableMetadata.DbIndex, boolean> & Serializable)_$2 -> _$2 != null).map((Function1<TableMetadata.DbIndex, TableMetadata.DbIndex> & Serializable)x$1 -> {
                TableMetadata.ComplexKey pk;
                TableMetadata.DbIndex dbIndex = x$1;
                if (dbIndex instanceof TableMetadata.ComplexKey && (pk = (TableMetadata.ComplexKey)dbIndex).part() == 1) {
                    return TableMetadata$DbIndex$.MODULE$.apply(pk.name(), pk.cols(), pk.parameters());
                }
                TableMetadata.DbIndex idx = dbIndex;
                return idx;
            });
        }
        if (((SeqOps)cols.filter((Function1<String, boolean> & Serializable)name -> this.isIdName((String)name))).size() == 1) {
            return Some$.MODULE$.apply(TableMetadata$DbIndex$.MODULE$.apply(null, (Seq)cols.filter((Function1<String, boolean> & Serializable)name -> this.isIdName((String)name)), null));
        }
        if (((SeqOps)cols.filter((Function1<String, boolean> & Serializable)name -> this.isCodeName((String)name))).size() == 1) {
            return Some$.MODULE$.apply(TableMetadata$DbIndex$.MODULE$.apply(null, (Seq)cols.filter((Function1<String, boolean> & Serializable)name -> this.isCodeName((String)name)), null));
        }
        if (cols.size() == 2 && ((SeqOps)cols.filter((Function1<String, boolean> & Serializable)name -> this.isIdRefName((String)name))).size() == 2) {
            return Some$.MODULE$.apply(TableMetadata$DbIndex$.MODULE$.apply(null, cols, null));
        }
        return None$.MODULE$;
    }

    public ColumnDef_<Type> fromExternal(ColumnDef_<IoColumnType> col, Option<TableMetadata.DbIndex> pk) {
        String string2;
        Type typ = this.typeFromExternal(col.name(), col.type_().type_());
        boolean nullable = this.nullableFromExternal(col.name(), col.type_().nullable(), pk);
        Tuple2<String, String> tuple2 = Tuple2$.MODULE$.apply(typ.name(), col.dbDefault());
        if (tuple2 != null) {
            String d;
            String d2;
            String string3 = tuple2._2();
            string2 = string3 == null ? null : ("string".equals(tuple2._1()) ? ((d2 = string3).startsWith("'") ? d2 : (d2.startsWith("()") ? d2.substring(2).trim() : (d2.contains("(") ? d2 : new StringBuilder(2).append("'").append(d2).append("'").toString()))) : (d = string3));
        } else {
            throw new MatchError(tuple2);
        }
        String dbDefault = string2;
        return col.copy(col.copy$default$1(), (IoColumnType)((Object)typ), nullable, dbDefault, col.copy$default$5(), col.copy$default$6(), col.copy$default$7());
    }

    public Type typeFromExternal(String name, Option<Type> type_) {
        Tuple2<String, Option<Type>> tuple2 = Tuple2$.MODULE$.apply(name, type_);
        if (tuple2 != null) {
            Type typ;
            String string2 = tuple2._1();
            Option<Type> option = tuple2._2();
            String name2 = string2;
            if (option instanceof Some && this.isRefName((typ = (Type)((Some)option).value()).name())) {
                return typ;
            }
            String name3 = string2;
            if (this.isIdName(name3)) {
                return MdConventions.defaultType$1(type_, this.idTypeName());
            }
            String name4 = string2;
            Option<Type> typ2 = option;
            if (this.isRefName(name4)) {
                return (Type)typ2.getOrElse(MdConventions::typeFromExternal$$anonfun$1);
            }
            String name5 = string2;
            if (this.isBooleanName(name5)) {
                return MdConventions.defaultType$1(type_, "boolean");
            }
            String name6 = string2;
            if (this.isDateName(name6)) {
                return MdConventions.defaultType$1(type_, "date");
            }
            String name7 = string2;
            if (this.isDateTimeName(name7)) {
                return MdConventions.defaultType$1(type_, "dateTime");
            }
            String name8 = string2;
            if (this.isIdRefName(name8)) {
                return MdConventions.defaultType$1(type_, this.idTypeName());
            }
        }
        return MdConventions.defaultType$1(type_, "string");
    }

    public boolean nullableFromExternal(String name, Option<Object> nullable, Option<TableMetadata.DbIndex> pk) {
        return BoxesRunTime.unboxToBoolean(nullable.getOrElse(() -> MdConventions.nullableFromExternal$$anonfun$1(pk, name)));
    }

    public TableDef_<ColumnDef_<IoColumnType>> toExternal(TableDef_<ColumnDef_<Type>> table) {
        Seq seq = (Seq)table.cols().map((Function1<ColumnDef_, ColumnDef_> & Serializable)_$4 -> this.toExternal(table, (ColumnDef_<Type>)_$4));
        Option<TableMetadata.DbIndex> option = this.toExternalPk(table);
        Seq<TableMetadata.DbIndex> seq2 = this.toExternalUk(table);
        Seq<TableMetadata.DbIndex> seq3 = this.toExternalIdx(table);
        Seq<TableMetadata.Ref> seq4 = this.toExternalRefs(table);
        String string2 = table.copy$default$1();
        String string3 = table.copy$default$2();
        String string4 = table.copy$default$3();
        Seq<TableMetadata.CheckConstraint> seq5 = table.copy$default$7();
        Map<String, Object> map = table.copy$default$10();
        return table.copy(string2, string3, string4, seq, option, seq2, seq5, seq3, seq4, map);
    }

    private TableMetadata.DbIndex toExternalIdx(String defaultName, TableMetadata.DbIndex idx) {
        TableMetadata.DbIndex dbIndex;
        TableMetadata.DbIndex idx2 = dbIndex = !idx.cols().exists((Function1<String, boolean> & Serializable)_$5 -> _$5.toLowerCase().endsWith(" asc")) ? idx : idx.mapCols((Function1<String, String> & Serializable)c -> {
            if (c.toLowerCase().endsWith(" asc")) {
                return c.substring(0, c.length() - 4);
            }
            return c;
        });
        String string2 = idx2.name();
        String string3 = defaultName;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return idx2.mapName((Function1<String, String> & Serializable)_$6 -> null);
        }
        TableMetadata.DbIndex idx3 = dbIndex;
        return idx3;
    }

    public Option<TableMetadata.DbIndex> toExternalPk(TableDef_<ColumnDef_<Type>> tableDef) {
        Seq cols = (Seq)tableDef.cols().map((Function1<ColumnDef_, String> & Serializable)_$7 -> _$7.name());
        String defaultPkName = this.naming.pkName(tableDef.name());
        None$ none$ = None$.MODULE$;
        String string2 = tableDef.copy$default$1();
        String string3 = tableDef.copy$default$2();
        String string4 = tableDef.copy$default$3();
        Seq<ColumnDef_<Type>> seq = tableDef.copy$default$4();
        Seq<TableMetadata.DbIndex> seq2 = tableDef.copy$default$6();
        Seq<TableMetadata.CheckConstraint> seq3 = tableDef.copy$default$7();
        Seq<TableMetadata.DbIndex> seq4 = tableDef.copy$default$8();
        Seq<TableMetadata.Ref> seq5 = tableDef.copy$default$9();
        Map<String, Object> map = tableDef.copy$default$10();
        Option<TableMetadata.DbIndex> defaultPk = this.fromExternalPk(tableDef.copy(string2, string3, string4, seq, none$, seq2, seq3, seq4, seq5, map));
        Option option = MdConventions.pkNormalize$1(defaultPkName, tableDef.pk());
        Option option2 = MdConventions.pkNormalize$1(defaultPkName, defaultPk);
        if (option == null ? option2 != null : !option.equals(option2)) {
            if (tableDef.pk().isDefined()) {
                return tableDef.pk().map((Function1<TableMetadata.DbIndex, TableMetadata.DbIndex> & Serializable)idx -> this.toExternalIdx(defaultPkName, (TableMetadata.DbIndex)idx));
            }
            return Some$.MODULE$.apply(null);
        }
        return None$.MODULE$;
    }

    public Seq<TableMetadata.DbIndex> toExternalUk(TableDef_<ColumnDef_<Type>> table) {
        Seq seq;
        if (table.pk().isDefined()) {
            Seq<String> pkCols = this.toExternalIdx("", table.pk().get()).cols();
            seq = (Seq)table.uk().filter((Function1<TableMetadata.DbIndex, boolean> & Serializable)_$9 -> {
                Seq<String> seq = this.toExternalIdx("", (TableMetadata.DbIndex)_$9).cols();
                Seq seq2 = pkCols;
                return seq == null ? seq2 != null : !seq.equals(seq2);
            });
        } else {
            seq = table.uk();
        }
        return (Seq)seq.map((Function1<TableMetadata.DbIndex, TableMetadata.DbIndex> & Serializable)uk2 -> this.toExternalIdx(this.naming.ukName(table.name(), (TableMetadata.DbIndex)uk2), (TableMetadata.DbIndex)uk2));
    }

    public Seq<TableMetadata.DbIndex> toExternalIdx(TableDef_<ColumnDef_<Type>> table) {
        return (Seq)table.idx().map((Function1<TableMetadata.DbIndex, TableMetadata.DbIndex> & Serializable)idx -> this.toExternalIdx(this.naming.idxName(table.name(), (TableMetadata.DbIndex)idx), (TableMetadata.DbIndex)idx));
    }

    public Seq<TableMetadata.Ref> toExternalRefs(TableDef_<ColumnDef_<Type>> table) {
        return (Seq)((IterableOps)((IterableOps)((IterableOps)table.refs().map((Function1<TableMetadata.Ref, TableMetadata.Ref> & Serializable)r -> {
            String string2 = r.onDeleteAction();
            String string3 = "no action";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return r.copy(r.copy$default$1(), r.copy$default$2(), r.copy$default$3(), r.copy$default$4(), r.copy$default$5(), r.copy$default$6(), null, r.copy$default$8());
            }
            return r;
        })).map((Function1<TableMetadata.Ref, TableMetadata.Ref> & Serializable)r -> {
            String string2 = r.onUpdateAction();
            String string3 = "no action";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return r.copy(r.copy$default$1(), r.copy$default$2(), r.copy$default$3(), r.copy$default$4(), r.copy$default$5(), r.copy$default$6(), r.copy$default$7(), null);
            }
            return r;
        })).map((Function1<TableMetadata.Ref, TableMetadata.Ref> & Serializable)r -> {
            String string2 = r.name();
            String string3 = this.naming.fkName(table.name(), (TableMetadata.Ref)r);
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return r.copy(null, r.copy$default$2(), r.copy$default$3(), r.copy$default$4(), r.copy$default$5(), r.copy$default$6(), r.copy$default$7(), r.copy$default$8());
            }
            return r;
        })).filter((Function1<TableMetadata.Ref, boolean> & Serializable)r -> r.cols().size() > 1 || r.onDeleteAction() != null || r.onUpdateAction() != null || r.name() != null);
    }

    public Option<Object> nullableOpt(String name, boolean nullable, TableDef_<ColumnDef_<Type>> table) {
        Tuple2<String, Boolean> tuple2 = Tuple2$.MODULE$.apply(name, BoxesRunTime.boxToBoolean(nullable));
        if (tuple2 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean(tuple2._2());
            String name2 = tuple2._1();
            if (!bl && table.pk().exists((Function1<TableMetadata.DbIndex, Object>)(Function1<TableMetadata.DbIndex, boolean> & Serializable)_$10 -> _$10.cols().contains(name2))) {
                return None$.MODULE$;
            }
            if (bl) {
                return None$.MODULE$;
            }
            boolean nullable2 = bl;
            return Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(nullable2));
        }
        throw new MatchError(tuple2);
    }

    public ColumnDef_<IoColumnType> toExternal(TableDef_<ColumnDef_<Type>> table, ColumnDef_<Type> col) {
        String string2;
        Some<Object> nullOpt = col.type_().isArray() ? Some$.MODULE$.apply(BoxesRunTime.boxToBoolean(col.nullable())) : this.nullableOpt(col.name(), col.nullable(), table);
        Tuple2<String, String> tuple2 = Tuple2$.MODULE$.apply(col.type_().name(), col.dbDefault());
        if (tuple2 != null) {
            String d;
            String d2;
            String string3 = tuple2._2();
            string2 = string3 == null ? null : ("string".equals(tuple2._1()) ? ((d2 = string3).startsWith("'") && d2.endsWith("'") ? (d2.contains("(") ? d2 : d2.substring(1, d2.length() - 1)) : (!d2.contains("(") ? new StringBuilder(3).append("() ").append(d2).toString() : d2)) : (d = string3));
        } else {
            throw new MatchError(tuple2);
        }
        String dbDefault = string2;
        Option ref = ((IterableOnceOps)table.refs().filter((Function1<TableMetadata.Ref, boolean> & Serializable)_$11 -> _$11.cols().size() == 1)).find((Function1<TableMetadata.Ref, boolean> & Serializable)_$12 -> {
            Object r = _$12.cols().apply(false);
            String string2 = col.name();
            return !(r != null ? !r.equals(string2) : string2 != null);
        });
        if (ref.isDefined()) {
            String refTable = ((TableMetadata.Ref)ref.get()).refTable();
            String refCol = (String)((TableMetadata.Ref)ref.get()).refCols().apply(false);
            String refTypeName = new StringBuilder(1).append(refTable).append(".").append(refCol).toString();
            String string4 = col.name();
            String string5 = refTypeName.replace(".", "_");
            Tuple2<None$, String> tuple22 = !(string4 != null ? !string4.equals(string5) : string5 != null) ? Tuple2$.MODULE$.apply(None$.MODULE$, refTypeName) : Tuple2$.MODULE$.apply(Some$.MODULE$.apply(new Type(refTypeName)), MdConventions.toRefColName$1(col.name(), refCol));
            Option typeOpt = tuple22._1();
            String refColName = tuple22._2();
            IoColumnType ioColumnType = IoColumnType$.MODULE$.apply(nullOpt, typeOpt);
            boolean bl = col.copy$default$3();
            Seq<String> seq = col.copy$default$5();
            String string6 = col.copy$default$6();
            Map<String, Object> map = col.copy$default$7();
            return col.copy(refColName, (Type)((Object)ioColumnType), bl, dbDefault, seq, string6, map);
        }
        IoColumnType ioColumnType = IoColumnType$.MODULE$.apply(nullOpt, this.typeOpt(col.name(), col.type_()));
        String string7 = col.copy$default$1();
        boolean bl = col.copy$default$3();
        Seq<String> seq = col.copy$default$5();
        String string8 = col.copy$default$6();
        Map<String, Object> map = col.copy$default$7();
        return col.copy(string7, (Type)((Object)ioColumnType), bl, dbDefault, seq, string8, map);
    }

    public Option<Type> typeOpt(String name, Type type_) {
        Tuple3<String, String, Option<Object>> tuple3 = Tuple3$.MODULE$.apply(name, type_.name(), type_.length());
        if (tuple3 != null) {
            String string2 = tuple3._1();
            String string3 = tuple3._2();
            Option<Object> option = tuple3._3();
            String name2 = string2;
            String type_2 = string3;
            if (this.isIdName(name2)) {
                String string4 = type_2;
                String string5 = this.idTypeName();
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    return None$.MODULE$;
                }
            }
            String name3 = string2;
            String type_3 = string3;
            if (this.isIdRefName(name3)) {
                String string6 = type_3;
                String string7 = this.idTypeName();
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    return None$.MODULE$;
                }
            }
            String name4 = string2;
            if ("boolean".equals(string3) && this.isBooleanName(name4)) {
                return None$.MODULE$;
            }
            String name5 = string2;
            if ("date".equals(string3) && this.isDateName(name5)) {
                return None$.MODULE$;
            }
            String name6 = string2;
            if ("dateTime".equals(string3) && this.isDateTimeName(name6)) {
                return None$.MODULE$;
            }
            String name7 = string2;
            if ("string".equals(string3) && None$.MODULE$.equals(option) && !this.isTypedName(name7)) {
                return None$.MODULE$;
            }
            String name8 = string2;
            if ("string[]".equals(string3) && None$.MODULE$.equals(option) && !this.isTypedName(name8)) {
                return Some$.MODULE$.apply(new Type("[]"));
            }
            String name9 = string2;
            if ("string".equals(string3) && option instanceof Some) {
                int len = BoxesRunTime.unboxToInt(((Some)option).value());
                if (!this.isTypedName(name9)) {
                    return Some$.MODULE$.apply(new Type(null, len));
                }
            }
            String name10 = string2;
            if ("string[]".equals(string3) && option instanceof Some) {
                int len = BoxesRunTime.unboxToInt(((Some)option).value());
                if (!this.isTypedName(name10)) {
                    return Some$.MODULE$.apply(new Type("[]", len));
                }
            }
        }
        return Option$.MODULE$.apply(type_);
    }

    public ViewDef_<FieldDef_<IoColumnType>> toExternal(ViewDef_<FieldDef_<Type>> view, TableMetadata tableMetadata, Map<String, ViewDef_<FieldDef_<Type>>> allViews) {
        TableDef_<ColumnDef_<Type>> tableDef;
        TableDef_<ColumnDef_<Type>> tableDef_ = tableDef = view.table() == null ? null : tableMetadata.tableDef(view);
        String string2 = view.table() == null ? "" : (view.extends_() != null && BoxesRunTime.unboxToBoolean(allViews.get(view.extends_()).map((Function1<ViewDef_, boolean> & Serializable)_$17 -> {
            String string2 = _$17.table();
            String string3 = view.table();
            return !(string2 != null ? !string2.equals(string3) : string3 != null);
        }).getOrElse(MdConventions::$anonfun$12)) ? null : view.table());
        String string3 = (String)Option$.MODULE$.apply(view.comments()).filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)_$18 -> {
            if (tableDef == null) return true;
            String string2 = _$18;
            String string3 = tableDef.comments();
            if (string2 == null) {
                if (string3 == null) return false;
                return true;
            } else if (string2.equals(string3)) return false;
            return true;
        }).orNull($less$colon$less$.MODULE$.refl());
        Seq seq = (Seq)view.fields().map((Function1<FieldDef_, FieldDef_> & Serializable)f -> this.mapField$1(tableMetadata, view, (FieldDef_)f));
        String string4 = view.copy$default$1();
        String string5 = view.copy$default$2();
        String string6 = view.copy$default$4();
        String string7 = view.copy$default$5();
        String string8 = view.copy$default$6();
        Seq<String> seq2 = view.copy$default$7();
        Seq<String> seq3 = view.copy$default$8();
        Seq<String> seq4 = view.copy$default$9();
        Seq<String> seq5 = view.copy$default$10();
        Seq<String> seq6 = view.copy$default$11();
        String string9 = view.copy$default$12();
        Seq<String> seq7 = view.copy$default$15();
        Map<String, Object> map = view.copy$default$16();
        return view.copy(string4, string5, string2, string6, string7, string8, seq2, seq3, seq4, seq5, seq6, string9, string3, seq, seq7, map);
    }

    private static final Type defaultType$1$$anonfun$2(String defaultName$2) {
        return new Type(defaultName$2);
    }

    private static final Type defaultType$1(Option type_$5, String defaultName) {
        return (Type)type_$5.map((Function1<Type, Type> & Serializable)x -> {
            if (x.name() == null) {
                return x.copy(defaultName, x.copy$default$2(), x.copy$default$3(), x.copy$default$4(), x.copy$default$5());
            }
            String string2 = x.name();
            String string3 = "[]";
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return x.copy(new StringBuilder(2).append(defaultName).append("[]").toString(), x.copy$default$2(), x.copy$default$3(), x.copy$default$4(), x.copy$default$5());
            }
            return x;
        }).getOrElse(() -> MdConventions.defaultType$1$$anonfun$2(defaultName));
    }

    private static final Type typeFromExternal$$anonfun$1() {
        return new Type(null);
    }

    private static final boolean nullableFromExternal$$anonfun$1(Option pk$4, String name$7) {
        return !pk$4.exists((Function1<TableMetadata.DbIndex, boolean> & Serializable)_$3 -> _$3.cols().contains(name$7));
    }

    private static final Option pkNormalize$1(String defaultPkName$1, Option pk2) {
        return pk2.map((Function1<TableMetadata.DbIndex, TableMetadata.DbIndex> & Serializable)pk -> {
            String string2 = pk.name();
            String string3 = defaultPkName$1;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return pk.mapName((Function1<String, String> & Serializable)_$8 -> null);
            }
            return pk;
        });
    }

    private static final String prefix$1(String s2) {
        if (s2.indexOf(".") < 0) {
            return "";
        }
        return new StringBuilder(1).append(s2.substring(0, s2.lastIndexOf("."))).append(".").toString();
    }

    private static final String suffix$1(String s2) {
        if (s2.indexOf(".") < 0) {
            return s2;
        }
        return s2.substring(s2.lastIndexOf(".") + 1);
    }

    private static final String toRefColName$1(String col, String refCol) {
        if (col.endsWith(new StringBuilder(1).append("_").append(refCol).toString())) {
            return new StringBuilder(1).append(col.substring(0, col.length() - refCol.length() - 1)).append(".").append(refCol).toString();
        }
        return col;
    }

    private static final /* synthetic */ boolean $anonfun$7(boolean _$13) {
        return !_$13;
    }

    private static /* bridge */ /* synthetic */ boolean $anonfun$adapted$1(Object _$13) {
        return MdConventions.$anonfun$7(BoxesRunTime.unboxToBoolean(_$13));
    }

    private static final /* synthetic */ boolean $anonfun$8(ColumnDef_ col$2, boolean _$14) {
        return _$14 != col$2.nullable();
    }

    private static /* bridge */ /* synthetic */ boolean $anonfun$adapted$2(ColumnDef_ col$5, Object _$14) {
        return MdConventions.$anonfun$8(col$5, BoxesRunTime.unboxToBoolean(_$14));
    }

    private static final /* synthetic */ boolean $anonfun$9(ColumnDef_ col$3, Type _$15) {
        Type type2 = _$15;
        Object t = col$3.type_();
        return type2 == null ? t != null : !((Object)type2).equals(t);
    }

    private static final /* synthetic */ boolean $anonfun$10(ColumnDef_ col$4, String _$16) {
        String string2 = _$16;
        String string3 = col$4.comments();
        return string2 == null ? string3 != null : !string2.equals(string3);
    }

    /*
     * Unable to fully structure code
     */
    private final FieldDef_ mapField$1(TableMetadata tableMetadata$1, ViewDef_ view$1, FieldDef_ f) {
        block6: {
            block7: {
                block5: {
                    if (f.table() == null || ((Type)f.type_()).isComplexType()) {
                        var4_4 = new IoColumnType(Option$.MODULE$.apply(BoxesRunTime.boxToBoolean(f.nullable())).filter((Function1<Boolean, Object>)(Function1<Object, boolean> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$adapted$1(java.lang.Object ), (Ljava/lang/Object;)Z)()), this.typeOpt(f.name(), (Type)f.type_()));
                        var5_5 = f.copy$default$1();
                        var6_6 = f.copy$default$2();
                        var7_7 = f.copy$default$3();
                        var8_8 = f.copy$default$4();
                        var9_9 = f.copy$default$5();
                        var10_10 = f.copy$default$6();
                        var11_11 = f.copy$default$7();
                        var12_12 = f.copy$default$8();
                        var13_13 = f.copy$default$9();
                        var14_14 = f.copy$default$10();
                        var15_15 = f.copy$default$11();
                        var16_16 = f.copy$default$12();
                        var17_17 = f.copy$default$14();
                        var18_18 = f.copy$default$15();
                        var19_19 = f.copy$default$16();
                        var20_20 = f.copy$default$17();
                        var21_21 = f.copy$default$18();
                        return f.copy(var5_5, var6_6, var7_7, var8_8, var9_9, var10_10, var11_11, var12_12, var13_13, var14_14, var15_15, var16_16, var4_4, var17_17, var18_18, var19_19, var20_20, var21_21);
                    }
                    col = tableMetadata$1.columnDef(view$1, f);
                    nullableOpt = Option$.MODULE$.apply(BoxesRunTime.boxToBoolean(f.nullable())).filter((Function1<Boolean, Object>)(Function1<Object, boolean> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$adapted$2(org.mojoz.metadata.ColumnDef_ java.lang.Object ), (Ljava/lang/Object;)Z)(col));
                    type_ = Option$.MODULE$.apply(f.type_()).filter((Function1<Type, boolean> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$9(org.mojoz.metadata.ColumnDef_ org.mojoz.metadata.Type ), (Lorg/mojoz/metadata/Type;)Z)(col));
                    if (!f.isExpression() && f.expression() == null) break block5;
                    if (f.expression() == null) ** GOTO lbl-1000
                    v0 = f.expression().replace(".", "_");
                    var26_25 = f.fieldName();
                    if (!(v0 != null ? v0.equals(var26_25) == false : var26_25 != null)) {
                        v1 = Tuple2$.MODULE$.apply(f.expression(), null);
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = Tuple2$.MODULE$.apply(f.fieldName(), f.expression());
                    }
                    break block6;
                }
                if (f.tableAlias() == null) break block7;
                v2 = f.tableAlias();
                var27_26 = view$1.tableAlias();
                if (!(v2 == null ? var27_26 != null : v2.equals(var27_26) == false)) break block7;
                v1 = Tuple2$.MODULE$.apply(new StringBuilder(1).append(f.tableAlias()).append(".").append(f.name()).toString(), f.expression());
                break block6;
            }
            if (f.table() == null) ** GOTO lbl-1000
            v3 = f.table();
            var28_27 = view$1.table();
            if (v3 == null ? var28_27 != null : v3.equals(var28_27) == false) {
                v1 = Tuple2$.MODULE$.apply(new StringBuilder(1).append(f.table()).append(".").append(f.name()).toString(), f.expression());
            } else lbl-1000:
            // 2 sources

            {
                v1 = Tuple2$.MODULE$.apply(f.name(), f.expression());
            }
        }
        var25_28 = v1;
        newName = var25_28._1();
        newExpr = var25_28._2();
        var31_31 = (String)Option$.MODULE$.apply(f.comments()).filter((Function1<String, Object>)(Function1<String, boolean> & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$10(org.mojoz.metadata.ColumnDef_ java.lang.String ), (Ljava/lang/String;)Z)(col)).orNull($less$colon$less$.MODULE$.refl());
        var32_32 = new IoColumnType(nullableOpt, type_);
        var33_33 = f.copy$default$1();
        var34_34 = f.copy$default$2();
        var35_35 = f.copy$default$4();
        var36_36 = f.copy$default$5();
        var37_37 = f.copy$default$6();
        var38_38 = f.copy$default$7();
        var39_39 = f.copy$default$8();
        var40_40 = f.copy$default$10();
        var41_41 = f.copy$default$11();
        var42_42 = f.copy$default$12();
        var43_43 = f.copy$default$14();
        var44_44 = f.copy$default$15();
        var45_45 = f.copy$default$16();
        var46_46 = f.copy$default$18();
        return f.copy(var33_33, var34_34, newName, var35_35, var36_36, var37_37, var38_38, var39_39, newExpr, var40_40, var41_41, var42_42, var32_32, var43_43, var44_44, var45_45, var31_31, var46_46);
    }

    private static final boolean $anonfun$12() {
        return false;
    }

    public static class Ends
    implements Pattern,
    Product,
    Serializable {
        private final String pattern;

        public static Ends apply(String string2) {
            return MdConventions$Ends$.MODULE$.apply(string2);
        }

        public static Ends fromProduct(Product product) {
            return MdConventions$Ends$.MODULE$.fromProduct(product);
        }

        public static Ends unapply(Ends ends) {
            return MdConventions$Ends$.MODULE$.unapply(ends);
        }

        public Ends(String pattern) {
            this.pattern = pattern;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Ends)) return false;
            Ends ends = (Ends)object;
            String string2 = this.pattern();
            String string3 = ends.pattern();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (!ends.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Ends;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Ends";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pattern";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String pattern() {
            return this.pattern;
        }

        public Ends copy(String pattern) {
            return new Ends(pattern);
        }

        public String copy$default$1() {
            return this.pattern();
        }

        public String _1() {
            return this.pattern();
        }
    }

    public static class Equals
    implements Pattern,
    Product,
    Serializable {
        private final String pattern;

        public static Equals apply(String string2) {
            return MdConventions$Equals$.MODULE$.apply(string2);
        }

        public static Equals fromProduct(Product product) {
            return MdConventions$Equals$.MODULE$.fromProduct(product);
        }

        public static Equals unapply(Equals equals) {
            return MdConventions$Equals$.MODULE$.unapply(equals);
        }

        public Equals(String pattern) {
            this.pattern = pattern;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Equals)) return false;
            Equals equals = (Equals)object;
            String string2 = this.pattern();
            String string3 = equals.pattern();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (!equals.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Equals;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Equals";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pattern";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String pattern() {
            return this.pattern;
        }

        public Equals copy(String pattern) {
            return new Equals(pattern);
        }

        public String copy$default$1() {
            return this.pattern();
        }

        public String _1() {
            return this.pattern();
        }
    }

    public static interface Pattern {
    }

    public static class PatternSource
    implements Product,
    Serializable {
        private final String filename;
        private final Seq defaultPatterns;

        public static PatternSource apply(String string2, Seq<String> seq) {
            return MdConventions$PatternSource$.MODULE$.apply(string2, seq);
        }

        public static PatternSource fromProduct(Product product) {
            return MdConventions$PatternSource$.MODULE$.fromProduct(product);
        }

        public static PatternSource unapply(PatternSource patternSource) {
            return MdConventions$PatternSource$.MODULE$.unapply(patternSource);
        }

        public PatternSource(String filename, Seq<String> defaultPatterns) {
            this.filename = filename;
            this.defaultPatterns = defaultPatterns;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PatternSource)) return false;
            PatternSource patternSource = (PatternSource)object;
            String string2 = this.filename();
            String string3 = patternSource.filename();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            Seq<String> seq = this.defaultPatterns();
            Seq<String> seq2 = patternSource.defaultPatterns();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!patternSource.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof PatternSource;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "PatternSource";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "filename";
            }
            if (1 == n2) {
                return "defaultPatterns";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String filename() {
            return this.filename;
        }

        public Seq<String> defaultPatterns() {
            return this.defaultPatterns;
        }

        public PatternSource copy(String filename, Seq<String> defaultPatterns) {
            return new PatternSource(filename, defaultPatterns);
        }

        public String copy$default$1() {
            return this.filename();
        }

        public Seq<String> copy$default$2() {
            return this.defaultPatterns();
        }

        public String _1() {
            return this.filename();
        }

        public Seq<String> _2() {
            return this.defaultPatterns();
        }
    }

    public static class SimplePatternMdConventions
    extends MdConventions {
        private final Seq booleanNamePatterns;
        private final Seq dateNamePatterns;
        private final Seq dateTimeNamePatterns;

        public static Seq<String> $lessinit$greater$default$1() {
            return MdConventions$SimplePatternMdConventions$.MODULE$.$lessinit$greater$default$1();
        }

        public static Seq<String> $lessinit$greater$default$2() {
            return MdConventions$SimplePatternMdConventions$.MODULE$.$lessinit$greater$default$2();
        }

        public static Seq<String> $lessinit$greater$default$3() {
            return MdConventions$SimplePatternMdConventions$.MODULE$.$lessinit$greater$default$3();
        }

        public SimplePatternMdConventions(Seq<String> booleanNamePatternStrings, Seq<String> dateNamePatternStrings, Seq<String> dateTimeNamePatternStrings) {
            super(MdConventions$.MODULE$.$lessinit$greater$default$1());
            this.booleanNamePatterns = ((Seq)booleanNamePatternStrings.map((Function1<String, Pattern> & Serializable)patternString -> this.pattern((String)patternString))).toSeq();
            this.dateNamePatterns = ((Seq)dateNamePatternStrings.map((Function1<String, Pattern> & Serializable)patternString -> this.pattern((String)patternString))).toSeq();
            this.dateTimeNamePatterns = ((Seq)dateTimeNamePatternStrings.map((Function1<String, Pattern> & Serializable)patternString -> this.pattern((String)patternString))).toSeq();
        }

        public SimplePatternMdConventions(Function1<String, InputStream> resourceLoader) {
            this(MdConventions$.MODULE$.namePatternsFromResource(MdConventions$.MODULE$.defaultBooleanNamePatternSource(), resourceLoader), MdConventions$.MODULE$.namePatternsFromResource(MdConventions$.MODULE$.defaultDateNamePatternSource(), resourceLoader), MdConventions$.MODULE$.namePatternsFromResource(MdConventions$.MODULE$.defaultDateTimeNamePatternSource(), resourceLoader));
        }

        public Seq<Pattern> booleanNamePatterns() {
            return this.booleanNamePatterns;
        }

        public Seq<Pattern> dateNamePatterns() {
            return this.dateNamePatterns;
        }

        public Seq<Pattern> dateTimeNamePatterns() {
            return this.dateTimeNamePatterns;
        }

        public Pattern pattern(String patternString) {
            if (patternString.startsWith("*")) {
                return MdConventions$Ends$.MODULE$.apply(patternString.substring(1));
            }
            return patternString.endsWith("*") ? MdConventions$Starts$.MODULE$.apply(patternString.substring(0, patternString.length() - 1)) : MdConventions$Equals$.MODULE$.apply(patternString);
        }

        public boolean matches(String name, Pattern pattern) {
            Pattern pattern2 = pattern;
            if (pattern2 instanceof Equals) {
                String string2;
                Equals equals = MdConventions$Equals$.MODULE$.unapply((Equals)pattern2);
                String s2 = string2 = equals._1();
                String string3 = name;
                String string4 = s2;
                return !(string3 != null ? !string3.equals(string4) : string4 != null);
            }
            if (pattern2 instanceof Starts) {
                String string5;
                Starts starts = MdConventions$Starts$.MODULE$.unapply((Starts)pattern2);
                String s3 = string5 = starts._1();
                return name.startsWith(s3);
            }
            if (pattern2 instanceof Ends) {
                String string6;
                Ends ends = MdConventions$Ends$.MODULE$.unapply((Ends)pattern2);
                String s4 = string6 = ends._1();
                return name.endsWith(s4);
            }
            throw new MatchError(pattern2);
        }

        @Override
        public boolean isBooleanName(String name) {
            return this.booleanNamePatterns().exists((Function1<Pattern, boolean> & Serializable)pattern -> this.matches(name, (Pattern)pattern));
        }

        @Override
        public boolean isDateName(String name) {
            return this.dateNamePatterns().exists((Function1<Pattern, boolean> & Serializable)pattern -> this.matches(name, (Pattern)pattern));
        }

        @Override
        public boolean isDateTimeName(String name) {
            return this.dateTimeNamePatterns().exists((Function1<Pattern, boolean> & Serializable)pattern -> this.matches(name, (Pattern)pattern));
        }
    }

    public static class Starts
    implements Pattern,
    Product,
    Serializable {
        private final String pattern;

        public static Starts apply(String string2) {
            return MdConventions$Starts$.MODULE$.apply(string2);
        }

        public static Starts fromProduct(Product product) {
            return MdConventions$Starts$.MODULE$.fromProduct(product);
        }

        public static Starts unapply(Starts starts) {
            return MdConventions$Starts$.MODULE$.unapply(starts);
        }

        public Starts(String pattern) {
            this.pattern = pattern;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Starts)) return false;
            Starts starts = (Starts)object;
            String string2 = this.pattern();
            String string3 = starts.pattern();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (!starts.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Starts;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Starts";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "pattern";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String pattern() {
            return this.pattern;
        }

        public Starts copy(String pattern) {
            return new Starts(pattern);
        }

        public String copy$default$1() {
            return this.pattern();
        }

        public String _1() {
            return this.pattern();
        }
    }
}

