/*
 * Decompiled with CFR 0.152.
 */
package org.mojoz.metadata.in;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.mojoz.metadata.in.FileMdSource;
import org.mojoz.metadata.in.FilesMdSource;
import org.mojoz.metadata.in.MdSource;
import org.mojoz.metadata.in.YamlMd;
import org.mojoz.metadata.in.YamlMd$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public class ResourcePathsMdSource
implements MdSource {
    private final Seq resourcePaths;
    private final Function1 nameFilter;
    private final ClassLoader classLoader;

    public ResourcePathsMdSource(Seq<String> resourcePaths, Function1<String, Object> nameFilter) {
        this.resourcePaths = resourcePaths;
        this.nameFilter = nameFilter;
        this.classLoader = Thread.currentThread().getContextClassLoader();
    }

    public Seq<String> resourcePaths() {
        return this.resourcePaths;
    }

    public Function1<String, Object> nameFilter() {
        return this.nameFilter;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    @Override
    public Seq<YamlMd> defSets() {
        return (Seq)this.resourcePaths().flatMap((Function1<String, IterableOnce> & Serializable)path -> {
            String normalizedPath = path.startsWith("/") ? StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString((String)path), 1) : path;
            URL resourceUrl = this.classLoader().getResource(normalizedPath);
            if (resourceUrl == null) {
                return package$.MODULE$.Nil();
            }
            String string2 = resourceUrl.getProtocol();
            if ("file".equals(string2)) {
                String filePath = resourceUrl.getPath();
                if (Files.isDirectory(Paths.get(filePath, new String[0]), new LinkOption[0])) {
                    return new FilesMdSource(filePath, (Function1<File, Object>)(Function1<File, boolean> & Serializable)f -> BoxesRunTime.unboxToBoolean(this.nameFilter().apply(f.getName()))).defSets();
                }
                if (BoxesRunTime.unboxToBoolean(this.nameFilter().apply(filePath))) {
                    return new FileMdSource(new File(filePath)).defSets();
                }
                return package$.MODULE$.Nil();
            }
            if ("jar".equals(string2)) {
                Seq seq;
                String jarPath = resourceUrl.getPath().substring(5, resourceUrl.getPath().indexOf("!"));
                String entryPath = resourceUrl.getPath().substring(resourceUrl.getPath().indexOf("!") + 2);
                try (JarFile jarFile = new JarFile(jarPath);){
                    JarEntry entry2;
                    Seq entries = CollectionConverters$.MODULE$.EnumerationHasAsScala(jarFile.entries()).asScala().filter((Function1<JarEntry, Object>)(Function1<JarEntry, boolean> & Serializable)entry -> entry.getName().startsWith(entryPath) && !entry.isDirectory()).toSeq();
                    seq = entries.isEmpty() ? ((entry2 = jarFile.getJarEntry(entryPath)) != null && !entry2.isDirectory() ? (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)YamlMd$.MODULE$.apply(entryPath, 0, Source$.MODULE$.fromInputStream(jarFile.getInputStream(entry2), Codec$.MODULE$.string2codec("UTF-8")).mkString())), Nil$.MODULE$)) : package$.MODULE$.Nil()) : (Seq)entries.map((Function1<JarEntry, YamlMd> & Serializable)entry -> YamlMd$.MODULE$.apply(entry.getName(), 0, Source$.MODULE$.fromInputStream(jarFile.getInputStream((ZipEntry)entry), Codec$.MODULE$.string2codec("UTF-8")).mkString()));
                }
                return seq;
            }
            String protocol = string2;
            throw new IllegalArgumentException(new StringBuilder(27).append("Unsupported protocol: ").append(protocol).append(" for ").append(normalizedPath).toString());
        });
    }
}

