/*
 * Decompiled with CFR 0.152.
 */
package org.mojoz.metadata.in;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.mojoz.metadata.ColumnDef_;
import org.mojoz.metadata.JdbcLoadInfo;
import org.mojoz.metadata.TableDef_;
import org.mojoz.metadata.TableMetadata;
import org.mojoz.metadata.TableMetadata$CheckConstraint$;
import org.mojoz.metadata.TableMetadata$DbIndex$;
import org.mojoz.metadata.TableMetadata$Ref$;
import org.mojoz.metadata.Type;
import org.mojoz.metadata.Type$;
import org.mojoz.metadata.TypeDef;
import org.mojoz.metadata.in.CkParser$;
import org.mojoz.metadata.in.JdbcTableDefLoader$;
import org.mojoz.metadata.in.JdbcTableDefLoader$H2$;
import org.mojoz.metadata.in.JdbcTableDefLoader$Hsqldb$;
import org.mojoz.metadata.in.JdbcTableDefLoader$JdbcColumnType$;
import org.mojoz.metadata.in.JdbcTableDefLoader$Oracle$;
import org.mojoz.metadata.in.JdbcTableDefLoader$Other$;
import org.mojoz.metadata.in.JdbcTableDefLoader$Postgresql$;
import org.mojoz.metadata.package$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.AbstractIterable;
import scala.collection.AbstractSeq;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.Ordering$Short$;
import scala.math.Ordering$String$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LazyVals$Evaluating$;
import scala.runtime.LazyVals$NullValue$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;
import scala.util.matching.Regex;

public abstract class JdbcTableDefLoader {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(JdbcTableDefLoader.class.getDeclaredField("jdbcLoadInfoToTypeDef$lzy1"));
    private Seq<TypeDef> typeDefs;
    private final String jdbcLoadInfoKey;
    private volatile Object jdbcLoadInfoToTypeDef$lzy1;
    private final Regex PlainTypeName;
    private final Regex SizedTypeName;
    private final Regex FracTypeName;

    public static Map<Object, String> jdbcCodeToTypeName() {
        return JdbcTableDefLoader$.MODULE$.jdbcCodeToTypeName();
    }

    public static JdbcTableDefLoader jdbcTableDefLoader(Connection connection, Seq<TypeDef> seq) {
        return JdbcTableDefLoader$.MODULE$.jdbcTableDefLoader(connection, seq);
    }

    public static Map<String, Object> jdbcTypeNameToCode() {
        return JdbcTableDefLoader$.MODULE$.jdbcTypeNameToCode();
    }

    public static List<TableDef_<ColumnDef_<Type>>> tableDefs(Connection connection, String string2, String string3, String string4, Seq<String> seq) {
        return JdbcTableDefLoader$.MODULE$.tableDefs(connection, string2, string3, string4, seq);
    }

    public static Seq<TypeDef> jdbcTableDefLoader$default$2() {
        return JdbcTableDefLoader$.MODULE$.jdbcTableDefLoader$default$2();
    }

    public JdbcTableDefLoader(Seq<TypeDef> typeDefs) {
        this.typeDefs = typeDefs;
        this.jdbcLoadInfoKey = "jdbc";
        String ident = "[_\\p{IsLatin}][_\\p{IsLatin}0-9]*";
        this.PlainTypeName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(13).append("^(").append(ident).append("|").append(ident).append(" +").append(ident).append(") ARRAY$").toString()));
        this.SizedTypeName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(22).append("^(").append(ident).append("|").append(ident).append(" +").append(ident).append(")\\((\\d+)\\) ARRAY$").toString()));
        this.FracTypeName = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(new StringBuilder(30).append("^(").append(ident).append("|").append(ident).append(" +").append(ident).append(")\\((\\d+), *(\\d+)\\) ARRAY$").toString()));
    }

    public void log(Function0<String> msg) {
    }

    public ListBuffer<TableDef_<ColumnDef_<JdbcColumnType>>> jdbcTableDefsBuf(Connection conn, String catalog, String schemaPattern, String tableNamePattern, Seq<String> types) {
        ListBuffer tableDefs = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new TableDef_[0]));
        DatabaseMetaData dmd = conn.getMetaData();
        ResultSet rs = dmd.getTables(catalog, schemaPattern, tableNamePattern, types.size() == 0 ? (String[])null : (String[])types.toArray(ClassTag$.MODULE$.apply(String.class)));
        while (rs.next()) {
            Tuple2<List<TableMetadata.Index>, List<TableMetadata.Index>> tuple2;
            String catalog2 = rs.getString("TABLE_CAT");
            String schema = rs.getString("TABLE_SCHEM");
            String tableName = rs.getString("TABLE_NAME");
            String tableType = rs.getString("TABLE_TYPE");
            this.log(() -> JdbcTableDefLoader.jdbcTableDefsBuf$$anonfun$1(tableType, catalog2, schema, tableName));
            String comments = rs.getString("REMARKS");
            ResultSet colsRs = this.dmd_getColumns(dmd, catalog2, schema, tableName, tableType);
            List cols = colsRs != null ? this.colDefs(colsRs) : scala.package$.MODULE$.Nil();
            ResultSet pkRs = this.dmd_getPrimaryKeys(dmd, catalog2, schema, tableName, tableType);
            None$ pk = pkRs != null ? this.pk(pkRs) : None$.MODULE$;
            ResultSet idxRs = this.dmd_getIndexInfo(dmd, catalog2, schema, tableName, tableType);
            Tuple2<List<TableMetadata.Index>, List<TableMetadata.Index>> tuple22 = tuple2 = idxRs != null ? this.ukAndIdx(idxRs) : Tuple2$.MODULE$.apply(scala.package$.MODULE$.Nil(), scala.package$.MODULE$.Nil());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List<TableMetadata.Index> uk2 = tuple2._1();
            List<TableMetadata.Index> idx = tuple2._2();
            Tuple2<List<TableMetadata.Index>, List<TableMetadata.Index>> tuple23 = Tuple2$.MODULE$.apply(uk2, idx);
            List<TableMetadata.DbIndex> uk3 = tuple23._1();
            List<TableMetadata.DbIndex> idx2 = tuple23._2();
            ResultSet refsRs = this.dmd_getImportedKeys(dmd, catalog2, schema, tableName, tableType);
            List refs = refsRs != null ? this.refs(refsRs) : scala.package$.MODULE$.Nil();
            Seq ck2 = (Seq)this.checkConstraints(conn, catalog2, schema, tableName).filterNot((Function1<TableMetadata.CheckConstraint, boolean> & Serializable)c -> CkParser$.MODULE$.isNotNullCheck(c.expression()));
            Seq checkColEnum = (Seq)((IterableOps)((IterableOps)((IterableOps)((IterableOps)ck2.map((Function1<TableMetadata.CheckConstraint, Tuple2> & Serializable)c -> Tuple2$.MODULE$.apply(c, CkParser$.MODULE$.colAndEnum(c.expression())))).filter((Function1<Tuple2, boolean> & Serializable)_$1 -> ((Option)_$1._2()).isDefined())).map((Function1<Tuple2, Tuple3> & Serializable)cce -> Tuple3$.MODULE$.apply(cce._1(), JdbcTableDefLoader.findCol$1(cols, tableName, schema, (String)((Tuple2)((Option)cce._2()).get())._1()), ((Tuple2)((Option)cce._2()).get())._2()))).filter((Function1<Tuple3, boolean> & Serializable)_$2 -> ((Option)_$2._2()).isDefined())).map((Function1<Tuple3, Tuple3> & Serializable)cce -> Tuple3$.MODULE$.apply(cce._1(), ((Option)cce._2()).get(), cce._3()));
            Set enumCk = ((IterableOnceOps)checkColEnum.map((Function1<Tuple3, TableMetadata.CheckConstraint> & Serializable)_$3 -> (TableMetadata.CheckConstraint)_$3._1())).toSet();
            Seq unmappedCk = (Seq)((SeqOps)ck2.filterNot((Function1<TableMetadata.CheckConstraint, boolean> & Serializable)elem -> enumCk.contains(elem))).sortBy((Function1<TableMetadata.CheckConstraint, Tuple2> & Serializable)ck -> Tuple2$.MODULE$.apply(ck.name() == null ? "" : ck.name(), ck.expression() == null ? "" : ck.expression()), Ordering$.MODULE$.Tuple2(Ordering$String$.MODULE$, Ordering$String$.MODULE$));
            Map colToEnum = ((IterableOnceOps)checkColEnum.map((Function1<Tuple3, Tuple2> & Serializable)cce -> Tuple2$.MODULE$.apply(cce._2(), cce._3()))).toMap($less$colon$less$.MODULE$.refl());
            Object mappedCols = cols.map((Function1<ColumnDef_, ColumnDef_> & Serializable)c -> {
                Option enm = colToEnum.get(c);
                if (enm.isDefined()) {
                    List list = (List)enm.get();
                    String string2 = c.copy$default$1();
                    JdbcColumnType jdbcColumnType = (JdbcColumnType)c.copy$default$2();
                    boolean bl = c.copy$default$3();
                    String string3 = c.copy$default$4();
                    String string4 = c.copy$default$6();
                    Map<String, Object> map = c.copy$default$7();
                    return c.copy(string2, jdbcColumnType, bl, string3, list, string4, map);
                }
                return c;
            });
            Object db = null;
            String tableFullName = ((AbstractIterable)((List)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)catalog2), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)schema), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)tableName), Nil$.MODULE$))))).filter((Function1<String, boolean> & Serializable)_$4 -> _$4 != null)).filter((Function1<String, boolean> & Serializable)_$5 -> {
                String string2 = _$5;
                String string3 = "";
                return string2 == null ? string3 != null : !string2.equals(string3);
            })).mkString(".");
            Map extras = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
            tableDefs.$plus$eq(package$.MODULE$.JdbcTableDef(null, tableFullName, comments, (Seq<ColumnDef_<JdbcColumnType>>)mappedCols, pk, uk3, unmappedCk, idx2, refs, extras));
        }
        rs.close();
        return tableDefs;
    }

    public ResultSet dmd_getColumns(DatabaseMetaData dmd, String catalog, String schema, String tableName, String tableType) {
        ResultSet resultSet;
        try {
            resultSet = dmd.getColumns(catalog, schema, tableName, null);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option.get();
                throw new RuntimeException(new StringBuilder(21).append("Failed to get columns").append(new StringBuilder(39).append(" for catalog ").append(catalog).append(", schema ").append(schema).append(", table ").append(tableName).append(" of type ").append(tableType).toString()).toString(), ex);
            }
            throw throwable;
        }
        return resultSet;
    }

    public ResultSet dmd_getPrimaryKeys(DatabaseMetaData dmd, String catalog, String schema, String tableName, String tableType) {
        ResultSet resultSet;
        try {
            resultSet = dmd.getPrimaryKeys(catalog, schema, tableName);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option.get();
                throw new RuntimeException(new StringBuilder(26).append("Failed to get primary keys").append(new StringBuilder(39).append(" for catalog ").append(catalog).append(", schema ").append(schema).append(", table ").append(tableName).append(" of type ").append(tableType).toString()).toString(), ex);
            }
            throw throwable;
        }
        return resultSet;
    }

    public ResultSet dmd_getIndexInfo(DatabaseMetaData dmd, String catalog, String schema, String tableName, String tableType) {
        ResultSet resultSet;
        try {
            resultSet = dmd.getIndexInfo(catalog, schema, tableName, false, true);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option.get();
                throw new RuntimeException(new StringBuilder(24).append("Failed to get index info").append(new StringBuilder(39).append(" for catalog ").append(catalog).append(", schema ").append(schema).append(", table ").append(tableName).append(" of type ").append(tableType).toString()).toString(), ex);
            }
            throw throwable;
        }
        return resultSet;
    }

    public ResultSet dmd_getImportedKeys(DatabaseMetaData dmd, String catalog, String schema, String tableName, String tableType) {
        ResultSet resultSet;
        try {
            resultSet = dmd.getImportedKeys(catalog, schema, tableName);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option.get();
                throw new RuntimeException(new StringBuilder(27).append("Failed to get imported keys").append(new StringBuilder(39).append(" for catalog ").append(catalog).append(", schema ").append(schema).append(", table ").append(tableName).append(" of type ").append(tableType).toString()).toString(), ex);
            }
            throw throwable;
        }
        return resultSet;
    }

    public List<TableDef_<ColumnDef_<JdbcColumnType>>> jdbcTableDefs(Connection conn, String catalog, String schemaPattern, String tableNamePattern, Seq<String> types) {
        return this.jdbcTableDefsBuf(conn, catalog, schemaPattern, tableNamePattern, types).toList();
    }

    public abstract Seq<TableMetadata.CheckConstraint> checkConstraints(Connection var1, String var2, String var3, String var4);

    public List<TableMetadata.CheckConstraint> checkConstraints(ResultSet rs) {
        List checks = scala.package$.MODULE$.Nil();
        while (rs.next()) {
            String name = rs.getString("CONSTRAINT_NAME");
            String expr = rs.getString("CHECK_CLAUSE");
            TableMetadata.CheckConstraint checkConstraint = TableMetadata$CheckConstraint$.MODULE$.apply(name, expr);
            checks = checks.$colon$colon(checkConstraint);
        }
        rs.close();
        return checks;
    }

    public List<TableMetadata.CheckConstraint> standardCheckConstraints(Connection conn, String catalog, String schemaPattern, String tableNamePattern) {
        PreparedStatement ps = conn.prepareStatement(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |select c.constraint_name, c.check_clause\n      |  -- TODO? is_deferrable, initially_deferred\n      |from information_schema.check_constraints c\n      |join information_schema.table_constraints t\n      |on c.constraint_catalog = t.constraint_catalog\n      |and  c.constraint_schema = t.constraint_schema\n      |and  c.constraint_name = t.constraint_name\n      |where constraint_type = 'CHECK'\n      |  and table_catalog like ?\n      |  and table_schema like ?\n      |  and table_name like ?\n      ")).trim(), 1003, 1007, 2);
        ps.setString(1, catalog == null ? "%" : catalog);
        ps.setString(2, schemaPattern);
        ps.setString(3, tableNamePattern);
        ResultSet rs = ps.executeQuery();
        List<TableMetadata.CheckConstraint> checks = this.checkConstraints(rs);
        ps.close();
        return checks;
    }

    /*
     * Unable to fully structure code
     */
    public List<ColumnDef_<JdbcColumnType>> colDefs(ResultSet rs) {
        cols = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new ColumnDef_[0]));
        while (rs.next()) {
            block7: {
                block5: {
                    block6: {
                        name = rs.getString("COLUMN_NAME");
                        jdbcTypeCode = rs.getInt("DATA_TYPE");
                        dbTypeName = rs.getString("TYPE_NAME");
                        size = rs.getInt("COLUMN_SIZE");
                        fractionDigits = rs.getInt("DECIMAL_DIGITS");
                        nullable = rs.getInt("NULLABLE") == 1;
                        var10_10 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(jdbcTypeCode), rs.getString("COLUMN_DEF"));
                        if (var10_10 == null) break block5;
                        var11_11 = var10_10._2();
                        if (var11_11 != null) break block6;
                        v0 = null;
                        break block7;
                    }
                    if (16 != BoxesRunTime.unboxToInt(var10_10._1())) ** GOTO lbl-1000
                    if ("TRUE".equals(var11_11)) {
                        v0 = "true";
                    } else if ("FALSE".equals(var11_11)) {
                        v0 = "false";
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = (d = var11_11).indexOf("::") > 0 ? d.substring(0, d.indexOf("::")) : (d = var11_11);
                    }
                    break block7;
                }
                throw new MatchError(var10_10);
            }
            dbDefault = v0;
            comments = rs.getString("REMARKS");
            check = null;
            dbType = JdbcTableDefLoader$JdbcColumnType$.MODULE$.apply(dbTypeName, jdbcTypeCode, size, fractionDigits);
            extras = (Map)Predef$.MODULE$.Map().apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
            cols.$plus$eq(package$.MODULE$.JdbcColumnDef(name, dbType, nullable, dbDefault, null, comments, extras));
        }
        rs.close();
        return cols.toList();
    }

    public Option<TableMetadata.Index> pk(ResultSet rs) {
        List cols = scala.package$.MODULE$.Nil();
        while (rs.next()) {
            short keySeq = rs.getShort("KEY_SEQ");
            String colName = rs.getString("COLUMN_NAME");
            String pkName = rs.getString("PK_NAME");
            Tuple3<Short, String, String> tuple3 = Tuple3$.MODULE$.apply(BoxesRunTime.boxToShort(keySeq), colName, pkName);
            cols = cols.$colon$colon(tuple3);
        }
        rs.close();
        String pkName = (String)((List)cols.map((Function1<Tuple3, String> & Serializable)_$6 -> (String)_$6._3())).headOption().orNull($less$colon$less$.MODULE$.refl());
        if (cols.size() == 0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(TableMetadata$DbIndex$.MODULE$.apply(pkName, (Seq<String>)((List)cols.sorted(Ordering$.MODULE$.Tuple3(Ordering$Short$.MODULE$, Ordering$String$.MODULE$, Ordering$String$.MODULE$))).map((Function1<Tuple3, String> & Serializable)_$7 -> (String)_$7._2()), null));
    }

    public Tuple2<List<TableMetadata.Index>, List<TableMetadata.Index>> ukAndIdx(ResultSet rs) {
        List uk2 = scala.package$.MODULE$.Nil();
        List idx = scala.package$.MODULE$.Nil();
        while (rs.next()) {
            String string2;
            short s2 = rs.getShort("TYPE");
            boolean isIndex = 0 != s2;
            if (!isIndex) continue;
            String string3 = rs.getString("ASC_OR_DESC");
            if ("A".equals(string3)) {
                string2 = "ASC";
            } else if ("D".equals(string3)) {
                string2 = "DESC";
            } else if (string3 == null) {
                string2 = null;
            } else {
                throw new MatchError((Object)string3);
            }
            String ascDesc = string2;
            boolean nonUnique = rs.getBoolean("NON_UNIQUE");
            short ordinal = rs.getShort("ORDINAL_POSITION");
            String colName = rs.getString("COLUMN_NAME");
            String idxName = rs.getString("INDEX_NAME");
            String colExpr = ((AbstractIterable)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)colName), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)ascDesc), Nil$.MODULE$)))).filter((Function1<String, boolean> & Serializable)_$8 -> _$8 != null)).mkString(" ");
            Tuple3<Short, String, String> t2 = Tuple3$.MODULE$.apply(BoxesRunTime.boxToShort(ordinal), colExpr, idxName);
            if (nonUnique) {
                idx = idx.$colon$colon(t2);
                continue;
            }
            uk2 = uk2.$colon$colon(t2);
        }
        rs.close();
        Iterable uks = (Iterable)uk2.groupBy((Function1<Tuple3, String> & Serializable)_$9 -> (String)_$9._3()).map((Function1<Tuple2, TableMetadata.Index> & Serializable)t -> TableMetadata$DbIndex$.MODULE$.apply((String)t._1(), (Seq<String>)((List)((StrictOptimizedSeqOps)t._2()).sorted(Ordering$.MODULE$.Tuple3(Ordering$Short$.MODULE$, Ordering$String$.MODULE$, Ordering$String$.MODULE$))).map((Function1<Tuple3, String> & Serializable)_$10 -> (String)_$10._2()), null));
        Iterable idxs = (Iterable)idx.groupBy((Function1<Tuple3, String> & Serializable)_$11 -> (String)_$11._3()).map((Function1<Tuple2, TableMetadata.Index> & Serializable)t -> TableMetadata$DbIndex$.MODULE$.apply((String)t._1(), (Seq<String>)((List)((StrictOptimizedSeqOps)t._2()).sorted(Ordering$.MODULE$.Tuple3(Ordering$Short$.MODULE$, Ordering$String$.MODULE$, Ordering$String$.MODULE$))).map((Function1<Tuple3, String> & Serializable)_$12 -> (String)_$12._2()), null));
        return Tuple2$.MODULE$.apply(uks.toList().sortBy((Function1<TableMetadata.Index, String> & Serializable)_$13 -> _$13.name(), (Ordering)Ordering$String$.MODULE$), idxs.toList().sortBy((Function1<TableMetadata.Index, String> & Serializable)_$14 -> _$14.name(), (Ordering)Ordering$String$.MODULE$));
    }

    public List<TableMetadata.Ref> refs(ResultSet rs) {
        scala.collection.mutable.Map refMap = (scala.collection.mutable.Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
        while (rs.next()) {
            String string2;
            String pkTabCat = rs.getString("PKTABLE_CAT");
            String pkTabSch = rs.getString("PKTABLE_SCHEM");
            String pkTabName = rs.getString("PKTABLE_NAME");
            String pkColName = rs.getString("PKCOLUMN_NAME");
            String fkColName = rs.getString("FKCOLUMN_NAME");
            short keySeq = rs.getShort("KEY_SEQ");
            String updateRule = JdbcTableDefLoader.fkRule$1(rs.getShort("UPDATE_RULE"));
            String deleteRule = JdbcTableDefLoader.fkRule$1(rs.getShort("DELETE_RULE"));
            String fkName = rs.getString("FK_NAME");
            short s2 = rs.getShort("DEFERRABILITY");
            switch (s2) {
                case 5: {
                    string2 = "deferred";
                    break;
                }
                case 6: {
                    string2 = "immediate";
                    break;
                }
                case 7: {
                    string2 = "not deferrable";
                    break;
                }
                default: {
                    string2 = null;
                    break;
                }
            }
            String deferrability = string2;
            String pkTabFullName = ((AbstractIterable)((List)((List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)pkTabCat), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)pkTabSch), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)pkTabName), Nil$.MODULE$))))).filter((Function1<String, boolean> & Serializable)_$15 -> _$15 != null)).filter((Function1<String, boolean> & Serializable)_$16 -> {
                String string2 = _$16;
                String string3 = "";
                return string2 == null ? string3 != null : !string2.equals(string3);
            })).mkString(".");
            Option option = refMap.get(Tuple2$.MODULE$.apply(pkTabFullName, fkName));
            if (option instanceof Some) {
                TableMetadata.Ref r = (TableMetadata.Ref)((Some)option).value();
                Tuple2<String, String> tuple2 = Predef$.MODULE$.ArrowAssoc(Tuple2$.MODULE$.apply(pkTabFullName, fkName));
                Seq seq = (Seq)r.cols().$colon$plus(fkColName);
                Seq seq2 = (Seq)r.refCols().$colon$plus(pkColName);
                String string3 = r.copy$default$1();
                String string4 = r.copy$default$3();
                String string5 = r.copy$default$5();
                String string6 = r.copy$default$6();
                String string7 = r.copy$default$7();
                String string8 = r.copy$default$8();
                refMap.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(tuple2, r.copy(string3, seq, string4, seq2, string5, string6, string7, string8)));
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                Tuple2<String, String> tuple2 = Predef$.MODULE$.ArrowAssoc(Tuple2$.MODULE$.apply(pkTabFullName, fkName));
                refMap.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(tuple2, TableMetadata$Ref$.MODULE$.apply(fkName, (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)fkColName), Nil$.MODULE$)), pkTabFullName, (Seq)((SeqOps)new $colon$colon<Nothing$>((Nothing$)((Object)pkColName), Nil$.MODULE$)), null, null, deleteRule, updateRule)));
                continue;
            }
            throw new MatchError(option);
        }
        rs.close();
        return (List)refMap.values().toList().sortBy((Function1<TableMetadata.Ref, String> & Serializable)_$17 -> _$17.name(), (Ordering)Ordering$String$.MODULE$);
    }

    public String jdbcLoadInfoKey() {
        return this.jdbcLoadInfoKey;
    }

    public Seq<Tuple2<JdbcLoadInfo, TypeDef>> jdbcLoadInfoToTypeDef() {
        Object object = this.jdbcLoadInfoToTypeDef$lzy1;
        if (object instanceof Seq) {
            return (Seq)object;
        }
        if (object == LazyVals$NullValue$.MODULE$) {
            return null;
        }
        return (Seq)this.jdbcLoadInfoToTypeDef$lzyINIT1();
    }

    private Object jdbcLoadInfoToTypeDef$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jdbcLoadInfoToTypeDef$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, null, LazyVals$Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Seq seq = null;
                    try {
                        seq = (Seq)this.typeDefs.flatMap((Function1<TypeDef, IterableOnce> & Serializable)td -> {
                            Seq specific = (Seq)td.jdbcLoad().get(this.jdbcLoadInfoKey()).getOrElse(JdbcTableDefLoader::$anonfun$22);
                            Seq generic2 = (Seq)td.jdbcLoad().get("jdbc").getOrElse(JdbcTableDefLoader::$anonfun$23);
                            return (IterableOnce)((IterableOps)specific.$plus$plus((IterableOnce)generic2.filterNot((Function1<JdbcLoadInfo, boolean> & Serializable)elem -> specific.contains(elem)))).map((Function1<JdbcLoadInfo, Tuple2> & Serializable)_$18 -> {
                                JdbcLoadInfo jdbcLoadInfo = Predef$.MODULE$.ArrowAssoc(_$18);
                                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(jdbcLoadInfo, td);
                            });
                        });
                        object2 = seq == null ? LazyVals$NullValue$.MODULE$ : seq;
                        this.typeDefs = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS(this, OFFSET$0, LazyVals$Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jdbcLoadInfoToTypeDef$lzy1;
                            LazyVals$.MODULE$.objCAS(this, OFFSET$0, waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return seq;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals$Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS(this, OFFSET$0, object, new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Type jdbcTypeToMojozType(int jdbcTypeCode, int size, int frac) {
        return (Type)this.jdbcLoadInfoToTypeDef().find((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                JdbcLoadInfo jl = (JdbcLoadInfo)tuple2._1();
                TypeDef td = (TypeDef)tuple2._2();
                return jl.jdbcTypeCode() == jdbcTypeCode && BoxesRunTime.unboxToBoolean(jl.minSize().map(_$19 -> _$19 <= size).getOrElse(JdbcTableDefLoader::jdbcTypeToMojozType$$anonfun$1$$anonfun$2)) && BoxesRunTime.unboxToBoolean(jl.maxSize().map(_$20 -> _$20 >= size).getOrElse(JdbcTableDefLoader::jdbcTypeToMojozType$$anonfun$1$$anonfun$4)) && BoxesRunTime.unboxToBoolean(jl.minFractionDigits().map(_$21 -> _$21 <= frac).getOrElse(JdbcTableDefLoader::jdbcTypeToMojozType$$anonfun$1$$anonfun$6)) && BoxesRunTime.unboxToBoolean(jl.maxFractionDigits().map(_$22 -> _$22 >= frac).getOrElse(JdbcTableDefLoader::jdbcTypeToMojozType$$anonfun$1$$anonfun$8));
            }
            throw new MatchError(tuple2);
        }).map((Function1<Tuple2, Type> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Option<Object> option;
                Option<Object> option2;
                Option<Object> option3;
                JdbcLoadInfo jl = (JdbcLoadInfo)tuple2._1();
                TypeDef td = (TypeDef)tuple2._2();
                Option<Integer> option4 = jl.targetLength();
                if (option4 instanceof Some && ((Some)option4).value() == null) {
                    option3 = Some$.MODULE$.apply(BoxesRunTime.boxToInteger(size));
                } else {
                    Option<Integer> x = option4;
                    option3 = x.map((Function1<Integer, int> & Serializable)_$23 -> _$23);
                }
                Option<Object> length = option3;
                Option<Integer> option5 = jl.targetTotalDigits();
                if (option5 instanceof Some && ((Some)option5).value() == null) {
                    option2 = Some$.MODULE$.apply(BoxesRunTime.boxToInteger(size));
                } else {
                    Option<Integer> x = option5;
                    option2 = x.map((Function1<Integer, int> & Serializable)_$24 -> _$24);
                }
                Option<Object> totalDigits = option2;
                Option<Integer> option6 = jl.targetFractionDigits();
                if (option6 instanceof Some && ((Some)option6).value() == null) {
                    option = Some$.MODULE$.apply(BoxesRunTime.boxToInteger(frac));
                } else {
                    Option<Integer> x = option6;
                    option = x.map((Function1<Integer, int> & Serializable)_$25 -> _$25);
                }
                Option<Object> fractionDigits = option;
                boolean isComplexType = false;
                return Type$.MODULE$.apply(td.name(), length, totalDigits, fractionDigits, isComplexType);
            }
            throw new MatchError(tuple2);
        }).getOrElse(() -> JdbcTableDefLoader.jdbcTypeToMojozType$$anonfun$3(jdbcTypeCode, size, frac));
    }

    public Type dbTypeNameToMojozType(String dbTypeName, int size, int frac) {
        return (Type)this.jdbcLoadInfoToTypeDef().find((Function1<Tuple2, boolean> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) throw new MatchError(tuple2);
            JdbcLoadInfo jl = (JdbcLoadInfo)tuple2._1();
            TypeDef td = (TypeDef)tuple2._2();
            String string2 = jl.jdbcTypeNameOrCode();
            String string3 = dbTypeName;
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (!BoxesRunTime.unboxToBoolean(jl.minSize().map(_$26 -> _$26 <= size).getOrElse(JdbcTableDefLoader::dbTypeNameToMojozType$$anonfun$1$$anonfun$2))) return false;
            if (!BoxesRunTime.unboxToBoolean(jl.maxSize().map(_$27 -> _$27 >= size).getOrElse(JdbcTableDefLoader::dbTypeNameToMojozType$$anonfun$1$$anonfun$4))) return false;
            if (!BoxesRunTime.unboxToBoolean(jl.minFractionDigits().map(_$28 -> _$28 <= frac).getOrElse(JdbcTableDefLoader::dbTypeNameToMojozType$$anonfun$1$$anonfun$6))) return false;
            if (!BoxesRunTime.unboxToBoolean(jl.maxFractionDigits().map(_$29 -> _$29 >= frac).getOrElse(JdbcTableDefLoader::dbTypeNameToMojozType$$anonfun$1$$anonfun$8))) return false;
            return true;
        }).map((Function1<Tuple2, Type> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Option<Object> option;
                Option<Object> option2;
                Option<Object> option3;
                JdbcLoadInfo jl = (JdbcLoadInfo)tuple2._1();
                TypeDef td = (TypeDef)tuple2._2();
                Option<Integer> option4 = jl.targetLength();
                if (option4 instanceof Some && ((Some)option4).value() == null) {
                    option3 = Some$.MODULE$.apply(BoxesRunTime.boxToInteger(size));
                } else {
                    Option<Integer> x = option4;
                    option3 = x.map((Function1<Integer, int> & Serializable)_$30 -> _$30);
                }
                Option<Object> length = option3;
                Option<Integer> option5 = jl.targetTotalDigits();
                if (option5 instanceof Some && ((Some)option5).value() == null) {
                    option2 = Some$.MODULE$.apply(BoxesRunTime.boxToInteger(size));
                } else {
                    Option<Integer> x = option5;
                    option2 = x.map((Function1<Integer, int> & Serializable)_$31 -> _$31);
                }
                Option<Object> totalDigits = option2;
                Option<Integer> option6 = jl.targetFractionDigits();
                if (option6 instanceof Some && ((Some)option6).value() == null) {
                    option = Some$.MODULE$.apply(BoxesRunTime.boxToInteger(frac));
                } else {
                    Option<Integer> x = option6;
                    option = x.map((Function1<Integer, int> & Serializable)_$32 -> _$32);
                }
                Option<Object> fractionDigits = option;
                boolean isComplexType = false;
                return Type$.MODULE$.apply(td.name(), length, totalDigits, fractionDigits, isComplexType);
            }
            throw new MatchError(tuple2);
        }).getOrElse(() -> JdbcTableDefLoader.dbTypeNameToMojozType$$anonfun$3(dbTypeName, size, frac));
    }

    public Type fallbackType(JdbcColumnType jdbcColumnType) {
        return null;
    }

    public Type toMojozElementType(JdbcColumnType jdbcColumnType) {
        String string2 = jdbcColumnType.dbTypeName();
        if (string2 != null) {
            List<String> list;
            List<String> list2;
            List<String> list3;
            Option<List<String>> option = this.PlainTypeName.unapplySeq(string2);
            if (!option.isEmpty() && (list3 = option.get()).lengthCompare(1) == 0) {
                String string3;
                String dbTypeName = string3 = list3.apply(0);
                return this.dbTypeNameToMojozType(dbTypeName, 0, 0);
            }
            Option<List<String>> option2 = this.SizedTypeName.unapplySeq(string2);
            if (!option2.isEmpty() && (list2 = option2.get()).lengthCompare(2) == 0) {
                String string4 = list2.apply(0);
                String string5 = list2.apply(1);
                String dbTypeName = string4;
                String size = string5;
                return this.dbTypeNameToMojozType(dbTypeName, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(size)), 0);
            }
            Option<List<String>> option3 = this.FracTypeName.unapplySeq(string2);
            if (!option3.isEmpty() && (list = option3.get()).lengthCompare(3) == 0) {
                String string6 = list.apply(0);
                String string7 = list.apply(1);
                String string8 = list.apply(2);
                String dbTypeName = string6;
                String size = string7;
                String frac = string8;
                return this.dbTypeNameToMojozType(dbTypeName, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(size)), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(frac)));
            }
        }
        throw new MatchError((Object)string2);
    }

    public Type toMojozType(JdbcColumnType jdbcColumnType) {
        int n2 = jdbcColumnType.jdbcTypeCode();
        if (2003 == n2) {
            Type elementType = this.toMojozElementType(jdbcColumnType);
            return elementType.copy((String)Option$.MODULE$.apply(elementType.name()).map((Function1<String, String> & Serializable)n -> new StringBuilder(2).append((String)n).append("[]").toString()).getOrElse(JdbcTableDefLoader::toMojozType$$anonfun$2), elementType.copy$default$2(), elementType.copy$default$3(), elementType.copy$default$4(), elementType.copy$default$5());
        }
        return this.jdbcTypeToMojozType(jdbcColumnType.jdbcTypeCode(), jdbcColumnType.size(), jdbcColumnType.fractionDigits());
    }

    public TableDef_<ColumnDef_<Type>> toMojozTableDef(TableDef_<ColumnDef_<JdbcColumnType>> tableDef) {
        this.log(() -> JdbcTableDefLoader.toMojozTableDef$$anonfun$1(tableDef));
        Seq seq = (Seq)tableDef.cols().map((Function1<ColumnDef_, ColumnDef_> & Serializable)c -> {
            ColumnDef_<Type> columnDef_;
            try {
                Type type2 = this.toMojozType((JdbcColumnType)c.type_());
                String string2 = c.copy$default$1();
                boolean bl = c.copy$default$3();
                String string3 = c.copy$default$4();
                Seq<String> seq = c.copy$default$5();
                String string4 = c.copy$default$6();
                Map<String, Object> map = c.copy$default$7();
                columnDef_ = c.copy(string2, type2, bl, string3, seq, string4, map);
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable ex = throwable3 = option.get();
                    Type type3 = this.fallbackType((JdbcColumnType)c.type_());
                    if (type3 == null) {
                        throw new RuntimeException(new StringBuilder(56).append("Failed to process column ").append(tableDef.name()).append(".").append(c.name()).append(" and no fallback type provided").toString(), ex);
                    }
                    Type x = type3;
                    this.log(() -> JdbcTableDefLoader.$anonfun$31$$anonfun$1(x, tableDef, c, ex));
                    columnDef_ = c.copy(c.copy$default$1(), x, c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7());
                }
                throw throwable;
            }
            return columnDef_;
        });
        String string2 = tableDef.copy$default$1();
        String string3 = tableDef.copy$default$2();
        String string4 = tableDef.copy$default$3();
        Option<TableMetadata.DbIndex> option = tableDef.copy$default$5();
        Seq<TableMetadata.DbIndex> seq2 = tableDef.copy$default$6();
        Seq<TableMetadata.CheckConstraint> seq3 = tableDef.copy$default$7();
        Seq<TableMetadata.DbIndex> seq4 = tableDef.copy$default$8();
        Seq<TableMetadata.Ref> seq5 = tableDef.copy$default$9();
        Map<String, Object> map = tableDef.copy$default$10();
        return tableDef.copy(string2, string3, string4, seq, option, seq2, seq3, seq4, seq5, map);
    }

    private static final String jdbcTableDefsBuf$$anonfun$1(String tableType$1, String catalog$1, String schema$1, String tableName$1) {
        return new StringBuilder(56).append("Processing jdbc metadata for ").append(tableType$1).append(", catalog ").append(catalog$1).append(", schema ").append(schema$1).append(", table ").append(tableName$1).toString();
    }

    private static final Option findCol$1(List cols$5, String tableName$2, String schema$2, String name) {
        return cols$5.find((Function1<ColumnDef_, boolean> & Serializable)c -> name.equalsIgnoreCase(c.name()) || name.equalsIgnoreCase(new StringBuilder(1).append(tableName$2).append(".").append(c.name()).toString()) || name.equalsIgnoreCase(new StringBuilder(2).append(schema$2).append(".").append(tableName$2).append(".").append(c.name()).toString()));
    }

    private static final String fkRule$1(short rule) {
        short s2 = rule;
        switch (s2) {
            case 1: 
            case 3: {
                return "no action";
            }
            case 0: {
                return "cascade";
            }
            case 2: {
                return "set null";
            }
            case 4: {
                return "set default";
            }
        }
        throw scala.sys.package$.MODULE$.error(new StringBuilder(20).append("Unexpected fk rule: ").append(rule).toString());
    }

    private static final Seq $anonfun$22() {
        return scala.package$.MODULE$.Nil();
    }

    private static final Seq $anonfun$23() {
        return scala.package$.MODULE$.Nil();
    }

    private static final boolean jdbcTypeToMojozType$$anonfun$1$$anonfun$2() {
        return true;
    }

    private static final boolean jdbcTypeToMojozType$$anonfun$1$$anonfun$4() {
        return true;
    }

    private static final boolean jdbcTypeToMojozType$$anonfun$1$$anonfun$6() {
        return true;
    }

    private static final boolean jdbcTypeToMojozType$$anonfun$1$$anonfun$8() {
        return true;
    }

    private static final String $anonfun$27() {
        return "";
    }

    private static final Type jdbcTypeToMojozType$$anonfun$3(int jdbcTypeCode$3, int size$6, int frac$5) {
        String jdbcTypeName = (String)JdbcTableDefLoader$.MODULE$.jdbcCodeToTypeName().get(BoxesRunTime.boxToInteger(jdbcTypeCode$3)).getOrElse(JdbcTableDefLoader::$anonfun$27);
        throw scala.sys.package$.MODULE$.error(new StringBuilder(101).append("Failed to convert jdbc type (code: ").append(jdbcTypeCode$3).append(", name: ").append(jdbcTypeName).append(", size: ").append(size$6).append(", fractionDigits: ").append(frac$5).append(")").append(" to mojoz type - mo match found").toString());
    }

    private static final boolean dbTypeNameToMojozType$$anonfun$1$$anonfun$2() {
        return true;
    }

    private static final boolean dbTypeNameToMojozType$$anonfun$1$$anonfun$4() {
        return true;
    }

    private static final boolean dbTypeNameToMojozType$$anonfun$1$$anonfun$6() {
        return true;
    }

    private static final boolean dbTypeNameToMojozType$$anonfun$1$$anonfun$8() {
        return true;
    }

    private static final Type dbTypeNameToMojozType$$anonfun$3(String dbTypeName$3, int size$11, int frac$10) {
        throw scala.sys.package$.MODULE$.error(new StringBuilder(91).append("Failed to convert db type (name: ").append(dbTypeName$3).append(", size: ").append(size$11).append(", fractionDigits: ").append(frac$10).append(")").append(" to mojoz type - mo match found").toString());
    }

    private static final String toMojozType$$anonfun$2() {
        return "[]";
    }

    private static final String toMojozTableDef$$anonfun$1(TableDef_ tableDef$1) {
        return new StringBuilder(20).append("Finalizing tableDef ").append(tableDef$1.name()).toString();
    }

    private static final String $anonfun$31$$anonfun$1(Type x$1, TableDef_ tableDef$3, ColumnDef_ c$1, Throwable ex$1) {
        return new StringBuilder(42).append("Fallback to type ").append(x$1).append(" for column ").append(tableDef$3.name()).append(".").append(c$1.name()).append(" caused by: ").append(ex$1.toString()).toString();
    }

    public static class H2
    extends JdbcTableDefLoader {
        private final String jdbcLoadInfoKey;
        private final String h2_uk_drop_suffix;
        private final int h2_uk_drop_suffix_len;

        public static Seq<TypeDef> $lessinit$greater$default$1() {
            return JdbcTableDefLoader$H2$.MODULE$.$lessinit$greater$default$1();
        }

        public H2(Seq<TypeDef> typeDefs) {
            super(typeDefs);
            this.jdbcLoadInfoKey = "h2 jdbc";
            this.h2_uk_drop_suffix = "_INDEX_F";
            this.h2_uk_drop_suffix_len = this.h2_uk_drop_suffix.length();
        }

        @Override
        public String jdbcLoadInfoKey() {
            return this.jdbcLoadInfoKey;
        }

        @Override
        public Seq<TableMetadata.CheckConstraint> checkConstraints(Connection conn, String catalog, String schemaPattern, String tableNamePattern) {
            return this.standardCheckConstraints(conn, catalog, schemaPattern, tableNamePattern);
        }

        private String h2_ukRoundtripNameFix(String ukName) {
            if (ukName.endsWith(this.h2_uk_drop_suffix)) {
                return ukName.substring(0, ukName.length() - this.h2_uk_drop_suffix_len);
            }
            return ukName;
        }

        @Override
        public Tuple2<List<TableMetadata.Index>, List<TableMetadata.Index>> ukAndIdx(ResultSet rs) {
            Tuple2<List<TableMetadata.Index>, List<TableMetadata.Index>> tuple2 = super.ukAndIdx(rs);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            List<TableMetadata.Index> uks = tuple2._1();
            List<TableMetadata.Index> idxs = tuple2._2();
            Tuple2<List<TableMetadata.Index>, List<TableMetadata.Index>> tuple22 = Tuple2$.MODULE$.apply(uks, idxs);
            List<TableMetadata.Index> uks2 = tuple22._1();
            List<TableMetadata.Index> idxs2 = tuple22._2();
            return Tuple2$.MODULE$.apply(((AbstractSeq)uks2.map((Function1<TableMetadata.Index, TableMetadata.Index> & Serializable)uk2 -> uk2.copy(this.h2_ukRoundtripNameFix(uk2.name()), uk2.copy$default$2(), uk2.copy$default$3()))).sortBy(JdbcTableDefLoader$::org$mojoz$metadata$in$JdbcTableDefLoader$H2$$_$ukAndIdx$$anonfun$4, (Ordering)Ordering$String$.MODULE$), idxs2);
        }
    }

    public static class Hsqldb
    extends JdbcTableDefLoader {
        private final String jdbcLoadInfoKey;

        public static Seq<TypeDef> $lessinit$greater$default$1() {
            return JdbcTableDefLoader$Hsqldb$.MODULE$.$lessinit$greater$default$1();
        }

        public Hsqldb(Seq<TypeDef> typeDefs) {
            super(typeDefs);
            this.jdbcLoadInfoKey = "hsqldb jdbc";
        }

        @Override
        public String jdbcLoadInfoKey() {
            return this.jdbcLoadInfoKey;
        }

        @Override
        public Seq<TableMetadata.CheckConstraint> checkConstraints(Connection conn, String catalog, String schemaPattern, String tableNamePattern) {
            return this.standardCheckConstraints(conn, catalog, schemaPattern, tableNamePattern);
        }
    }

    public static class JdbcColumnType
    implements Product,
    Serializable {
        private final String dbTypeName;
        private final int jdbcTypeCode;
        private final int size;
        private final int fractionDigits;

        public static JdbcColumnType apply(String string2, int n, int n2, int n3) {
            return JdbcTableDefLoader$JdbcColumnType$.MODULE$.apply(string2, n, n2, n3);
        }

        public static JdbcColumnType fromProduct(Product product) {
            return JdbcTableDefLoader$JdbcColumnType$.MODULE$.fromProduct(product);
        }

        public static JdbcColumnType unapply(JdbcColumnType jdbcColumnType) {
            return JdbcTableDefLoader$JdbcColumnType$.MODULE$.unapply(jdbcColumnType);
        }

        public JdbcColumnType(String dbTypeName, int jdbcTypeCode, int size, int fractionDigits) {
            this.dbTypeName = dbTypeName;
            this.jdbcTypeCode = jdbcTypeCode;
            this.size = size;
            this.fractionDigits = fractionDigits;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.dbTypeName()));
            n = Statics.mix(n, this.jdbcTypeCode());
            n = Statics.mix(n, this.size());
            n = Statics.mix(n, this.fractionDigits());
            return Statics.finalizeHash(n, 4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof JdbcColumnType)) return false;
            JdbcColumnType jdbcColumnType = (JdbcColumnType)object;
            if (this.jdbcTypeCode() != jdbcColumnType.jdbcTypeCode()) return false;
            if (this.size() != jdbcColumnType.size()) return false;
            if (this.fractionDigits() != jdbcColumnType.fractionDigits()) return false;
            String string2 = this.dbTypeName();
            String string3 = jdbcColumnType.dbTypeName();
            if (string2 == null) {
                if (string3 != null) {
                    return false;
                }
            } else if (!string2.equals(string3)) return false;
            if (!jdbcColumnType.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof JdbcColumnType;
        }

        @Override
        public int productArity() {
            return 4;
        }

        @Override
        public String productPrefix() {
            return "JdbcColumnType";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger(this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger(this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger(this._4());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "dbTypeName";
                }
                case 1: {
                    return "jdbcTypeCode";
                }
                case 2: {
                    return "size";
                }
                case 3: {
                    return "fractionDigits";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public String dbTypeName() {
            return this.dbTypeName;
        }

        public int jdbcTypeCode() {
            return this.jdbcTypeCode;
        }

        public int size() {
            return this.size;
        }

        public int fractionDigits() {
            return this.fractionDigits;
        }

        public JdbcColumnType copy(String dbTypeName, int jdbcTypeCode, int size, int fractionDigits) {
            return new JdbcColumnType(dbTypeName, jdbcTypeCode, size, fractionDigits);
        }

        public String copy$default$1() {
            return this.dbTypeName();
        }

        public int copy$default$2() {
            return this.jdbcTypeCode();
        }

        public int copy$default$3() {
            return this.size();
        }

        public int copy$default$4() {
            return this.fractionDigits();
        }

        public String _1() {
            return this.dbTypeName();
        }

        public int _2() {
            return this.jdbcTypeCode();
        }

        public int _3() {
            return this.size();
        }

        public int _4() {
            return this.fractionDigits();
        }
    }

    public static class Oracle
    extends JdbcTableDefLoader {
        private final String jdbcLoadInfoKey;
        private final Set emulatedBooleanEnums = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new List[]{(List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"N"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"Y"), Nil$.MODULE$))), (List)((Object)new $colon$colon<Nothing$>((Nothing$)((Object)"Y"), (List<Nothing$>)new $colon$colon<Nothing$>((Nothing$)((Object)"N"), Nil$.MODULE$)))}));

        public static Seq<TypeDef> $lessinit$greater$default$1() {
            return JdbcTableDefLoader$Oracle$.MODULE$.$lessinit$greater$default$1();
        }

        public Oracle(Seq<TypeDef> typeDefs) {
            super(typeDefs);
            this.jdbcLoadInfoKey = "oracle jdbc";
        }

        @Override
        public String jdbcLoadInfoKey() {
            return this.jdbcLoadInfoKey;
        }

        @Override
        public ResultSet dmd_getIndexInfo(DatabaseMetaData dmd, String catalog, String schema, String tableName, String tableType) {
            String string2 = new StringBuilder(2).append(tableType).append(" ").append(schema).append(".").append(tableName).toString();
            String x = string2;
            if (x.startsWith("VIEW SYS._")) {
                return null;
            }
            return super.dmd_getIndexInfo(dmd, catalog, schema, tableName, tableType);
        }

        public ListBuffer<TableDef_<ColumnDef_<JdbcColumnType>>> oraFixTableComments(Connection conn, ListBuffer<TableDef_<ColumnDef_<JdbcColumnType>>> tableDefs) {
            if (!tableDefs.exists((Function1<TableDef_<ColumnDef_<JdbcColumnType>>, Object>)((Function1<TableDef_, boolean> & Serializable)JdbcTableDefLoader$::org$mojoz$metadata$in$JdbcTableDefLoader$Oracle$$_$oraFixTableComments$$anonfun$1))) {
                ListBuffer listBuffer;
                try (PreparedStatement st = conn.prepareStatement("select comments from all_tab_comments where owner || '.' || table_name = ?", 1003, 1007);){
                    listBuffer = (ListBuffer)tableDefs.map((Function1<TableDef_, TableDef_> & Serializable)td -> {
                        this.log(() -> JdbcTableDefLoader$.org$mojoz$metadata$in$JdbcTableDefLoader$Oracle$$_$oraFixTableComments$$anonfun$2$$anonfun$1(td));
                        st.setString(1, td.name());
                        ResultSet rs = st.executeQuery();
                        String comments = rs.next() ? rs.getString(1) : null;
                        rs.close();
                        st.clearParameters();
                        if (comments == null) {
                            return td;
                        }
                        return td.copy(td.copy$default$1(), td.copy$default$2(), comments, td.copy$default$4(), td.copy$default$5(), td.copy$default$6(), td.copy$default$7(), td.copy$default$8(), td.copy$default$9(), td.copy$default$10());
                    });
                }
                return listBuffer;
            }
            return tableDefs;
        }

        public ListBuffer<TableDef_<ColumnDef_<JdbcColumnType>>> oraFixColumnComments(Connection conn, ListBuffer<TableDef_<ColumnDef_<JdbcColumnType>>> tableDefs) {
            if (!tableDefs.exists((Function1<TableDef_<ColumnDef_<JdbcColumnType>>, Object>)((Function1<TableDef_, boolean> & Serializable)JdbcTableDefLoader$::org$mojoz$metadata$in$JdbcTableDefLoader$Oracle$$_$oraFixColumnComments$$anonfun$1))) {
                ListBuffer listBuffer;
                try (PreparedStatement st = conn.prepareStatement("select column_name, comments from all_col_comments where owner || '.' || table_name = ?", 1003, 1007);){
                    listBuffer = (ListBuffer)tableDefs.map((Function1<TableDef_, TableDef_> & Serializable)td -> {
                        this.log(() -> JdbcTableDefLoader$.org$mojoz$metadata$in$JdbcTableDefLoader$Oracle$$_$oraFixColumnComments$$anonfun$2$$anonfun$1(td));
                        st.setString(1, td.name());
                        ResultSet rs = st.executeQuery();
                        List cList = scala.package$.MODULE$.Nil();
                        while (rs.next()) {
                            Tuple2<String, String> tuple2 = Tuple2$.MODULE$.apply(rs.getString(1), rs.getString(2));
                            cList = cList.$colon$colon(tuple2);
                        }
                        rs.close();
                        st.clearParameters();
                        Map cMap = cList.toMap($less$colon$less$.MODULE$.refl());
                        if (!cMap.values().exists(JdbcTableDefLoader$::org$mojoz$metadata$in$JdbcTableDefLoader$Oracle$$_$oraFixColumnComments$$anonfun$2$$anonfun$2)) {
                            return td;
                        }
                        Seq seq = (Seq)td.cols().map(arg_0 -> JdbcTableDefLoader$.org$mojoz$metadata$in$JdbcTableDefLoader$Oracle$$_$_$$anonfun$32(cMap, arg_0));
                        String string2 = td.copy$default$1();
                        String string3 = td.copy$default$2();
                        String string4 = td.copy$default$3();
                        Option<TableMetadata.DbIndex> option = td.copy$default$5();
                        Seq<TableMetadata.DbIndex> seq2 = td.copy$default$6();
                        Seq<TableMetadata.CheckConstraint> seq3 = td.copy$default$7();
                        Seq<TableMetadata.DbIndex> seq4 = td.copy$default$8();
                        Seq<TableMetadata.Ref> seq5 = td.copy$default$9();
                        Map<String, Object> map = td.copy$default$10();
                        return td.copy(string2, string3, string4, seq, option, seq2, seq3, seq4, seq5, map);
                    });
                }
                return listBuffer;
            }
            return tableDefs;
        }

        public Set<List<String>> emulatedBooleanEnums() {
            return this.emulatedBooleanEnums;
        }

        public boolean isEmulatedBoolean(ColumnDef_<JdbcColumnType> c) {
            return c.type_().jdbcTypeCode() == 1 && c.type_().size() == 1 && c.enum_() != null && this.emulatedBooleanEnums().contains(c.enum_().toList());
        }

        public ListBuffer<TableDef_<ColumnDef_<JdbcColumnType>>> oraFixEmulatedBooleans(ListBuffer<TableDef_<ColumnDef_<JdbcColumnType>>> tableDefs) {
            return (ListBuffer)tableDefs.map((Function1<TableDef_, TableDef_> & Serializable)td -> {
                if (td.cols().exists((Function1<ColumnDef_, boolean> & Serializable)c -> this.isEmulatedBoolean((ColumnDef_<JdbcColumnType>)c))) {
                    Seq seq = (Seq)td.cols().map((Function1<ColumnDef_, ColumnDef_> & Serializable)c -> {
                        if (this.isEmulatedBoolean((ColumnDef_<JdbcColumnType>)c)) {
                            String d;
                            String string2;
                            int n = 16;
                            String string3 = ((JdbcColumnType)c.type_()).copy$default$1();
                            int n2 = ((JdbcColumnType)c.type_()).copy$default$3();
                            int n3 = ((JdbcColumnType)c.type_()).copy$default$4();
                            JdbcColumnType jdbcColumnType = ((JdbcColumnType)c.type_()).copy(string3, n, n2, n3);
                            String string4 = c.dbDefault() == null ? null : ("'N'".equals(string2 = c.dbDefault().trim()) ? "false" : ("'Y'".equals(string2) ? "true" : (d = string2)));
                            String string5 = c.copy$default$1();
                            boolean bl = c.copy$default$3();
                            String string6 = c.copy$default$6();
                            Map<String, Object> map = c.copy$default$7();
                            return c.copy(string5, jdbcColumnType, bl, string4, null, string6, map);
                        }
                        return c;
                    });
                    String string2 = td.copy$default$1();
                    String string3 = td.copy$default$2();
                    String string4 = td.copy$default$3();
                    Option<TableMetadata.DbIndex> option = td.copy$default$5();
                    Seq<TableMetadata.DbIndex> seq2 = td.copy$default$6();
                    Seq<TableMetadata.CheckConstraint> seq3 = td.copy$default$7();
                    Seq<TableMetadata.DbIndex> seq4 = td.copy$default$8();
                    Seq<TableMetadata.Ref> seq5 = td.copy$default$9();
                    Map<String, Object> map = td.copy$default$10();
                    return td.copy(string2, string3, string4, seq, option, seq2, seq3, seq4, seq5, map);
                }
                return td;
            });
        }

        @Override
        public List<TableDef_<ColumnDef_<JdbcColumnType>>> jdbcTableDefs(Connection conn, String catalog, String schemaPattern, String tableNamePattern, Seq<String> types) {
            ListBuffer<TableDef_<ColumnDef_<JdbcColumnType>>> tableDefs = this.jdbcTableDefsBuf(conn, catalog, schemaPattern, tableNamePattern, types);
            return this.oraFixEmulatedBooleans(this.oraFixColumnComments(conn, this.oraFixTableComments(conn, tableDefs))).toList();
        }

        @Override
        public Seq<TableMetadata.CheckConstraint> checkConstraints(Connection conn, String catalog, String schemaPattern, String tableNamePattern) {
            PreparedStatement ps = conn.prepareStatement("select constraint_name, search_condition check_clause  from all_constraints  where constraint_type = 'C' and owner like ? and table_name like ?", 1003, 1007);
            ps.setString(1, schemaPattern);
            ps.setString(2, tableNamePattern);
            ResultSet rs = ps.executeQuery();
            List<TableMetadata.CheckConstraint> checks = this.checkConstraints(rs);
            ps.close();
            return checks;
        }
    }

    public static class Other
    extends JdbcTableDefLoader {
        public static Seq<TypeDef> $lessinit$greater$default$1() {
            return JdbcTableDefLoader$Other$.MODULE$.$lessinit$greater$default$1();
        }

        public Other(Seq<TypeDef> typeDefs) {
            super(typeDefs);
        }

        @Override
        public Seq<TableMetadata.CheckConstraint> checkConstraints(Connection conn, String catalog, String schemaPattern, String tableNamePattern) {
            return scala.package$.MODULE$.Nil();
        }
    }

    public static class Postgresql
    extends JdbcTableDefLoader {
        private final String jdbcLoadInfoKey;

        public static Seq<TypeDef> $lessinit$greater$default$1() {
            return JdbcTableDefLoader$Postgresql$.MODULE$.$lessinit$greater$default$1();
        }

        public Postgresql(Seq<TypeDef> typeDefs) {
            super(typeDefs);
            this.jdbcLoadInfoKey = "postgresql jdbc";
        }

        @Override
        public String jdbcLoadInfoKey() {
            return this.jdbcLoadInfoKey;
        }

        @Override
        public Seq<TableMetadata.CheckConstraint> checkConstraints(Connection conn, String catalog, String schemaPattern, String tableNamePattern) {
            return this.standardCheckConstraints(conn, catalog, schemaPattern, tableNamePattern);
        }

        @Override
        public Type toMojozElementType(JdbcColumnType jdbcColumnType) {
            return this.dbTypeNameToMojozType(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(jdbcColumnType.dbTypeName()), "_").toUpperCase(), jdbcColumnType.size(), jdbcColumnType.fractionDigits());
        }
    }
}

