/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io.pem;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemHeader;
import org.bouncycastle.util.io.pem.PemObject;

public class PemReader
extends BufferedReader {
    public static final String LAX_PEM_PARSING_SYSTEM_PROPERTY_NAME = "org.bouncycastle.pemreader.lax";
    private static final String BEGIN = "-----BEGIN ";
    private static final String END = "-----END ";
    private static final Logger LOG = Logger.getLogger(PemReader.class.getName());

    public PemReader(Reader reader) {
        super(reader);
    }

    public PemObject readPemObject() throws IOException {
        int n;
        String string2 = this.readLine();
        while (string2 != null && !string2.startsWith(BEGIN)) {
            string2 = this.readLine();
        }
        if (string2 != null && (n = (string2 = string2.substring(BEGIN.length()).trim()).indexOf(45)) > 0 && string2.endsWith("-----") && string2.length() - n == 5) {
            String string3 = string2.substring(0, n);
            return this.loadObject(string3);
        }
        return null;
    }

    private PemObject loadObject(String string2) throws IOException {
        String string3;
        String string4 = END + string2 + "-----";
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<PemHeader> arrayList = new ArrayList<PemHeader>();
        while ((string3 = this.readLine()) != null) {
            String string5;
            int n = string3.indexOf(58);
            if (n >= 0) {
                string5 = string3.substring(0, n);
                String string6 = string3.substring(n + 1).trim();
                arrayList.add(new PemHeader(string5, string6));
                continue;
            }
            if (System.getProperty(LAX_PEM_PARSING_SYSTEM_PROPERTY_NAME, "false").equalsIgnoreCase("true")) {
                string5 = string3.trim();
                if (!string5.equals(string3) && LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "PEM object contains whitespaces on -----END line", new Exception("trace"));
                }
                string3 = string5;
            }
            if (string3.indexOf(string4) == 0) break;
            stringBuffer.append(string3.trim());
        }
        if (string3 == null) {
            throw new IOException(string4 + " not found");
        }
        return new PemObject(string2, arrayList, Base64.decode(stringBuffer.toString()));
    }
}

