/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mldsa;

import org.bouncycastle.pqc.crypto.mldsa.MLDSAEngine;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecK;
import org.bouncycastle.pqc.crypto.mldsa.PolyVecL;

class PolyVecMatrix {
    private final int dilithiumK;
    private final int dilithiumL;
    private final PolyVecL[] mat;

    public PolyVecMatrix(MLDSAEngine mLDSAEngine) {
        this.dilithiumK = mLDSAEngine.getDilithiumK();
        this.dilithiumL = mLDSAEngine.getDilithiumL();
        this.mat = new PolyVecL[this.dilithiumK];
        for (int i = 0; i < this.dilithiumK; ++i) {
            this.mat[i] = new PolyVecL(mLDSAEngine);
        }
    }

    public void pointwiseMontgomery(PolyVecK polyVecK, PolyVecL polyVecL) {
        for (int i = 0; i < this.dilithiumK; ++i) {
            polyVecK.getVectorIndex(i).pointwiseAccountMontgomery(this.mat[i], polyVecL);
        }
    }

    public void expandMatrix(byte[] byArray) {
        for (int i = 0; i < this.dilithiumK; ++i) {
            for (int j = 0; j < this.dilithiumL; ++j) {
                this.mat[i].getVectorIndex(j).uniformBlocks(byArray, (short)((i << 8) + j));
            }
        }
    }

    private String addString() {
        String string2 = "[";
        for (int i = 0; i < this.dilithiumK; ++i) {
            string2 = string2 + "Outer Matrix " + i + " [";
            string2 = string2 + this.mat[i].toString();
            string2 = i == this.dilithiumK - 1 ? string2 + "]\n" : string2 + "],\n";
        }
        string2 = string2 + "]\n";
        return string2;
    }

    public String toString(String string2) {
        return string2.concat(": \n" + this.addString());
    }
}

