/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.jcajce.spec.HybridValueParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcePublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private static final byte X_HDR = 64;
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private SecureRandom random;
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcePublicKeyKeyEncryptionMethodGenerator(PGPPublicKey pGPPublicKey) {
        super(pGPPublicKey);
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(String string2) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(string2));
        this.keyConverter.setProvider(string2);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(PGPPublicKey pGPPublicKey, byte[] byArray, byte by, boolean bl) throws PGPException {
        try {
            PublicKey publicKey = this.keyConverter.getPublicKey(pGPPublicKey);
            if (pGPPublicKey.getAlgorithm() == 18) {
                byte[] byArray2 = this.createSessionInfo(bl ? by : (byte)0, byArray);
                final ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)pGPPublicKey.getPublicKeyPacket().getKey();
                String string2 = RFC6637Utils.getKeyEncryptionOID(eCDHPublicBCPGKey.getSymmetricKeyAlgorithm()).getId();
                PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
                if (JcaJcePGPUtil.isX25519(eCDHPublicBCPGKey.getCurveOID())) {
                    return this.encryptSessionInfoWithECDHKey(this.getKeyPair("X25519", 255), publicKeyPacket, publicKey, string2, eCDHPublicBCPGKey.getSymmetricKeyAlgorithm(), byArray2, RFC6637Utils.getXDHAlgorithm(publicKeyPacket), by, new EphPubEncoding(){

                        @Override
                        public byte[] getEphPubEncoding(byte[] byArray) {
                            return Arrays.prepend(byArray, (byte)64);
                        }
                    });
                }
                if (eCDHPublicBCPGKey.getCurveOID().equals(EdECObjectIdentifiers.id_X448)) {
                    return this.encryptSessionInfoWithECDHKey(this.getKeyPair("X448", 448), publicKeyPacket, publicKey, string2, eCDHPublicBCPGKey.getSymmetricKeyAlgorithm(), byArray2, RFC6637Utils.getXDHAlgorithm(publicKeyPacket), by, new EphPubEncoding(){

                        @Override
                        public byte[] getEphPubEncoding(byte[] byArray) {
                            return Arrays.prepend(byArray, (byte)64);
                        }
                    });
                }
                KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator("EC");
                AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters("EC");
                algorithmParameters.init(new X962Parameters(eCDHPublicBCPGKey.getCurveOID()).getEncoded());
                keyPairGenerator.initialize(algorithmParameters.getParameterSpec(AlgorithmParameterSpec.class), this.random);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                return this.encryptSessionInfoWithECDHKey(keyPair, publicKeyPacket, publicKey, string2, eCDHPublicBCPGKey.getSymmetricKeyAlgorithm(), byArray2, RFC6637Utils.getAgreementAlgorithm(publicKeyPacket), by, new EphPubEncoding(){

                    @Override
                    public byte[] getEphPubEncoding(byte[] byArray) {
                        if (null == byArray || byArray.length < 1 || byArray[0] != 4) {
                            byArray = JcaJcePGPUtil.getX9Parameters(eCDHPublicBCPGKey.getCurveOID()).getCurve().decodePoint(byArray).getEncoded(false);
                        }
                        return byArray;
                    }
                });
            }
            if (pGPPublicKey.getAlgorithm() == 25) {
                return this.encryptSessionInfoWithX25519X448Key(pGPPublicKey, "X25519", publicKey, NISTObjectIdentifiers.id_aes128_wrap.getId(), 7, byArray, "X25519withSHA256HKDF", 255, by, bl);
            }
            if (pGPPublicKey.getAlgorithm() == 26) {
                return this.encryptSessionInfoWithX25519X448Key(pGPPublicKey, "X448", publicKey, NISTObjectIdentifiers.id_aes256_wrap.getId(), 9, byArray, "X448withSHA512HKDF", 448, by, bl);
            }
            Cipher cipher = this.helper.createPublicKeyCipher(pGPPublicKey.getAlgorithm());
            cipher.init(1, (Key)publicKey, this.random);
            byte[] byArray3 = this.createSessionInfo(bl ? by : (byte)0, byArray);
            return cipher.doFinal(byArray3);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new PGPException("illegal block size: " + illegalBlockSizeException.getMessage(), illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new PGPException("bad padding: " + badPaddingException.getMessage(), badPaddingException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new PGPException("key invalid: " + invalidKeyException.getMessage(), invalidKeyException);
        }
        catch (IOException iOException) {
            throw new PGPException("unable to encode MPI: " + iOException.getMessage(), iOException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PGPException("unable to set up ephemeral keys: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private byte[] encryptSessionInfoWithECDHKey(KeyPair keyPair, PublicKeyPacket publicKeyPacket, PublicKey publicKey, String string2, int n, byte[] byArray, String string3, byte by, EphPubEncoding ephPubEncoding) throws GeneralSecurityException, IOException, PGPException {
        UserKeyingMaterialSpec userKeyingMaterialSpec = new UserKeyingMaterialSpec(RFC6637Utils.createUserKeyingMaterial(publicKeyPacket, new JcaKeyFingerprintCalculator()));
        Key key2 = JcaJcePGPUtil.getSecret(this.helper, publicKey, string2, string3, userKeyingMaterialSpec, keyPair.getPrivate());
        byte[] byArray2 = ephPubEncoding.getEphPubEncoding(SubjectPublicKeyInfo.getInstance(keyPair.getPublic().getEncoded()).getPublicKeyData().getBytes());
        byte[] byArray3 = PGPPad.padSessionData(byArray, this.sessionKeyObfuscation);
        return JcePublicKeyKeyEncryptionMethodGenerator.getSessionInfo(new MPInteger(new BigInteger(1, byArray2)).getEncoded(), (byte)0, this.getWrapper(n, by, key2, byArray3));
    }

    private byte[] encryptSessionInfoWithX25519X448Key(PGPPublicKey pGPPublicKey, String string2, PublicKey publicKey, String string3, int n, byte[] byArray, String string4, int n2, byte by, boolean bl) throws GeneralSecurityException, IOException, PGPException {
        KeyPair keyPair = this.getKeyPair(string2, n2);
        byte[] byArray2 = SubjectPublicKeyInfo.getInstance(keyPair.getPublic().getEncoded()).getPublicKeyData().getBytes();
        HybridValueParameterSpec hybridValueParameterSpec = JcaJcePGPUtil.getHybridValueParameterSpecWithPrepend(byArray2, pGPPublicKey.getPublicKeyPacket(), string2);
        Key key2 = JcaJcePGPUtil.getSecret(this.helper, publicKey, string3, string4, hybridValueParameterSpec, keyPair.getPrivate());
        return JcePublicKeyKeyEncryptionMethodGenerator.getSessionInfo(byArray2, bl ? by : (byte)0, this.getWrapper(n, by, key2, byArray));
    }

    private KeyPair getKeyPair(String string2, int n) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = this.helper.createKeyPairGenerator(string2);
        keyPairGenerator.initialize(n, this.random);
        return keyPairGenerator.generateKeyPair();
    }

    private byte[] getWrapper(int n, byte by, Key key2, byte[] byArray) throws PGPException, InvalidKeyException, IllegalBlockSizeException {
        Cipher cipher = this.helper.createKeyWrapper(n);
        cipher.init(3, key2, this.random);
        return cipher.wrap(new SecretKeySpec(byArray, PGPUtil.getSymmetricCipherName(by)));
    }

    @FunctionalInterface
    private static interface EphPubEncoding {
        public byte[] getEphPubEncoding(byte[] var1);
    }
}

