/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

public class JcaKeyFingerprintCalculator
implements KeyFingerPrintCalculator {
    private final JcaJceHelper helper;

    public JcaKeyFingerprintCalculator() {
        this(new DefaultJcaJceHelper());
    }

    private JcaKeyFingerprintCalculator(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    public JcaKeyFingerprintCalculator setProvider(Provider provider) {
        return new JcaKeyFingerprintCalculator(new ProviderJcaJceHelper(provider));
    }

    public JcaKeyFingerprintCalculator setProvider(String string2) {
        return new JcaKeyFingerprintCalculator(new NamedJcaJceHelper(string2));
    }

    @Override
    public byte[] calculateFingerprint(PublicKeyPacket publicKeyPacket) throws PGPException {
        BCPGKey bCPGKey = publicKeyPacket.getKey();
        if (publicKeyPacket.getVersion() <= 3) {
            RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
            try {
                MessageDigest messageDigest = this.helper.createMessageDigest("MD5");
                byte[] byArray = new MPInteger(rSAPublicBCPGKey.getModulus()).getEncoded();
                messageDigest.update(byArray, 2, byArray.length - 2);
                byArray = new MPInteger(rSAPublicBCPGKey.getPublicExponent()).getEncoded();
                messageDigest.update(byArray, 2, byArray.length - 2);
                return messageDigest.digest();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PGPException("can't find MD5", generalSecurityException);
            }
            catch (IOException iOException) {
                throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
            }
        }
        if (publicKeyPacket.getVersion() == 4) {
            try {
                byte[] byArray = publicKeyPacket.getEncodedContents();
                MessageDigest messageDigest = this.helper.createMessageDigest("SHA1");
                messageDigest.update((byte)-103);
                messageDigest.update((byte)(byArray.length >> 8));
                messageDigest.update((byte)byArray.length);
                messageDigest.update(byArray);
                return messageDigest.digest();
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new PGPException("can't find SHA1", generalSecurityException);
            }
            catch (IOException iOException) {
                throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
            }
        }
        if (publicKeyPacket.getVersion() == 5 || publicKeyPacket.getVersion() == 6) {
            try {
                byte[] byArray = publicKeyPacket.getEncodedContents();
                MessageDigest messageDigest = this.helper.createMessageDigest("SHA-256");
                messageDigest.update((byte)(publicKeyPacket.getVersion() == 6 ? 155 : 154));
                messageDigest.update((byte)(byArray.length >> 24));
                messageDigest.update((byte)(byArray.length >> 16));
                messageDigest.update((byte)(byArray.length >> 8));
                messageDigest.update((byte)byArray.length);
                messageDigest.update(byArray);
                return messageDigest.digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PGPException("can't find SHA-256", noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new PGPException("can't find SHA-256", noSuchProviderException);
            }
            catch (IOException iOException) {
                throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
            }
        }
        throw new UnsupportedPacketVersionException("Unsupported PGP key version: " + publicKeyPacket.getVersion());
    }
}

