/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Iterator;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPOnePassSignatureList;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.examples.PGPExampleUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.Streams;

public class KeyBasedFileProcessor {
    private static void decryptFile(String string2, String string3, char[] cArray, String string4) throws IOException, NoSuchProviderException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(new FileInputStream(string3));
        KeyBasedFileProcessor.decryptFile(bufferedInputStream, bufferedInputStream2, cArray, string4);
        ((InputStream)bufferedInputStream2).close();
        ((InputStream)bufferedInputStream).close();
    }

    private static void decryptFile(InputStream inputStream, InputStream inputStream2, char[] cArray, String string2) throws IOException, NoSuchProviderException {
        block13: {
            inputStream = PGPUtil.getDecoderStream(inputStream);
            try {
                Object object;
                Object object2;
                JcaPGPObjectFactory jcaPGPObjectFactory = new JcaPGPObjectFactory(inputStream);
                Object object3 = jcaPGPObjectFactory.nextObject();
                PGPEncryptedDataList pGPEncryptedDataList = object3 instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)object3 : (PGPEncryptedDataList)jcaPGPObjectFactory.nextObject();
                Iterator<PGPEncryptedData> iterator = pGPEncryptedDataList.getEncryptedDataObjects();
                PGPPrivateKey pGPPrivateKey = null;
                PGPPublicKeyEncryptedData pGPPublicKeyEncryptedData = null;
                PGPSecretKeyRingCollection pGPSecretKeyRingCollection = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream(inputStream2), (KeyFingerPrintCalculator)new JcaKeyFingerprintCalculator());
                while (pGPPrivateKey == null && iterator.hasNext()) {
                    pGPPublicKeyEncryptedData = (PGPPublicKeyEncryptedData)iterator.next();
                    pGPPrivateKey = PGPExampleUtil.findSecretKey(pGPSecretKeyRingCollection, pGPPublicKeyEncryptedData.getKeyID(), cArray);
                }
                if (pGPPrivateKey == null) {
                    throw new IllegalArgumentException("secret key for message not found.");
                }
                InputStream inputStream3 = pGPPublicKeyEncryptedData.getDataStream(new JcePublicKeyDataDecryptorFactoryBuilder().setProvider("BC").build(pGPPrivateKey));
                JcaPGPObjectFactory jcaPGPObjectFactory2 = new JcaPGPObjectFactory(inputStream3);
                Object object4 = jcaPGPObjectFactory2.nextObject();
                if (object4 instanceof PGPCompressedData) {
                    object2 = (PGPCompressedData)object4;
                    object = new JcaPGPObjectFactory(((PGPCompressedData)object2).getDataStream());
                    object4 = ((PGPObjectFactory)object).nextObject();
                }
                if (object4 instanceof PGPLiteralData) {
                    object2 = (PGPLiteralData)object4;
                    object = ((PGPLiteralData)object2).getFileName();
                    if (((String)object).length() == 0) {
                        object = string2;
                    }
                } else {
                    if (object4 instanceof PGPOnePassSignatureList) {
                        throw new PGPException("encrypted message contains a signed message - not literal data.");
                    }
                    throw new PGPException("message is not a simple encrypted file - type unknown.");
                }
                InputStream inputStream4 = ((PGPLiteralData)object2).getInputStream();
                FileOutputStream fileOutputStream = new FileOutputStream((String)object);
                Streams.pipeAll(inputStream4, fileOutputStream, 8192);
                ((OutputStream)fileOutputStream).close();
                if (pGPPublicKeyEncryptedData.isIntegrityProtected()) {
                    if (!pGPPublicKeyEncryptedData.verify()) {
                        System.err.println("message failed integrity check");
                    } else {
                        System.err.println("message integrity check passed");
                    }
                } else {
                    System.err.println("no message integrity check");
                }
            }
            catch (PGPException pGPException) {
                System.err.println(pGPException);
                if (pGPException.getUnderlyingException() == null) break block13;
                pGPException.getUnderlyingException().printStackTrace();
            }
        }
    }

    private static void encryptFile(String string2, String string3, String string4, boolean bl, boolean bl2) throws IOException, NoSuchProviderException, PGPException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string2));
        PGPPublicKey pGPPublicKey = PGPExampleUtil.readPublicKey(string4);
        KeyBasedFileProcessor.encryptFile(bufferedOutputStream, string3, pGPPublicKey, bl, bl2);
        ((OutputStream)bufferedOutputStream).close();
    }

    private static void encryptFile(OutputStream outputStream, String string2, PGPPublicKey pGPPublicKey, boolean bl, boolean bl2) throws IOException, NoSuchProviderException {
        block4: {
            if (bl) {
                outputStream = new ArmoredOutputStream(outputStream);
            }
            try {
                byte[] byArray = PGPExampleUtil.compressFile(string2, 1);
                JcePGPDataEncryptorBuilder jcePGPDataEncryptorBuilder = new JcePGPDataEncryptorBuilder(3).setProvider("BC").setSecureRandom(new SecureRandom()).setWithIntegrityPacket(bl2);
                PGPEncryptedDataGenerator pGPEncryptedDataGenerator = new PGPEncryptedDataGenerator(jcePGPDataEncryptorBuilder);
                pGPEncryptedDataGenerator.addMethod(new JcePublicKeyKeyEncryptionMethodGenerator(pGPPublicKey).setProvider("BC"));
                OutputStream outputStream2 = pGPEncryptedDataGenerator.open(outputStream, byArray.length);
                outputStream2.write(byArray);
                outputStream2.close();
                if (bl) {
                    outputStream.close();
                }
            }
            catch (PGPException pGPException) {
                System.err.println(pGPException);
                if (pGPException.getUnderlyingException() == null) break block4;
                pGPException.getUnderlyingException().printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        if (stringArray.length == 0) {
            System.err.println("usage: KeyBasedFileProcessor -e|-d [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
            return;
        }
        if (stringArray[0].equals("-e")) {
            if (stringArray[1].equals("-a") || stringArray[1].equals("-ai") || stringArray[1].equals("-ia")) {
                KeyBasedFileProcessor.encryptFile(stringArray[2] + ".asc", stringArray[2], stringArray[3], true, stringArray[1].indexOf(105) > 0);
            } else if (stringArray[1].equals("-i")) {
                KeyBasedFileProcessor.encryptFile(stringArray[2] + ".bpg", stringArray[2], stringArray[3], false, true);
            } else {
                KeyBasedFileProcessor.encryptFile(stringArray[1] + ".bpg", stringArray[1], stringArray[2], false, false);
            }
        } else if (stringArray[0].equals("-d")) {
            KeyBasedFileProcessor.decryptFile(stringArray[1], stringArray[2], stringArray[3].toCharArray(), new File(stringArray[1]).getName() + ".out");
        } else {
            System.err.println("usage: KeyBasedFileProcessor -d|-e [-a|ai] file [secretKeyFile passPhrase|pubKeyFile]");
        }
    }
}

