/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.Exportable;
import org.bouncycastle.bcpg.sig.Features;
import org.bouncycastle.bcpg.sig.IntendedRecipientFingerprint;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.KeyExpirationTime;
import org.bouncycastle.bcpg.sig.KeyFlags;
import org.bouncycastle.bcpg.sig.LibrePGPPreferredEncryptionModes;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.bcpg.sig.PolicyURI;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.bcpg.sig.PreferredAlgorithms;
import org.bouncycastle.bcpg.sig.PrimaryUserID;
import org.bouncycastle.bcpg.sig.RegularExpression;
import org.bouncycastle.bcpg.sig.Revocable;
import org.bouncycastle.bcpg.sig.RevocationKey;
import org.bouncycastle.bcpg.sig.RevocationReason;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.bcpg.sig.SignatureExpirationTime;
import org.bouncycastle.bcpg.sig.SignatureTarget;
import org.bouncycastle.bcpg.sig.SignerUserID;
import org.bouncycastle.bcpg.sig.TrustSignature;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;

public class PGPSignatureSubpacketVector {
    SignatureSubpacket[] packets;

    public static PGPSignatureSubpacketVector fromSubpackets(Collection<SignatureSubpacket> collection) {
        if (collection == null) {
            return PGPSignatureSubpacketVector.fromSubpackets((SignatureSubpacket[])null);
        }
        return PGPSignatureSubpacketVector.fromSubpackets(collection.toArray(new SignatureSubpacket[0]));
    }

    public static PGPSignatureSubpacketVector fromSubpackets(SignatureSubpacket[] signatureSubpacketArray) {
        if (signatureSubpacketArray == null) {
            signatureSubpacketArray = new SignatureSubpacket[]{};
        }
        return new PGPSignatureSubpacketVector(signatureSubpacketArray);
    }

    PGPSignatureSubpacketVector(SignatureSubpacket[] signatureSubpacketArray) {
        this.packets = signatureSubpacketArray;
    }

    public SignatureSubpacket getSubpacket(int n) {
        for (int i = 0; i != this.packets.length; ++i) {
            if (this.packets[i].getType() != n) continue;
            return this.packets[i];
        }
        return null;
    }

    public boolean hasSubpacket(int n) {
        return this.getSubpacket(n) != null;
    }

    public SignatureSubpacket[] getSubpackets(int n) {
        ArrayList<SignatureSubpacket> arrayList = new ArrayList<SignatureSubpacket>();
        for (int i = 0; i != this.packets.length; ++i) {
            if (this.packets[i].getType() != n) continue;
            arrayList.add(this.packets[i]);
        }
        return arrayList.toArray(new SignatureSubpacket[0]);
    }

    public PGPSignatureList getEmbeddedSignatures() throws PGPException {
        SignatureSubpacket[] signatureSubpacketArray = this.getSubpackets(32);
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        for (int i = 0; i < signatureSubpacketArray.length; ++i) {
            try {
                arrayList.add(new PGPSignature(SignaturePacket.fromByteArray(signatureSubpacketArray[i].getData())));
                continue;
            }
            catch (IOException iOException) {
                throw new PGPException("Unable to parse signature packet: " + iOException.getMessage(), iOException);
            }
        }
        return new PGPSignatureList(arrayList.toArray(new PGPSignature[arrayList.size()]));
    }

    public NotationData[] getNotationDataOccurrences() {
        SignatureSubpacket[] signatureSubpacketArray = this.getSubpackets(20);
        NotationData[] notationDataArray = new NotationData[signatureSubpacketArray.length];
        for (int i = 0; i < signatureSubpacketArray.length; ++i) {
            notationDataArray[i] = (NotationData)signatureSubpacketArray[i];
        }
        return notationDataArray;
    }

    public NotationData[] getNotationDataOccurences() {
        return this.getNotationDataOccurrences();
    }

    public NotationData[] getNotationDataOccurrences(String string2) {
        NotationData[] notationDataArray = this.getNotationDataOccurrences();
        ArrayList<NotationData> arrayList = new ArrayList<NotationData>();
        for (int i = 0; i != notationDataArray.length; ++i) {
            NotationData notationData = notationDataArray[i];
            if (!notationData.getNotationName().equals(string2)) continue;
            arrayList.add(notationData);
        }
        return arrayList.toArray(new NotationData[0]);
    }

    public long getIssuerKeyID() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(16);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((IssuerKeyID)signatureSubpacket).getKeyID();
    }

    public Date getSignatureCreationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(2);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((SignatureCreationTime)signatureSubpacket).getTime();
    }

    public long getSignatureExpirationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(3);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((SignatureExpirationTime)signatureSubpacket).getTime();
    }

    public long getKeyExpirationTime() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(9);
        if (signatureSubpacket == null) {
            return 0L;
        }
        return ((KeyExpirationTime)signatureSubpacket).getTime();
    }

    public int[] getPreferredHashAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(21);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferences();
    }

    public int[] getPreferredSymmetricAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(11);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferences();
    }

    public int[] getPreferredCompressionAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(22);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferences();
    }

    @Deprecated
    public int[] getPreferredAEADAlgorithms() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(39);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((PreferredAlgorithms)signatureSubpacket).getPreferences();
    }

    public PreferredAEADCiphersuites getPreferredAEADCiphersuites() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(39);
        if (signatureSubpacket == null) {
            return null;
        }
        return (PreferredAEADCiphersuites)signatureSubpacket;
    }

    public int[] getPreferredLibrePgpEncryptionModes() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(39);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((LibrePGPPreferredEncryptionModes)signatureSubpacket).getPreferences();
    }

    public int getKeyFlags() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(27);
        if (signatureSubpacket == null) {
            return 0;
        }
        return ((KeyFlags)signatureSubpacket).getFlags();
    }

    public String getSignerUserID() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(28);
        if (signatureSubpacket == null) {
            return null;
        }
        return ((SignerUserID)signatureSubpacket).getID();
    }

    public boolean isPrimaryUserID() {
        PrimaryUserID primaryUserID = (PrimaryUserID)this.getSubpacket(25);
        if (primaryUserID != null) {
            return primaryUserID.isPrimaryUserID();
        }
        return false;
    }

    public int[] getCriticalTags() {
        int n = 0;
        for (int i = 0; i != this.packets.length; ++i) {
            if (!this.packets[i].isCritical()) continue;
            ++n;
        }
        int[] nArray = new int[n];
        n = 0;
        for (int i = 0; i != this.packets.length; ++i) {
            if (!this.packets[i].isCritical()) continue;
            nArray[n++] = this.packets[i].getType();
        }
        return nArray;
    }

    public SignatureTarget getSignatureTarget() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(31);
        if (signatureSubpacket == null) {
            return null;
        }
        return new SignatureTarget(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
    }

    public Features getFeatures() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(30);
        if (signatureSubpacket == null) {
            return null;
        }
        return new Features(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
    }

    public IssuerFingerprint getIssuerFingerprint() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(33);
        if (signatureSubpacket == null) {
            return null;
        }
        return new IssuerFingerprint(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
    }

    public IntendedRecipientFingerprint getIntendedRecipientFingerprint() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(35);
        if (signatureSubpacket == null) {
            return null;
        }
        return new IntendedRecipientFingerprint(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
    }

    public IntendedRecipientFingerprint[] getIntendedRecipientFingerprints() {
        SignatureSubpacket[] signatureSubpacketArray = this.getSubpackets(35);
        IntendedRecipientFingerprint[] intendedRecipientFingerprintArray = new IntendedRecipientFingerprint[signatureSubpacketArray.length];
        for (int i = 0; i < intendedRecipientFingerprintArray.length; ++i) {
            intendedRecipientFingerprintArray[i] = new IntendedRecipientFingerprint(signatureSubpacketArray[i].isCritical(), signatureSubpacketArray[i].isLongLength(), signatureSubpacketArray[i].getData());
        }
        return intendedRecipientFingerprintArray;
    }

    public Exportable getExportable() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(4);
        if (signatureSubpacket == null) {
            return null;
        }
        return new Exportable(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
    }

    public boolean isExportable() {
        Exportable exportable = this.getExportable();
        return exportable == null || exportable.isExportable();
    }

    public PolicyURI getPolicyURI() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(26);
        if (signatureSubpacket == null) {
            return null;
        }
        return new PolicyURI(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
    }

    public PolicyURI[] getPolicyURIs() {
        SignatureSubpacket[] signatureSubpacketArray = this.getSubpackets(26);
        PolicyURI[] policyURIArray = new PolicyURI[signatureSubpacketArray.length];
        for (int i = 0; i < signatureSubpacketArray.length; ++i) {
            SignatureSubpacket signatureSubpacket = signatureSubpacketArray[i];
            policyURIArray[i] = new PolicyURI(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
        }
        return policyURIArray;
    }

    public RegularExpression getRegularExpression() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(6);
        if (signatureSubpacket == null) {
            return null;
        }
        return new RegularExpression(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
    }

    public RegularExpression[] getRegularExpressions() {
        SignatureSubpacket[] signatureSubpacketArray = this.getSubpackets(6);
        RegularExpression[] regularExpressionArray = new RegularExpression[signatureSubpacketArray.length];
        for (int i = 0; i < regularExpressionArray.length; ++i) {
            SignatureSubpacket signatureSubpacket = signatureSubpacketArray[i];
            regularExpressionArray[i] = new RegularExpression(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
        }
        return regularExpressionArray;
    }

    public Revocable getRevocable() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(7);
        if (signatureSubpacket == null) {
            return null;
        }
        return new Revocable(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
    }

    public boolean isRevocable() {
        Revocable revocable = this.getRevocable();
        return revocable == null || revocable.isRevocable();
    }

    public RevocationKey[] getRevocationKeys() {
        SignatureSubpacket[] signatureSubpacketArray = this.getSubpackets(12);
        RevocationKey[] revocationKeyArray = new RevocationKey[signatureSubpacketArray.length];
        for (int i = 0; i < revocationKeyArray.length; ++i) {
            revocationKeyArray[i] = new RevocationKey(signatureSubpacketArray[i].isCritical(), signatureSubpacketArray[i].isLongLength(), signatureSubpacketArray[i].getData());
        }
        return revocationKeyArray;
    }

    public RevocationReason getRevocationReason() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(29);
        if (signatureSubpacket == null) {
            return null;
        }
        return new RevocationReason(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
    }

    public TrustSignature getTrust() {
        SignatureSubpacket signatureSubpacket = this.getSubpacket(5);
        if (signatureSubpacket == null) {
            return null;
        }
        return new TrustSignature(signatureSubpacket.isCritical(), signatureSubpacket.isLongLength(), signatureSubpacket.getData());
    }

    public int size() {
        return this.packets.length;
    }

    SignatureSubpacket[] toSubpacketArray() {
        return this.packets;
    }

    public SignatureSubpacket[] toArray() {
        SignatureSubpacket[] signatureSubpacketArray = new SignatureSubpacket[this.packets.length];
        System.arraycopy(this.packets, 0, signatureSubpacketArray, 0, signatureSubpacketArray.length);
        return signatureSubpacketArray;
    }
}

