/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.bcpg.HashUtils;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.IssuerFingerprint;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.openpgp.PGPDefaultSignatureGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentSigner;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class PGPSignatureGenerator
extends PGPDefaultSignatureGenerator {
    private SignatureSubpacket[] unhashed = new SignatureSubpacket[0];
    private SignatureSubpacket[] hashed = new SignatureSubpacket[0];
    private PGPContentSignerBuilder contentSignerBuilder;
    private PGPContentSigner contentSigner;
    private int providedKeyAlgorithm = -1;
    private PGPPublicKey signingPubKey;
    private byte[] salt;

    public PGPSignatureGenerator(PGPContentSignerBuilder pGPContentSignerBuilder) {
        this(pGPContentSignerBuilder, 4);
    }

    PGPSignatureGenerator(PGPContentSignerBuilder pGPContentSignerBuilder, int n) {
        super(n);
        this.contentSignerBuilder = pGPContentSignerBuilder;
    }

    public PGPSignatureGenerator(PGPContentSignerBuilder pGPContentSignerBuilder, PGPPublicKey pGPPublicKey) {
        this(pGPContentSignerBuilder, pGPPublicKey, pGPPublicKey.getVersion());
    }

    public PGPSignatureGenerator(PGPContentSignerBuilder pGPContentSignerBuilder, PGPPublicKey pGPPublicKey, int n) {
        this(pGPContentSignerBuilder, n);
        this.signingPubKey = pGPPublicKey;
        if (pGPPublicKey.getVersion() == 6 && n != 6) {
            throw new IllegalArgumentException("Version 6 keys MUST only generate version 6 signatures.");
        }
    }

    public void init(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        if (n == 255) {
            throw new PGPException("Illegal signature type 0xFF provided.");
        }
        this.contentSigner = this.contentSignerBuilder.build(n, pGPPrivateKey);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
        if (pGPPrivateKey.getPublicKeyPacket().getVersion() != this.version) {
            throw new PGPException("Key version mismatch.");
        }
        if (this.version == 6) {
            int n2 = HashUtils.getV6SignatureSaltSizeInBytes(this.contentSigner.getHashAlgorithm());
            this.salt = new byte[n2];
            CryptoServicesRegistrar.getSecureRandom().nextBytes(this.salt);
            try {
                this.sigOut.write(this.salt);
            }
            catch (IOException iOException) {
                throw new PGPException("Cannot update signature with salt.");
            }
        }
    }

    public void setHashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.hashed = new SignatureSubpacket[0];
            return;
        }
        this.hashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public void setUnhashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.unhashed = new SignatureSubpacket[0];
            return;
        }
        this.unhashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public PGPOnePassSignature generateOnePassVersion(boolean bl) throws PGPException {
        if (this.version == 6) {
            return new PGPOnePassSignature(this.v6OPSPacket(bl));
        }
        return new PGPOnePassSignature(this.v3OPSPacket(bl));
    }

    private OnePassSignaturePacket v3OPSPacket(boolean bl) {
        return new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getKeyID(), bl);
    }

    private OnePassSignaturePacket v6OPSPacket(boolean bl) {
        return new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.salt, this.signingPubKey.getFingerprint(), bl);
    }

    public PGPSignature generate() throws PGPException {
        Object[] objectArray;
        Object object;
        this.prepareSignatureSubpackets();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write((byte)this.version);
            byteArrayOutputStream.write((byte)this.sigType);
            byteArrayOutputStream.write((byte)this.contentSigner.getKeyAlgorithm());
            byteArrayOutputStream.write((byte)this.contentSigner.getHashAlgorithm());
            object = new ByteArrayOutputStream();
            for (int i = 0; i != this.hashed.length; ++i) {
                this.hashed[i].encode((OutputStream)object);
            }
            objectArray = ((ByteArrayOutputStream)object).toByteArray();
            if (this.version == 6) {
                byteArrayOutputStream.write((byte)(objectArray.length >> 24));
                byteArrayOutputStream.write((byte)(objectArray.length >> 16));
            }
            byteArrayOutputStream.write((byte)(objectArray.length >> 8));
            byteArrayOutputStream.write((byte)objectArray.length);
            byteArrayOutputStream.write((byte[])objectArray);
            int n = byteArrayOutputStream.toByteArray().length;
            byteArrayOutputStream.write((byte)this.version);
            byteArrayOutputStream.write(-1);
            byteArrayOutputStream.write((byte)(n >> 24));
            byteArrayOutputStream.write((byte)(n >> 16));
            byteArrayOutputStream.write((byte)(n >> 8));
            byteArrayOutputStream.write((byte)n);
        }
        catch (IOException iOException) {
            throw new PGPException("exception encoding hashed data.", iOException);
        }
        object = byteArrayOutputStream.toByteArray();
        this.blockUpdate((byte[])object, 0, ((Object)object).length);
        switch (this.contentSigner.getKeyAlgorithm()) {
            case 1: 
            case 3: {
                objectArray = new MPInteger[1];
                objectArray[0] = (byte)new MPInteger(new BigInteger(1, this.contentSigner.getSignature()));
                break;
            }
            case 22: {
                byte[] byArray = this.contentSigner.getSignature();
                objectArray = new MPInteger[]{new MPInteger(new BigInteger(1, Arrays.copyOfRange(byArray, 0, byArray.length / 2))), new MPInteger(new BigInteger(1, Arrays.copyOfRange(byArray, byArray.length / 2, byArray.length)))};
                break;
            }
            case 27: 
            case 28: {
                objectArray = null;
                break;
            }
            default: {
                objectArray = PGPUtil.dsaSigToMpi(this.contentSigner.getSignature());
            }
        }
        byte[] byArray = this.contentSigner.getDigest();
        byte[] byArray2 = new byte[]{byArray[0], byArray[1]};
        SignaturePacket signaturePacket = objectArray != null ? new SignaturePacket(this.version, this.sigType, this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), this.hashed, this.unhashed, byArray2, (MPInteger[])objectArray, this.salt) : new SignaturePacket(this.version, this.sigType, this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), this.hashed, this.unhashed, byArray2, this.contentSigner.getSignature(), this.salt);
        return new PGPSignature(signaturePacket);
    }

    protected void prepareSignatureSubpackets() throws PGPException {
        switch (this.version) {
            case 4: 
            case 5: {
                if (this.packetNotPresent(this.hashed, 2)) {
                    this.hashed = this.insertSubpacket(this.hashed, new SignatureCreationTime(true, new Date()));
                }
                if (!this.packetNotPresent(this.hashed, 16) || !this.packetNotPresent(this.unhashed, 16)) break;
                this.unhashed = this.insertSubpacket(this.unhashed, new IssuerKeyID(false, this.contentSigner.getKeyID()));
                break;
            }
            case 6: {
                if (this.packetNotPresent(this.hashed, 2)) {
                    this.hashed = this.insertSubpacket(this.hashed, new SignatureCreationTime(true, new Date()));
                }
                if (!this.packetNotPresent(this.hashed, 33) || !this.packetNotPresent(this.unhashed, 33) || this.signingPubKey == null) break;
                this.hashed = this.insertSubpacket(this.hashed, new IssuerFingerprint(true, this.version, this.signingPubKey.getFingerprint()));
            }
        }
    }

    public PGPSignature generateCertification(String string2, PGPPublicKey pGPPublicKey) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithIdData(180, Strings.toUTF8ByteArray(string2));
        return this.generate();
    }

    public PGPSignature generateCertification(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPPublicKey pGPPublicKey) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.getAttributesHash(pGPUserAttributeSubpacketVector);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithPublicKey(pGPPublicKey2);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey) throws PGPException {
        if (!(this.sigType != 40 && this.sigType != 24 || pGPPublicKey.isMasterKey())) {
            throw new IllegalArgumentException("certifications involving subkey requires public key of revoking key as well.");
        }
        this.updateWithPublicKey(pGPPublicKey);
        return this.generate();
    }

    private boolean packetNotPresent(SignatureSubpacket[] signatureSubpacketArray, int n) {
        for (int i = 0; i != signatureSubpacketArray.length; ++i) {
            if (signatureSubpacketArray[i].getType() != n) continue;
            return false;
        }
        return true;
    }

    private SignatureSubpacket[] insertSubpacket(SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket signatureSubpacket) {
        SignatureSubpacket[] signatureSubpacketArray2 = new SignatureSubpacket[signatureSubpacketArray.length + 1];
        signatureSubpacketArray2[0] = signatureSubpacket;
        System.arraycopy(signatureSubpacketArray, 0, signatureSubpacketArray2, 1, signatureSubpacketArray.length);
        return signatureSubpacketArray2;
    }
}

