/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.gpg.SExpression;
import org.bouncycastle.openpgp.OpenedPGPKeyData;
import org.bouncycastle.openpgp.PGPExtendedKeyHeader;
import org.bouncycastle.util.Strings;

public class PGPSecretKeyParser {
    public static boolean isExtendedSExpression(InputStream inputStream) throws IOException {
        if (!inputStream.markSupported()) {
            throw new IOException("input stream must support mark");
        }
        inputStream.mark(1);
        int n = inputStream.read();
        inputStream.reset();
        return n != 40;
    }

    private static int lastIndexOfWhitespace(String string2) {
        if (string2.length() == 0) {
            return -1;
        }
        for (int i = string2.length() - 1; i >= 0; --i) {
            char c = string2.charAt(i);
            if (c > ' ') continue;
            return i;
        }
        return -1;
    }

    private static void consumeUntil(InputStream inputStream, char c, ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n;
        byteArrayOutputStream.reset();
        while ((n = inputStream.read()) > -1) {
            if (n == c) {
                return;
            }
            byteArrayOutputStream.write(n);
        }
    }

    public static OpenedPGPKeyData parse(InputStream inputStream, int n) throws IOException {
        OpenedPGPKeyData.Builder builder = OpenedPGPKeyData.builder();
        if (PGPSecretKeyParser.isExtendedSExpression(inputStream)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string2 = null;
            do {
                PGPSecretKeyParser.consumeUntil(inputStream, ':', byteArrayOutputStream);
                String string3 = Strings.fromByteArray(byteArrayOutputStream.toByteArray()).trim();
                int n2 = PGPSecretKeyParser.lastIndexOfWhitespace(string3);
                if (n2 == -1) {
                    string2 = string3;
                    continue;
                }
                builder.add(new PGPExtendedKeyHeader(string2, string3.substring(0, n2)));
                string2 = string3.substring(n2).trim();
            } while (!string2.equalsIgnoreCase("Key"));
        }
        builder.setKeyExpression(SExpression.parse(inputStream, n));
        return builder.build();
    }
}

