/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.CRC24;
import org.bouncycastle.bcpg.FastCRC24;
import org.bouncycastle.util.Strings;

public class ArmoredOutputStream
extends OutputStream {
    public static final String VERSION_HDR = "Version";
    public static final String COMMENT_HDR = "Comment";
    public static final String MESSAGE_ID_HDR = "MessageID";
    public static final String HASH_HDR = "Hash";
    public static final String CHARSET_HDR = "Charset";
    public static final String DEFAULT_VERSION = "BCPG v1.80";
    private static final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    OutputStream out;
    byte[] buf = new byte[3];
    int bufPtr = 0;
    CRC24 crc = new FastCRC24();
    int chunkCount = 0;
    int lastb;
    boolean start = true;
    boolean clearText = false;
    boolean newLine = false;
    String nl = Strings.lineSeparator();
    String type;
    String headerStart = "-----BEGIN PGP ";
    String headerTail = "-----";
    String footerStart = "-----END PGP ";
    String footerTail = "-----";
    final Hashtable<String, List<String>> headers = new Hashtable();

    private static void encode(OutputStream outputStream, byte[] byArray, int n) throws IOException {
        switch (n) {
            case 1: {
                int n2 = byArray[0] & 0xFF;
                outputStream.write(encodingTable[n2 >>> 2 & 0x3F]);
                outputStream.write(encodingTable[n2 << 4 & 0x3F]);
                outputStream.write(61);
                outputStream.write(61);
                break;
            }
            case 2: {
                int n3 = byArray[0] & 0xFF;
                int n4 = byArray[1] & 0xFF;
                outputStream.write(encodingTable[n3 >>> 2 & 0x3F]);
                outputStream.write(encodingTable[(n3 << 4 | n4 >>> 4) & 0x3F]);
                outputStream.write(encodingTable[n4 << 2 & 0x3F]);
                outputStream.write(61);
                break;
            }
            case 3: {
                int n5 = byArray[0] & 0xFF;
                int n6 = byArray[1] & 0xFF;
                int n7 = byArray[2] & 0xFF;
                outputStream.write(encodingTable[n5 >>> 2 & 0x3F]);
                outputStream.write(encodingTable[(n5 << 4 | n6 >>> 4) & 0x3F]);
                outputStream.write(encodingTable[(n6 << 2 | n7 >>> 6) & 0x3F]);
                outputStream.write(encodingTable[n7 & 0x3F]);
                break;
            }
            default: {
                throw new IOException("unknown length in encode");
            }
        }
    }

    private static void encode3(OutputStream outputStream, byte[] byArray) throws IOException {
        int n = byArray[0] & 0xFF;
        int n2 = byArray[1] & 0xFF;
        int n3 = byArray[2] & 0xFF;
        outputStream.write(encodingTable[n >>> 2 & 0x3F]);
        outputStream.write(encodingTable[(n << 4 | n2 >>> 4) & 0x3F]);
        outputStream.write(encodingTable[(n2 << 2 | n3 >>> 6) & 0x3F]);
        outputStream.write(encodingTable[n3 & 0x3F]);
    }

    public ArmoredOutputStream(OutputStream outputStream) {
        this.out = outputStream;
        if (this.nl == null) {
            this.nl = "\r\n";
        }
        this.setHeader(VERSION_HDR, DEFAULT_VERSION);
    }

    public ArmoredOutputStream(OutputStream outputStream, Hashtable<String, String> hashtable) {
        this(outputStream);
        Enumeration<String> enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(hashtable.get(string2));
            this.headers.put(string2, arrayList);
        }
    }

    ArmoredOutputStream(OutputStream outputStream, Builder builder) {
        this(outputStream);
        if (!builder.computeCRCSum) {
            this.crc = null;
        }
        this.headers.clear();
        Map map = builder.headers;
        for (String string2 : map.keySet()) {
            this.headers.put(string2, (List)map.get(string2));
        }
    }

    @Deprecated
    public void setHeader(String string2, String string3) {
        if (string3 == null) {
            this.headers.remove(string2);
        } else {
            List<String> list = this.headers.get(string2);
            if (list == null) {
                list = new ArrayList<String>();
                this.headers.put(string2, list);
            } else {
                list.clear();
            }
            list.add(string3);
        }
    }

    @Deprecated
    public void clearHeaders() {
        this.headers.clear();
    }

    @Deprecated
    public void addHeader(String string2, String string3) {
        if (string3 == null || string2 == null) {
            return;
        }
        List<String> list = this.headers.get(string2);
        if (list == null) {
            list = new ArrayList<String>();
            this.headers.put(string2, list);
        }
        list.add(string3);
    }

    @Deprecated
    public void resetHeaders() {
        List<String> list = this.headers.get(VERSION_HDR);
        this.headers.clear();
        if (list != null) {
            this.headers.put(VERSION_HDR, list);
        }
    }

    public void beginClearText(int n) throws IOException {
        this.beginClearText(new int[]{n});
    }

    public void beginClearText(int ... nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder("-----BEGIN PGP SIGNED MESSAGE-----");
        stringBuilder.append(this.nl);
        for (int n : nArray) {
            String string2;
            switch (n) {
                case 1: {
                    string2 = "MD5";
                    break;
                }
                case 2: {
                    string2 = "SHA1";
                    break;
                }
                case 3: {
                    string2 = "RIPEMD160";
                    break;
                }
                case 5: {
                    string2 = "MD2";
                    break;
                }
                case 8: {
                    string2 = "SHA256";
                    break;
                }
                case 9: {
                    string2 = "SHA384";
                    break;
                }
                case 10: {
                    string2 = "SHA512";
                    break;
                }
                case 11: {
                    string2 = "SHA224";
                    break;
                }
                case 12: 
                case 313: {
                    string2 = "SHA3-256";
                    break;
                }
                case 314: {
                    string2 = "SHA3-384";
                    break;
                }
                case 14: 
                case 315: {
                    string2 = "SHA3-512";
                    break;
                }
                case 312: {
                    string2 = "SHA3-224";
                    break;
                }
                default: {
                    throw new IOException("unknown hash algorithm tag in beginClearText: " + n);
                }
            }
            stringBuilder.append(HASH_HDR).append(": ").append(string2).append(this.nl);
        }
        stringBuilder.append(this.nl);
        this.write(stringBuilder.toString());
        this.clearText = true;
        this.newLine = true;
        this.lastb = 0;
    }

    public void endClearText() {
        this.clearText = false;
    }

    private void writeHeaderEntry(String string2, String string3) throws IOException {
        this.write(string2);
        this.write(": ");
        this.write(string3);
        this.write(this.nl);
    }

    @Override
    public void write(int n) throws IOException {
        if (this.clearText) {
            this.out.write(n);
            if (this.newLine) {
                if (n != 10 || this.lastb != 13) {
                    this.newLine = false;
                }
                if (n == 45) {
                    this.out.write(32);
                    this.out.write(45);
                }
            }
            if (n == 13 || n == 10 && this.lastb != 13) {
                this.newLine = true;
            }
            this.lastb = n;
            return;
        }
        if (this.start) {
            boolean bl = (n & 0x40) != 0;
            int n2 = 0;
            n2 = bl ? n & 0x3F : (n & 0x3F) >> 2;
            switch (n2) {
                case 6: {
                    this.type = "PUBLIC KEY BLOCK";
                    break;
                }
                case 5: {
                    this.type = "PRIVATE KEY BLOCK";
                    break;
                }
                case 2: {
                    this.type = "SIGNATURE";
                    break;
                }
                default: {
                    this.type = "MESSAGE";
                }
            }
            this.write(this.headerStart);
            this.write(this.type);
            this.write(this.headerTail);
            this.write(this.nl);
            if (this.headers.containsKey(VERSION_HDR)) {
                this.writeHeaderEntry(VERSION_HDR, this.headers.get(VERSION_HDR).get(0));
            }
            Enumeration<String> enumeration = this.headers.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                if (string2.equals(VERSION_HDR)) continue;
                List<String> list = this.headers.get(string2);
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext()) {
                    this.writeHeaderEntry(string2, iterator.next());
                }
            }
            this.write(this.nl);
            this.start = false;
        }
        if (this.bufPtr == 3) {
            if (this.crc != null) {
                this.crc.update3(this.buf, 0);
            }
            ArmoredOutputStream.encode3(this.out, this.buf);
            this.bufPtr = 0;
            if ((++this.chunkCount & 0xF) == 0) {
                this.write(this.nl);
            }
        }
        this.buf[this.bufPtr++] = (byte)n;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.type != null) {
            int n;
            if (this.bufPtr > 0) {
                if (this.crc != null) {
                    for (n = 0; n < this.bufPtr; ++n) {
                        this.crc.update(this.buf[n] & 0xFF);
                    }
                }
                ArmoredOutputStream.encode(this.out, this.buf, this.bufPtr);
            }
            this.write(this.nl);
            if (this.crc != null) {
                this.out.write(61);
                n = this.crc.getValue();
                this.buf[0] = (byte)(n >>> 16);
                this.buf[1] = (byte)(n >>> 8);
                this.buf[2] = (byte)n;
                ArmoredOutputStream.encode3(this.out, this.buf);
                this.write(this.nl);
            }
            this.write(this.footerStart);
            this.write(this.type);
            this.write(this.footerTail);
            this.write(this.nl);
            this.out.flush();
            this.type = null;
            this.start = true;
        }
    }

    private void write(String string2) throws IOException {
        this.out.write(Strings.toUTF8ByteArray(string2));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private boolean computeCRCSum = true;

        private Builder() {
        }

        public ArmoredOutputStream build(OutputStream outputStream) {
            return new ArmoredOutputStream(outputStream, this);
        }

        public Builder setVersion(String string2) {
            return this.setSingletonHeader(ArmoredOutputStream.VERSION_HDR, string2);
        }

        public Builder setComment(String string2) {
            return this.replaceHeader(ArmoredOutputStream.COMMENT_HDR, string2);
        }

        public Builder setMessageId(String string2) {
            return this.replaceHeader(ArmoredOutputStream.MESSAGE_ID_HDR, string2);
        }

        public Builder setCharset(String string2) {
            return this.replaceHeader(ArmoredOutputStream.CHARSET_HDR, string2);
        }

        public Builder addComment(String string2) {
            return this.addHeader(ArmoredOutputStream.COMMENT_HDR, string2);
        }

        private Builder setSingletonHeader(String string2, String string3) {
            if (string3 == null || string3.trim().length() == 0) {
                this.headers.remove(string2);
            } else {
                String string4 = string3.trim();
                if (string4.contains("\n")) {
                    throw new IllegalArgumentException("Armor header value for key " + string2 + " cannot contain newlines.");
                }
                this.headers.put(string2, Collections.singletonList(string3));
            }
            return this;
        }

        private Builder addHeader(String string2, String string3) {
            if (string3 == null || string3.trim().length() == 0) {
                return this;
            }
            List<String> list = this.headers.get(string2);
            if (list == null) {
                list = new ArrayList<String>();
                this.headers.put(string2, list);
            }
            String string4 = string3.trim();
            for (String string5 : string4.split("\n")) {
                String string6 = string5.trim();
                if (string6.length() == 0) continue;
                list.add(string6);
            }
            return this;
        }

        private Builder replaceHeader(String string2, String string3) {
            if (string3 == null || string3.trim().length() == 0) {
                return this;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string4 = string3.trim();
            for (String string5 : string4.split("\n")) {
                String string6 = string5.trim();
                if (string6.length() == 0) continue;
                arrayList.add(string6);
            }
            this.headers.put(string2, arrayList);
            return this;
        }

        public Builder clearHeaders() {
            this.headers.clear();
            return this;
        }

        public Builder enableCRC(boolean bl) {
            this.computeCRCSum = bl;
            return this;
        }
    }
}

