/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.HashCode$;
import org.apache.pekko.util.Version$;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class Version
implements Comparable<Version> {
    private final String version;
    private volatile int[] numbers;
    private String rest;

    public static Version Zero() {
        return Version$.MODULE$.Zero();
    }

    public static Version apply(String string2) {
        return Version$.MODULE$.apply(string2);
    }

    public Version(String version) {
        this.version = version;
        this.numbers = Array$.MODULE$.emptyIntArray();
        this.rest = "";
    }

    public String version() {
        return this.version;
    }

    private int[] numbers() {
        return this.numbers;
    }

    private void numbers_$eq(int[] x$0) {
        this.numbers = x$0;
    }

    private String rest() {
        return this.rest;
    }

    private void rest_$eq(String x$0) {
        this.rest = x$0;
    }

    @InternalApi
    public Version parse() {
        if (this.numbers().length == 0) {
            String string2;
            int[] nbrs = new int[4];
            String[] segments = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(this.version()), '.');
            if (segments.length == 1) {
                String s2 = segments[0];
                if (s2.isEmpty()) {
                    throw new IllegalArgumentException("Empty version not supported.");
                }
                nbrs[1] = Version$.org$apache$pekko$util$Version$$$Undefined;
                nbrs[2] = Version$.org$apache$pekko$util$Version$$$Undefined;
                nbrs[3] = Version$.org$apache$pekko$util$Version$$$Undefined;
                if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(s2.charAt(0)))) {
                    try {
                        nbrs[0] = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s2));
                        string2 = "";
                    }
                    catch (NumberFormatException numberFormatException) {
                        string2 = s2;
                    }
                } else {
                    string2 = s2;
                }
            } else if (segments.length == 2) {
                Tuple3 tuple3 = Version.parseLastParts$1(segments[1]);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                int n1 = BoxesRunTime.unboxToInt(tuple3._1());
                int n2 = BoxesRunTime.unboxToInt(tuple3._2());
                String rest = (String)tuple3._3();
                Tuple3<Integer, Integer, String> tuple32 = Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(n1), BoxesRunTime.boxToInteger(n2), rest);
                int n12 = BoxesRunTime.unboxToInt(tuple32._1());
                int n22 = BoxesRunTime.unboxToInt(tuple32._2());
                String rest2 = tuple32._3();
                nbrs[0] = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[0]));
                nbrs[1] = n12;
                nbrs[2] = n22;
                nbrs[3] = Version$.org$apache$pekko$util$Version$$$Undefined;
                string2 = rest2;
            } else if (segments.length == 3) {
                Tuple3 tuple3 = Version.parseLastParts$1(segments[2]);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                int n1 = BoxesRunTime.unboxToInt(tuple3._1());
                int n2 = BoxesRunTime.unboxToInt(tuple3._2());
                String rest = (String)tuple3._3();
                Tuple3<Integer, Integer, String> tuple33 = Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(n1), BoxesRunTime.boxToInteger(n2), rest);
                int n13 = BoxesRunTime.unboxToInt(tuple33._1());
                int n23 = BoxesRunTime.unboxToInt(tuple33._2());
                String rest3 = tuple33._3();
                nbrs[0] = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[0]));
                nbrs[1] = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[1]));
                nbrs[2] = n13;
                nbrs[3] = n23;
                string2 = rest3;
            } else {
                throw new IllegalArgumentException(new StringBuilder(50).append("Only 3 digits separated with '.' are supported. [").append(this.version()).append("]").toString());
            }
            String rst = string2;
            this.rest_$eq(rst);
            this.numbers_$eq(nbrs);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(Version other) {
        String string2 = this.version();
        String string3 = other.version();
        if (string2 == null) {
            if (string3 == null) return 0;
        } else if (string2.equals(string3)) {
            return 0;
        }
        this.parse();
        other.parse();
        int diff = 0;
        diff = this.numbers()[0] - other.numbers()[0];
        if (diff != 0) return diff;
        diff = this.numbers()[1] - other.numbers()[1];
        if (diff != 0) return diff;
        diff = this.numbers()[2] - other.numbers()[2];
        if (diff != 0) return diff;
        diff = this.numbers()[3] - other.numbers()[3];
        if (diff != 0) return diff;
        String string4 = this.rest();
        String string5 = "";
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            String string6 = other.rest();
            String string7 = "";
            if (string6 == null ? string7 != null : !string6.equals(string7)) {
                diff = 1;
            }
        }
        String string8 = other.rest();
        String string9 = "";
        if (string8 == null) {
            if (string9 != null) {
                return this.rest().compareTo(other.rest());
            }
        } else if (!string8.equals(string9)) return this.rest().compareTo(other.rest());
        String string10 = this.rest();
        String string11 = "";
        if (string10 == null) {
            if (string11 == null) return this.rest().compareTo(other.rest());
            return -1;
        } else if (string10.equals(string11)) return this.rest().compareTo(other.rest());
        return -1;
    }

    public boolean equals(Object o) {
        Object object = o;
        if (object instanceof Version) {
            Version v = (Version)object;
            return this.compareTo(v) == 0;
        }
        return false;
    }

    public int hashCode() {
        this.parse();
        int result = HashCode$.MODULE$.SEED();
        result = HashCode$.MODULE$.hash(result, this.numbers()[0]);
        result = HashCode$.MODULE$.hash(result, this.numbers()[1]);
        result = HashCode$.MODULE$.hash(result, this.numbers()[2]);
        result = HashCode$.MODULE$.hash(result, this.numbers()[3]);
        result = HashCode$.MODULE$.hash(result, this.rest());
        return result;
    }

    public String toString() {
        return this.version();
    }

    private static final Tuple2 parseLastPart$1(String s2) {
        int k;
        if (s2.length() == 0) {
            Integer n = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(Version$.org$apache$pekko$util$Version$$$Undefined));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n, s2);
        }
        int i = s2.indexOf(45);
        int j = s2.indexOf(43);
        int n = i == -1 ? j : (k = j == -1 ? i : package$.MODULE$.min(i, j));
        if (k == -1) {
            Integer n2 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s2))));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n2, "");
        }
        Integer n3 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s2.substring(0, k)))));
        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n3, s2.substring(k + 1));
    }

    private static final Tuple2 parseDynverPart$1(String s2) {
        Tuple2<Integer, String> tuple2;
        if (s2.isEmpty() || !RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(s2.charAt(0)))) {
            Integer n = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(Version$.org$apache$pekko$util$Version$$$Undefined));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n, s2);
        }
        int n = s2.indexOf(45);
        if (-1 == n) {
            Integer n2 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(Version$.org$apache$pekko$util$Version$$$Undefined));
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n2, s2);
        }
        int i = n;
        try {
            Integer n3 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s2.substring(0, i)))));
            tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n3, s2.substring(i + 1));
        }
        catch (NumberFormatException numberFormatException) {
            Integer n4 = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(Version$.org$apache$pekko$util$Version$$$Undefined));
            tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n4, s2);
        }
        return tuple2;
    }

    private static final Tuple3 parseLastParts$1(String s2) {
        String rest;
        Tuple2 tuple2 = Version.parseLastPart$1(s2);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int lastNumber = BoxesRunTime.unboxToInt(tuple2._1());
        String rest2 = (String)tuple2._2();
        Tuple2<Integer, String> tuple22 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(lastNumber), rest2);
        int lastNumber2 = BoxesRunTime.unboxToInt(tuple22._1());
        String string2 = rest = tuple22._2();
        String string3 = "";
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(lastNumber2), BoxesRunTime.boxToInteger(Version$.org$apache$pekko$util$Version$$$Undefined), rest);
        }
        Tuple2 tuple23 = Version.parseDynverPart$1(rest);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        int dynverNumber = BoxesRunTime.unboxToInt(tuple23._1());
        String rest22 = (String)tuple23._2();
        Tuple2<Integer, String> tuple24 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(dynverNumber), rest22);
        int dynverNumber2 = BoxesRunTime.unboxToInt(tuple24._1());
        String rest23 = tuple24._2();
        return Tuple3$.MODULE$.apply(BoxesRunTime.boxToInteger(lastNumber2), BoxesRunTime.boxToInteger(dynverNumber2), rest23);
    }
}

