/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import org.apache.pekko.util.Subclassification;
import org.apache.pekko.util.SubclassifiedIndex$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.ScalaRunTime$;

public class SubclassifiedIndex<K, V> {
    private Set values;
    private final Subclassification<K> sc;
    private Vector subkeys;
    private final SubclassifiedIndex root;

    public static <K, V> Map<K, Set<V>> emptyMergeMap() {
        return SubclassifiedIndex$.MODULE$.emptyMergeMap();
    }

    public SubclassifiedIndex(Set<V> values, Subclassification<K> sc) {
        this.values = values;
        this.sc = sc;
        this.subkeys = package$.MODULE$.Vector().empty();
        this.root = this;
    }

    public Set<V> values() {
        return this.values;
    }

    public void values_$eq(Set<V> x$1) {
        this.values = x$1;
    }

    public Vector<Nonroot<K, V>> subkeys() {
        return this.subkeys;
    }

    public void subkeys_$eq(Vector<Nonroot<K, V>> x$1) {
        this.subkeys = x$1;
    }

    public SubclassifiedIndex(Subclassification<K> sc) {
        this((Set<V>)Predef$.MODULE$.Set().empty(), sc);
    }

    public SubclassifiedIndex<K, V> root() {
        return this.root;
    }

    public Seq<Tuple2<K, Set<V>>> addKey(K key2) {
        return this.mergeChangesByKey(this.innerAddKey(key2));
    }

    public Seq<Tuple2<K, Set<V>>> innerAddKey(K key2) {
        BooleanRef found = BooleanRef.create(false);
        Vector ch = (Vector)this.subkeys().flatMap((Function1<Nonroot, IterableOnce> & Serializable)n -> {
            if (this.sc.isEqual(key2, n.key())) {
                found$1.elem = true;
                return package$.MODULE$.Nil();
            }
            if (this.sc.isSubclass(key2, n.key())) {
                found$1.elem = true;
                return n.innerAddKey(key2);
            }
            return package$.MODULE$.Nil();
        });
        if (!found.elem) {
            return (Seq)this.integrate(new Nonroot<K, V>(this.root(), key2, this.values(), this.sc)).$colon$plus(Tuple2$.MODULE$.apply(key2, this.values()));
        }
        return ch;
    }

    public Seq<Tuple2<K, Set<V>>> addValue(K key2, V value) {
        return this.mergeChangesByKey(this.innerAddValue(key2, value));
    }

    public Seq<Tuple2<K, Set<V>>> innerAddValue(K key2, V value) {
        BooleanRef found = BooleanRef.create(false);
        Vector ch = (Vector)this.subkeys().flatMap((Function1<Nonroot, IterableOnce> & Serializable)n -> {
            if (this.sc.isSubclass(key2, n.key())) {
                found$2.elem = true;
                return n.innerAddValue(key2, value);
            }
            return package$.MODULE$.Nil();
        });
        if (!found.elem) {
            Set v = (Set)this.values().$plus(value);
            Nonroot<K, V> n2 = new Nonroot<K, V>(this.root(), key2, v, this.sc);
            K k = Predef$.MODULE$.ArrowAssoc(key2);
            return (Seq)((SeqOps)this.integrate(n2).$plus$plus(n2.innerAddValue(key2, value))).$colon$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(k, v));
        }
        return ch;
    }

    public Seq<Tuple2<K, Set<V>>> removeValue(K key2, V value) {
        return (Seq)this.mergeChangesByKey(this.innerRemoveValue(key2, value)).map((Function1<Tuple2, Tuple2> & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                return Tuple2$.MODULE$.apply(k, this.findValues(k));
            }
            throw new MatchError(tuple2);
        });
    }

    public Seq<Tuple2<K, Set<V>>> innerRemoveValue(K key2, V value) {
        BooleanRef found = BooleanRef.create(false);
        Vector ch = (Vector)this.subkeys().flatMap((Function1<Nonroot, IterableOnce> & Serializable)n -> {
            if (this.sc.isSubclass(key2, n.key())) {
                found$3.elem = true;
                return n.innerRemoveValue(key2, value);
            }
            return package$.MODULE$.Nil();
        });
        if (!found.elem) {
            Nonroot<K, V> n2 = new Nonroot<K, V>(this.root(), key2, this.values(), this.sc);
            return (Seq)this.integrate(n2).$plus$plus(n2.removeValue(value));
        }
        return ch;
    }

    public Seq<Tuple2<K, Set<V>>> removeValue(V value) {
        return this.mergeChangesByKey((Seq)this.subkeys().flatMap((Function1<Nonroot, IterableOnce> & Serializable)_$3 -> _$3.removeValue(value)));
    }

    public final Set<V> findValues(K key2) {
        return this.root().innerFindValues(key2);
    }

    public Set<V> innerFindValues(K key2) {
        return (Set)this.subkeys().foldLeft(Predef$.MODULE$.Set().empty(), (Function2<Set, Nonroot, Set> & Serializable)(s2, n) -> {
            if (this.sc.isSubclass(key2, n.key())) {
                return (Set)s2.$plus$plus(n.innerFindValues(key2));
            }
            return s2;
        });
    }

    public final Set<K> findSubKeysExcept(K key2, Vector<Nonroot<K, V>> except) {
        return this.root().innerFindSubKeys(key2, except);
    }

    public Set<K> innerFindSubKeys(K key2, Vector<Nonroot<K, V>> except) {
        return (Set)this.subkeys().foldLeft(Predef$.MODULE$.Set().empty(), (Function2<Set, Nonroot, Set> & Serializable)(s2, n) -> {
            if (this.sc.isEqual(key2, n.key())) {
                return s2;
            }
            return (Set)n.innerFindSubKeys(key2, except).$plus$plus(this.sc.isSubclass(n.key(), key2) && !except.exists((Function1<Nonroot, boolean> & Serializable)e -> this.sc.isEqual(key2, e.key())) ? s2.$plus(n.key()) : s2);
        });
    }

    public String toString() {
        return this.subkeys().mkString(new StringBuilder(21).append("SubclassifiedIndex(").append(this.values()).append(",\n").toString(), ",\n", ")");
    }

    private Seq<Tuple2<K, Set<V>>> integrate(Nonroot<K, V> n2) {
        Tuple2<Vector<Nonroot<K, V>>, Vector<Nonroot<K, V>>> tuple2 = this.subkeys().partition((Function1<Nonroot, boolean> & Serializable)k -> this.sc.isSubclass(k.key(), n2.key()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Vector<Nonroot<K, V>> subsub = tuple2._1();
        Vector<Nonroot<K, V>> sub = tuple2._2();
        Tuple2<Vector<Nonroot<K, V>>, Vector<Nonroot<K, V>>> tuple22 = Tuple2$.MODULE$.apply(subsub, sub);
        Vector<Nonroot<K, V>> subsub2 = tuple22._1();
        Vector<Nonroot<K, V>> sub2 = tuple22._2();
        this.subkeys_$eq((Vector)sub2.$colon$plus(n2));
        n2.subkeys_$eq(subsub2.nonEmpty() ? subsub2 : n2.subkeys());
        n2.subkeys_$eq((Vector)n2.subkeys().$plus$plus((IterableOnce)this.findSubKeysExcept(n2.key(), n2.subkeys()).map((Function1<Object, Nonroot> & Serializable)k -> new Nonroot<Object, V>(this.root(), k, this.values(), this.sc))));
        return (Seq)n2.subkeys().map((Function1<Nonroot, Tuple2> & Serializable)n -> Tuple2$.MODULE$.apply(n.key(), n.values().toSet()));
    }

    private Seq<Tuple2<K, Set<V>>> mergeChangesByKey(Seq<Tuple2<K, Set<V>>> changes) {
        return ((IterableOnceOps)changes.foldLeft(SubclassifiedIndex$.MODULE$.emptyMergeMap(), (Function2<Map, Tuple2, Map> & Serializable)(x$1, x$2) -> {
            Tuple2<Map, Tuple2> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Tuple2 tuple22 = tuple2._2();
                Map m = tuple2._1();
                if (tuple22 != null) {
                    Object k = tuple22._1();
                    Set s2 = (Set)tuple22._2();
                    return (Map)m.updated(k, ((SetOps)m.apply(k)).$plus$plus(s2));
                }
            }
            throw new MatchError(tuple2);
        })).to(IterableFactory$.MODULE$.toFactory(Seq$.MODULE$));
    }

    public static class Nonroot<K, V>
    extends SubclassifiedIndex<K, V> {
        private final SubclassifiedIndex root;
        private final Object key;
        private final Subclassification<K> sc;

        public Nonroot(SubclassifiedIndex<K, V> root, K key2, Set<V> _values, Subclassification<K> sc) {
            this.root = root;
            this.key = key2;
            this.sc = sc;
            super(_values, sc);
        }

        @Override
        public SubclassifiedIndex<K, V> root() {
            return this.root;
        }

        public K key() {
            return (K)this.key;
        }

        @Override
        public Seq<Tuple2<K, Set<V>>> innerAddValue(K key2, V value) {
            if (this.sc.isEqual(key2, this.key())) {
                return this.org$apache$pekko$util$SubclassifiedIndex$Nonroot$$addValue(value);
            }
            return super.innerAddValue(key2, value);
        }

        public Seq<Tuple2<K, Set<V>>> org$apache$pekko$util$SubclassifiedIndex$Nonroot$$addValue(V value) {
            Vector kids = (Vector)this.subkeys().flatMap(arg_0 -> SubclassifiedIndex$.org$apache$pekko$util$SubclassifiedIndex$Nonroot$$_$_$$anonfun$5(value, arg_0));
            if (!this.values().contains(value)) {
                this.values_$eq((Set)this.values().$plus(value));
                return (Seq)kids.$colon$plus(Tuple2$.MODULE$.apply(this.key(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{value}))));
            }
            return kids;
        }

        @Override
        public Seq<Tuple2<K, Set<V>>> innerRemoveValue(K key2, V value) {
            if (this.sc.isEqual(key2, this.key())) {
                return this.removeValue(value);
            }
            return super.innerRemoveValue(key2, value);
        }

        @Override
        public Seq<Tuple2<K, Set<V>>> removeValue(V value) {
            Vector kids = (Vector)this.subkeys().flatMap(arg_0 -> SubclassifiedIndex$.org$apache$pekko$util$SubclassifiedIndex$Nonroot$$_$_$$anonfun$6(value, arg_0));
            if (this.values().contains(value)) {
                this.values_$eq((Set)this.values().$minus(value));
                return (Seq)kids.$colon$plus(Tuple2$.MODULE$.apply(this.key(), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{value}))));
            }
            return kids;
        }

        @Override
        public Set<V> innerFindValues(K key2) {
            if (this.sc.isEqual(key2, this.key())) {
                return this.values();
            }
            return super.innerFindValues(key2);
        }

        @Override
        public String toString() {
            return this.subkeys().mkString(new StringBuilder(12).append("Nonroot(").append(this.key()).append(", ").append(this.values()).append(",\n").toString(), ",\n", ")");
        }
    }
}

