/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.BoxedType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@InternalApi
public final class Reflect$
implements Serializable {
    private static final Option getCallerClass;
    public static final Reflect$ MODULE$;

    private Reflect$() {
    }

    static {
        Option option;
        MODULE$ = new Reflect$();
        try {
            Class<?> c = Class.forName("sun.reflect.Reflection");
            Method m = c.getMethod("getCallerClass", Integer.TYPE);
            option = Some$.MODULE$.apply((Function1<Object, Class> & Serializable)i -> this.$init$$$anonfun$1(m, BoxesRunTime.unboxToInt(i)));
        }
        catch (Throwable throwable) {
            Option<Throwable> option2;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = option2.get();
                option = None$.MODULE$;
            }
            throw throwable;
        }
        getCallerClass = option;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Reflect$.class);
    }

    public Option<Function1<Object, Class<?>>> getCallerClass() {
        return getCallerClass;
    }

    public <T> T instantiate(Class<T> clazz) {
        T t;
        Constructor<T> ctor = clazz.getDeclaredConstructor(new Class[0]);
        try {
            t = ctor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            ctor.setAccessible(true);
            t = ctor.newInstance(new Object[0]);
        }
        return t;
    }

    public <T> T instantiate(Class<T> clazz, Seq<Object> args) {
        return this.instantiate(this.findConstructor(clazz, args), args);
    }

    public <T> T instantiate(Constructor<T> constructor, Seq<Object> args) {
        T t;
        constructor.setAccessible(true);
        try {
            t = constructor.newInstance((Object[])Arrays$.MODULE$.seqToArray(args, Object.class));
        }
        catch (IllegalArgumentException e) {
            String argString = ((IterableOnceOps)args.map((Function1<Object, Class> & Serializable)a -> MODULE$.safeGetClass(a))).mkString("[", ", ", "]");
            throw new IllegalArgumentException(new StringBuilder(44).append("constructor ").append(constructor).append(" is incompatible with arguments ").append(argString).toString(), e);
        }
        return t;
    }

    public <T> Constructor<T> findConstructor(Class<T> clazz, Seq<Object> args) {
        Constructor constructor;
        Constructor constructor2;
        if (args.isEmpty()) {
            constructor2 = (Constructor)Try$.MODULE$.apply(() -> Reflect$.$anonfun$3(clazz)).getOrElse(Reflect$::$anonfun$4);
        } else {
            int length = args.length();
            Object object = Predef$.MODULE$.refArrayOps(clazz.getDeclaredConstructors());
            Iterator candidates = ArrayOps$.MODULE$.iterator$extension(object).filter((Function1<Constructor, boolean> & Serializable)c -> {
                Object object;
                Object[] parameterTypes = c.getParameterTypes();
                return parameterTypes.length == length && ArrayOps$.MODULE$.iterator$extension(object = Predef$.MODULE$.refArrayOps(parameterTypes)).zip(args.iterator()).forall((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        Object required;
                        Class found = (Class)tuple2._1();
                        return found.isInstance(required = tuple2._2()) || BoxedType$.MODULE$.apply(found).isInstance(required) || required == null && !found.isPrimitive();
                    }
                    throw new MatchError(tuple2);
                });
            });
            if (candidates.hasNext()) {
                Constructor cstrtr = (Constructor)candidates.next();
                if (candidates.hasNext()) {
                    throw this.error$1(args, clazz, "multiple matching constructors");
                }
                constructor2 = cstrtr;
            } else {
                constructor2 = constructor = null;
            }
        }
        if (constructor == null) {
            throw this.error$1(args, clazz, "no matching constructor");
        }
        return constructor;
    }

    private Class<?> safeGetClass(Object a) {
        if (a == null) {
            return Object.class;
        }
        return a.getClass();
    }

    public <T> Function0<T> instantiator(Class<T> clazz) {
        return (Function0<Object> & Serializable)() -> MODULE$.instantiate(clazz);
    }

    public Type findMarker(Class<?> root, Class<?> marker) {
        return this.rec$1(marker, root, root);
    }

    public ClassLoader findClassLoader() {
        return (ClassLoader)Option$.MODULE$.apply(Thread.currentThread().getContextClassLoader()).orElse(this::findClassLoader$$anonfun$1).getOrElse(Reflect$::findClassLoader$$anonfun$2);
    }

    private final /* synthetic */ Class $init$$$anonfun$1(Method m$1, int i) {
        return (Class)m$1.invoke(null, BoxesRunTime.boxToInteger(i));
    }

    private final Nothing$ error$1(Seq args$1, Class clazz$1, String msg) {
        String argClasses = ((IterableOnceOps)args$1.map((Function1<Object, Class> & Serializable)a -> MODULE$.safeGetClass(a))).mkString(", ");
        throw new IllegalArgumentException(new StringBuilder(27).append(msg).append(" found on ").append(clazz$1).append(" for arguments [").append(argClasses).append("]").toString());
    }

    private static final Constructor $anonfun$3(Class clazz$2) {
        return clazz$2.getDeclaredConstructor(new Class[0]);
    }

    private static final Constructor $anonfun$4() {
        return null;
    }

    private final Type rec$1(Class marker$1, Class root$1, Class curr) {
        while (true) {
            if (curr.getSuperclass() != null && marker$1.isAssignableFrom(curr.getSuperclass())) {
                curr = curr.getSuperclass();
                continue;
            }
            Object object = Predef$.MODULE$.refArrayOps(curr.getGenericInterfaces());
            Option<Type> option = ArrayOps$.MODULE$.collectFirst$extension(object, new Serializable(marker$1){
                private final Class marker$2;
                {
                    this.marker$2 = marker$3;
                }

                public final boolean isDefinedAt(Type x) {
                    ParameterizedType t;
                    Class c;
                    Type type2 = x;
                    if (type2 instanceof Class && this.marker$2.isAssignableFrom(c = (Class)type2)) {
                        return true;
                    }
                    return type2 instanceof ParameterizedType && this.marker$2.isAssignableFrom((Class)(t = (ParameterizedType)type2).getRawType());
                }

                public final Object applyOrElse(Type x, Function1 function1) {
                    ParameterizedType t;
                    Class c;
                    Type type2 = x;
                    if (type2 instanceof Class && this.marker$2.isAssignableFrom(c = (Class)type2)) {
                        return c;
                    }
                    if (type2 instanceof ParameterizedType && this.marker$2.isAssignableFrom((Class)(t = (ParameterizedType)type2).getRawType())) {
                        return t;
                    }
                    return function1.apply(x);
                }
            });
            if (None$.MODULE$.equals(option)) {
                throw new IllegalArgumentException(new StringBuilder(33).append("cannot find [").append(marker$1).append("] in ancestors of [").append(root$1).append("]").toString());
            }
            if (!(option instanceof Some)) break;
            Type type2 = (Type)((Some)option).value();
            if (type2 instanceof Class) {
                Class c;
                Class clazz = c = (Class)type2;
                Class clazz2 = marker$1;
                if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null)) {
                    return c;
                }
                curr = c;
                continue;
            }
            if (!(type2 instanceof ParameterizedType)) break;
            ParameterizedType t = (ParameterizedType)type2;
            Type type3 = t.getRawType();
            Class clazz = marker$1;
            if (!(type3 != null ? !type3.equals(clazz) : clazz != null)) {
                return t;
            }
            curr = (Class)t.getRawType();
        }
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private final ClassLoader findCaller$1(Function1 get) {
        Class clazz = (Class)package$.MODULE$.Iterator().from(2).map(get).dropWhile((Function1<Class, boolean> & Serializable)c -> c != null && (c.getName().startsWith("org.apache.pekko.actor.ActorSystem") || c.getName().startsWith("scala.Option") || c.getName().startsWith("scala.collection.Iterator") || c.getName().startsWith("org.apache.pekko.util.Reflect"))).next();
        if (clazz == null) {
            return this.getClass().getClassLoader();
        }
        Class c2 = clazz;
        return c2.getClassLoader();
    }

    private final Option findClassLoader$$anonfun$1() {
        return this.getCallerClass().map((Function1<Function1, ClassLoader> & Serializable)get -> this.findCaller$1((Function1)get));
    }

    private static final ClassLoader findClassLoader$$anonfun$2() {
        return MODULE$.getClass().getClassLoader();
    }
}

