/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.japi.Pair;
import org.apache.pekko.japi.Pair$;
import org.apache.pekko.japi.function.Procedure2;
import org.apache.pekko.util.MessageBuffer$;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.AbstractSeq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MessageBuffer {
    private Node _head;
    private Node _tail;
    private int _size;

    public static MessageBuffer empty() {
        return MessageBuffer$.MODULE$.empty();
    }

    public MessageBuffer(Node _head, Node _tail) {
        this._head = _head;
        this._tail = _tail;
        this._size = this._head() == null ? 0 : 1;
    }

    private Node _head() {
        return this._head;
    }

    private void _head_$eq(Node x$0) {
        this._head = x$0;
    }

    private Node _tail() {
        return this._tail;
    }

    private void _tail_$eq(Node x$0) {
        this._tail = x$0;
    }

    public boolean isEmpty() {
        return this._head() == null;
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public int size() {
        return this._size;
    }

    public MessageBuffer append(Object message, ActorRef ref) {
        Node node = new Node(null, message, ref);
        if (this.isEmpty()) {
            this._head_$eq(node);
            this._tail_$eq(node);
        } else {
            this._tail().next_$eq(node);
            this._tail_$eq(node);
        }
        ++this._size;
        return this;
    }

    public void dropHead() {
        if (this.nonEmpty()) {
            this._head_$eq(this._head().next());
            --this._size;
            if (this.isEmpty()) {
                this._tail_$eq(null);
                return;
            }
            return;
        }
    }

    public Tuple2<Object, ActorRef> head() {
        if (this.nonEmpty()) {
            return Tuple2$.MODULE$.apply(this._head().message(), this._head().ref());
        }
        return Tuple2$.MODULE$.apply(null, null);
    }

    public Pair<Object, ActorRef> getHead() {
        if (this.nonEmpty()) {
            return Pair$.MODULE$.create(this._head().message(), this._head().ref());
        }
        return Pair$.MODULE$.create(null, null);
    }

    public void foreach(Function2<Object, ActorRef, BoxedUnit> f) {
        for (Node node = this._head(); node != null; node = node.next()) {
            node.apply(f);
        }
    }

    public void forEach(Procedure2<Object, ActorRef> f) {
        this.foreach((x$1, x$2) -> {
            Tuple2<Object, ActorRef> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Object message = tuple2._1();
                ActorRef ref = tuple2._2();
                f.apply(message, ref);
                return;
            }
            throw new MatchError(tuple2);
        });
    }

    @InternalApi
    public void filterNot(Function2<Object, ActorRef, Object> p) {
        Object result = package$.MODULE$.Vector().empty();
        for (Node node = this._head(); node != null; node = node.next()) {
            if (BoxesRunTime.unboxToBoolean(p.apply(node.message(), node.ref()))) continue;
            result = (Vector)((AbstractSeq)result).$colon$plus(node);
        }
        this._size = ((AbstractSeq)result).size();
        if (this._size == 0) {
            this._head_$eq(null);
            this._tail_$eq(null);
            return;
        }
        if (this._size == 1) {
            this._head_$eq((Node)((Vector)result).head());
            this._tail_$eq((Node)((Vector)result).head());
            this._tail().next_$eq(null);
            return;
        }
        this._head_$eq((Node)((Vector)result).head());
        this._tail_$eq((Node)((Vector)result).last());
        this._tail().next_$eq(null);
        for (int i = 0; i < ((AbstractSeq)result).size(); ++i) {
            Node node = (Node)result.apply(i);
            if (node == this._tail()) continue;
            node.next_$eq((Node)result.apply(i + 1));
        }
    }

    public static final class Node {
        private Node next;
        private final Object message;
        private final ActorRef ref;

        public Node(Node next, Object message, ActorRef ref) {
            this.next = next;
            this.message = message;
            this.ref = ref;
        }

        public Node next() {
            return this.next;
        }

        public void next_$eq(Node x$1) {
            this.next = x$1;
        }

        public Object message() {
            return this.message;
        }

        public ActorRef ref() {
            return this.ref;
        }

        public void apply(Function2<Object, ActorRef, BoxedUnit> f) {
            f.apply(this.message(), this.ref());
        }

        public String toString() {
            return new StringBuilder(7).append("Node(").append(this.message()).append(",").append(this.ref()).append(")").toString();
        }
    }
}

