/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.DataInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import org.apache.pekko.util.LineNumbers;
import org.apache.pekko.util.LineNumbers$NoSourceInfo$;
import org.apache.pekko.util.LineNumbers$SourceFile$;
import org.apache.pekko.util.LineNumbers$SourceFileLines$;
import org.apache.pekko.util.LineNumbers$UnknownSourceFormat$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.math.Ordering$Int$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.util.control.NonFatal$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class LineNumbers$
implements Serializable {
    public static final LineNumbers$NoSourceInfo$ NoSourceInfo;
    public static final LineNumbers$UnknownSourceFormat$ UnknownSourceFormat;
    public static final LineNumbers$SourceFile$ SourceFile;
    public static final LineNumbers$SourceFileLines$ SourceFileLines;
    public static final LineNumbers$ MODULE$;

    private LineNumbers$() {
    }

    static {
        MODULE$ = new LineNumbers$();
        boolean debug = false;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(LineNumbers$.class);
    }

    public LineNumbers.Result apply(Object obj) {
        return this.forObject(obj);
    }

    public LineNumbers.Result for(Object obj) {
        return this.apply(obj);
    }

    public String prettyName(Object obj) {
        LineNumbers.Result result = this.apply(obj);
        if (LineNumbers$NoSourceInfo$.MODULE$.equals(result)) {
            return obj.getClass().getName();
        }
        if (result instanceof LineNumbers.UnknownSourceFormat) {
            String string2;
            LineNumbers.UnknownSourceFormat unknownSourceFormat = LineNumbers$UnknownSourceFormat$.MODULE$.unapply((LineNumbers.UnknownSourceFormat)result);
            String msg = string2 = unknownSourceFormat._1();
            return new StringBuilder(2).append(obj.getClass().getName()).append("(").append(msg).append(")").toString();
        }
        if (result instanceof LineNumbers.SourceFile) {
            String string3;
            LineNumbers.SourceFile sourceFile = LineNumbers$SourceFile$.MODULE$.unapply((LineNumbers.SourceFile)result);
            String f = string3 = sourceFile._1();
            return new StringBuilder(2).append(obj.getClass().getName()).append("(").append(f).append(")").toString();
        }
        if (result instanceof LineNumbers.SourceFileLines) {
            LineNumbers.SourceFileLines l = (LineNumbers.SourceFileLines)result;
            return new StringBuilder(1).append(obj.getClass().getPackage().getName()).append("/").append(l).toString();
        }
        throw new MatchError(result);
    }

    private LineNumbers.Result forObject(Object obj) {
        Tuple2 tuple2;
        Option option = this.getStreamForClass(obj.getClass()).orElse(() -> LineNumbers$.forObject$$anonfun$1(obj));
        if (None$.MODULE$.equals(option)) {
            return LineNumbers$NoSourceInfo$.MODULE$;
        }
        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            InputStream stream = (InputStream)tuple2._1();
            Option filter = (Option)tuple2._2();
            return this.getInfo(stream, filter);
        }
        throw new MatchError(option);
    }

    private LineNumbers.Result getInfo(InputStream stream, Option<String> filter) {
        LineNumbers.Result result;
        DataInputStream dis;
        block19: {
            dis = new DataInputStream(stream);
            try {
                try {
                    this.skipID(dis);
                    this.skipVersion(dis);
                    LineNumbers.Constants constants = this.getConstants(dis);
                    this.skipClassInfo(dis, constants);
                    this.skipInterfaceInfo(dis, constants);
                    this.skipFields(dis, constants);
                    Option<Tuple2<Object, Object>> lines = this.readMethods(dis, filter, constants);
                    Option<String> source = this.readAttributes(dis, constants);
                    if (source.isEmpty()) {
                        result = LineNumbers$NoSourceInfo$.MODULE$;
                    } else {
                        Tuple2 tuple2;
                        Product product;
                        Option<Tuple2<Object, Object>> option = lines;
                        if (None$.MODULE$.equals(option)) {
                            product = LineNumbers$SourceFile$.MODULE$.apply(source.get());
                        } else if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                            int from = tuple2._1$mcI$sp();
                            int to = tuple2._2$mcI$sp();
                            product = LineNumbers$SourceFileLines$.MODULE$.apply(source.get(), from, to);
                        } else {
                            throw new MatchError(option);
                        }
                        result = product;
                    }
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = option.get();
                        result = LineNumbers$UnknownSourceFormat$.MODULE$.apply(new StringBuilder(13).append("parse error: ").append(ex.getMessage()).toString());
                        break block19;
                    }
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                block20: {
                    try {
                        dis.close();
                    }
                    catch (InterruptedException ex) {
                        throw ex;
                    }
                    catch (Throwable throwable4) {
                        Option<Throwable> option;
                        Throwable throwable5 = throwable4;
                        if (throwable5 != null && !(option = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                            Throwable throwable6 = option.get();
                            break block20;
                        }
                        throw throwable4;
                    }
                }
                throw throwable;
            }
        }
        LineNumbers.UnknownSourceFormat unknownSourceFormat = result;
        try {
            dis.close();
        }
        catch (InterruptedException ex) {
            throw ex;
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable7 = throwable;
            if (throwable7 != null && !(option = NonFatal$.MODULE$.unapply(throwable7)).isEmpty()) {
                Throwable throwable8 = option.get();
            }
            throw throwable;
        }
        return unknownSourceFormat;
    }

    private Option<Tuple2<InputStream, None$>> getStreamForClass(Class<?> c) {
        String resource = new StringBuilder(6).append(c.getName().replace('.', '/')).append(".class").toString();
        ClassLoader cl = c.getClassLoader();
        InputStream r = cl.getResourceAsStream(resource);
        return Option$.MODULE$.apply(r).map((Function1<InputStream, Tuple2> & Serializable)_$1 -> {
            InputStream inputStream = Predef$.MODULE$.ArrowAssoc(_$1);
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(inputStream, None$.MODULE$);
        });
    }

    private Option<Tuple2<InputStream, Some<String>>> getStreamForLambda(Object l) {
        Option option;
        try {
            Class<?> c = l.getClass();
            Method writeReplace = c.getDeclaredMethod("writeReplace", new Class[0]);
            writeReplace.setAccessible(true);
            Object object = writeReplace.invoke(l, new Object[0]);
            if (object instanceof SerializedLambda) {
                SerializedLambda serialized = (SerializedLambda)object;
                option = Option$.MODULE$.apply(c.getClassLoader().getResourceAsStream(new StringBuilder(6).append(serialized.getImplClass()).append(".class").toString())).map((Function1<InputStream, Tuple2> & Serializable)_$2 -> {
                    InputStream inputStream = Predef$.MODULE$.ArrowAssoc(_$2);
                    return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(inputStream, Some$.MODULE$.apply(serialized.getImplMethodName()));
                });
            } else {
                option = None$.MODULE$;
            }
        }
        catch (Throwable throwable) {
            Option<Throwable> option2;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable ex = throwable3 = option2.get();
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    private void skipID(DataInputStream d) {
        int magic = d.readInt();
        if (magic != -889275714) {
            throw new IllegalArgumentException("not a Java class file");
        }
    }

    private void skipVersion(DataInputStream d) {
        short minor = d.readShort();
        short major = d.readShort();
    }

    private LineNumbers.Constants getConstants(DataInputStream d) {
        int count = d.readUnsignedShort();
        LineNumbers.Constants c = new LineNumbers.Constants(count);
        while (!c.isDone()) {
            c.readOne(d);
        }
        c.resolve();
        return c;
    }

    private void skipClassInfo(DataInputStream d, LineNumbers.Constants c) {
        this.org$apache$pekko$util$LineNumbers$$$skip(d, 2);
        int name = d.readUnsignedShort();
        this.org$apache$pekko$util$LineNumbers$$$skip(d, 2);
    }

    private void skipInterfaceInfo(DataInputStream d, LineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).foreach(x$1 -> {
            int n = x$1;
            int intf = d.readUnsignedShort();
        });
    }

    private void skipFields(DataInputStream d, LineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).foreach(x$1 -> {
            int n = x$1;
            MODULE$.skipMethodOrField(d, c);
        });
    }

    private void skipMethodOrField(DataInputStream d, LineNumbers.Constants c) {
        this.org$apache$pekko$util$LineNumbers$$$skip(d, 2);
        int name = d.readUnsignedShort();
        this.org$apache$pekko$util$LineNumbers$$$skip(d, 2);
        int attributes = d.readUnsignedShort();
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), attributes).foreach(x$1 -> {
            int n = x$1;
            MODULE$.skipAttribute(d);
        });
    }

    private void skipAttribute(DataInputStream d) {
        this.org$apache$pekko$util$LineNumbers$$$skip(d, 2);
        int length = d.readInt();
        this.org$apache$pekko$util$LineNumbers$$$skip(d, length);
    }

    private Option<Tuple2<Object, Object>> readMethods(DataInputStream d, Option<String> filter, LineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        if (c.contains("Code") && c.contains("LineNumberTable")) {
            Integer n = Predef$.MODULE$.ArrowAssoc(BoxesRunTime.boxToInteger(Integer.MAX_VALUE));
            Tuple2<Integer, Integer> tuple2 = ((IterableOnceOps)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1<Object, Option> & Serializable)_$3 -> LineNumbers$.MODULE$.readMethod(d, c.apply("Code"), c.apply("LineNumberTable"), filter, c)).flatten(Predef$.MODULE$.$conforms())).foldLeft(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n, BoxesRunTime.boxToInteger(0)), (Function2<Tuple2, Tuple2, Tuple2> & Serializable)(x$1, x$2) -> {
                Tuple2<Tuple2, Tuple2> tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = tuple2._1();
                    Tuple2 tuple23 = tuple2._2();
                    if (tuple22 != null) {
                        int low = tuple22._1$mcI$sp();
                        int high = tuple22._2$mcI$sp();
                        if (tuple23 != null) {
                            int start = tuple23._1$mcI$sp();
                            int end = tuple23._2$mcI$sp();
                            return Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(Math.min(low, start)), BoxesRunTime.boxToInteger(Math.max(high, end)));
                        }
                    }
                }
                throw new MatchError(tuple2);
            });
            if (tuple2 != null && Integer.MAX_VALUE == tuple2._1$mcI$sp() && 0 == tuple2._2$mcI$sp()) {
                return None$.MODULE$;
            }
            Tuple2<Integer, Integer> other = tuple2;
            return Some$.MODULE$.apply(other);
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).foreach(x$1 -> {
            int n = x$1;
            MODULE$.skipMethodOrField(d, c);
        });
        return None$.MODULE$;
    }

    private Option<Tuple2<Object, Object>> readMethod(DataInputStream d, int codeTag, int lineNumberTableTag, Option<String> filter, LineNumbers.Constants c) {
        this.org$apache$pekko$util$LineNumbers$$$skip(d, 2);
        int name = d.readUnsignedShort();
        this.org$apache$pekko$util$LineNumbers$$$skip(d, 2);
        Object attributes = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), d.readUnsignedShort()).map((Function1<Object, Option> & Serializable)x$1 -> LineNumbers$.$anonfun$1(d, codeTag, filter, c, name, lineNumberTableTag, BoxesRunTime.unboxToInt(x$1)));
        return ((IndexedSeqOps)attributes.flatten(Predef$.MODULE$.$conforms())).headOption();
    }

    private Option<String> readAttributes(DataInputStream d, LineNumbers.Constants c) {
        int count = d.readUnsignedShort();
        if (c.contains("SourceFile")) {
            int s2 = c.apply("SourceFile");
            Object attributes = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), count).map((Function1<Object, Option> & Serializable)x$1 -> LineNumbers$.$anonfun$4(d, s2, c, BoxesRunTime.unboxToInt(x$1)));
            return ((IndexedSeqOps)attributes.flatten(Predef$.MODULE$.$conforms())).headOption();
        }
        return None$.MODULE$;
    }

    public void org$apache$pekko$util$LineNumbers$$$skip(DataInputStream d, int length) {
        if (d.skipBytes(length) != length) {
            throw new IllegalArgumentException("class file ends prematurely");
        }
    }

    private static final Option forObject$$anonfun$1(Object obj$1) {
        return MODULE$.getStreamForLambda(obj$1);
    }

    private static final /* synthetic */ Option $anonfun$2(DataInputStream d$7, int lineNumberTableTag$2, int x$12) {
        int n = x$12;
        int tag = d$7.readUnsignedShort();
        int length = d$7.readInt();
        if (tag != lineNumberTableTag$2) {
            MODULE$.org$apache$pekko$util$LineNumbers$$$skip(d$7, length);
            return None$.MODULE$;
        }
        Object lines = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), d$7.readUnsignedShort()).map(x$1 -> {
            int n = x$1;
            MODULE$.org$apache$pekko$util$LineNumbers$$$skip(d$7, 2);
            return d$7.readUnsignedShort();
        });
        Integer n2 = (Integer)Predef$.MODULE$.ArrowAssoc(lines.min(Ordering$Int$.MODULE$));
        return Some$.MODULE$.apply(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(n2, lines.max(Ordering$Int$.MODULE$)));
    }

    private static final /* synthetic */ Option $anonfun$1(DataInputStream d$6, int codeTag$1, Option filter$2, LineNumbers.Constants c$4, int name$1, int lineNumberTableTag$1, int x$12) {
        block3: {
            int length;
            block2: {
                int n = x$12;
                int tag = d$6.readUnsignedShort();
                length = d$6.readInt();
                if (tag != codeTag$1) break block2;
                if (!filter$2.isDefined()) break block3;
                String string2 = c$4.apply(name$1);
                Object a = filter$2.get();
                if (!(string2 == null ? a != null : !string2.equals(a))) break block3;
            }
            MODULE$.org$apache$pekko$util$LineNumbers$$$skip(d$6, length);
            return None$.MODULE$;
        }
        MODULE$.org$apache$pekko$util$LineNumbers$$$skip(d$6, 4);
        MODULE$.org$apache$pekko$util$LineNumbers$$$skip(d$6, d$6.readInt());
        MODULE$.org$apache$pekko$util$LineNumbers$$$skip(d$6, 8 * d$6.readUnsignedShort());
        Object possibleLines = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), d$6.readUnsignedShort()).map((Function1<Object, Option> & Serializable)x$1 -> LineNumbers$.$anonfun$2(d$6, lineNumberTableTag$1, BoxesRunTime.unboxToInt(x$1)));
        return ((IndexedSeqOps)possibleLines.flatten(Predef$.MODULE$.$conforms())).headOption();
    }

    private static final /* synthetic */ Option $anonfun$4(DataInputStream d$9, int s$1, LineNumbers.Constants c$5, int x$1) {
        int n = x$1;
        int tag = d$9.readUnsignedShort();
        int length = d$9.readInt();
        if (tag != s$1) {
            MODULE$.org$apache$pekko$util$LineNumbers$$$skip(d$9, length);
            return None$.MODULE$;
        }
        int name = d$9.readUnsignedShort();
        return Some$.MODULE$.apply(c$5.apply(name));
    }
}

