/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.ImmutableIntMap$;
import scala.Function0;
import scala.Function1;
import scala.collection.Iterator;
import scala.package$;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class ImmutableIntMap {
    private final int[] kvs;
    private final int size;

    public static ImmutableIntMap empty() {
        return ImmutableIntMap$.MODULE$.empty();
    }

    public ImmutableIntMap(int[] kvs, int size) {
        this.kvs = kvs;
        this.size = size;
    }

    private final int[] kvs() {
        return this.kvs;
    }

    public final int size() {
        return this.size;
    }

    private ImmutableIntMap(int key2, int value) {
        this(new int[2], 1);
        this.kvs()[0] = key2;
        this.kvs()[1] = value;
    }

    private final int indexForKey(int key2) {
        return this.find$1(key2, 0, this.size() - 1);
    }

    public final int get(int key2) {
        return this.find$2(key2, 0, this.size() - 1);
    }

    public final boolean contains(int key2) {
        return this.indexForKey(key2) >= 0;
    }

    public final ImmutableIntMap updateIfAbsent(int key2, Function0<Object> value) {
        if (this.size() > 0) {
            int i = this.indexForKey(key2);
            if (i >= 0) {
                return this;
            }
            return this.insert(key2, value.apply$mcI$sp(), i);
        }
        return new ImmutableIntMap(key2, value.apply$mcI$sp());
    }

    public final ImmutableIntMap updated(int key2, int value) {
        if (this.size() > 0) {
            int i = this.indexForKey(key2);
            if (i >= 0) {
                int valueIndex = i + 1;
                if (this.kvs()[valueIndex] != value) {
                    return this.update(value, valueIndex);
                }
                return this;
            }
            return this.insert(key2, value, i);
        }
        return new ImmutableIntMap(key2, value);
    }

    private final ImmutableIntMap update(int value, int valueIndex) {
        int[] newKvs = (int[])this.kvs().clone();
        newKvs[valueIndex] = value;
        return new ImmutableIntMap(newKvs, this.size());
    }

    private final ImmutableIntMap insert(int key2, int value, int index) {
        int at = ~index;
        int[] newKvs = new int[this.kvs().length + 2];
        System.arraycopy(this.kvs(), 0, newKvs, 0, at);
        newKvs[at] = key2;
        newKvs[at + 1] = value;
        System.arraycopy(this.kvs(), at, newKvs, at + 2, this.kvs().length - at);
        return new ImmutableIntMap(newKvs, this.size() + 1);
    }

    public final ImmutableIntMap remove(int key2) {
        int i = this.indexForKey(key2);
        if (i >= 0) {
            if (this.size() > 1) {
                int newSz = this.kvs().length - 2;
                int[] newKvs = new int[newSz];
                System.arraycopy(this.kvs(), 0, newKvs, 0, i);
                System.arraycopy(this.kvs(), i + 2, newKvs, i, newSz - i);
                return new ImmutableIntMap(newKvs, this.size() - 1);
            }
            return ImmutableIntMap$.MODULE$.empty();
        }
        return this;
    }

    public final Iterator<Object> keysIterator() {
        if (this.size() < 1) {
            return package$.MODULE$.Iterator().empty();
        }
        return package$.MODULE$.Iterator().range(0, this.kvs().length - 1, 2).map(i -> this.kvs()[i]);
    }

    public final String toString() {
        if (this.size() < 1) {
            return "ImmutableIntMap()";
        }
        return package$.MODULE$.Iterator().range(0, this.kvs().length - 1, 2).map((Function1<Object, String> & Serializable)i -> this.toString$$anonfun$1(BoxesRunTime.unboxToInt(i))).mkString("ImmutableIntMap(", ", ", ")");
    }

    public final int hashCode() {
        return Arrays.hashCode(this.kvs());
    }

    public final boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof ImmutableIntMap) {
            ImmutableIntMap other = (ImmutableIntMap)object;
            return Arrays.equals(this.kvs(), other.kvs());
        }
        return false;
    }

    private final int find$1(int key$1, int lo, int hi) {
        while (lo <= hi) {
            int lohi = lo + hi;
            int idx = lohi & 0xFFFFFFFE;
            int k = this.kvs()[idx];
            if (k == key$1) {
                return idx;
            }
            if (k < key$1) {
                lo = (lohi >>> 1) + 1;
                continue;
            }
            hi = (lohi >>> 1) - 1;
        }
        return ~(lo << 1);
    }

    private final int find$2(int key$2, int lo, int hi) {
        while (lo <= hi) {
            int lohi = lo + hi;
            int k = this.kvs()[lohi & 0xFFFFFFFE];
            if (k == key$2) {
                return this.kvs()[lohi | 1];
            }
            if (k < key$2) {
                lo = (lohi >>> 1) + 1;
                continue;
            }
            hi = (lohi >>> 1) - 1;
        }
        return Integer.MIN_VALUE;
    }

    private final /* synthetic */ String toString$$anonfun$1(int i) {
        return new StringBuilder(4).append(this.kvs()[i]).append(" -> ").append(this.kvs()[i + 1]).toString();
    }
}

