/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import scala.Byte$;
import scala.Predef$;
import scala.Short$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;

public final class HashCode$
implements Serializable {
    private static final int SEED;
    private static final int PRIME;
    public static final HashCode$ MODULE$;

    private HashCode$() {
    }

    static {
        MODULE$ = new HashCode$();
        SEED = 23;
        PRIME = 37;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(HashCode$.class);
    }

    public int SEED() {
        return SEED;
    }

    public int hash(int seed, Object any2) {
        Object object = any2;
        if (object instanceof Boolean) {
            boolean value = BoxesRunTime.unboxToBoolean(object);
            return this.hash(seed, value);
        }
        if (object instanceof Character) {
            char value = BoxesRunTime.unboxToChar(object);
            return this.hash(seed, value);
        }
        if (object instanceof Short) {
            short value = BoxesRunTime.unboxToShort(object);
            return this.hash(seed, Short$.MODULE$.short2int(value));
        }
        if (object instanceof Integer) {
            int value = BoxesRunTime.unboxToInt(object);
            return this.hash(seed, value);
        }
        if (object instanceof Long) {
            long value = BoxesRunTime.unboxToLong(object);
            return this.hash(seed, value);
        }
        if (object instanceof Float) {
            float value = BoxesRunTime.unboxToFloat(object);
            return this.hash(seed, value);
        }
        if (object instanceof Double) {
            double value = BoxesRunTime.unboxToDouble(object);
            return this.hash(seed, value);
        }
        if (object instanceof Byte) {
            byte value = BoxesRunTime.unboxToByte(object);
            return this.hash(seed, Byte$.MODULE$.byte2int(value));
        }
        if (object instanceof Object) {
            Object value = object;
            IntRef result = IntRef.create(seed);
            if (value == null) {
                result.elem = this.hash(result.elem, 0);
            } else if (!this.isArray(value)) {
                result.elem = this.hash(result.elem, value.hashCode());
            } else {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), Array.getLength(value)).foreach(id -> {
                    result$1.elem = MODULE$.hash(result$1.elem, Array.get(value, id));
                });
            }
            return result.elem;
        }
        Object unexpected = object;
        throw new IllegalArgumentException(new StringBuilder(27).append("Unexpected hash parameter: ").append(unexpected).toString());
    }

    public int hash(int seed, boolean value) {
        return this.firstTerm(seed) + (value ? 1 : 0);
    }

    public int hash(int seed, char value) {
        return this.firstTerm(seed) + value;
    }

    public int hash(int seed, int value) {
        return this.firstTerm(seed) + value;
    }

    public int hash(int seed, long value) {
        return this.firstTerm(seed) + (int)(value ^ value >>> 32);
    }

    public int hash(int seed, float value) {
        return this.hash(seed, Float.floatToIntBits(value));
    }

    public int hash(int seed, double value) {
        return this.hash(seed, Double.doubleToLongBits(value));
    }

    private int firstTerm(int seed) {
        return PRIME * seed;
    }

    private boolean isArray(Object anyRef) {
        return anyRef.getClass().isArray();
    }
}

