/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.DoubleLinkedList;
import org.apache.pekko.util.FrequencyList$;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.apache.pekko.util.RecencyList;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class FrequencyList<A> {
    private final boolean dynamicAging;
    private final RecencyList.Clock clock;
    private final DoubleLinkedList<FrequencyNode<A>> frequency;
    private final DoubleLinkedList<Node<A>> overallRecency;
    private final Map<A, Node<A>> lookupNode;
    private long age;

    public static <A> FrequencyList<A> empty(boolean bl) {
        return FrequencyList$.MODULE$.empty(bl);
    }

    public static <A> boolean empty$default$1() {
        return FrequencyList$.MODULE$.empty$default$1();
    }

    public FrequencyList(boolean dynamicAging, RecencyList.Clock clock) {
        this.dynamicAging = dynamicAging;
        this.clock = clock;
        this.frequency = new DoubleLinkedList((Function1<FrequencyNode, Object> & Serializable)_$3 -> new OptionVal<FrequencyNode>(_$3.lessFrequent()), (Function1<FrequencyNode, Object> & Serializable)_$4 -> new OptionVal<FrequencyNode>(_$4.moreFrequent()), (Function2<Object, Object, Object> & Serializable)(v1, v2) -> {
            ((FrequencyNode)v1).lessFrequent_$eq(v2 == null ? null : ((OptionVal)v2).x());
            return BoxedUnit.UNIT;
        }, (Function2<Object, Object, Object> & Serializable)(v1, v2) -> {
            ((FrequencyNode)v1).moreFrequent_$eq(v2 == null ? null : ((OptionVal)v2).x());
            return BoxedUnit.UNIT;
        });
        this.overallRecency = new DoubleLinkedList((Function1<Node, Object> & Serializable)_$5 -> new OptionVal<Node>(_$5.overallLessRecent()), (Function1<Node, Object> & Serializable)_$6 -> new OptionVal<Node>(_$6.overallMoreRecent()), (Function2<Object, Object, Object> & Serializable)(v1, v2) -> {
            ((Node)v1).overallLessRecent_$eq(v2 == null ? null : ((OptionVal)v2).x());
            return BoxedUnit.UNIT;
        }, (Function2<Object, Object, Object> & Serializable)(v1, v2) -> {
            ((Node)v1).overallMoreRecent_$eq(v2 == null ? null : ((OptionVal)v2).x());
            return BoxedUnit.UNIT;
        });
        this.lookupNode = (Map)Map$.MODULE$.empty();
        this.age = 0L;
    }

    public int size() {
        return this.lookupNode.size();
    }

    public FrequencyList<A> update(A value) {
        if (this.lookupNode.contains(value)) {
            Node node = (Node)this.lookupNode.apply(value);
            this.increaseFrequency(node);
            if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
                node.timestamp_$eq(((RecencyList.Clock)OptionVal$.MODULE$.get$extension(this.clock)).currentTime());
                this.overallRecency.moveToBack(node);
            }
        } else {
            Node<A> node = this.addInitialFrequency(value);
            A a = Predef$.MODULE$.ArrowAssoc(value);
            this.lookupNode.$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(a, node));
            if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
                node.timestamp_$eq(((RecencyList.Clock)OptionVal$.MODULE$.get$extension(this.clock)).currentTime());
                this.overallRecency.append(node);
            }
        }
        return this;
    }

    public FrequencyList<A> remove(A value) {
        if (this.lookupNode.contains(value)) {
            this.removeNode((Node)this.lookupNode.apply(value));
        }
        return this;
    }

    public boolean contains(A value) {
        return this.lookupNode.contains(value);
    }

    public Object leastFrequent() {
        FrequencyNode frequencyNode = (FrequencyNode)this.frequency.getFirst();
        FrequencyNode frequencyNode2 = (FrequencyNode)OptionVal$Some$.MODULE$.unapply(frequencyNode);
        if (!OptionVal$.MODULE$.isEmpty$extension(frequencyNode2)) {
            FrequencyNode frequencyNode3 = (FrequencyNode)OptionVal$.MODULE$.get$extension(frequencyNode2);
            FrequencyNode least = frequencyNode3;
            Node node = (Node)least.nodes().getFirst();
            Node node2 = (Node)OptionVal$Some$.MODULE$.unapply(node);
            if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
                Node node3;
                Node first = node3 = (Node)OptionVal$.MODULE$.get$extension(node2);
                return OptionVal$Some$.MODULE$.apply(first.value());
            }
            return OptionVal$.MODULE$.none();
        }
        return OptionVal$.MODULE$.none();
    }

    public Object mostFrequent() {
        FrequencyNode frequencyNode = (FrequencyNode)this.frequency.getLast();
        FrequencyNode frequencyNode2 = (FrequencyNode)OptionVal$Some$.MODULE$.unapply(frequencyNode);
        if (!OptionVal$.MODULE$.isEmpty$extension(frequencyNode2)) {
            FrequencyNode frequencyNode3 = (FrequencyNode)OptionVal$.MODULE$.get$extension(frequencyNode2);
            FrequencyNode most = frequencyNode3;
            Node node = (Node)most.nodes().getLast();
            Node node2 = (Node)OptionVal$Some$.MODULE$.unapply(node);
            if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
                Node node3;
                Node last = node3 = (Node)OptionVal$.MODULE$.get$extension(node2);
                return OptionVal$Some$.MODULE$.apply(last.value());
            }
            return OptionVal$.MODULE$.none();
        }
        return OptionVal$.MODULE$.none();
    }

    public Iterator<A> leastToMostFrequent() {
        return this.forwardIterator().map((Function1<Node, Object> & Serializable)_$7 -> _$7.value());
    }

    public Iterator<A> mostToLeastFrequent() {
        return this.backwardIterator().map((Function1<Node, Object> & Serializable)_$8 -> _$8.value());
    }

    public Seq<A> removeLeastFrequent(int n) {
        if (n == 1) {
            return this.removeLeastFrequent();
        }
        return this.forwardIterator().take(n).map((Function1<Node, Object> & Serializable)node -> this.removeLeastFrequentNode((Node<A>)node)).toList();
    }

    public Seq<A> removeLeastFrequent(int n, Object skip) {
        return this.forwardIterator().filterNot((Function1<Node, boolean> & Serializable)node -> OptionVal$.MODULE$.contains$extension(skip, node.value())).take(n).map((Function1<Node, Object> & Serializable)node -> this.removeLeastFrequentNode((Node<A>)node)).toList();
    }

    public int removeLeastFrequent$default$1() {
        return 1;
    }

    public Seq<A> removeLeastFrequent() {
        FrequencyNode frequencyNode = (FrequencyNode)this.frequency.getFirst();
        FrequencyNode frequencyNode2 = (FrequencyNode)OptionVal$Some$.MODULE$.unapply(frequencyNode);
        if (!OptionVal$.MODULE$.isEmpty$extension(frequencyNode2)) {
            FrequencyNode frequencyNode3 = (FrequencyNode)OptionVal$.MODULE$.get$extension(frequencyNode2);
            FrequencyNode least = frequencyNode3;
            Node node = (Node)least.nodes().getFirst();
            Node node2 = (Node)OptionVal$Some$.MODULE$.unapply(node);
            if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
                Node node3;
                Node first = node3 = (Node)OptionVal$.MODULE$.get$extension(node2);
                return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.removeLeastFrequentNode(first)}));
            }
            return package$.MODULE$.Nil();
        }
        return package$.MODULE$.Nil();
    }

    public Seq<A> removeMostFrequent(int n) {
        if (n == 1) {
            return this.removeMostFrequent();
        }
        return this.backwardIterator().take(n).map((Function1<Node, Object> & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public Seq<A> removeMostFrequent(int n, Object skip) {
        return this.backwardIterator().filterNot((Function1<Node, boolean> & Serializable)node -> OptionVal$.MODULE$.contains$extension(skip, node.value())).take(n).map((Function1<Node, Object> & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public int removeMostFrequent$default$1() {
        return 1;
    }

    public Seq<A> removeMostFrequent() {
        FrequencyNode frequencyNode = (FrequencyNode)this.frequency.getLast();
        FrequencyNode frequencyNode2 = (FrequencyNode)OptionVal$Some$.MODULE$.unapply(frequencyNode);
        if (!OptionVal$.MODULE$.isEmpty$extension(frequencyNode2)) {
            FrequencyNode frequencyNode3 = (FrequencyNode)OptionVal$.MODULE$.get$extension(frequencyNode2);
            FrequencyNode most = frequencyNode3;
            Node node = (Node)most.nodes().getLast();
            Node node2 = (Node)OptionVal$Some$.MODULE$.unapply(node);
            if (!OptionVal$.MODULE$.isEmpty$extension(node2)) {
                Node node3;
                Node last = node3 = (Node)OptionVal$.MODULE$.get$extension(node2);
                return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{this.removeNode(last)}));
            }
            return package$.MODULE$.Nil();
        }
        return package$.MODULE$.Nil();
    }

    public Iterator<A> overallLeastToMostRecent() {
        return this.overallRecency.forwardIterator().map((Function1<Node, Object> & Serializable)_$9 -> _$9.value());
    }

    public Iterator<A> overallMostToLeastRecent() {
        return this.overallRecency.backwardIterator().map((Function1<Node, Object> & Serializable)_$10 -> _$10.value());
    }

    public Seq<A> removeOverallLeastRecent(int n) {
        if (OptionVal$.MODULE$.isEmpty$extension(this.clock)) {
            throw new UnsupportedOperationException("Overall recency is not enabled for this FrequencyList");
        }
        return this.overallRecency.forwardIterator().take(n).map((Function1<Node, Object> & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public int removeOverallLeastRecent$default$1() {
        return 1;
    }

    public Seq<A> removeOverallMostRecent(int n) {
        if (OptionVal$.MODULE$.isEmpty$extension(this.clock)) {
            throw new UnsupportedOperationException("Overall recency is not enabled for this FrequencyList");
        }
        return this.overallRecency.backwardIterator().take(n).map((Function1<Node, Object> & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public int removeOverallMostRecent$default$1() {
        return 1;
    }

    public Seq<A> removeOverallLeastRecentOutside(FiniteDuration duration) {
        if (OptionVal$.MODULE$.isEmpty$extension(this.clock)) {
            throw new UnsupportedOperationException("Overall recency is not enabled for this FrequencyList");
        }
        long min2 = ((RecencyList.Clock)OptionVal$.MODULE$.get$extension(this.clock)).earlierTime(duration);
        return this.overallRecency.forwardIterator().takeWhile((Function1<Node, boolean> & Serializable)_$11 -> _$11.timestamp() < min2).map((Function1<Node, Object> & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    public Seq<A> removeOverallMostRecentWithin(FiniteDuration duration) {
        if (OptionVal$.MODULE$.isEmpty$extension(this.clock)) {
            throw new UnsupportedOperationException("Overall recency is not enabled for this FrequencyList");
        }
        long max2 = ((RecencyList.Clock)OptionVal$.MODULE$.get$extension(this.clock)).earlierTime(duration);
        return this.overallRecency.backwardIterator().takeWhile((Function1<Node, boolean> & Serializable)_$12 -> _$12.timestamp() > max2).map((Function1<Node, Object> & Serializable)node -> this.removeNode((Node<A>)node)).toList();
    }

    private Node<A> addInitialFrequency(A value) {
        if (this.dynamicAging) {
            return this.addInitialAdjustedFrequency(value);
        }
        return this.addAsLeastFrequent(value);
    }

    private Node<A> addAsLeastFrequent(A value) {
        FrequencyNode<A> one = this.frequency.getFirstOrElsePrepend((Function1<FrequencyNode, boolean> & Serializable)_$13 -> _$13.priority() == 1L, FrequencyList::$anonfun$2);
        Node<A> node = new Node<A>(value, one);
        this.addToFrequency(node, one);
        return node;
    }

    private Node<A> addInitialAdjustedFrequency(A value) {
        FrequencyNode frequencyNode;
        FrequencyNode first;
        long priority = 1L + this.age;
        FrequencyNode frequencyNode2 = (FrequencyNode)this.frequency.getFirst();
        FrequencyNode frequencyNode3 = (FrequencyNode)OptionVal$Some$.MODULE$.unapply(frequencyNode2);
        FrequencyNode frequencyNode4 = !OptionVal$.MODULE$.isEmpty$extension(frequencyNode3) && (first = (frequencyNode = (FrequencyNode)OptionVal$.MODULE$.get$extension(frequencyNode3))).priority() < priority ? this.frequency.findNextOrElseInsert(first, (Function1<FrequencyNode, boolean> & Serializable)_$14 -> _$14.priority() < priority, (Function1<FrequencyNode, boolean> & Serializable)_$15 -> _$15.priority() == priority, () -> FrequencyList.$anonfun$5(priority)) : this.frequency.getFirstOrElsePrepend((Function1<FrequencyNode, boolean> & Serializable)_$16 -> _$16.priority() == priority, () -> FrequencyList.$anonfun$7(priority));
        Node<A> node = new Node<A>(value, frequencyNode4);
        this.addToFrequency(node, frequencyNode4);
        return node;
    }

    private void increaseFrequency(Node<A> node) {
        if (this.dynamicAging) {
            this.increaseAdjustedFrequency(node);
            return;
        }
        this.increaseToNextFrequency(node);
    }

    private void increaseAdjustedFrequency(Node<A> node) {
        node.accesses_$eq(node.accesses() + 1L);
        long priority = node.accesses() + this.age;
        FrequencyNode<A> frequencyNode = this.frequency.findNextOrElseInsert(node.frequency(), (Function1<FrequencyNode, boolean> & Serializable)_$17 -> _$17.priority() < priority, (Function1<FrequencyNode, boolean> & Serializable)_$18 -> _$18.priority() == priority, () -> FrequencyList.$anonfun$10(priority));
        this.removeFromFrequency(node);
        this.addToFrequency(node, frequencyNode);
    }

    private void increaseToNextFrequency(Node<A> node) {
        node.accesses_$eq(node.accesses() + 1L);
        long priority = node.accesses();
        FrequencyNode<A> frequencyNode = this.frequency.getNextOrElseInsert(node.frequency(), (Function1<FrequencyNode, boolean> & Serializable)_$19 -> _$19.priority() == priority, () -> FrequencyList.$anonfun$12(priority));
        this.removeFromFrequency(node);
        this.addToFrequency(node, frequencyNode);
    }

    private void addToFrequency(Node<A> node, FrequencyNode<A> frequencyNode) {
        node.frequency_$eq(frequencyNode);
        frequencyNode.nodes().append(node);
    }

    private void removeFromFrequency(Node<A> node) {
        FrequencyNode<A> frequencyNode = node.frequency();
        frequencyNode.nodes().remove(node);
        if (frequencyNode.nodes().isEmpty()) {
            this.frequency.remove(frequencyNode);
            return;
        }
    }

    private A removeNode(Node<A> node) {
        A value = node.value();
        this.removeFromFrequency(node);
        if (OptionVal$.MODULE$.isDefined$extension(this.clock)) {
            this.overallRecency.remove(node);
        }
        this.lookupNode.$minus$eq(value);
        return value;
    }

    private A removeLeastFrequentNode(Node<A> node) {
        if (this.dynamicAging) {
            this.age = node.frequency().priority();
        }
        return this.removeNode(node);
    }

    private Iterator<Node<A>> forwardIterator() {
        return this.frequency.forwardIterator().flatMap((Function1<FrequencyNode, IterableOnce> & Serializable)_$20 -> _$20.nodes().forwardIterator());
    }

    private Iterator<Node<A>> backwardIterator() {
        return this.frequency.backwardIterator().flatMap((Function1<FrequencyNode, IterableOnce> & Serializable)_$21 -> _$21.nodes().backwardIterator());
    }

    private static final FrequencyNode $anonfun$2() {
        return new FrequencyNode(1L);
    }

    private static final FrequencyNode $anonfun$5(long priority$3) {
        return new FrequencyNode(priority$3);
    }

    private static final FrequencyNode $anonfun$7(long priority$5) {
        return new FrequencyNode(priority$5);
    }

    private static final FrequencyNode $anonfun$10(long priority$8) {
        return new FrequencyNode(priority$8);
    }

    private static final FrequencyNode $anonfun$12(long priority$10) {
        return new FrequencyNode(priority$10);
    }

    public static final class FrequencyNode<A> {
        private final long priority;
        private FrequencyNode lessFrequent;
        private FrequencyNode moreFrequent;
        private final DoubleLinkedList nodes;

        public FrequencyNode(long priority) {
            this.priority = priority;
            OptionVal$.MODULE$.None();
            this.lessFrequent = null;
            OptionVal$.MODULE$.None();
            this.moreFrequent = null;
            this.nodes = new DoubleLinkedList((Function1<Node, Object> & Serializable)_$1 -> new OptionVal<Node>(this.$init$$$anonfun$9((Node)_$1)), (Function1<Node, Object> & Serializable)_$2 -> new OptionVal<Node>(this.$init$$$anonfun$10((Node)_$2)), (Function2<Object, Object, Object> & Serializable)(v1, v2) -> {
                this.$init$$$anonfun$11((Node)v1, v2 == null ? null : ((OptionVal)v2).x());
                return BoxedUnit.UNIT;
            }, (Function2<Object, Object, Object> & Serializable)(v1, v2) -> {
                this.$init$$$anonfun$12((Node)v1, v2 == null ? null : ((OptionVal)v2).x());
                return BoxedUnit.UNIT;
            });
        }

        public long priority() {
            return this.priority;
        }

        public FrequencyNode lessFrequent() {
            return this.lessFrequent;
        }

        public void lessFrequent_$eq(FrequencyNode x$1) {
            this.lessFrequent = x$1;
        }

        public FrequencyNode moreFrequent() {
            return this.moreFrequent;
        }

        public void moreFrequent_$eq(FrequencyNode x$1) {
            this.moreFrequent = x$1;
        }

        public DoubleLinkedList<Node<A>> nodes() {
            return this.nodes;
        }

        private final /* synthetic */ Node $init$$$anonfun$9(Node _$1) {
            return _$1.lessRecent();
        }

        private final /* synthetic */ Node $init$$$anonfun$10(Node _$2) {
            return _$2.moreRecent();
        }

        private final /* synthetic */ void $init$$$anonfun$11(Node node, Node previous) {
            node.lessRecent_$eq(previous);
        }

        private final /* synthetic */ void $init$$$anonfun$12(Node node, Node next) {
            node.moreRecent_$eq(next);
        }
    }

    public static final class Node<A> {
        private final Object value;
        private long accesses;
        private FrequencyNode frequency;
        private Node lessRecent;
        private Node moreRecent;
        private Node overallLessRecent;
        private Node overallMoreRecent;
        private long timestamp;

        public Node(A value, FrequencyNode<A> initialFrequency) {
            this.value = value;
            this.accesses = 1L;
            this.frequency = initialFrequency;
            OptionVal$.MODULE$.None();
            this.lessRecent = null;
            OptionVal$.MODULE$.None();
            this.moreRecent = null;
            OptionVal$.MODULE$.None();
            this.overallLessRecent = null;
            OptionVal$.MODULE$.None();
            this.overallMoreRecent = null;
            this.timestamp = 0L;
        }

        public A value() {
            return (A)this.value;
        }

        public long accesses() {
            return this.accesses;
        }

        public void accesses_$eq(long x$1) {
            this.accesses = x$1;
        }

        public FrequencyNode<A> frequency() {
            return this.frequency;
        }

        public void frequency_$eq(FrequencyNode<A> x$1) {
            this.frequency = x$1;
        }

        public Node lessRecent() {
            return this.lessRecent;
        }

        public void lessRecent_$eq(Node x$1) {
            this.lessRecent = x$1;
        }

        public Node moreRecent() {
            return this.moreRecent;
        }

        public void moreRecent_$eq(Node x$1) {
            this.moreRecent = x$1;
        }

        public Node overallLessRecent() {
            return this.overallLessRecent;
        }

        public void overallLessRecent_$eq(Node x$1) {
            this.overallLessRecent = x$1;
        }

        public Node overallMoreRecent() {
            return this.overallMoreRecent;
        }

        public void overallMoreRecent_$eq(Node x$1) {
            this.overallMoreRecent = x$1;
        }

        public long timestamp() {
            return this.timestamp;
        }

        public void timestamp_$eq(long x$1) {
            this.timestamp = x$1;
        }
    }
}

