/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.util;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.util.OptionVal;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InternalApi
public final class DoubleLinkedList<Node> {
    private final Function1<Node, OptionVal<Node>> getPrevious;
    private final Function1<Node, OptionVal<Node>> getNext;
    private final Function2<Node, OptionVal<Node>, BoxedUnit> setPrevious;
    private final Function2<Node, OptionVal<Node>, BoxedUnit> setNext;
    private Object first;
    private Object last;

    public DoubleLinkedList(Function1<Node, OptionVal<Node>> getPrevious, Function1<Node, OptionVal<Node>> getNext, Function2<Node, OptionVal<Node>, BoxedUnit> setPrevious, Function2<Node, OptionVal<Node>, BoxedUnit> setNext) {
        this.getPrevious = getPrevious;
        this.getNext = getNext;
        this.setPrevious = setPrevious;
        this.setNext = setNext;
        this.first = OptionVal$.MODULE$.none();
        this.last = OptionVal$.MODULE$.none();
    }

    public boolean isEmpty() {
        Object object = this.first;
        return OptionVal$.MODULE$.isEmpty$extension(object);
    }

    public Object getFirst() {
        return this.first;
    }

    public Object getLast() {
        return this.last;
    }

    public Node prepend(Node node) {
        return this.insertBefore(node, this.first);
    }

    public Node append(Node node) {
        return this.insertAfter(this.last, node);
    }

    public void remove(Node node) {
        this.unlink(node);
        this.setNext.apply(node, new OptionVal<Object>(OptionVal$.MODULE$.none()));
        this.setPrevious.apply(node, new OptionVal<Object>(OptionVal$.MODULE$.none()));
    }

    public Node moveToFront(Node node) {
        Object object = this.first;
        if (OptionVal$.MODULE$.contains$extension(object, node)) {
            return node;
        }
        this.unlink(node);
        return this.prepend(node);
    }

    public Node moveToBack(Node node) {
        Object object = this.last;
        if (OptionVal$.MODULE$.contains$extension(object, node)) {
            return node;
        }
        this.unlink(node);
        return this.append(node);
    }

    public Node getFirstOrElsePrepend(Function1<Node, Object> check, Function0<Node> newNode) {
        Object a;
        Object first;
        Object object = this.first;
        Object object2 = OptionVal$Some$.MODULE$.unapply(object);
        if (!OptionVal$.MODULE$.isEmpty$extension(object2) && BoxesRunTime.unboxToBoolean(check.apply(first = (a = OptionVal$.MODULE$.get$extension(object2))))) {
            return (Node)first;
        }
        return this.prepend(newNode.apply());
    }

    public Node getLastOrElseAppend(Function1<Node, Object> check, Function0<Node> newNode) {
        Object a;
        Object last;
        Object object = this.last;
        Object object2 = OptionVal$Some$.MODULE$.unapply(object);
        if (!OptionVal$.MODULE$.isEmpty$extension(object2) && BoxesRunTime.unboxToBoolean(check.apply(last = (a = OptionVal$.MODULE$.get$extension(object2))))) {
            return (Node)last;
        }
        return this.append(newNode.apply());
    }

    public Node getNextOrElseInsert(Node node, Function1<Node, Object> check, Function0<Node> newNode) {
        Object a;
        Object next;
        OptionVal<Node> optionVal = this.getNext.apply(node);
        Object var4_5 = optionVal == null ? null : optionVal.x();
        Object object = OptionVal$Some$.MODULE$.unapply(var4_5);
        if (!OptionVal$.MODULE$.isEmpty$extension(object) && BoxesRunTime.unboxToBoolean(check.apply(next = (a = OptionVal$.MODULE$.get$extension(object))))) {
            return (Node)next;
        }
        return this.insertAfter(OptionVal$Some$.MODULE$.apply(node), newNode.apply());
    }

    public Node getPreviousOrElseInsert(Node node, Function1<Node, Object> check, Function0<Node> newNode) {
        Object a;
        Object previous;
        OptionVal<Node> optionVal = this.getPrevious.apply(node);
        Object var4_5 = optionVal == null ? null : optionVal.x();
        Object object = OptionVal$Some$.MODULE$.unapply(var4_5);
        if (!OptionVal$.MODULE$.isEmpty$extension(object) && BoxesRunTime.unboxToBoolean(check.apply(previous = (a = OptionVal$.MODULE$.get$extension(object))))) {
            return (Node)previous;
        }
        return this.insertBefore(newNode.apply(), OptionVal$Some$.MODULE$.apply(node));
    }

    public Node findNextOrElseInsert(Node node, Function1<Node, Object> isBefore, Function1<Node, Object> check, Function0<Node> newNode) {
        return this.getNextOrElseInsert(this.shiftWhile(node, this.getNext, isBefore), check, newNode);
    }

    public Node findPreviousOrElseInsert(Node node, Function1<Node, Object> isAfter, Function1<Node, Object> check, Function0<Node> newNode) {
        return this.getPreviousOrElseInsert(this.shiftWhile(node, this.getPrevious, isAfter), check, newNode);
    }

    public Iterator<Node> forwardIterator() {
        return this.iteratorFrom(this.first, this.getNext);
    }

    public Iterator<Node> backwardIterator() {
        return this.iteratorFrom(this.last, this.getPrevious);
    }

    private Node insertBefore(Node node, Object next) {
        OptionVal<Node> optionVal;
        Object previous = OptionVal$.MODULE$.isDefined$extension(next) ? ((optionVal = this.getPrevious.apply(OptionVal$.MODULE$.get$extension(next))) == null ? null : optionVal.x()) : OptionVal$.MODULE$.none();
        this.link(previous, node, next);
        return node;
    }

    private Node insertAfter(Object previous, Node node) {
        OptionVal<Node> optionVal;
        Object next = OptionVal$.MODULE$.isDefined$extension(previous) ? ((optionVal = this.getNext.apply(OptionVal$.MODULE$.get$extension(previous))) == null ? null : optionVal.x()) : OptionVal$.MODULE$.none();
        this.link(previous, node, next);
        return node;
    }

    private void link(Object previous, Node node, Object next) {
        this.setPrevious.apply(node, new OptionVal<Object>(previous));
        this.setNext.apply(node, new OptionVal<Object>(next));
        if (OptionVal$.MODULE$.isEmpty$extension(previous)) {
            this.first = OptionVal$Some$.MODULE$.apply(node);
        } else {
            this.setNext.apply(OptionVal$.MODULE$.get$extension(previous), new OptionVal<Object>(OptionVal$Some$.MODULE$.apply(node)));
        }
        if (OptionVal$.MODULE$.isEmpty$extension(next)) {
            this.last = OptionVal$Some$.MODULE$.apply(node);
            return;
        }
        this.setPrevious.apply(OptionVal$.MODULE$.get$extension(next), new OptionVal<Object>(OptionVal$Some$.MODULE$.apply(node)));
    }

    private void unlink(Node node) {
        Object next;
        OptionVal<Node> optionVal = this.getPrevious.apply(node);
        Object previous = optionVal == null ? null : (Object)optionVal.x();
        OptionVal<Node> optionVal2 = this.getNext.apply(node);
        Object a = next = optionVal2 == null ? null : (Object)optionVal2.x();
        if (OptionVal$.MODULE$.isEmpty$extension(previous)) {
            this.first = next;
        } else {
            this.setNext.apply(OptionVal$.MODULE$.get$extension(previous), new OptionVal<Object>(next));
        }
        if (OptionVal$.MODULE$.isEmpty$extension(next)) {
            this.last = previous;
            return;
        }
        this.setPrevious.apply(OptionVal$.MODULE$.get$extension(next), new OptionVal<Object>(previous));
    }

    private Node shiftWhile(Node start, Function1<Node, OptionVal<Node>> shift, Function1<Node, Object> check) {
        Object var8_8;
        Object var7_7;
        Object peek;
        Object current = start;
        OptionVal<Node> optionVal = shift.apply(current);
        Object v0 = peek = optionVal == null ? null : optionVal.x();
        while (OptionVal$.MODULE$.isDefined$extension(var7_7 = peek) && BoxesRunTime.unboxToBoolean(check.apply(OptionVal$.MODULE$.get$extension(var8_8 = peek)))) {
            Object var9_9 = peek;
            current = OptionVal$.MODULE$.get$extension(var9_9);
            OptionVal<Node> optionVal2 = shift.apply(current);
            peek = optionVal2 == null ? null : optionVal2.x();
        }
        return current;
    }

    private Iterator<Node> iteratorFrom(Object start, Function1<Node, OptionVal<Node>> shift) {
        return new AbstractIterator<Node>(start, shift){
            private final Function1 shift$2;
            private Object cursor;
            {
                this.shift$2 = shift$1;
                this.cursor = start$1;
            }

            public boolean hasNext() {
                Object object = this.cursor;
                return OptionVal$.MODULE$.isDefined$extension(object);
            }

            public Object next() {
                Object node = this.cursor;
                Object object = this.cursor;
                R r = this.shift$2.apply(OptionVal$.MODULE$.get$extension(object));
                this.cursor = r == null ? null : ((OptionVal)r).x();
                return OptionVal$.MODULE$.get$extension(node);
            }
        };
    }
}

