/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.stage;

import java.io.Serializable;
import java.time.Duration;
import org.apache.pekko.actor.Cancellable;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.TimerMessages;
import org.apache.pekko.stream.stage.TimerMessages$Scheduled$;
import org.apache.pekko.stream.stage.TimerMessages$Timer$;
import org.apache.pekko.util.JavaDurationConverters$;
import org.apache.pekko.util.JavaDurationConverters$JavaDurationOps$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public abstract class TimerGraphStageLogic
extends GraphStageLogic {
    private final Map<Object, TimerMessages.Timer> keyToTimers = (Map)Map$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray(new Tuple2[0]));
    private final Iterator<Object> timerIdGen = package$.MODULE$.Iterator().from(1);
    private AsyncCallback<TimerMessages.Scheduled> _timerAsyncCallback;

    public TimerGraphStageLogic(Shape _shape) {
        super(_shape);
    }

    private AsyncCallback<TimerMessages.Scheduled> getTimerAsyncCallback() {
        if (this._timerAsyncCallback == null) {
            this._timerAsyncCallback = this.getAsyncCallback(scheduled -> this.onInternalTimer((TimerMessages.Scheduled)scheduled));
        }
        return this._timerAsyncCallback;
    }

    private void onInternalTimer(TimerMessages.Scheduled scheduled) {
        TimerMessages.Timer timer;
        int Id2 = scheduled.timerId();
        Object timerKey = scheduled.timerKey();
        Option option = this.keyToTimers.get(timerKey);
        if (option instanceof Some && (timer = (TimerMessages.Timer)((Some)option).value()) != null) {
            TimerMessages.Timer timer2 = TimerMessages$Timer$.MODULE$.unapply(timer);
            int n = timer2._1();
            Cancellable cancellable = timer2._2();
            if (Id2 == n) {
                if (!scheduled.repeating()) {
                    this.keyToTimers.$minus$eq(timerKey);
                }
                this.onTimer(timerKey);
                return;
            }
        }
    }

    public void onTimer(Object timerKey) throws Exception {
    }

    @Override
    public void afterPostStop() {
        super.afterPostStop();
        if (this.keyToTimers != null) {
            this.keyToTimers.foreach((Function1<Tuple2, boolean> & Serializable)x$1 -> {
                TimerMessages.Timer timer;
                Tuple2 tuple2 = x$1;
                if (tuple2 != null && (timer = (TimerMessages.Timer)tuple2._2()) != null) {
                    Cancellable cancellable;
                    TimerMessages.Timer timer2 = TimerMessages$Timer$.MODULE$.unapply(timer);
                    int n = timer2._1();
                    Cancellable task = cancellable = timer2._2();
                    return task.cancel();
                }
                throw new MatchError(tuple2);
            });
            this.keyToTimers.clear();
            return;
        }
    }

    public final void scheduleOnce(Object timerKey, FiniteDuration delay) {
        this.cancelTimer(timerKey);
        int id = BoxesRunTime.unboxToInt(this.timerIdGen.next());
        AsyncCallback<TimerMessages.Scheduled> callback = this.getTimerAsyncCallback();
        Cancellable task = this.interpreter().materializer().scheduleOnce(delay, () -> callback.invoke(TimerMessages$Scheduled$.MODULE$.apply(timerKey, id, false)));
        this.keyToTimers.update(timerKey, TimerMessages$Timer$.MODULE$.apply(id, task));
    }

    public final void scheduleOnce(Object timerKey, Duration delay) {
        this.scheduleOnce(timerKey, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(delay)));
    }

    public final void scheduleWithFixedDelay(Object timerKey, FiniteDuration initialDelay, FiniteDuration delay) {
        this.cancelTimer(timerKey);
        int id = BoxesRunTime.unboxToInt(this.timerIdGen.next());
        AsyncCallback<TimerMessages.Scheduled> callback = this.getTimerAsyncCallback();
        Cancellable task = this.interpreter().materializer().scheduleWithFixedDelay(initialDelay, delay, () -> callback.invoke(TimerMessages$Scheduled$.MODULE$.apply(timerKey, id, true)));
        this.keyToTimers.update(timerKey, TimerMessages$Timer$.MODULE$.apply(id, task));
    }

    public final void scheduleWithFixedDelay(Object timerKey, Duration initialDelay, Duration interval) {
        this.scheduleWithFixedDelay(timerKey, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(initialDelay)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(interval)));
    }

    public final void scheduleAtFixedRate(Object timerKey, FiniteDuration initialDelay, FiniteDuration interval) {
        this.cancelTimer(timerKey);
        int id = BoxesRunTime.unboxToInt(this.timerIdGen.next());
        AsyncCallback<TimerMessages.Scheduled> callback = this.getTimerAsyncCallback();
        Cancellable task = this.interpreter().materializer().scheduleAtFixedRate(initialDelay, interval, () -> callback.invoke(TimerMessages$Scheduled$.MODULE$.apply(timerKey, id, true)));
        this.keyToTimers.update(timerKey, TimerMessages$Timer$.MODULE$.apply(id, task));
    }

    public final void scheduleAtFixedRate(Object timerKey, Duration initialDelay, Duration interval) {
        this.scheduleAtFixedRate(timerKey, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(initialDelay)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(interval)));
    }

    public final void schedulePeriodicallyWithInitialDelay(Object timerKey, FiniteDuration initialDelay, FiniteDuration interval) {
        this.scheduleAtFixedRate(timerKey, initialDelay, interval);
    }

    public final void schedulePeriodicallyWithInitialDelay(Object timerKey, Duration initialDelay, Duration interval) {
        this.schedulePeriodicallyWithInitialDelay(timerKey, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(initialDelay)), JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(interval)));
    }

    public final void schedulePeriodically(Object timerKey, FiniteDuration interval) {
        this.schedulePeriodicallyWithInitialDelay(timerKey, interval, interval);
    }

    public final void schedulePeriodically(Object timerKey, Duration interval) {
        this.schedulePeriodically(timerKey, JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(interval)));
    }

    public final void cancelTimer(Object timerKey) {
        this.keyToTimers.get(timerKey).foreach((Function1<TimerMessages.Timer, Map> & Serializable)t -> {
            t.task().cancel();
            return (Map)this.keyToTimers.$minus$eq(timerKey);
        });
    }

    public final boolean isTimerActive(Object timerKey) {
        return this.keyToTimers.contains(timerKey);
    }
}

