/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.scaladsl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.AbstractList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.DoNotInherit;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SinkShape;
import org.apache.pekko.stream.SinkShape$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SourceShape$;
import org.apache.pekko.stream.javadsl.PartitionHub;
import org.apache.pekko.stream.scaladsl.PartitionHub;
import org.apache.pekko.stream.scaladsl.PartitionHub$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$Closed$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$Completed$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$Consumer$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$HubCompleted$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$Initialize$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$NeedWakeup$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$Open$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$RegistrationPending$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$TryPull$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$UnRegister$;
import org.apache.pekko.stream.scaladsl.PartitionHub$Internal$Wakeup$;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.Source;
import org.apache.pekko.stream.scaladsl.Source$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStage;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Vector;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.math.Ordering$Long$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
public class PartitionHub<T>
extends GraphStageWithMaterializedValue<SinkShape<T>, Source<T, NotUsed>> {
    public final Function0<Function2<ConsumerInfo, T, Object>> org$apache$pekko$stream$scaladsl$PartitionHub$$partitioner;
    public final int org$apache$pekko$stream$scaladsl$PartitionHub$$startAfterNrOfConsumers;
    public final int org$apache$pekko$stream$scaladsl$PartitionHub$$bufferSize;
    private final Inlet in;
    private final SinkShape shape;

    public static int defaultBufferSize() {
        return PartitionHub$.MODULE$.defaultBufferSize();
    }

    public static <T> Sink<T, Source<T, NotUsed>> sink(Function2<Object, T, Object> function2, int n, int n2) {
        return PartitionHub$.MODULE$.sink(function2, n, n2);
    }

    public static <T> Sink<T, Source<T, NotUsed>> statefulSink(Function0<Function2<ConsumerInfo, T, Object>> function0, int n, int n2) {
        return PartitionHub$.MODULE$.statefulSink(function0, n, n2);
    }

    public static <T> int sink$default$3() {
        return PartitionHub$.MODULE$.sink$default$3();
    }

    public static <T> int statefulSink$default$3() {
        return PartitionHub$.MODULE$.statefulSink$default$3();
    }

    public PartitionHub(Function0<Function2<ConsumerInfo, T, Object>> partitioner, int startAfterNrOfConsumers, int bufferSize) {
        this.org$apache$pekko$stream$scaladsl$PartitionHub$$partitioner = partitioner;
        this.org$apache$pekko$stream$scaladsl$PartitionHub$$startAfterNrOfConsumers = startAfterNrOfConsumers;
        this.org$apache$pekko$stream$scaladsl$PartitionHub$$bufferSize = bufferSize;
        Predef$.MODULE$.require(partitioner != null, PartitionHub::$init$$$anonfun$9);
        Predef$.MODULE$.require(startAfterNrOfConsumers >= 0, PartitionHub::$init$$$anonfun$10);
        Predef$.MODULE$.require(bufferSize > 0, PartitionHub::$init$$$anonfun$11);
        this.in = Inlet$.MODULE$.apply("PartitionHub.in");
        this.shape = SinkShape$.MODULE$.apply(this.in());
    }

    public Inlet<T> in() {
        return this.in;
    }

    @Override
    public SinkShape<T> shape() {
        return this.shape;
    }

    public Internal.PartitionQueue createQueue() {
        return new Internal.PartitionQueueImpl();
    }

    @Override
    public Tuple2<GraphStageLogic, Source<T, NotUsed>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        AtomicLong idCounter = new AtomicLong();
        PartitionSinkLogic logic = new PartitionSinkLogic(this.shape());
        GraphStage source = new GraphStage<SourceShape<T>>(idCounter, logic){
            private final AtomicLong idCounter$5;
            public final PartitionSinkLogic org$apache$pekko$stream$scaladsl$PartitionHub$$anon$7$$logic$3;
            private final Outlet out;
            private final SourceShape shape;
            {
                this.idCounter$5 = idCounter$9;
                this.org$apache$pekko$stream$scaladsl$PartitionHub$$anon$7$$logic$3 = logic$6;
                this.out = Outlet$.MODULE$.apply("PartitionHub.out");
                this.shape = SourceShape$.MODULE$.apply(this.out());
            }

            public Outlet out() {
                return this.out;
            }

            public SourceShape shape() {
                return this.shape;
            }

            public GraphStageLogic createLogic(Attributes inheritedAttributes) {
                return new OutHandler(this.idCounter$5, this){
                    private final long id;
                    private AsyncCallback hubCallback;
                    private final Internal.Consumer consumer;
                    private long callbackCount;
                    private final /* synthetic */ $anon$7 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super($outer.shape());
                        this.id = idCounter$6.getAndIncrement();
                        AsyncCallback<Internal.ConsumerEvent> callback = this.getAsyncCallback(cmd -> this.onCommand((Internal.ConsumerEvent)cmd));
                        this.consumer = PartitionHub$Internal$Consumer$.MODULE$.apply(this.id, callback);
                        this.callbackCount = 0L;
                        this.setHandler($outer.out(), this);
                    }

                    public void preStart() {
                        JProcedure1<Try> onHubReady = x$1 -> {
                            Try try_ = x$1;
                            if (try_ instanceof Success) {
                                AsyncCallback callback;
                                this.hubCallback = callback = (AsyncCallback)((Success)try_).value();
                                callback.invoke(PartitionHub$Internal$RegistrationPending$.MODULE$);
                                if (this.isAvailable(this.$outer.out())) {
                                    this.onPull();
                                    return;
                                }
                                return;
                            }
                            if (try_ instanceof Failure) {
                                Throwable ex = ((Failure)try_).exception();
                                this.failStage(ex);
                                return;
                            }
                            throw new MatchError(try_);
                        };
                        this.register$2(onHubReady);
                    }

                    public void onPull() {
                        if (this.hubCallback != null) {
                            Object elem = this.$outer.org$apache$pekko$stream$scaladsl$PartitionHub$$anon$7$$logic$3.poll(this.id, this.hubCallback);
                            Object object = elem;
                            if (object == null) {
                                this.hubCallback.invoke(PartitionHub$Internal$NeedWakeup$.MODULE$.apply(this.consumer));
                                return;
                            }
                            if (PartitionHub$Internal$Completed$.MODULE$.equals(object)) {
                                this.completeStage();
                                return;
                            }
                            this.push(this.$outer.out(), elem);
                            return;
                        }
                    }

                    public void postStop() {
                        if (this.hubCallback != null) {
                            this.hubCallback.invoke(PartitionHub$Internal$UnRegister$.MODULE$.apply(this.id));
                            return;
                        }
                    }

                    private void onCommand(Internal.ConsumerEvent cmd) {
                        ++this.callbackCount;
                        Internal.ConsumerEvent consumerEvent = cmd;
                        if (consumerEvent instanceof Internal.HubCompleted) {
                            Internal.HubCompleted hubCompleted = PartitionHub$Internal$HubCompleted$.MODULE$.unapply((Internal.HubCompleted)consumerEvent);
                            Option<Throwable> option = hubCompleted._1();
                            if (option instanceof Some) {
                                Throwable ex = (Throwable)((Some)option).value();
                                this.failStage(ex);
                                return;
                            }
                            if (None$.MODULE$.equals(option)) {
                                this.completeStage();
                                return;
                            }
                        }
                        if (PartitionHub$Internal$Wakeup$.MODULE$.equals(consumerEvent)) {
                            if (this.isAvailable(this.$outer.out())) {
                                this.onPull();
                                return;
                            }
                            return;
                        }
                        if (PartitionHub$Internal$Initialize$.MODULE$.equals(consumerEvent)) {
                            if (this.isAvailable(this.$outer.out()) && this.hubCallback != null) {
                                this.onPull();
                                return;
                            }
                            return;
                        }
                        throw new MatchError(consumerEvent);
                    }

                    private final void register$2(Function1 onHubReady$2) {
                        Internal.HubState hubState;
                        block4: {
                            List<Internal.Consumer> newRegistrations;
                            Future<AsyncCallback<Internal.HubEvent>> callbackFuture;
                            Internal.Open previousState;
                            do {
                                if ((hubState = this.$outer.org$apache$pekko$stream$scaladsl$PartitionHub$$anon$7$$logic$3.state().get()) instanceof Internal.Closed) {
                                    Internal.Closed closed = PartitionHub$Internal$Closed$.MODULE$.unapply((Internal.Closed)hubState);
                                    Option<Throwable> option = closed._1();
                                    if (option instanceof Some) {
                                        Throwable ex = (Throwable)((Some)option).value();
                                        this.failStage(ex);
                                        return;
                                    }
                                    if (None$.MODULE$.equals(option)) {
                                        this.completeStage();
                                        return;
                                    }
                                }
                                if (!(hubState instanceof Internal.Open)) break block4;
                                Internal.Open open = (Internal.Open)hubState;
                                Internal.Open open2 = PartitionHub$Internal$Open$.MODULE$.unapply(open);
                                Future<AsyncCallback<Internal.HubEvent>> future = open2._1();
                                List<Internal.Consumer> list = open2._2();
                                callbackFuture = future;
                                List<Internal.Consumer> registrations = list;
                                previousState = open;
                                newRegistrations = registrations.$colon$colon(this.consumer);
                            } while (!this.$outer.org$apache$pekko$stream$scaladsl$PartitionHub$$anon$7$$logic$3.state().compareAndSet(previousState, PartitionHub$Internal$Open$.MODULE$.apply(callbackFuture, newRegistrations)));
                            AsyncCallback<T> asyncCallback = this.getAsyncCallback(onHubReady$2);
                            callbackFuture.onComplete(arg_0 -> PartitionHub.org$apache$pekko$stream$scaladsl$PartitionHub$$anon$7$$anon$8$$_$register$2$$anonfun$1(asyncCallback, arg_0), this.materializer().executionContext());
                            return;
                        }
                        throw new MatchError(hubState);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$12(org.apache.pekko.stream.scaladsl.PartitionHub$Internal$ConsumerEvent ), $anonfun$7(scala.util.Try ), org$apache$pekko$stream$scaladsl$PartitionHub$$anon$7$$anon$8$$_$register$2$$anonfun$1(org.apache.pekko.stream.stage.AsyncCallback scala.util.Try )}, serializedLambda);
                    }
                };
            }
        };
        return Tuple2$.MODULE$.apply(logic, Source$.MODULE$.fromGraph(source));
    }

    private static final Object $init$$$anonfun$9() {
        return "partitioner must not be null";
    }

    private static final Object $init$$$anonfun$10() {
        return "startAfterNrOfConsumers must >= 0";
    }

    private static final Object $init$$$anonfun$11() {
        return "Buffer size must be positive";
    }

    public static final /* synthetic */ long org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$ConsumerInfoImpl$$_$consumerIds$$anonfun$1(Internal.Consumer _$6) {
        return _$6.id();
    }

    public static final /* synthetic */ long org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$_$_$$anonfun$5(Internal.Consumer _$7) {
        return _$7.id();
    }

    public static final /* synthetic */ boolean org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$_$_$$anonfun$6(long id$1, Internal.Consumer _$8) {
        return _$8.id() == id$1;
    }

    public static final /* synthetic */ void org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$_$onUpstreamFailure$$anonfun$4(Internal.HubCompleted failMessage$3, Internal.Consumer consumer) {
        consumer.callback().invoke(failMessage$3);
    }

    public static final /* synthetic */ void org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$_$onUpstreamFailure$$anonfun$5(Internal.HubCompleted failMessage$4, Internal.Consumer consumer) {
        consumer.callback().invoke(failMessage$4);
    }

    public static final /* synthetic */ void org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$_$tryClose$2$$anonfun$1(Internal.HubCompleted completedMessage$2, Internal.Consumer consumer) {
        consumer.callback().invoke(completedMessage$2);
    }

    public static final /* synthetic */ void org$apache$pekko$stream$scaladsl$PartitionHub$$anon$7$$anon$8$$_$register$2$$anonfun$1(AsyncCallback $2$$1, Try t) {
        $2$$1.invoke(t);
    }

    @DoNotInherit
    public static interface ConsumerInfo
    extends PartitionHub.ConsumerInfo {
        public IndexedSeq<Object> consumerIds();

        @Override
        public long consumerIdByIdx(int var1);

        @Override
        public int queueSize(long var1);

        @Override
        public int size();
    }

    public class PartitionSinkLogic
    extends GraphStageLogic
    implements InHandler {
        private final int DemandThreshold;
        private final Function2<ConsumerInfo, T, Object> materializedPartitioner;
        private final Promise<AsyncCallback<Internal.HubEvent>> callbackPromise;
        private final Internal.Open noRegistrationsState;
        private final AtomicReference state;
        private boolean initialized;
        public final Internal.PartitionQueue org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue;
        private Vector<T> pending;
        private ConsumerInfoImpl consumerInfo;
        private final LongMap<Internal.Consumer> needWakeup;
        private long callbackCount;

        public PartitionSinkLogic(SinkShape<T> _shape) {
            if (PartitionHub.this == null) {
                throw new NullPointerException();
            }
            super(_shape);
            this.DemandThreshold = PartitionHub.this.org$apache$pekko$stream$scaladsl$PartitionHub$$bufferSize / 2 + PartitionHub.this.org$apache$pekko$stream$scaladsl$PartitionHub$$bufferSize % 2;
            this.materializedPartitioner = PartitionHub.this.org$apache$pekko$stream$scaladsl$PartitionHub$$partitioner.apply();
            this.callbackPromise = Promise$.MODULE$.apply();
            this.noRegistrationsState = PartitionHub$Internal$Open$.MODULE$.apply(this.callbackPromise.future(), package$.MODULE$.Nil());
            this.state = new AtomicReference<Internal.Open>(this.noRegistrationsState);
            this.initialized = false;
            this.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue = PartitionHub.this.createQueue();
            this.pending = package$.MODULE$.Vector().empty();
            this.consumerInfo = new ConsumerInfoImpl(this, (Vector<Internal.Consumer>)package$.MODULE$.Vector().empty());
            this.needWakeup = LongMap$.MODULE$.empty();
            this.callbackCount = 0L;
            this.setHandler(PartitionHub.this.in(), this);
        }

        public AtomicReference<Internal.HubState> state() {
            return this.state;
        }

        @Override
        public void preStart() {
            this.setKeepGoing(true);
            this.callbackPromise.success(this.getAsyncCallback(ev -> this.onEvent((Internal.HubEvent)ev)));
            if (PartitionHub.this.org$apache$pekko$stream$scaladsl$PartitionHub$$startAfterNrOfConsumers == 0) {
                this.pull(PartitionHub.this.in());
                return;
            }
        }

        @Override
        public void onPush() {
            this.publish(this.grab(PartitionHub.this.in()));
            if (!this.isFull()) {
                this.pull(PartitionHub.this.in());
                return;
            }
        }

        private boolean isFull() {
            return this.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue.totalSize() + this.pending.size() >= PartitionHub.this.org$apache$pekko$stream$scaladsl$PartitionHub$$bufferSize;
        }

        private void publish(T elem) {
            if (!this.initialized || this.consumerInfo.consumers().isEmpty()) {
                this.pending = (Vector)this.pending.$colon$plus(elem);
                return;
            }
            long id = BoxesRunTime.unboxToLong(this.materializedPartitioner.apply(this.consumerInfo, elem));
            if (id >= 0L) {
                this.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue.offer(id, elem);
                this.wakeup(id);
                return;
            }
        }

        private void wakeup(long id) {
            Option<Internal.Consumer> option = this.needWakeup.get(id);
            if (None$.MODULE$.equals(option)) {
                return;
            }
            if (option instanceof Some) {
                Internal.Consumer consumer = (Internal.Consumer)((Some)option).value();
                this.needWakeup.$minus$eq(BoxesRunTime.boxToLong(id));
                consumer.callback().invoke(PartitionHub$Internal$Wakeup$.MODULE$);
                return;
            }
            throw new MatchError(option);
        }

        @Override
        public void onUpstreamFinish() {
            if (this.consumerInfo.consumers().isEmpty()) {
                this.completeStage();
                return;
            }
            this.consumerInfo.consumers().foreach(c -> this.complete(c.id()));
        }

        private void complete(long id) {
            this.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue.offer(id, PartitionHub$Internal$Completed$.MODULE$);
            this.wakeup(id);
        }

        private void tryPull() {
            if (this.initialized && !this.isClosed(PartitionHub.this.in()) && !this.hasBeenPulled(PartitionHub.this.in()) && !this.isFull()) {
                this.pull(PartitionHub.this.in());
                return;
            }
        }

        private void onEvent(Internal.HubEvent ev) {
            ++this.callbackCount;
            Internal.HubEvent hubEvent = ev;
            if (hubEvent instanceof Internal.NeedWakeup) {
                Internal.NeedWakeup needWakeup = PartitionHub$Internal$NeedWakeup$.MODULE$.unapply((Internal.NeedWakeup)hubEvent);
                Internal.Consumer consumer2 = needWakeup._1();
                Internal.Consumer consumer3 = consumer2;
                if (this.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue.nonEmpty(consumer3.id())) {
                    consumer3.callback().invoke(PartitionHub$Internal$Wakeup$.MODULE$);
                    return;
                }
                this.needWakeup.update(consumer3.id(), consumer3);
                this.tryPull();
                return;
            }
            if (PartitionHub$Internal$TryPull$.MODULE$.equals(hubEvent)) {
                this.tryPull();
                return;
            }
            if (PartitionHub$Internal$RegistrationPending$.MODULE$.equals(hubEvent)) {
                ((Internal.Open)this.state().getAndSet(this.noRegistrationsState)).registrations().foreach(consumer -> {
                    Vector newConsumers = (Vector)((SeqOps)this.consumerInfo.consumers().$colon$plus(consumer)).sortBy(PartitionHub::org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$_$_$$anonfun$5, Ordering$Long$.MODULE$);
                    this.consumerInfo = new ConsumerInfoImpl(this, newConsumers);
                    this.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue.init(consumer.id());
                    consumer.callback().invoke(PartitionHub$Internal$Initialize$.MODULE$);
                });
                if (this.consumerInfo.size() >= PartitionHub.this.org$apache$pekko$stream$scaladsl$PartitionHub$$startAfterNrOfConsumers) {
                    this.initialized = true;
                }
                if (this.initialized && this.pending.nonEmpty()) {
                    this.pending.foreach(elem -> this.publish(elem));
                    this.pending = package$.MODULE$.Vector().empty();
                }
                this.tryPull();
                return;
            }
            if (hubEvent instanceof Internal.UnRegister) {
                long l;
                Internal.UnRegister unRegister = PartitionHub$Internal$UnRegister$.MODULE$.unapply((Internal.UnRegister)hubEvent);
                long id = l = unRegister._1();
                Vector newConsumers = (Vector)this.consumerInfo.consumers().filterNot(arg_0 -> PartitionHub.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$_$_$$anonfun$6(id, arg_0));
                this.consumerInfo = new ConsumerInfoImpl(this, newConsumers);
                this.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue.remove(id);
                if (newConsumers.isEmpty()) {
                    if (this.isClosed(PartitionHub.this.in())) {
                        this.completeStage();
                        return;
                    }
                    return;
                }
                this.tryPull();
                return;
            }
            throw new MatchError(hubEvent);
        }

        @Override
        public void onUpstreamFailure(Throwable ex) {
            Internal.HubCompleted failMessage = PartitionHub$Internal$HubCompleted$.MODULE$.apply(Some$.MODULE$.apply(ex));
            ((Internal.Open)this.state().getAndSet(PartitionHub$Internal$Closed$.MODULE$.apply(Some$.MODULE$.apply(ex)))).registrations().foreach(arg_0 -> PartitionHub.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$_$onUpstreamFailure$$anonfun$4(failMessage, arg_0));
            this.consumerInfo.consumers().foreach(arg_0 -> PartitionHub.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$_$onUpstreamFailure$$anonfun$5(failMessage, arg_0));
            this.failStage(ex);
        }

        @Override
        public void postStop() {
            this.tryClose$2();
        }

        public Object poll(long id, AsyncCallback<Internal.HubEvent> hubCallback) {
            if (this.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue.totalSize() == this.DemandThreshold) {
                hubCallback.invoke(PartitionHub$Internal$TryPull$.MODULE$);
            }
            return this.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue.poll(id);
        }

        public final /* synthetic */ PartitionHub org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$$outer() {
            return PartitionHub.this;
        }

        private final void tryClose$2() {
            Internal.HubState hubState;
            block2: {
                Internal.Open open;
                do {
                    if ((hubState = this.state().get()) instanceof Internal.Closed) {
                        Internal.Closed closed = PartitionHub$Internal$Closed$.MODULE$.unapply((Internal.Closed)hubState);
                        Option<Throwable> option = closed._1();
                        return;
                    }
                    if (!(hubState instanceof Internal.Open)) break block2;
                    open = (Internal.Open)hubState;
                } while (!this.state().compareAndSet(open, PartitionHub$Internal$Closed$.MODULE$.apply(None$.MODULE$)));
                Internal.HubCompleted completedMessage = PartitionHub$Internal$HubCompleted$.MODULE$.apply(None$.MODULE$);
                open.registrations().foreach(arg_0 -> PartitionHub.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$_$tryClose$2$$anonfun$1(completedMessage, arg_0));
                return;
            }
            throw new MatchError(hubState);
        }

        public final class ConsumerInfoImpl
        implements ConsumerInfo {
            private final Vector consumers;
            private final /* synthetic */ PartitionSinkLogic $outer;

            public ConsumerInfoImpl(PartitionSinkLogic $outer, Vector<Internal.Consumer> consumers) {
                this.consumers = consumers;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public Vector<Internal.Consumer> consumers() {
                return this.consumers;
            }

            @Override
            public int queueSize(long consumerId) {
                return this.$outer.org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$$queue.size(consumerId);
            }

            @Override
            public int size() {
                return this.consumers().size();
            }

            @Override
            public IndexedSeq<Object> consumerIds() {
                return (IndexedSeq)this.consumers().map(PartitionHub::org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$ConsumerInfoImpl$$_$consumerIds$$anonfun$1);
            }

            @Override
            public long consumerIdByIdx(int idx) {
                return ((Internal.Consumer)this.consumers().apply(idx)).id();
            }

            @Override
            public java.util.List<Object> getConsumerIds() {
                return new AbstractList<Object>(this){
                    private final /* synthetic */ ConsumerInfoImpl $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public long get(int idx) {
                        return this.$outer.consumerIdByIdx(idx);
                    }

                    public int size() {
                        return this.$outer.size();
                    }
                };
            }

            public final /* synthetic */ PartitionSinkLogic org$apache$pekko$stream$scaladsl$PartitionHub$PartitionSinkLogic$ConsumerInfoImpl$$$outer() {
                return this.$outer;
            }
        }
    }
}

