/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.Serializable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.TLSClientAuth;
import org.apache.pekko.stream.TLSClientAuth$Need$;
import org.apache.pekko.stream.TLSClientAuth$None$;
import org.apache.pekko.stream.TLSClientAuth$Want$;
import org.apache.pekko.stream.TLSProtocol;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;

@InternalApi
public final class TlsUtils$
implements Serializable {
    public static final TlsUtils$ MODULE$ = new TlsUtils$();

    private TlsUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TlsUtils$.class);
    }

    public void applySessionParameters(SSLEngine engine, TLSProtocol.NegotiateNewSession sessionParameters) {
        sessionParameters.enabledCipherSuites().foreach(cs -> engine.setEnabledCipherSuites((String[])cs.toArray(ClassTag$.MODULE$.apply(String.class))));
        sessionParameters.enabledProtocols().foreach(p -> engine.setEnabledProtocols((String[])p.toArray(ClassTag$.MODULE$.apply(String.class))));
        sessionParameters.sslParameters().foreach(x$0 -> engine.setSSLParameters((SSLParameters)x$0));
        Option<TLSClientAuth> option = sessionParameters.clientAuth();
        if (option instanceof Some) {
            TLSClientAuth tLSClientAuth = (TLSClientAuth)((Some)option).value();
            if (TLSClientAuth$None$.MODULE$.equals(tLSClientAuth)) {
                engine.setNeedClientAuth(false);
                return;
            }
            if (TLSClientAuth$Want$.MODULE$.equals(tLSClientAuth)) {
                engine.setWantClientAuth(true);
                return;
            }
            if (TLSClientAuth$Need$.MODULE$.equals(tLSClientAuth)) {
                engine.setNeedClientAuth(true);
                return;
            }
        }
    }

    public SSLParameters cloneParameters(SSLParameters old) {
        SSLParameters newParameters = new SSLParameters();
        newParameters.setAlgorithmConstraints(old.getAlgorithmConstraints());
        newParameters.setCipherSuites(old.getCipherSuites());
        newParameters.setEndpointIdentificationAlgorithm(old.getEndpointIdentificationAlgorithm());
        newParameters.setNeedClientAuth(old.getNeedClientAuth());
        newParameters.setProtocols(old.getProtocols());
        newParameters.setServerNames(old.getServerNames());
        newParameters.setSNIMatchers(old.getSNIMatchers());
        newParameters.setUseCipherSuitesOrder(old.getUseCipherSuitesOrder());
        newParameters.setWantClientAuth(old.getWantClientAuth());
        return newParameters;
    }
}

