/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.stream.impl.io.OutputStreamSourceStage;
import org.apache.pekko.stream.impl.io.OutputStreamSourceStage$Close$;
import org.apache.pekko.stream.impl.io.OutputStreamSourceStage$Send$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.concurrent.Await$;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Numeric$IntIsIntegral$;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public class OutputStreamAdapter
extends OutputStream {
    private final Semaphore unfulfilledDemand;
    private final AsyncCallback<OutputStreamSourceStage.AdapterToStageMessage> sendToStage;
    private final FiniteDuration writeTimeout;

    public OutputStreamAdapter(Semaphore unfulfilledDemand, AsyncCallback<OutputStreamSourceStage.AdapterToStageMessage> sendToStage, FiniteDuration writeTimeout) {
        this.unfulfilledDemand = unfulfilledDemand;
        this.sendToStage = sendToStage;
        this.writeTimeout = writeTimeout;
    }

    private void sendData(ByteString data) throws IOException {
        if (!this.unfulfilledDemand.tryAcquire(this.writeTimeout.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new IOException("Timed out trying to write data to stream");
        }
        try {
            Await$.MODULE$.result(this.sendToStage.invokeWithFeedback(OutputStreamSourceStage$Send$.MODULE$.apply(data)), this.writeTimeout);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = option.get();
                throw new IOException(e);
            }
            throw throwable;
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.sendData(ByteString$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapIntArray(new int[]{b}), Numeric$IntIsIntegral$.MODULE$));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = Predef$.MODULE$.byteArrayOps(b);
        if (ArrayOps$.MODULE$.nonEmpty$extension(object)) {
            this.sendData(ByteString$.MODULE$.fromArray(b, off, len));
            return;
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        try {
            Await$.MODULE$.result(this.sendToStage.invokeWithFeedback(OutputStreamSourceStage$Close$.MODULE$), this.writeTimeout);
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = option.get();
                throw new IOException(e);
            }
            throw throwable;
        }
    }
}

