/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.InputStream;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.AbruptStageTerminationException;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.IOOperationIncompleteException;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.IOResult$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SourceShape$;
import org.apache.pekko.stream.SubscriptionWithCancelException;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ByteString$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.util.control.NonFatal$;

@InternalApi
public final class InputStreamSource
extends GraphStageWithMaterializedValue<SourceShape<ByteString>, Future<IOResult>> {
    public final Function0<InputStream> org$apache$pekko$stream$impl$io$InputStreamSource$$factory;
    public final int org$apache$pekko$stream$impl$io$InputStreamSource$$chunkSize;
    public final Outlet<ByteString> org$apache$pekko$stream$impl$io$InputStreamSource$$out;

    public InputStreamSource(Function0<InputStream> factory, int chunkSize) {
        this.org$apache$pekko$stream$impl$io$InputStreamSource$$factory = factory;
        this.org$apache$pekko$stream$impl$io$InputStreamSource$$chunkSize = chunkSize;
        Predef$.MODULE$.require(chunkSize > 0, () -> InputStreamSource.$init$$$anonfun$1(chunkSize));
        this.org$apache$pekko$stream$impl$io$InputStreamSource$$out = Outlet$.MODULE$.apply("InputStreamSource.out");
    }

    @Override
    public SourceShape<ByteString> shape() {
        return SourceShape$.MODULE$.apply(this.org$apache$pekko$stream$impl$io$InputStreamSource$$out);
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.inputStreamSource();
    }

    @Override
    public Tuple2<GraphStageLogic, Future<IOResult>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        Promise mat = Promise$.MODULE$.apply();
        OutHandler logic = new OutHandler(mat, this){
            private final Promise mat$1;
            private final byte[] buffer;
            private long readBytesTotal;
            private InputStream inputStream;
            private final /* synthetic */ InputStreamSource $outer;
            {
                this.mat$1 = mat$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.buffer = new byte[$outer.org$apache$pekko$stream$impl$io$InputStreamSource$$chunkSize];
                this.readBytesTotal = 0L;
                this.setHandler($outer.org$apache$pekko$stream$impl$io$InputStreamSource$$out, this);
            }

            private boolean isClosed() {
                return this.mat$1.isCompleted();
            }

            public Class logSource() {
                return InputStreamSource.class;
            }

            public void preStart() {
                try {
                    this.inputStream = this.$outer.org$apache$pekko$stream$impl$io$InputStreamSource$$factory.apply();
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable t = throwable3 = option.get();
                        this.mat$1.failure(new IOOperationIncompleteException(0L, t));
                        this.failStage(t);
                    }
                    throw throwable;
                }
            }

            public void onPull() {
                try {
                    int n = this.inputStream.read(this.buffer);
                    if (-1 == n) {
                        this.closeStage();
                    } else {
                        int readBytes = n;
                        this.readBytesTotal += (long)readBytes;
                        this.push(this.$outer.org$apache$pekko$stream$impl$io$InputStreamSource$$out, ByteString$.MODULE$.fromArray(this.buffer, 0, readBytes));
                    }
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable t = throwable3 = option.get();
                        this.failStream(t);
                        this.failStage(t);
                    }
                    throw throwable;
                }
            }

            public void onDownstreamFinish(Throwable cause) {
                if (!this.isClosed()) {
                    this.closeInputStream();
                    Throwable throwable = cause;
                    if (throwable instanceof SubscriptionWithCancelException.NonFailureCancellation) {
                        this.mat$1.trySuccess(IOResult$.MODULE$.apply(this.readBytesTotal));
                        return;
                    }
                    if (throwable != null) {
                        Throwable ex = throwable;
                        this.mat$1.tryFailure(new IOOperationIncompleteException("Downstream failed before input stream reached end", this.readBytesTotal, ex));
                        return;
                    }
                    throw new MatchError((Object)throwable);
                }
            }

            public void postStop() {
                if (!this.isClosed()) {
                    this.mat$1.tryFailure(new AbruptStageTerminationException(this));
                    return;
                }
            }

            private void closeStage() {
                this.closeInputStream();
                this.mat$1.trySuccess(IOResult$.MODULE$.apply(this.readBytesTotal));
                this.completeStage();
            }

            private void failStream(Throwable reason) {
                this.closeInputStream();
                this.mat$1.tryFailure(new IOOperationIncompleteException(this.readBytesTotal, reason));
            }

            private void closeInputStream() {
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable ex = throwable3 = option.get();
                        this.mat$1.tryFailure(new IOOperationIncompleteException(this.readBytesTotal, ex));
                        this.failStage(ex);
                    }
                    throw throwable;
                }
            }
        };
        return Tuple2$.MODULE$.apply(logic, mat.future());
    }

    public String toString() {
        return "InputStreamSource";
    }

    private static final Object $init$$$anonfun$1(int chunkSize$1) {
        return new StringBuilder(28).append("chunkSize must be > 0 (was ").append(chunkSize$1).append(")").toString();
    }
}

