/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.AbruptStageTerminationException;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$InputBuffer$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.SinkShape;
import org.apache.pekko.stream.SinkShape$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.io.InputStreamAdapter;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Close$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Data$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Failed$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Finished$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$Initialized$;
import org.apache.pekko.stream.impl.io.InputStreamSinkStage$ReadElementAcknowledgement$;
import org.apache.pekko.stream.stage.AsyncCallback;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.util.ByteString;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;

@InternalApi
public final class InputStreamSinkStage
extends GraphStageWithMaterializedValue<SinkShape<ByteString>, InputStream> {
    private final FiniteDuration readTimeout;
    private final Inlet in;
    private final SinkShape shape;

    public InputStreamSinkStage(FiniteDuration readTimeout) {
        this.readTimeout = readTimeout;
        this.in = Inlet$.MODULE$.apply("InputStreamSink.in");
        this.shape = SinkShape$.MODULE$.of(this.in());
    }

    public Inlet<ByteString> in() {
        return this.in;
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.inputStreamSink();
    }

    @Override
    public SinkShape<ByteString> shape() {
        return this.shape;
    }

    @Override
    public Tuple2<GraphStageLogic, InputStream> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        int maxBuffer = inheritedAttributes.get(Attributes$InputBuffer$.MODULE$.apply(16, 16), ClassTag$.MODULE$.apply(Attributes.InputBuffer.class)).max();
        Predef$.MODULE$.require(maxBuffer > 0, InputStreamSinkStage::createLogicAndMaterializedValue$$anonfun$1);
        LinkedBlockingDeque<StreamToAdapterMessage> dataQueue = new LinkedBlockingDeque<StreamToAdapterMessage>(maxBuffer + 2);
        StageWithCallback logic = new StageWithCallback(dataQueue, this){
            private final LinkedBlockingDeque dataQueue$1;
            private boolean completionSignalled;
            private final AsyncCallback callback;
            private final /* synthetic */ InputStreamSinkStage $outer;
            {
                this.dataQueue$1 = dataQueue$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.completionSignalled = false;
                this.callback = this.getAsyncCallback(x$1 -> {
                    AdapterToStageMessage adapterToStageMessage = x$1;
                    if (InputStreamSinkStage$ReadElementAcknowledgement$.MODULE$.equals(adapterToStageMessage)) {
                        this.sendPullIfAllowed();
                        return;
                    }
                    if (InputStreamSinkStage$Close$.MODULE$.equals(adapterToStageMessage)) {
                        this.completeStage();
                        return;
                    }
                    throw new MatchError(adapterToStageMessage);
                });
                this.setHandler($outer.in(), this);
            }

            public boolean completionSignalled() {
                return this.completionSignalled;
            }

            public void completionSignalled_$eq(boolean x$1) {
                this.completionSignalled = x$1;
            }

            public void wakeUp(AdapterToStageMessage msg) {
                this.callback.invoke(msg);
            }

            private void sendPullIfAllowed() {
                if (this.dataQueue$1.remainingCapacity() > 1 && !this.hasBeenPulled(this.$outer.in())) {
                    this.pull(this.$outer.in());
                    return;
                }
            }

            public void preStart() {
                this.dataQueue$1.add(InputStreamSinkStage$Initialized$.MODULE$);
                this.pull(this.$outer.in());
            }

            public void onPush() {
                Predef$.MODULE$.require(this.dataQueue$1.remainingCapacity() > 1);
                ByteString bs = this.grab(this.$outer.in());
                if (bs.nonEmpty()) {
                    this.dataQueue$1.add(InputStreamSinkStage$Data$.MODULE$.apply(bs));
                }
                if (this.dataQueue$1.remainingCapacity() > 1) {
                    this.sendPullIfAllowed();
                    return;
                }
            }

            public void onUpstreamFinish() {
                this.dataQueue$1.add(InputStreamSinkStage$Finished$.MODULE$);
                this.completionSignalled_$eq(true);
                this.completeStage();
            }

            public void onUpstreamFailure(Throwable ex) {
                this.dataQueue$1.add(InputStreamSinkStage$Failed$.MODULE$.apply(ex));
                this.completionSignalled_$eq(true);
                this.failStage(ex);
            }

            public void postStop() {
                if (!this.completionSignalled()) {
                    this.dataQueue$1.add(InputStreamSinkStage$Failed$.MODULE$.apply(new AbruptStageTerminationException(this)));
                    return;
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$1(org.apache.pekko.stream.impl.io.InputStreamSinkStage$AdapterToStageMessage )}, serializedLambda);
            }
        };
        return Tuple2$.MODULE$.apply(logic, new InputStreamAdapter(dataQueue, arg_0 -> InputStreamSinkStage.createLogicAndMaterializedValue$$anonfun$2((GraphStageLogic)((Object)logic), arg_0), this.readTimeout));
    }

    private static final Object createLogicAndMaterializedValue$$anonfun$1() {
        return "Buffer size must be greater than 0";
    }

    private static final /* synthetic */ void createLogicAndMaterializedValue$$anonfun$2(GraphStageLogic logic$1, AdapterToStageMessage msg) {
        ((StageWithCallback)((Object)logic$1)).wakeUp(msg);
    }

    public static interface AdapterToStageMessage {
    }

    public static class Data
    implements StreamToAdapterMessage,
    Product,
    Serializable {
        private final ByteString data;

        public static Data apply(ByteString byteString) {
            return InputStreamSinkStage$Data$.MODULE$.apply(byteString);
        }

        public static Data fromProduct(Product product) {
            return InputStreamSinkStage$Data$.MODULE$.fromProduct(product);
        }

        public static Data unapply(Data data) {
            return InputStreamSinkStage$Data$.MODULE$.unapply(data);
        }

        public Data(ByteString data) {
            this.data = data;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Data)) return false;
            Data data = (Data)object;
            ByteString byteString = this.data();
            ByteString byteString2 = data.data();
            if (byteString == null) {
                if (byteString2 != null) {
                    return false;
                }
            } else if (!((Object)byteString).equals(byteString2)) return false;
            if (!data.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Data;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Data";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ByteString data() {
            return this.data;
        }

        public Data copy(ByteString data) {
            return new Data(data);
        }

        public ByteString copy$default$1() {
            return this.data();
        }

        public ByteString _1() {
            return this.data();
        }
    }

    public static class Failed
    implements StreamToAdapterMessage,
    Product,
    Serializable {
        private final Throwable cause;

        public static Failed apply(Throwable throwable) {
            return InputStreamSinkStage$Failed$.MODULE$.apply(throwable);
        }

        public static Failed fromProduct(Product product) {
            return InputStreamSinkStage$Failed$.MODULE$.fromProduct(product);
        }

        public static Failed unapply(Failed failed) {
            return InputStreamSinkStage$Failed$.MODULE$.unapply(failed);
        }

        public Failed(Throwable cause) {
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Failed)) return false;
            Failed failed = (Failed)object;
            Throwable throwable = this.cause();
            Throwable throwable2 = failed.cause();
            if (throwable == null) {
                if (throwable2 != null) {
                    return false;
                }
            } else if (!throwable.equals(throwable2)) return false;
            if (!failed.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Failed;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Failed";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public Throwable cause() {
            return this.cause;
        }

        public Failed copy(Throwable cause) {
            return new Failed(cause);
        }

        public Throwable copy$default$1() {
            return this.cause();
        }

        public Throwable _1() {
            return this.cause();
        }
    }

    public static interface StageWithCallback {
        public void wakeUp(AdapterToStageMessage var1);
    }

    public static interface StreamToAdapterMessage {
    }
}

