/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.AbruptStageTerminationException;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.IOOperationIncompleteException;
import org.apache.pekko.stream.IOResult;
import org.apache.pekko.stream.IOResult$;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.SinkShape;
import org.apache.pekko.stream.SinkShape$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.ByteString;
import org.apache.pekko.util.ccompat.package$JavaConverters$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Set;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.runtime.LambdaDeserialize;
import scala.util.Success$;
import scala.util.control.NonFatal$;

@InternalApi
public final class FileOutputStage
extends GraphStageWithMaterializedValue<SinkShape<ByteString>, Future<IOResult>> {
    public final Path org$apache$pekko$stream$impl$io$FileOutputStage$$path;
    public final long org$apache$pekko$stream$impl$io$FileOutputStage$$startPosition;
    public final scala.collection.immutable.Set<OpenOption> org$apache$pekko$stream$impl$io$FileOutputStage$$openOptions;
    private final Inlet in;

    public FileOutputStage(Path path, long startPosition, scala.collection.immutable.Set<OpenOption> openOptions) {
        this.org$apache$pekko$stream$impl$io$FileOutputStage$$path = path;
        this.org$apache$pekko$stream$impl$io$FileOutputStage$$startPosition = startPosition;
        this.org$apache$pekko$stream$impl$io$FileOutputStage$$openOptions = openOptions;
        this.in = Inlet$.MODULE$.apply("FileSink");
    }

    public Inlet<ByteString> in() {
        return this.in;
    }

    @Override
    public SinkShape<ByteString> shape() {
        return SinkShape$.MODULE$.apply(this.in());
    }

    @Override
    public Attributes initialAttributes() {
        return Stages$DefaultAttributes$.MODULE$.fileSink();
    }

    @Override
    public Tuple2<GraphStageLogic, Future<IOResult>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        Promise mat = Promise$.MODULE$.apply();
        InHandler logic = new InHandler(mat, this){
            private final Promise mat$1;
            private FileChannel chan;
            private long bytesWritten;
            private final /* synthetic */ FileOutputStage $outer;
            {
                this.mat$1 = mat$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.bytesWritten = 0L;
                this.setHandler($outer.in(), this);
            }

            public void preStart() {
                try {
                    this.chan = FileChannel.open(this.$outer.org$apache$pekko$stream$impl$io$FileOutputStage$$path, package$JavaConverters$.MODULE$.SetHasAsJava((Set)this.$outer.org$apache$pekko$stream$impl$io$FileOutputStage$$openOptions).asJava(), new FileAttribute[0]);
                    if (this.$outer.org$apache$pekko$stream$impl$io$FileOutputStage$$startPosition > 0L) {
                        this.chan.position(this.$outer.org$apache$pekko$stream$impl$io$FileOutputStage$$startPosition);
                    }
                    this.pull(this.$outer.in());
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable t = throwable3 = option.get();
                        this.closeFile(Some$.MODULE$.apply(new IOOperationIncompleteException(this.bytesWritten, t)));
                        this.failStage(t);
                    }
                    throw throwable;
                }
            }

            public void onPush() {
                ByteString next = this.grab(this.$outer.in());
                try {
                    this.bytesWritten += (long)this.chan.write(next.asByteBuffer());
                    this.pull(this.$outer.in());
                }
                catch (Throwable throwable) {
                    Option<Throwable> option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable throwable3;
                        Throwable t = throwable3 = option.get();
                        this.closeFile(Some$.MODULE$.apply(new IOOperationIncompleteException(this.bytesWritten, t)));
                        this.failStage(t);
                    }
                    throw throwable;
                }
            }

            public void onUpstreamFailure(Throwable t) {
                this.closeFile(Some$.MODULE$.apply(new IOOperationIncompleteException(this.bytesWritten, t)));
                this.failStage(t);
            }

            public void onUpstreamFinish() {
                this.closeFile(None$.MODULE$);
                this.completeStage();
            }

            public void postStop() {
                if (!this.mat$1.isCompleted()) {
                    AbruptStageTerminationException failure = new AbruptStageTerminationException(this);
                    this.closeFile(Some$.MODULE$.apply(failure));
                    this.mat$1.tryFailure(failure);
                    return;
                }
            }

            private void closeFile(Option failed) {
                block6: {
                    try {
                        Option option;
                        if (this.chan != null) {
                            this.chan.close();
                        }
                        if ((option = failed) instanceof Some) {
                            Throwable t = (Throwable)((Some)option).value();
                            this.mat$1.tryFailure(t);
                            break block6;
                        }
                        if (None$.MODULE$.equals(option)) {
                            this.mat$1.tryComplete(Success$.MODULE$.apply(IOResult$.MODULE$.apply(this.bytesWritten)));
                            break block6;
                        }
                        throw new MatchError(option);
                    }
                    catch (Throwable throwable) {
                        Option<Throwable> option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable t = throwable3 = option.get();
                            this.mat$1.tryFailure((Throwable)failed.getOrElse(() -> FileOutputStage.org$apache$pekko$stream$impl$io$FileOutputStage$$anon$1$$_$closeFile$$anonfun$1(t)));
                        }
                        throw throwable;
                    }
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$stream$impl$io$FileOutputStage$$anon$1$$_$closeFile$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        };
        return Tuple2$.MODULE$.apply(logic, mat.future());
    }

    public static final Throwable org$apache$pekko$stream$impl$io$FileOutputStage$$anon$1$$_$closeFile$$anonfun$1(Throwable t$1) {
        return t$1;
    }
}

