/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.io;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetSocketAddress;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pekko.Done$;
import org.apache.pekko.NotUsed;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Terminated;
import org.apache.pekko.actor.Terminated$;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.dispatch.ExecutionContexts$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.io.Inet;
import org.apache.pekko.io.Tcp;
import org.apache.pekko.io.Tcp$Bind$;
import org.apache.pekko.io.Tcp$Bound$;
import org.apache.pekko.io.Tcp$ResumeAccepting$;
import org.apache.pekko.io.Tcp$Unbind$;
import org.apache.pekko.io.Tcp$Unbound$;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.Attributes$;
import org.apache.pekko.stream.BindFailedException;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SourceShape;
import org.apache.pekko.stream.SourceShape$;
import org.apache.pekko.stream.SubscriptionWithCancelException;
import org.apache.pekko.stream.impl.fusing.GraphStages$;
import org.apache.pekko.stream.impl.io.ConnectionSourceStage$;
import org.apache.pekko.stream.impl.io.IncomingConnectionStage;
import org.apache.pekko.stream.impl.io.TcpIdleTimeout$;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Flow$;
import org.apache.pekko.stream.scaladsl.Tcp;
import org.apache.pekko.stream.scaladsl.Tcp$IncomingConnection$;
import org.apache.pekko.stream.scaladsl.Tcp$ServerBinding$;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.stream.stage.StageLogging;
import org.apache.pekko.util.ByteString;
import scala.Function0;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Iterable;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@InternalApi
public class ConnectionSourceStage
extends GraphStageWithMaterializedValue<SourceShape<Tcp.IncomingConnection>, Future<Tcp.ServerBinding>> {
    private final ActorRef tcpManager;
    private final InetSocketAddress endpoint;
    private final int backlog;
    private final Iterable options;
    private final boolean halfClose;
    private final Duration idleTimeout;
    private final FiniteDuration bindShutdownTimeout;
    private final Outlet out;
    private final SourceShape shape;

    public static String BindShutdownTimer() {
        return ConnectionSourceStage$.MODULE$.BindShutdownTimer();
    }

    public static String BindTimer() {
        return ConnectionSourceStage$.MODULE$.BindTimer();
    }

    public ConnectionSourceStage(ActorRef tcpManager, InetSocketAddress endpoint, int backlog, Iterable<Inet.SocketOption> options, boolean halfClose, Duration idleTimeout, FiniteDuration bindShutdownTimeout) {
        this.tcpManager = tcpManager;
        this.endpoint = endpoint;
        this.backlog = backlog;
        this.options = options;
        this.halfClose = halfClose;
        this.idleTimeout = idleTimeout;
        this.bindShutdownTimeout = bindShutdownTimeout;
        this.out = Outlet$.MODULE$.apply("IncomingConnections.out");
        this.shape = SourceShape$.MODULE$.apply(this.out());
    }

    public ActorRef tcpManager() {
        return this.tcpManager;
    }

    public InetSocketAddress endpoint() {
        return this.endpoint;
    }

    public int backlog() {
        return this.backlog;
    }

    public Iterable<Inet.SocketOption> options() {
        return this.options;
    }

    public boolean halfClose() {
        return this.halfClose;
    }

    public Duration idleTimeout() {
        return this.idleTimeout;
    }

    public FiniteDuration bindShutdownTimeout() {
        return this.bindShutdownTimeout;
    }

    public Outlet<Tcp.IncomingConnection> out() {
        return this.out;
    }

    @Override
    public Attributes initialAttributes() {
        return Attributes$.MODULE$.name("ConnectionSource");
    }

    @Override
    public SourceShape<Tcp.IncomingConnection> shape() {
        return this.shape;
    }

    @Override
    public Tuple2<GraphStageLogic, Future<Tcp.ServerBinding>> createLogicAndMaterializedValue(Attributes inheritedAttributes) {
        throw new UnsupportedOperationException("Not used");
    }

    @Override
    public Tuple2<GraphStageLogic, Future<Tcp.ServerBinding>> createLogicAndMaterializedValue(Attributes inheritedAttributes, Materializer eagerMaterialzer) {
        Promise bindingPromise = Promise$.MODULE$.apply();
        StageLogging logic = new StageLogging(bindingPromise, this){
            private final Promise bindingPromise$1;
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private final AtomicLong connectionFlowsAwaitingInitialization;
            private ActorRef listener;
            private final Promise unbindPromise;
            private boolean unbindStarted;
            private final /* synthetic */ ConnectionSourceStage $outer;
            {
                this.bindingPromise$1 = bindingPromise$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                StageLogging.$init$(this);
                this.connectionFlowsAwaitingInitialization = new AtomicLong();
                this.unbindPromise = Promise$.MODULE$.apply();
                this.unbindStarted = false;
                this.setHandler($outer.out(), new OutHandler(this){
                    private final /* synthetic */ $anon$1 $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void onPull() {
                        if (this.$outer.listener() != null) {
                            this.$outer.listener().$bang(Tcp$ResumeAccepting$.MODULE$.apply(1), this.$outer.self());
                            return;
                        }
                    }

                    public void onDownstreamFinish(Throwable cause) {
                        if (this.$outer.log().isDebugEnabled()) {
                            Throwable throwable = cause;
                            if (throwable instanceof SubscriptionWithCancelException.NonFailureCancellation) {
                                this.$outer.log().debug("Unbinding from {}:{} because downstream cancelled stream", this.$outer.org$apache$pekko$stream$impl$io$ConnectionSourceStage$_$_$$anon$$$outer().endpoint().getHostString(), BoxesRunTime.boxToInteger(this.$outer.org$apache$pekko$stream$impl$io$ConnectionSourceStage$_$_$$anon$$$outer().endpoint().getPort()));
                            } else {
                                Throwable ex = throwable;
                                this.$outer.log().debug("Unbinding from {}:{} because of downstream failure: {}", this.$outer.org$apache$pekko$stream$impl$io$ConnectionSourceStage$_$_$$anon$$$outer().endpoint().getHostString(), BoxesRunTime.boxToInteger(this.$outer.org$apache$pekko$stream$impl$io$ConnectionSourceStage$_$_$$anon$$$outer().endpoint().getPort()), ex);
                            }
                        }
                        this.$outer.org$apache$pekko$stream$impl$io$ConnectionSourceStage$$anon$1$$tryUnbind();
                    }
                });
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            public ActorRef self() {
                return this.stageActor().ref();
            }

            public AtomicLong connectionFlowsAwaitingInitialization() {
                return this.connectionFlowsAwaitingInitialization;
            }

            public ActorRef listener() {
                return this.listener;
            }

            public void listener_$eq(ActorRef x$1) {
                this.listener = x$1;
            }

            public Promise unbindPromise() {
                return this.unbindPromise;
            }

            public boolean unbindStarted() {
                return this.unbindStarted;
            }

            public void unbindStarted_$eq(boolean x$1) {
                this.unbindStarted = x$1;
            }

            public void preStart() {
                this.getStageActor(evt -> this.receive((Tuple2)evt));
                this.$outer.tcpManager().$bang(Tcp$Bind$.MODULE$.apply(this.self(), this.$outer.endpoint(), this.$outer.backlog(), this.$outer.options(), true), this.self());
            }

            private void receive(Tuple2 evt) {
                ActorRef sender = (ActorRef)evt._1();
                T2 msg = evt._2();
                T2 T2 = msg;
                if (T2 instanceof Tcp.Bound) {
                    InetSocketAddress inetSocketAddress;
                    Tcp.Bound bound = Tcp$Bound$.MODULE$.unapply((Tcp.Bound)T2);
                    InetSocketAddress localAddress = inetSocketAddress = bound._1();
                    this.listener_$eq(sender);
                    this.stageActor().watch(this.listener());
                    if (this.isAvailable(this.$outer.out())) {
                        this.listener().$bang(Tcp$ResumeAccepting$.MODULE$.apply(1), this.self());
                    }
                    ActorRef thisStage = this.self();
                    this.bindingPromise$1.success(Tcp$ServerBinding$.MODULE$.apply(localAddress, (Function0<Future<BoxedUnit>>)(Function0<Future> & Serializable)() -> {
                        if (!this.unbindPromise().isCompleted()) {
                            thisStage.tell(Tcp$Unbind$.MODULE$, thisStage);
                        }
                        return this.unbindPromise().future();
                    }, this.unbindPromise().future().map(ConnectionSourceStage::org$apache$pekko$stream$impl$io$ConnectionSourceStage$$anon$1$$_$receive$$anonfun$2, ExecutionContexts$.MODULE$.parasitic())));
                    return;
                }
                if (T2 instanceof Tcp.CommandFailed) {
                    Tcp.CommandFailed f = (Tcp.CommandFailed)T2;
                    BindFailedException ex = new BindFailedException(f){
                        private final Tcp.CommandFailed f$1;
                        {
                            this.f$1 = f$2;
                        }

                        public String getMessage() {
                            return new StringBuilder(11).append("Bind failed").append(this.f$1.causedByString()).toString();
                        }
                    };
                    f.cause().foreach(arg_0 -> ConnectionSourceStage.org$apache$pekko$stream$impl$io$ConnectionSourceStage$$anon$1$$_$receive$$anonfun$3(ex, arg_0));
                    this.bindingPromise$1.failure(ex);
                    this.unbindPromise().tryFailure(ex);
                    this.failStage(ex);
                    return;
                }
                if (T2 instanceof Tcp.Connected) {
                    Tcp.Connected c = (Tcp.Connected)T2;
                    this.push(this.$outer.out(), this.connectionFor(c, sender));
                    return;
                }
                if (Tcp$Unbind$.MODULE$.equals(T2)) {
                    if (!this.isClosed(this.$outer.out()) && this.listener() != null) {
                        this.org$apache$pekko$stream$impl$io$ConnectionSourceStage$$anon$1$$tryUnbind();
                        return;
                    }
                    return;
                }
                if (Tcp$Unbound$.MODULE$.equals(T2)) {
                    this.unbindCompleted();
                    return;
                }
                if (T2 instanceof Terminated) {
                    ActorRef actorRef;
                    ActorRef ref;
                    Terminated terminated = Terminated$.MODULE$.unapply((Terminated)T2);
                    ActorRef actorRef2 = ref = (actorRef = terminated._1());
                    ActorRef actorRef3 = this.listener();
                    if (!(actorRef2 != null ? !((Object)actorRef2).equals(actorRef3) : actorRef3 != null)) {
                        if (this.unbindStarted()) {
                            this.unbindCompleted();
                            return;
                        }
                        IllegalStateException ex = new IllegalStateException(new StringBuilder(65).append("IO Listener actor terminated unexpectedly for remote endpoint [").append(this.$outer.endpoint().getHostString()).append(":").append(this.$outer.endpoint().getPort()).append("]").toString());
                        this.unbindPromise().tryFailure(ex);
                        this.failStage(ex);
                        return;
                    }
                }
                T2 other = T2;
                this.log().warning("Unexpected message to TcpStage: [{}]", other.getClass());
            }

            private Tcp.IncomingConnection connectionFor(Tcp.Connected connected, ActorRef connection) {
                Flow<I2, O1, Mat> flow;
                this.connectionFlowsAwaitingInitialization().incrementAndGet();
                Flow<I2, O1, Mat> tcpFlow = Flow$.MODULE$.fromGraph(new IncomingConnectionStage(connection, connected.remoteAddress(), this.$outer.halfClose(), () -> this.connectionFlowsAwaitingInitialization().decrementAndGet())).via(GraphStages$.MODULE$.detacher());
                Duration duration = this.$outer.idleTimeout();
                if (duration instanceof FiniteDuration) {
                    FiniteDuration d = (FiniteDuration)duration;
                    flow = tcpFlow.join(TcpIdleTimeout$.MODULE$.apply(d, Some$.MODULE$.apply(connected.remoteAddress())));
                } else {
                    flow = tcpFlow;
                }
                Flow<I2, O1, Mat> handler = flow;
                return Tcp$IncomingConnection$.MODULE$.apply(connected.localAddress(), connected.remoteAddress(), (Flow<ByteString, ByteString, NotUsed>)handler);
            }

            public void org$apache$pekko$stream$impl$io$ConnectionSourceStage$$anon$1$$tryUnbind() {
                if (this.listener() != null && !this.unbindStarted()) {
                    this.unbindStarted_$eq(true);
                    this.setKeepGoing(true);
                    this.listener().$bang(Tcp$Unbind$.MODULE$, this.self());
                    return;
                }
            }

            private void unbindCompleted() {
                this.stageActor().unwatch(this.listener());
                this.unbindPromise().trySuccess(BoxedUnit.UNIT);
                if (this.connectionFlowsAwaitingInitialization().get() == 0L) {
                    this.completeStage();
                    return;
                }
                this.scheduleOnce((Object)ConnectionSourceStage$.MODULE$.BindShutdownTimer(), this.$outer.bindShutdownTimeout());
            }

            public void onTimer(Object timerKey) {
                Object object = timerKey;
                String string2 = ConnectionSourceStage$.MODULE$.BindShutdownTimer();
                Object object2 = object;
                if (!(string2 != null ? !string2.equals(object2) : object2 != null)) {
                    this.completeStage();
                    return;
                }
                Object other = object;
                throw new IllegalArgumentException(new StringBuilder(18).append("Unknown timer key ").append(other).toString());
            }

            public void postStop() {
                this.unbindPromise().trySuccess(BoxedUnit.UNIT);
                this.bindingPromise$1.tryFailure(new NoSuchElementException("Binding was unbound before it was completely finished"));
            }

            public final /* synthetic */ ConnectionSourceStage org$apache$pekko$stream$impl$io$ConnectionSourceStage$_$_$$anon$$$outer() {
                return this.$outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{preStart$$anonfun$1(scala.Tuple2 ), receive$$anonfun$1(org.apache.pekko.actor.ActorRef ), org$apache$pekko$stream$impl$io$ConnectionSourceStage$$anon$1$$_$receive$$anonfun$2(scala.runtime.BoxedUnit ), org$apache$pekko$stream$impl$io$ConnectionSourceStage$$anon$1$$_$receive$$anonfun$3(org.apache.pekko.stream.BindFailedException java.lang.Throwable ), $anonfun$1()}, serializedLambda);
            }
        };
        return Tuple2$.MODULE$.apply(logic, bindingPromise.future());
    }

    public static final /* synthetic */ Done$ org$apache$pekko$stream$impl$io$ConnectionSourceStage$$anon$1$$_$receive$$anonfun$2(BoxedUnit _$2) {
        return Done$.MODULE$;
    }

    public static final /* synthetic */ Throwable org$apache$pekko$stream$impl$io$ConnectionSourceStage$$anon$1$$_$receive$$anonfun$3(BindFailedException ex$1, Throwable x$0) {
        return ex$1.initCause(x$0);
    }
}

