/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.BufferOverflowException$;
import org.apache.pekko.stream.OverflowStrategies;
import org.apache.pekko.stream.OverflowStrategy;
import org.apache.pekko.stream.impl.Buffer$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.StageLogging;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

@InternalApi
public final class Buffer<T>
extends GraphStages.SimpleLinearGraphStage<T>
implements Product,
Serializable {
    private final int size;
    private final OverflowStrategy overflowStrategy;

    public static <T> Buffer<T> apply(int n, OverflowStrategy overflowStrategy) {
        return org.apache.pekko.stream.impl.fusing.Buffer$.MODULE$.apply(n, overflowStrategy);
    }

    public static Buffer<?> fromProduct(Product product) {
        return org.apache.pekko.stream.impl.fusing.Buffer$.MODULE$.fromProduct(product);
    }

    public static <T> Buffer<T> unapply(Buffer<T> buffer) {
        return org.apache.pekko.stream.impl.fusing.Buffer$.MODULE$.unapply(buffer);
    }

    public Buffer(int size, OverflowStrategy overflowStrategy) {
        this.size = size;
        this.overflowStrategy = overflowStrategy;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.productPrefix().hashCode());
        n = Statics.mix(n, this.size());
        n = Statics.mix(n, Statics.anyHash(this.overflowStrategy()));
        return Statics.finalizeHash(n, 2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Buffer)) return false;
        Buffer buffer = (Buffer)object;
        if (this.size() != buffer.size()) return false;
        OverflowStrategy overflowStrategy = this.overflowStrategy();
        OverflowStrategy overflowStrategy2 = buffer.overflowStrategy();
        if (overflowStrategy != null) {
            if (!overflowStrategy.equals(overflowStrategy2)) return false;
            return true;
        }
        if (overflowStrategy2 == null) return true;
        return false;
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return that instanceof Buffer;
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public String productPrefix() {
        return "Buffer";
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return BoxesRunTime.boxToInteger(this._1());
        }
        if (1 == n2) {
            return this._2();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "size";
        }
        if (1 == n2) {
            return "overflowStrategy";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
    }

    public int size() {
        return this.size;
    }

    public OverflowStrategy overflowStrategy() {
        return this.overflowStrategy;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(inheritedAttributes, this){
            private LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log;
            private final org.apache.pekko.stream.impl.Buffer buffer;
            private final String name;
            private final Function1 enqueueAction;
            private final /* synthetic */ Buffer $outer;
            {
                JProcedure1<Object> jProcedure1;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                StageLogging.$init$(this);
                this.buffer = Buffer$.MODULE$.apply($outer.size(), inheritedAttributes$11);
                this.name = inheritedAttributes$11.nameOrDefault(this.getClass().toString());
                OverflowStrategy overflowStrategy = $outer.overflowStrategy();
                if (overflowStrategy instanceof OverflowStrategies.DropHead) {
                    OverflowStrategies.DropHead s2 = (OverflowStrategies.DropHead)overflowStrategy;
                    jProcedure1 = elem -> {
                        if (this.buffer.isFull()) {
                            this.log().log(s2.logLevel(), "Dropping the head element because buffer is full and overflowStrategy is: [DropHead] in stream [{}]", this.name);
                            this.buffer.dropHead();
                        }
                        this.buffer.enqueue(elem);
                        this.pull($outer.in());
                    };
                } else if (overflowStrategy instanceof OverflowStrategies.DropTail) {
                    OverflowStrategies.DropTail s3 = (OverflowStrategies.DropTail)overflowStrategy;
                    jProcedure1 = elem -> {
                        if (this.buffer.isFull()) {
                            this.log().log(s3.logLevel(), "Dropping the tail element because buffer is full and overflowStrategy is: [DropTail] in stream [{}]", this.name);
                            this.buffer.dropTail();
                        }
                        this.buffer.enqueue(elem);
                        this.pull($outer.in());
                    };
                } else if (overflowStrategy instanceof OverflowStrategies.DropBuffer) {
                    OverflowStrategies.DropBuffer s4 = (OverflowStrategies.DropBuffer)overflowStrategy;
                    jProcedure1 = elem -> {
                        if (this.buffer.isFull()) {
                            this.log().log(s4.logLevel(), "Dropping all the buffered elements because buffer is full and overflowStrategy is: [DropBuffer] in stream [{}]", this.name);
                            this.buffer.clear();
                        }
                        this.buffer.enqueue(elem);
                        this.pull($outer.in());
                    };
                } else if (overflowStrategy instanceof OverflowStrategies.DropNew) {
                    OverflowStrategies.DropNew s5 = (OverflowStrategies.DropNew)overflowStrategy;
                    jProcedure1 = elem -> {
                        if (!this.buffer.isFull()) {
                            this.buffer.enqueue(elem);
                        } else {
                            this.log().log(s5.logLevel(), "Dropping the new element because buffer is full and overflowStrategy is: [DropNew] in stream [{}]", this.name);
                        }
                        this.pull($outer.in());
                    };
                } else if (overflowStrategy instanceof OverflowStrategies.Backpressure) {
                    OverflowStrategies.Backpressure s6 = (OverflowStrategies.Backpressure)overflowStrategy;
                    jProcedure1 = elem -> {
                        this.buffer.enqueue(elem);
                        if (!this.buffer.isFull()) {
                            this.pull($outer.in());
                            return;
                        }
                        this.log().log(s6.logLevel(), "Backpressuring because buffer is full and overflowStrategy is: [Backpressure] in stream [{}]", this.name);
                    };
                } else if (overflowStrategy instanceof OverflowStrategies.Fail) {
                    OverflowStrategies.Fail s7 = (OverflowStrategies.Fail)overflowStrategy;
                    jProcedure1 = elem -> {
                        if (this.buffer.isFull()) {
                            this.log().log(s7.logLevel(), "Failing because buffer is full and overflowStrategy is: [Fail] in stream [{}]", this.name);
                            this.failStage(BufferOverflowException$.MODULE$.apply(new StringBuilder(37).append("Buffer overflow (max capacity was: ").append($outer.size()).append(")!").toString()));
                            return;
                        }
                        this.buffer.enqueue(elem);
                        this.pull($outer.in());
                    };
                } else {
                    throw new MatchError(overflowStrategy);
                }
                this.enqueueAction = jProcedure1;
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public LoggingAdapter org$apache$pekko$stream$stage$StageLogging$$_log() {
                return this.org$apache$pekko$stream$stage$StageLogging$$_log;
            }

            public void org$apache$pekko$stream$stage$StageLogging$$_log_$eq(LoggingAdapter x$1) {
                this.org$apache$pekko$stream$stage$StageLogging$$_log = x$1;
            }

            public Class logSource() {
                return Buffer.class;
            }

            public Function1 enqueueAction() {
                return this.enqueueAction;
            }

            public void preStart() {
                this.pull(this.$outer.in());
            }

            public void onPush() {
                T elem = this.grab(this.$outer.in());
                if (this.isAvailable(this.$outer.out())) {
                    this.push(this.$outer.out(), elem);
                    this.pull(this.$outer.in());
                    return;
                }
                this.enqueueAction().apply(elem);
            }

            public void onPull() {
                if (this.buffer.nonEmpty()) {
                    this.push(this.$outer.out(), this.buffer.dequeue());
                }
                if (this.isClosed(this.$outer.in())) {
                    if (this.buffer.isEmpty()) {
                        this.completeStage();
                        return;
                    }
                    return;
                }
                if (!this.hasBeenPulled(this.$outer.in())) {
                    this.pull(this.$outer.in());
                    return;
                }
            }

            public void onUpstreamFinish() {
                if (this.buffer.isEmpty()) {
                    this.completeStage();
                    return;
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$init$$$anonfun$6(org.apache.pekko.stream.OverflowStrategies$DropHead org.apache.pekko.stream.impl.fusing.Buffer java.lang.Object ), $init$$$anonfun$7(org.apache.pekko.stream.OverflowStrategies$DropTail org.apache.pekko.stream.impl.fusing.Buffer java.lang.Object ), $init$$$anonfun$8(org.apache.pekko.stream.OverflowStrategies$DropBuffer org.apache.pekko.stream.impl.fusing.Buffer java.lang.Object ), $init$$$anonfun$9(org.apache.pekko.stream.OverflowStrategies$DropNew org.apache.pekko.stream.impl.fusing.Buffer java.lang.Object ), $init$$$anonfun$10(org.apache.pekko.stream.impl.fusing.Buffer org.apache.pekko.stream.OverflowStrategies$Backpressure java.lang.Object ), $init$$$anonfun$11(org.apache.pekko.stream.OverflowStrategies$Fail org.apache.pekko.stream.impl.fusing.Buffer java.lang.Object )}, serializedLambda);
            }
        };
    }

    public <T> Buffer<T> copy(int size, OverflowStrategy overflowStrategy) {
        return new Buffer<T>(size, overflowStrategy);
    }

    public int copy$default$1() {
        return this.size();
    }

    public <T> OverflowStrategy copy$default$2() {
        return this.overflowStrategy();
    }

    public int _1() {
        return this.size();
    }

    public OverflowStrategy _2() {
        return this.overflowStrategy();
    }
}

