/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl.fusing;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.pekko.actor.Actor;
import org.apache.pekko.actor.ActorContext;
import org.apache.pekko.actor.ActorLogging;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorRef$;
import org.apache.pekko.actor.DeadLetterSuppression;
import org.apache.pekko.actor.NoSerializationVerificationNeeded;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.event.Logging$;
import org.apache.pekko.event.LoggingAdapter;
import org.apache.pekko.stream.AbruptTerminationException;
import org.apache.pekko.stream.AbruptTerminationException$;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Inlet;
import org.apache.pekko.stream.Inlet$;
import org.apache.pekko.stream.Outlet;
import org.apache.pekko.stream.Outlet$;
import org.apache.pekko.stream.SubscriptionWithCancelException;
import org.apache.pekko.stream.SubscriptionWithCancelException$NoMoreElementsNeeded$;
import org.apache.pekko.stream.impl.ActorPublisher;
import org.apache.pekko.stream.impl.CancelledSubscription$;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance$;
import org.apache.pekko.stream.impl.SubFusingActorMaterializerImpl;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$BatchingActorInputBoundary$OnComplete$;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$BatchingActorInputBoundary$OnError$;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$BatchingActorInputBoundary$OnNext$;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$BatchingActorInputBoundary$OnSubscribe$;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$Cancel$;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$RequestMore$;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$Resume$;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$Snapshot$;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$SubscribePending$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter;
import org.apache.pekko.stream.impl.fusing.GraphInterpreterShell;
import org.apache.pekko.stream.snapshot.RunningInterpreter;
import org.apache.pekko.stream.snapshot.StreamSnapshotImpl$;
import org.apache.pekko.stream.snapshot.UninitializedInterpreter;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.control.NonFatal$;

@InternalApi
public final class ActorGraphInterpreter
implements Actor,
ActorLogging {
    private ActorContext context;
    private ActorRef self;
    private LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log;
    private final GraphInterpreterShell _initial;
    private Set activeInterpreters;
    private List newShells;
    private final SubFusingActorMaterializerImpl subFusingMaterializerImpl;
    public final int org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$eventLimit;
    public int org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$currentLimit;
    public ArrayDeque<Object> org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer;

    public static Props props(GraphInterpreterShell graphInterpreterShell) {
        return ActorGraphInterpreter$.MODULE$.props(graphInterpreterShell);
    }

    public ActorGraphInterpreter(GraphInterpreterShell _initial) {
        this._initial = _initial;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.activeInterpreters = Predef$.MODULE$.Set().empty();
        this.newShells = scala.package$.MODULE$.Nil();
        this.subFusingMaterializerImpl = new SubFusingActorMaterializerImpl(_initial.mat(), (Function1<GraphInterpreterShell, ActorRef> & Serializable)shell -> this.registerShell((GraphInterpreterShell)shell));
        this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$currentLimit = this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$eventLimit = ((ActorAttributes.SyncProcessingLimit)_initial.attributes().mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.SyncProcessingLimit.class))).limit();
        this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer = null;
        Statics.releaseFence();
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$context_$eq(ActorContext x$0) {
        this.context = x$0;
    }

    @Override
    public void org$apache$pekko$actor$Actor$_setter_$self_$eq(ActorRef x$0) {
        this.self = x$0;
    }

    @Override
    public LoggingAdapter org$apache$pekko$actor$ActorLogging$$_log() {
        return this.org$apache$pekko$actor$ActorLogging$$_log;
    }

    @Override
    public void org$apache$pekko$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.org$apache$pekko$actor$ActorLogging$$_log = x$1;
    }

    public Set<GraphInterpreterShell> activeInterpreters() {
        return this.activeInterpreters;
    }

    public void activeInterpreters_$eq(Set<GraphInterpreterShell> x$1) {
        this.activeInterpreters = x$1;
    }

    public List<GraphInterpreterShell> newShells() {
        return this.newShells;
    }

    public void newShells_$eq(List<GraphInterpreterShell> x$1) {
        this.newShells = x$1;
    }

    public SubFusingActorMaterializerImpl subFusingMaterializerImpl() {
        return this.subFusingMaterializerImpl;
    }

    public boolean tryInit(GraphInterpreterShell shell) {
        boolean bl;
        try {
            this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$currentLimit = shell.init(this.self(), this.subFusingMaterializerImpl(), input -> this.enqueueToShortCircuit(input), this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$currentLimit);
            if (shell.isTerminated()) {
                bl = false;
            } else {
                this.activeInterpreters_$eq((Set)this.activeInterpreters().$plus(shell));
                bl = true;
            }
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = option.get();
                this.log().error(e, "initialization of GraphInterpreterShell failed for {}", (Object)shell);
                bl = false;
            }
            throw throwable;
        }
        return bl;
    }

    public void enqueueToShortCircuit(Object input) {
        if (this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer == null) {
            this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer = new ArrayDeque();
        }
        this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer.addLast(input);
    }

    public ActorRef registerShell(GraphInterpreterShell shell) {
        this.newShells_$eq(this.newShells().$colon$colon(shell));
        this.enqueueToShortCircuit(ActorGraphInterpreter$Resume$.MODULE$);
        return this.self();
    }

    private void finishShellRegistration() {
        List<GraphInterpreterShell> list;
        block3: {
            block4: {
                while (true) {
                    list = this.newShells();
                    Nil$ nil$ = scala.package$.MODULE$.Nil();
                    List<GraphInterpreterShell> list2 = list;
                    if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) {
                        if (this.activeInterpreters().isEmpty()) {
                            this.context().stop(this.self());
                            return;
                        }
                        return;
                    }
                    if (!(list instanceof $colon$colon)) break block3;
                    $colon$colon $colon$colon = ($colon$colon)list;
                    List<GraphInterpreterShell> list3 = $colon$colon.next$access$1();
                    GraphInterpreterShell shell = (GraphInterpreterShell)$colon$colon.head();
                    List<GraphInterpreterShell> tail = list3;
                    this.newShells_$eq(tail);
                    if (shell.isInitialized()) continue;
                    if (this.tryInit(shell)) break block4;
                    if (!this.activeInterpreters().isEmpty()) break;
                }
                return;
            }
            return;
        }
        throw new MatchError(list);
    }

    @Override
    public void preStart() {
        this.tryInit(this._initial);
        if (this.activeInterpreters().isEmpty()) {
            this.context().stop(this.self());
            return;
        }
        if (this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer != null) {
            this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBatch();
            return;
        }
    }

    public void org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBatch() {
        Object object;
        while (true) {
            if (this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer.isEmpty()) {
                return;
            }
            if (this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$currentLimit == 0) {
                this.self().$bang(ActorGraphInterpreter$Resume$.MODULE$, this.self());
                return;
            }
            object = this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer.poll();
            if (object instanceof BoundaryEvent) {
                BoundaryEvent b = (BoundaryEvent)object;
                this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$processEvent(b);
                continue;
            }
            if (!ActorGraphInterpreter$Resume$.MODULE$.equals(object)) break;
            this.finishShellRegistration();
        }
        Object unexpected = object;
        throw new IllegalStateException(new StringBuilder(46).append("Unexpected element in short circuit buffer: '").append(unexpected.getClass()).append("'").toString());
    }

    public void org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$processEvent(BoundaryEvent b) {
        GraphInterpreterShell shell = b.shell();
        if (!shell.isTerminated() && (shell.isInitialized() || this.tryInit(shell))) {
            try {
                this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$currentLimit = shell.processEvent(b, this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$currentLimit);
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = option.get();
                    shell.tryAbort(e);
                }
                throw throwable;
            }
            if (shell.isTerminated()) {
                this.activeInterpreters_$eq((Set)this.activeInterpreters().$minus(shell));
                if (this.activeInterpreters().isEmpty() && this.newShells().isEmpty()) {
                    this.context().stop(this.self());
                    return;
                }
                return;
            }
            return;
        }
        b.cancel();
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            private final /* synthetic */ ActorGraphInterpreter $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof BoundaryEvent) {
                    BoundaryEvent b = (BoundaryEvent)object;
                    return true;
                }
                if (ActorGraphInterpreter$Resume$.MODULE$.equals(object)) {
                    return true;
                }
                return ActorGraphInterpreter$Snapshot$.MODULE$.equals(object);
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof BoundaryEvent) {
                    BoundaryEvent b = (BoundaryEvent)object;
                    this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$currentLimit = this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$eventLimit;
                    this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$processEvent(b);
                    if (this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer != null) {
                        this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBatch();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (ActorGraphInterpreter$Resume$.MODULE$.equals(object)) {
                    this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$currentLimit = this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$eventLimit;
                    if (this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer != null) {
                        this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBatch();
                        return BoxedUnit.UNIT;
                    }
                    return BoxedUnit.UNIT;
                }
                if (ActorGraphInterpreter$Snapshot$.MODULE$.equals(object)) {
                    this.$outer.sender().$bang(StreamSnapshotImpl$.MODULE$.apply(this.$outer.self().path(), ((IterableOnceOps)this.$outer.activeInterpreters().map(ActorGraphInterpreter::org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$anon$2$$_$applyOrElse$$anonfun$1)).toSeq(), (Seq<UninitializedInterpreter>)this.$outer.newShells().map(ActorGraphInterpreter::org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$anon$2$$_$applyOrElse$$anonfun$2)), this.$outer.self());
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$anon$2$$_$applyOrElse$$anonfun$1(org.apache.pekko.stream.impl.fusing.GraphInterpreterShell ), org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$anon$2$$_$applyOrElse$$anonfun$2(org.apache.pekko.stream.impl.fusing.GraphInterpreterShell )}, serializedLambda);
            }
        };
    }

    @Override
    public void postStop() {
        if (this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer != null) {
            while (!this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer.isEmpty()) {
                Object object = this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$shortCircuitBuffer.poll();
                if (!(object instanceof BoundaryEvent)) continue;
                BoundaryEvent b = (BoundaryEvent)object;
                b.cancel();
            }
        }
        if (this.activeInterpreters().nonEmpty() || this.newShells().nonEmpty()) {
            AbruptTerminationException ex = AbruptTerminationException$.MODULE$.apply(this.self());
            this.activeInterpreters().foreach(_$8 -> _$8.tryAbort(ex));
            this.activeInterpreters_$eq((Set<GraphInterpreterShell>)Predef$.MODULE$.Set().empty());
            this.newShells().foreach(s2 -> {
                if (this.tryInit((GraphInterpreterShell)s2)) {
                    s2.tryAbort(ex);
                    return;
                }
            });
            return;
        }
    }

    public static final /* synthetic */ RunningInterpreter org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$anon$2$$_$applyOrElse$$anonfun$1(GraphInterpreterShell shell) {
        return (RunningInterpreter)shell.toSnapshot();
    }

    public static final /* synthetic */ UninitializedInterpreter org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$$anon$2$$_$applyOrElse$$anonfun$2(GraphInterpreterShell shell) {
        return (UninitializedInterpreter)shell.toSnapshot();
    }

    public static class ActorOutputBoundary
    extends GraphInterpreter.DownstreamBoundaryStageLogic<Object>
    implements InHandler {
        private final GraphInterpreterShell shell;
        private final String internalPortName;
        private final Inlet in;
        private final OutputBoundaryPublisher publisher;
        public volatile ActorRef org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$ActorOutputBoundary$$actor;
        private Subscriber<Object> subscriber;
        private long downstreamDemand;
        private Option<Throwable> downstreamCompletionCause;
        private boolean upstreamCompleted;

        public ActorOutputBoundary(GraphInterpreterShell shell, String internalPortName) {
            this.shell = shell;
            this.internalPortName = internalPortName;
            this.in = Inlet$.MODULE$.apply(new StringBuilder(17).append("UpstreamBoundary:").append(internalPortName).toString());
            this.in().id_$eq(0);
            this.publisher = new OutputBoundaryPublisher(this, internalPortName);
            this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$ActorOutputBoundary$$actor = null;
            this.downstreamDemand = 0L;
            this.downstreamCompletionCause = None$.MODULE$;
            this.upstreamCompleted = false;
            this.setHandler(this.in(), this);
        }

        public GraphInterpreterShell shell() {
            return this.shell;
        }

        public String internalPortName() {
            return this.internalPortName;
        }

        @Override
        public Inlet<Object> in() {
            return this.in;
        }

        public OutputBoundaryPublisher publisher() {
            return this.publisher;
        }

        public void setActor(ActorRef actor) {
            this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$ActorOutputBoundary$$actor = actor;
        }

        public ActorRef getActor() {
            return this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$ActorOutputBoundary$$actor;
        }

        public boolean downstreamCompleted() {
            return this.downstreamCompletionCause.isDefined();
        }

        private void onNext(Object elem) {
            --this.downstreamDemand;
            ReactiveStreamsCompliance$.MODULE$.tryOnNext(this.subscriber, elem);
        }

        private void complete() {
            if (!this.upstreamCompleted && !this.downstreamCompleted()) {
                this.upstreamCompleted = true;
                this.publisher().shutdown(None$.MODULE$);
                if (this.subscriber != null) {
                    ReactiveStreamsCompliance$.MODULE$.tryOnComplete(this.subscriber);
                    return;
                }
                return;
            }
        }

        public void fail(Throwable e) {
            if (!this.downstreamCompleted() && !this.upstreamCompleted) {
                this.upstreamCompleted = true;
                this.publisher().shutdown(Some$.MODULE$.apply(e));
                if (this.subscriber != null && !(e instanceof ReactiveStreamsCompliance.SpecViolation)) {
                    ReactiveStreamsCompliance$.MODULE$.tryOnError(this.subscriber, e);
                    return;
                }
                return;
            }
        }

        @Override
        public void onPush() {
            try {
                this.onNext(this.grab(this.in()));
                if (this.downstreamCompleted()) {
                    this.cancel(this.in(), this.downstreamCompletionCause.get());
                } else if (this.downstreamDemand > 0L) {
                    this.pull(this.in());
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ReactiveStreamsCompliance.SpecViolation) {
                    ReactiveStreamsCompliance.SpecViolation s2 = (ReactiveStreamsCompliance.SpecViolation)((Object)throwable2);
                    this.shell().tryAbort((Throwable)((Object)s2));
                }
                throw throwable;
            }
        }

        @Override
        public void onUpstreamFinish() {
            try {
                this.complete();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ReactiveStreamsCompliance.SpecViolation) {
                    ReactiveStreamsCompliance.SpecViolation s2 = (ReactiveStreamsCompliance.SpecViolation)((Object)throwable2);
                    this.shell().tryAbort((Throwable)((Object)s2));
                }
                throw throwable;
            }
        }

        @Override
        public void onUpstreamFailure(Throwable cause) {
            try {
                this.fail(cause);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ReactiveStreamsCompliance.SpecViolation) {
                    ReactiveStreamsCompliance.SpecViolation s2 = (ReactiveStreamsCompliance.SpecViolation)((Object)throwable2);
                    this.shell().tryAbort((Throwable)((Object)s2));
                }
                throw throwable;
            }
        }

        public void subscribePending() {
            this.publisher().takePendingSubscribers().foreach(sub -> {
                if (this.subscriber == null) {
                    this.subscriber = sub;
                    SubscriptionWithCancelException subscription = new SubscriptionWithCancelException(this){
                        private final /* synthetic */ ActorOutputBoundary $outer;
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }

                        public void request(long elements) {
                            ActorRef actorRef = this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$ActorOutputBoundary$$actor;
                            RequestMore requestMore = ActorGraphInterpreter$RequestMore$.MODULE$.apply(this.$outer, elements);
                            actorRef.$bang(requestMore, actorRef.$bang$default$2(requestMore));
                        }

                        public void cancel(Throwable cause) {
                            ActorRef actorRef = this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$ActorOutputBoundary$$actor;
                            Cancel cancel = ActorGraphInterpreter$Cancel$.MODULE$.apply(this.$outer, cause);
                            actorRef.$bang(cancel, actorRef.$bang$default$2(cancel));
                        }

                        public String toString() {
                            return new StringBuilder(24).append("BoundarySubscription[").append(this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$ActorOutputBoundary$$actor).append(", ").append(this.$outer.internalPortName()).append("]").toString();
                        }
                    };
                    ReactiveStreamsCompliance$.MODULE$.tryOnSubscribe(this.subscriber, subscription);
                    return;
                }
                ReactiveStreamsCompliance$.MODULE$.rejectAdditionalSubscriber(this.subscriber, String.valueOf(Logging$.MODULE$.simpleName(this)));
            });
        }

        public void requestMore(long elements) {
            if (elements < 1L) {
                this.cancel(this.in(), ReactiveStreamsCompliance$.MODULE$.numberOfElementsInRequestMustBePositiveException());
                this.fail(ReactiveStreamsCompliance$.MODULE$.numberOfElementsInRequestMustBePositiveException());
                return;
            }
            this.downstreamDemand += elements;
            if (this.downstreamDemand < 0L) {
                this.downstreamDemand = Long.MAX_VALUE;
            }
            if (!this.hasBeenPulled(this.in()) && !this.isClosed(this.in())) {
                this.pull(this.in());
                return;
            }
        }

        public void cancel(Throwable cause) {
            this.downstreamCompletionCause = Some$.MODULE$.apply(cause);
            this.subscriber = null;
            this.publisher().shutdown(Some$.MODULE$.apply(new ActorPublisher.NormalShutdownException()));
            this.cancel(this.in(), cause);
        }

        @Override
        public String toString() {
            return new StringBuilder(46).append("ActorOutputBoundary(port=").append(this.internalPortName()).append(", demand=").append(this.downstreamDemand).append(", finished=").append(this.downstreamCompleted()).append(")").toString();
        }
    }

    @InternalStableApi
    public static class BatchingActorInputBoundary
    extends GraphInterpreter.UpstreamBoundaryStageLogic<Object>
    implements OutHandler {
        private final int size;
        public final GraphInterpreterShell org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$shell;
        private final Publisher<Object> publisher;
        private final String internalPortName;
        public final ActorGraphInterpreter$BatchingActorInputBoundary$OnError$ OnError$lzy1;
        public final ActorGraphInterpreter$BatchingActorInputBoundary$OnComplete$ OnComplete$lzy1;
        public final ActorGraphInterpreter$BatchingActorInputBoundary$OnNext$ OnNext$lzy1;
        public final ActorGraphInterpreter$BatchingActorInputBoundary$OnSubscribe$ OnSubscribe$lzy1;
        public ActorRef org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$actor;
        private Subscription upstream;
        private final Object[] inputBuffer;
        private int inputBufferElements;
        private int nextInputElementCursor;
        private boolean upstreamCompleted;
        private Option<Throwable> downstreamCanceled;
        private final int IndexMask;
        private int batchRemaining;
        private final Outlet out;

        public BatchingActorInputBoundary(int size, GraphInterpreterShell shell, Publisher<Object> publisher, String internalPortName) {
            this.size = size;
            this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$shell = shell;
            this.publisher = publisher;
            this.internalPortName = internalPortName;
            this.OnError$lzy1 = new ActorGraphInterpreter$BatchingActorInputBoundary$OnError$(this);
            this.OnComplete$lzy1 = new ActorGraphInterpreter$BatchingActorInputBoundary$OnComplete$(this);
            this.OnNext$lzy1 = new ActorGraphInterpreter$BatchingActorInputBoundary$OnNext$(this);
            this.OnSubscribe$lzy1 = new ActorGraphInterpreter$BatchingActorInputBoundary$OnSubscribe$(this);
            if (size <= 0) {
                throw new IllegalArgumentException("buffer size cannot be zero");
            }
            if ((size & size - 1) != 0) {
                throw new IllegalArgumentException("buffer size must be a power of two");
            }
            this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$actor = ActorRef$.MODULE$.noSender();
            this.inputBuffer = new Object[size];
            this.inputBufferElements = 0;
            this.nextInputElementCursor = 0;
            this.upstreamCompleted = false;
            this.downstreamCanceled = None$.MODULE$;
            this.IndexMask = size - 1;
            this.batchRemaining = this.requestBatchSize();
            this.out = Outlet$.MODULE$.apply(new StringBuilder(17).append("UpstreamBoundary:").append(internalPortName).toString());
            this.out().id_$eq(0);
            this.setHandler(this.out(), this);
        }

        public final ActorGraphInterpreter$BatchingActorInputBoundary$OnError$ OnError() {
            return this.OnError$lzy1;
        }

        public final ActorGraphInterpreter$BatchingActorInputBoundary$OnComplete$ OnComplete() {
            return this.OnComplete$lzy1;
        }

        public final ActorGraphInterpreter$BatchingActorInputBoundary$OnNext$ OnNext() {
            return this.OnNext$lzy1;
        }

        public final ActorGraphInterpreter$BatchingActorInputBoundary$OnSubscribe$ OnSubscribe() {
            return this.OnSubscribe$lzy1;
        }

        private int requestBatchSize() {
            return package$.MODULE$.max(1, this.inputBuffer.length / 2);
        }

        @Override
        public Outlet<Object> out() {
            return this.out;
        }

        public void setActor(ActorRef actor) {
            this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$actor = actor;
        }

        @Override
        public void preStart() {
            this.publisher.subscribe(new Subscriber<Object>(this){
                private final /* synthetic */ BatchingActorInputBoundary $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void onError(Throwable t) {
                    ReactiveStreamsCompliance$.MODULE$.requireNonNullException(t);
                    ActorRef actorRef = this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$actor;
                    OnError onError2 = this.$outer.OnError().apply(this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$shell, t);
                    actorRef.$bang(onError2, actorRef.$bang$default$2(onError2));
                }

                public void onSubscribe(Subscription s2) {
                    ReactiveStreamsCompliance$.MODULE$.requireNonNullSubscription(s2);
                    ActorRef actorRef = this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$actor;
                    OnSubscribe onSubscribe = this.$outer.OnSubscribe().apply(this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$shell, s2);
                    actorRef.$bang(onSubscribe, actorRef.$bang$default$2(onSubscribe));
                }

                public void onComplete() {
                    ActorRef actorRef = this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$actor;
                    OnComplete onComplete = this.$outer.OnComplete().apply(this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$shell);
                    actorRef.$bang(onComplete, actorRef.$bang$default$2(onComplete));
                }

                public void onNext(Object t) {
                    ReactiveStreamsCompliance$.MODULE$.requireNonNullElement(t);
                    ActorRef actorRef = this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$actor;
                    OnNext onNext = this.$outer.OnNext().apply(this.$outer.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$shell, t);
                    actorRef.$bang(onNext, actorRef.$bang$default$2(onNext));
                }
            });
        }

        @InternalStableApi
        private Object dequeue() {
            Object elem = this.inputBuffer[this.nextInputElementCursor];
            if (elem == null) {
                throw new IllegalArgumentException("Internal queue must never contain a null");
            }
            this.inputBuffer[this.nextInputElementCursor] = null;
            --this.batchRemaining;
            if (this.batchRemaining == 0 && !this.upstreamCompleted) {
                ReactiveStreamsCompliance$.MODULE$.tryRequest(this.upstream, Int$.MODULE$.int2long(this.requestBatchSize()));
                this.batchRemaining = this.requestBatchSize();
            }
            --this.inputBufferElements;
            this.nextInputElementCursor = this.nextInputElementCursor + 1 & this.IndexMask;
            return elem;
        }

        @InternalStableApi
        private void clear() {
            Arrays.fill(this.inputBuffer, 0, this.inputBuffer.length, null);
            this.inputBufferElements = 0;
        }

        public void cancel(Throwable cause) {
            this.downstreamCanceled = Some$.MODULE$.apply(cause);
            if (!this.upstreamCompleted) {
                this.upstreamCompleted = true;
                if (this.upstream != null) {
                    ReactiveStreamsCompliance$.MODULE$.tryCancel(this.upstream, cause);
                }
                this.clear();
                return;
            }
        }

        @InternalStableApi
        public void onNext(Object elem) {
            if (!this.upstreamCompleted) {
                if (this.inputBufferElements == this.size) {
                    throw new IllegalStateException("Input buffer overrun");
                }
                this.inputBuffer[this.nextInputElementCursor + this.inputBufferElements & this.IndexMask] = elem;
                ++this.inputBufferElements;
                if (this.isAvailable(this.out())) {
                    this.push(this.out(), this.dequeue());
                    return;
                }
                return;
            }
        }

        public void onError(Throwable e) {
            if (!this.upstreamCompleted || this.downstreamCanceled.isEmpty()) {
                this.upstreamCompleted = true;
                this.clear();
                this.fail(this.out(), e);
                return;
            }
        }

        public void onInternalError(Throwable e) {
            if (!this.upstreamCompleted && !this.downstreamCanceled.isDefined() && this.upstream != null) {
                this.upstream.cancel();
            }
            if (!this.isClosed(this.out())) {
                this.onError(e);
                return;
            }
        }

        public void onComplete() {
            if (!this.upstreamCompleted) {
                this.upstreamCompleted = true;
                if (this.inputBufferElements == 0) {
                    this.complete(this.out());
                    return;
                }
                return;
            }
        }

        public void onSubscribe(Subscription subscription) {
            ReactiveStreamsCompliance$.MODULE$.requireNonNullSubscription(subscription);
            if (this.downstreamCanceled.isDefined()) {
                this.upstreamCompleted = true;
                ReactiveStreamsCompliance$.MODULE$.tryCancel(subscription, this.downstreamCanceled.get());
                return;
            }
            if (this.upstreamCompleted) {
                ReactiveStreamsCompliance$.MODULE$.tryCancel(subscription, SubscriptionWithCancelException$NoMoreElementsNeeded$.MODULE$);
                return;
            }
            if (this.upstream != null) {
                ReactiveStreamsCompliance$.MODULE$.tryCancel(subscription, new IllegalStateException("Publisher can only be subscribed once."));
                return;
            }
            this.upstream = subscription;
            ReactiveStreamsCompliance$.MODULE$.tryRequest(this.upstream, Int$.MODULE$.int2long(this.inputBuffer.length));
        }

        @Override
        public void onPull() {
            try {
                if (this.inputBufferElements > 1) {
                    this.push(this.out(), this.dequeue());
                } else if (this.inputBufferElements == 1) {
                    if (this.upstreamCompleted) {
                        this.push(this.out(), this.dequeue());
                        this.complete(this.out());
                    } else {
                        this.push(this.out(), this.dequeue());
                    }
                } else if (this.upstreamCompleted) {
                    this.complete(this.out());
                }
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ReactiveStreamsCompliance.SpecViolation) {
                    ReactiveStreamsCompliance.SpecViolation s2 = (ReactiveStreamsCompliance.SpecViolation)((Object)throwable2);
                    this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$shell.tryAbort((Throwable)((Object)s2));
                }
                throw throwable;
            }
        }

        @Override
        public void onDownstreamFinish(Throwable cause) {
            try {
                this.cancel(cause);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ReactiveStreamsCompliance.SpecViolation) {
                    ReactiveStreamsCompliance.SpecViolation s2 = (ReactiveStreamsCompliance.SpecViolation)((Object)throwable2);
                    this.org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$$shell.tryAbort((Throwable)((Object)s2));
                }
                throw throwable;
            }
        }

        @Override
        public String toString() {
            return new StringBuilder(67).append("BatchingActorInputBoundary(forPort=").append(this.internalPortName).append(", fill=").append(this.inputBufferElements).append("/").append(this.size).append(", completed=").append(this.upstreamCompleted).append(", canceled=").append(this.downstreamCanceled).append(")").toString();
        }

        public class OnComplete
        implements SimpleBoundaryEvent,
        Product,
        Serializable {
            private final GraphInterpreterShell shell;
            private final /* synthetic */ BatchingActorInputBoundary $outer;

            public OnComplete(BatchingActorInputBoundary $outer, GraphInterpreterShell shell) {
                this.shell = shell;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode(this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof OnComplete)) return false;
                if (((OnComplete)object).org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$OnComplete$$$outer() != this.$outer) return false;
                OnComplete onComplete = (OnComplete)object;
                GraphInterpreterShell graphInterpreterShell = this.shell();
                GraphInterpreterShell graphInterpreterShell2 = onComplete.shell();
                if (graphInterpreterShell == null) {
                    if (graphInterpreterShell2 != null) {
                        return false;
                    }
                } else if (!graphInterpreterShell.equals(graphInterpreterShell2)) return false;
                if (!onComplete.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString(this);
            }

            @Override
            public boolean canEqual(Object that) {
                return that instanceof OnComplete;
            }

            @Override
            public int productArity() {
                return 1;
            }

            @Override
            public String productPrefix() {
                return "OnComplete";
            }

            @Override
            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "shell";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public GraphInterpreterShell shell() {
                return this.shell;
            }

            @Override
            public void execute() {
                this.$outer.onComplete();
            }

            @Override
            public GraphStageLogic logic() {
                return this.$outer;
            }

            @Override
            public void cancel() {
            }

            public OnComplete copy(GraphInterpreterShell shell) {
                return new OnComplete(this.$outer, shell);
            }

            public GraphInterpreterShell copy$default$1() {
                return this.shell();
            }

            public GraphInterpreterShell _1() {
                return this.shell();
            }

            public final /* synthetic */ BatchingActorInputBoundary org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$OnComplete$$$outer() {
                return this.$outer;
            }
        }

        public class OnError
        implements SimpleBoundaryEvent,
        Product,
        Serializable {
            private final GraphInterpreterShell shell;
            private final Throwable cause;
            private final /* synthetic */ BatchingActorInputBoundary $outer;

            public OnError(BatchingActorInputBoundary $outer, GraphInterpreterShell shell, Throwable cause) {
                this.shell = shell;
                this.cause = cause;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode(this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof OnError)) return false;
                if (((OnError)object).org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$OnError$$$outer() != this.$outer) return false;
                OnError onError2 = (OnError)object;
                GraphInterpreterShell graphInterpreterShell = this.shell();
                GraphInterpreterShell graphInterpreterShell2 = onError2.shell();
                if (graphInterpreterShell == null) {
                    if (graphInterpreterShell2 != null) {
                        return false;
                    }
                } else if (!graphInterpreterShell.equals(graphInterpreterShell2)) return false;
                Throwable throwable = this.cause();
                Throwable throwable2 = onError2.cause();
                if (throwable == null) {
                    if (throwable2 != null) {
                        return false;
                    }
                } else if (!throwable.equals(throwable2)) return false;
                if (!onError2.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString(this);
            }

            @Override
            public boolean canEqual(Object that) {
                return that instanceof OnError;
            }

            @Override
            public int productArity() {
                return 2;
            }

            @Override
            public String productPrefix() {
                return "OnError";
            }

            @Override
            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "shell";
                }
                if (1 == n2) {
                    return "cause";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public GraphInterpreterShell shell() {
                return this.shell;
            }

            public Throwable cause() {
                return this.cause;
            }

            @Override
            public void execute() {
                this.$outer.onError(this.cause());
            }

            @Override
            public GraphStageLogic logic() {
                return this.$outer;
            }

            @Override
            public void cancel() {
            }

            public OnError copy(GraphInterpreterShell shell, Throwable cause) {
                return new OnError(this.$outer, shell, cause);
            }

            public GraphInterpreterShell copy$default$1() {
                return this.shell();
            }

            public Throwable copy$default$2() {
                return this.cause();
            }

            public GraphInterpreterShell _1() {
                return this.shell();
            }

            public Throwable _2() {
                return this.cause();
            }

            public final /* synthetic */ BatchingActorInputBoundary org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$OnError$$$outer() {
                return this.$outer;
            }
        }

        public class OnNext
        implements SimpleBoundaryEvent,
        Product,
        Serializable {
            private final GraphInterpreterShell shell;
            private final Object e;
            private final /* synthetic */ BatchingActorInputBoundary $outer;

            public OnNext(BatchingActorInputBoundary $outer, GraphInterpreterShell shell, Object e) {
                this.shell = shell;
                this.e = e;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode(this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof OnNext)) return false;
                if (((OnNext)object).org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$OnNext$$$outer() != this.$outer) return false;
                OnNext onNext = (OnNext)object;
                GraphInterpreterShell graphInterpreterShell = this.shell();
                GraphInterpreterShell graphInterpreterShell2 = onNext.shell();
                if (graphInterpreterShell == null) {
                    if (graphInterpreterShell2 != null) {
                        return false;
                    }
                } else if (!graphInterpreterShell.equals(graphInterpreterShell2)) return false;
                if (!BoxesRunTime.equals(this.e(), onNext.e())) return false;
                if (!onNext.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString(this);
            }

            @Override
            public boolean canEqual(Object that) {
                return that instanceof OnNext;
            }

            @Override
            public int productArity() {
                return 2;
            }

            @Override
            public String productPrefix() {
                return "OnNext";
            }

            @Override
            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "shell";
                }
                if (1 == n2) {
                    return "e";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public GraphInterpreterShell shell() {
                return this.shell;
            }

            public Object e() {
                return this.e;
            }

            @Override
            public void execute() {
                this.$outer.onNext(this.e());
            }

            @Override
            public GraphStageLogic logic() {
                return this.$outer;
            }

            @Override
            public void cancel() {
            }

            public OnNext copy(GraphInterpreterShell shell, Object e) {
                return new OnNext(this.$outer, shell, e);
            }

            public GraphInterpreterShell copy$default$1() {
                return this.shell();
            }

            public Object copy$default$2() {
                return this.e();
            }

            public GraphInterpreterShell _1() {
                return this.shell();
            }

            public Object _2() {
                return this.e();
            }

            public final /* synthetic */ BatchingActorInputBoundary org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$OnNext$$$outer() {
                return this.$outer;
            }
        }

        public class OnSubscribe
        implements SimpleBoundaryEvent,
        Product,
        Serializable {
            private final GraphInterpreterShell shell;
            private final Subscription subscription;
            private final /* synthetic */ BatchingActorInputBoundary $outer;

            public OnSubscribe(BatchingActorInputBoundary $outer, GraphInterpreterShell shell, Subscription subscription) {
                this.shell = shell;
                this.subscription = subscription;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                return ScalaRunTime$.MODULE$._hashCode(this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof OnSubscribe)) return false;
                if (((OnSubscribe)object).org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$OnSubscribe$$$outer() != this.$outer) return false;
                OnSubscribe onSubscribe = (OnSubscribe)object;
                GraphInterpreterShell graphInterpreterShell = this.shell();
                GraphInterpreterShell graphInterpreterShell2 = onSubscribe.shell();
                if (graphInterpreterShell == null) {
                    if (graphInterpreterShell2 != null) {
                        return false;
                    }
                } else if (!graphInterpreterShell.equals(graphInterpreterShell2)) return false;
                Subscription subscription = this.subscription();
                Subscription subscription2 = onSubscribe.subscription();
                if (subscription == null) {
                    if (subscription2 != null) {
                        return false;
                    }
                } else if (!subscription.equals(subscription2)) return false;
                if (!onSubscribe.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString(this);
            }

            @Override
            public boolean canEqual(Object that) {
                return that instanceof OnSubscribe;
            }

            @Override
            public int productArity() {
                return 2;
            }

            @Override
            public String productPrefix() {
                return "OnSubscribe";
            }

            @Override
            public Object productElement(int n) {
                int n2 = n;
                if (0 == n2) {
                    return this._1();
                }
                if (1 == n2) {
                    return this._2();
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public String productElementName(int n) {
                int n2 = n;
                if (0 == n2) {
                    return "shell";
                }
                if (1 == n2) {
                    return "subscription";
                }
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }

            @Override
            public GraphInterpreterShell shell() {
                return this.shell;
            }

            public Subscription subscription() {
                return this.subscription;
            }

            @Override
            public void execute() {
                this.shell().subscribeArrived();
                this.$outer.onSubscribe(this.subscription());
            }

            @Override
            public GraphStageLogic logic() {
                return this.$outer;
            }

            @Override
            public void cancel() {
            }

            public OnSubscribe copy(GraphInterpreterShell shell, Subscription subscription) {
                return new OnSubscribe(this.$outer, shell, subscription);
            }

            public GraphInterpreterShell copy$default$1() {
                return this.shell();
            }

            public Subscription copy$default$2() {
                return this.subscription();
            }

            public GraphInterpreterShell _1() {
                return this.shell();
            }

            public Subscription _2() {
                return this.subscription();
            }

            public final /* synthetic */ BatchingActorInputBoundary org$apache$pekko$stream$impl$fusing$ActorGraphInterpreter$BatchingActorInputBoundary$OnSubscribe$$$outer() {
                return this.$outer;
            }
        }
    }

    public static interface BoundaryEvent
    extends DeadLetterSuppression,
    NoSerializationVerificationNeeded {
        public GraphInterpreterShell shell();

        @InternalStableApi
        public int execute(int var1);

        @InternalStableApi
        public void cancel();
    }

    public static final class Cancel
    implements SimpleBoundaryEvent,
    Product,
    Serializable {
        private final ActorOutputBoundary boundary;
        private final Throwable cause;

        public static Cancel apply(ActorOutputBoundary actorOutputBoundary, Throwable throwable) {
            return ActorGraphInterpreter$Cancel$.MODULE$.apply(actorOutputBoundary, throwable);
        }

        public static Cancel fromProduct(Product product) {
            return ActorGraphInterpreter$Cancel$.MODULE$.fromProduct(product);
        }

        public static Cancel unapply(Cancel cancel) {
            return ActorGraphInterpreter$Cancel$.MODULE$.unapply(cancel);
        }

        public Cancel(ActorOutputBoundary boundary2, Throwable cause) {
            this.boundary = boundary2;
            this.cause = cause;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Cancel)) return false;
            Cancel cancel = (Cancel)object;
            ActorOutputBoundary actorOutputBoundary = this.boundary();
            ActorOutputBoundary actorOutputBoundary2 = cancel.boundary();
            if (actorOutputBoundary == null) {
                if (actorOutputBoundary2 != null) {
                    return false;
                }
            } else if (!actorOutputBoundary.equals(actorOutputBoundary2)) return false;
            Throwable throwable = this.cause();
            Throwable throwable2 = cancel.cause();
            if (throwable == null) {
                if (throwable2 == null) return true;
                return false;
            } else {
                if (!throwable.equals(throwable2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Cancel;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "Cancel";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "boundary";
            }
            if (1 == n2) {
                return "cause";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorOutputBoundary boundary() {
            return this.boundary;
        }

        public Throwable cause() {
            return this.cause;
        }

        @Override
        public void execute() {
            this.boundary().cancel(this.cause());
        }

        @Override
        public GraphInterpreterShell shell() {
            return this.boundary().shell();
        }

        @Override
        public GraphStageLogic logic() {
            return this.boundary();
        }

        @Override
        public void cancel() {
        }

        public Cancel copy(ActorOutputBoundary boundary2, Throwable cause) {
            return new Cancel(boundary2, cause);
        }

        public ActorOutputBoundary copy$default$1() {
            return this.boundary();
        }

        public Throwable copy$default$2() {
            return this.cause();
        }

        public ActorOutputBoundary _1() {
            return this.boundary();
        }

        public Throwable _2() {
            return this.cause();
        }
    }

    public static class OutputBoundaryPublisher
    implements Publisher<Object> {
        private final ActorOutputBoundary boundary;
        private final String internalPortName;
        private final AtomicReference<Seq<Subscriber<Object>>> pendingSubscribers;
        private final Object wakeUpMsg;
        private volatile Throwable shutdownReason;

        public OutputBoundaryPublisher(ActorOutputBoundary boundary2, String internalPortName) {
            this.boundary = boundary2;
            this.internalPortName = internalPortName;
            this.pendingSubscribers = new AtomicReference<Nil$>(scala.package$.MODULE$.Nil());
            this.wakeUpMsg = ActorGraphInterpreter$SubscribePending$.MODULE$.apply(boundary2);
            OptionVal$.MODULE$.None();
            this.shutdownReason = null;
        }

        public Object wakeUpMsg() {
            return this.wakeUpMsg;
        }

        @Override
        public void subscribe(Subscriber<? super Object> subscriber) {
            ReactiveStreamsCompliance$.MODULE$.requireNonNullSubscriber(subscriber);
            this.doSubscribe$1(subscriber);
        }

        public Seq<Subscriber<Object>> takePendingSubscribers() {
            Seq<Subscriber<Object>> pending = this.pendingSubscribers.getAndSet(scala.package$.MODULE$.Nil());
            if (pending == null) {
                return scala.package$.MODULE$.Nil();
            }
            return (Seq)pending.reverse();
        }

        public void shutdown(Option<Throwable> reason) {
            this.shutdownReason = (Throwable)OptionVal$.MODULE$.apply(reason.orNull($less$colon$less$.MODULE$.refl()));
            Seq seq = this.pendingSubscribers.getAndSet(null);
            if (seq == null) {
                return;
            }
            Seq pending = seq;
            pending.foreach(subscriber -> this.reportSubscribeFailure((Subscriber<Object>)subscriber));
        }

        private void reportSubscribeFailure(Subscriber<Object> subscriber) {
            block5: {
                try {
                    Throwable throwable = this.shutdownReason;
                    Throwable throwable2 = (Throwable)OptionVal$Some$.MODULE$.unapply(throwable);
                    if (!OptionVal$.MODULE$.isEmpty$extension(throwable2)) {
                        Throwable throwable3 = (Throwable)OptionVal$.MODULE$.get$extension(throwable2);
                        Throwable throwable4 = throwable3;
                        if (!(throwable4 instanceof ReactiveStreamsCompliance.SpecViolation)) {
                            Throwable e = throwable4;
                            ReactiveStreamsCompliance$.MODULE$.tryOnSubscribe(subscriber, CancelledSubscription$.MODULE$);
                            ReactiveStreamsCompliance$.MODULE$.tryOnError(subscriber, e);
                        }
                    } else {
                        ReactiveStreamsCompliance$.MODULE$.tryOnSubscribe(subscriber, CancelledSubscription$.MODULE$);
                        ReactiveStreamsCompliance$.MODULE$.tryOnComplete(subscriber);
                    }
                }
                catch (Throwable throwable) {
                    Throwable throwable5 = throwable;
                    if (throwable5 instanceof ReactiveStreamsCompliance.SpecViolation) break block5;
                    throw throwable;
                }
            }
        }

        public String toString() {
            return new StringBuilder(11).append("Publisher[").append(this.internalPortName).append("]").toString();
        }

        private final void doSubscribe$1(Subscriber subscriber$1) {
            Seq<Subscriber<Object>> current;
            do {
                if ((current = this.pendingSubscribers.get()) != null) continue;
                this.reportSubscribeFailure(subscriber$1);
                return;
            } while (!this.pendingSubscribers.compareAndSet(current, (Seq<Subscriber<Object>>)current.$plus$colon(subscriber$1)));
            if (this.boundary.getActor() != null) {
                ActorRef actorRef = this.boundary.getActor();
                actorRef.$bang(this.wakeUpMsg(), actorRef.$bang$default$2(this.wakeUpMsg()));
                return;
            }
        }
    }

    public static final class RequestMore
    implements SimpleBoundaryEvent,
    Product,
    Serializable {
        private final ActorOutputBoundary boundary;
        private final long demand;

        public static RequestMore apply(ActorOutputBoundary actorOutputBoundary, long l) {
            return ActorGraphInterpreter$RequestMore$.MODULE$.apply(actorOutputBoundary, l);
        }

        public static RequestMore fromProduct(Product product) {
            return ActorGraphInterpreter$RequestMore$.MODULE$.fromProduct(product);
        }

        public static RequestMore unapply(RequestMore requestMore) {
            return ActorGraphInterpreter$RequestMore$.MODULE$.unapply(requestMore);
        }

        public RequestMore(ActorOutputBoundary boundary2, long demand) {
            this.boundary = boundary2;
            this.demand = demand;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.productPrefix().hashCode());
            n = Statics.mix(n, Statics.anyHash(this.boundary()));
            n = Statics.mix(n, Statics.longHash(this.demand()));
            return Statics.finalizeHash(n, 2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RequestMore)) return false;
            RequestMore requestMore = (RequestMore)object;
            if (this.demand() != requestMore.demand()) return false;
            ActorOutputBoundary actorOutputBoundary = this.boundary();
            ActorOutputBoundary actorOutputBoundary2 = requestMore.boundary();
            if (actorOutputBoundary != null) {
                if (!actorOutputBoundary.equals(actorOutputBoundary2)) return false;
                return true;
            }
            if (actorOutputBoundary2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof RequestMore;
        }

        @Override
        public int productArity() {
            return 2;
        }

        @Override
        public String productPrefix() {
            return "RequestMore";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToLong(this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "boundary";
            }
            if (1 == n2) {
                return "demand";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorOutputBoundary boundary() {
            return this.boundary;
        }

        public long demand() {
            return this.demand;
        }

        @Override
        public void execute() {
            this.boundary().requestMore(this.demand());
        }

        @Override
        public GraphInterpreterShell shell() {
            return this.boundary().shell();
        }

        @Override
        public GraphStageLogic logic() {
            return this.boundary();
        }

        @Override
        public void cancel() {
        }

        public RequestMore copy(ActorOutputBoundary boundary2, long demand) {
            return new RequestMore(boundary2, demand);
        }

        public ActorOutputBoundary copy$default$1() {
            return this.boundary();
        }

        public long copy$default$2() {
            return this.demand();
        }

        public ActorOutputBoundary _1() {
            return this.boundary();
        }

        public long _2() {
            return this.demand();
        }
    }

    public static interface SimpleBoundaryEvent
    extends BoundaryEvent {
        public static int execute$(SimpleBoundaryEvent $this, int eventLimit) {
            return $this.execute(eventLimit);
        }

        @Override
        default public int execute(int eventLimit) {
            boolean wasNotShutdown = !this.shell().interpreter().isStageCompleted(this.logic());
            this.execute();
            if (wasNotShutdown) {
                this.shell().interpreter().afterStageHasRun(this.logic());
            }
            return this.shell().runBatch(eventLimit);
        }

        public GraphStageLogic logic();

        public void execute();
    }

    public static final class SubscribePending
    implements SimpleBoundaryEvent,
    Product,
    Serializable {
        private final ActorOutputBoundary boundary;

        public static SubscribePending apply(ActorOutputBoundary actorOutputBoundary) {
            return ActorGraphInterpreter$SubscribePending$.MODULE$.apply(actorOutputBoundary);
        }

        public static SubscribePending fromProduct(Product product) {
            return ActorGraphInterpreter$SubscribePending$.MODULE$.fromProduct(product);
        }

        public static SubscribePending unapply(SubscribePending subscribePending) {
            return ActorGraphInterpreter$SubscribePending$.MODULE$.unapply(subscribePending);
        }

        public SubscribePending(ActorOutputBoundary boundary2) {
            this.boundary = boundary2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SubscribePending)) return false;
            SubscribePending subscribePending = (SubscribePending)object;
            ActorOutputBoundary actorOutputBoundary = this.boundary();
            ActorOutputBoundary actorOutputBoundary2 = subscribePending.boundary();
            if (actorOutputBoundary != null) {
                if (!actorOutputBoundary.equals(actorOutputBoundary2)) return false;
                return true;
            }
            if (actorOutputBoundary2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof SubscribePending;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "SubscribePending";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "boundary";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
        }

        public ActorOutputBoundary boundary() {
            return this.boundary;
        }

        @Override
        public void execute() {
            this.boundary().subscribePending();
        }

        @Override
        public GraphInterpreterShell shell() {
            return this.boundary().shell();
        }

        @Override
        public GraphStageLogic logic() {
            return this.boundary();
        }

        @Override
        public void cancel() {
        }

        public SubscribePending copy(ActorOutputBoundary boundary2) {
            return new SubscribePending(boundary2);
        }

        public ActorOutputBoundary copy$default$1() {
            return this.boundary();
        }

        public ActorOutputBoundary _1() {
            return this.boundary();
        }
    }
}

