/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.RateExceededException;
import org.apache.pekko.stream.ThrottleMode;
import org.apache.pekko.stream.ThrottleMode$Enforcing$;
import org.apache.pekko.stream.impl.Throttle$;
import org.apache.pekko.stream.impl.Throttle$TimerKey$;
import org.apache.pekko.stream.impl.fusing.GraphStages;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.util.NanoTimeTokenBucket;
import scala.Function1;
import scala.Int$;
import scala.Predef$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxesRunTime;

@InternalApi
public class Throttle<T>
extends GraphStages.SimpleLinearGraphStage<T> {
    private final int cost;
    private final FiniteDuration per;
    private final int maximumBurst;
    private final Function1 costCalculation;
    private final ThrottleMode mode;
    public final long org$apache$pekko$stream$impl$Throttle$$nanosBetweenTokens;
    private final long effectiveMaximumBurst;

    public static int AutomaticMaximumBurst() {
        return Throttle$.MODULE$.AutomaticMaximumBurst();
    }

    public Throttle(int cost, FiniteDuration per, int maximumBurst, Function1<T, Object> costCalculation, ThrottleMode mode) {
        this.cost = cost;
        this.per = per;
        this.maximumBurst = maximumBurst;
        this.costCalculation = costCalculation;
        this.mode = mode;
        Predef$.MODULE$.require(cost > 0, Throttle::$init$$$anonfun$1);
        Predef$.MODULE$.require(per.toNanos() > 0L, Throttle::$init$$$anonfun$2);
        Predef$.MODULE$.require(per.toNanos() >= (long)cost, Throttle::$init$$$anonfun$3);
        this.org$apache$pekko$stream$impl$Throttle$$nanosBetweenTokens = per.toNanos() / (long)cost;
        this.effectiveMaximumBurst = maximumBurst == -1 ? scala.math.package$.MODULE$.max(1L, 100000000L / this.org$apache$pekko$stream$impl$Throttle$$nanosBetweenTokens) : Int$.MODULE$.int2long(maximumBurst);
        ThrottleMode throttleMode = mode;
        ThrottleMode$Enforcing$ throttleMode$Enforcing$ = ThrottleMode$Enforcing$.MODULE$;
        Predef$.MODULE$.require((throttleMode != null ? !throttleMode.equals(throttleMode$Enforcing$) : throttleMode$Enforcing$ != null) || this.effectiveMaximumBurst() >= 0L, Throttle::$init$$$anonfun$4);
    }

    public int cost() {
        return this.cost;
    }

    public FiniteDuration per() {
        return this.per;
    }

    public int maximumBurst() {
        return this.maximumBurst;
    }

    public Function1<T, Object> costCalculation() {
        return this.costCalculation;
    }

    public ThrottleMode mode() {
        return this.mode;
    }

    public long effectiveMaximumBurst() {
        return this.effectiveMaximumBurst;
    }

    @Override
    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new InHandler(this){
            private final NanoTimeTokenBucket tokenBucket;
            private Object currentElement;
            private final /* synthetic */ Throttle $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super($outer.shape());
                this.tokenBucket = new NanoTimeTokenBucket($outer.effectiveMaximumBurst(), $outer.org$apache$pekko$stream$impl$Throttle$$nanosBetweenTokens);
                this.setHandlers($outer.in(), $outer.out(), this);
            }

            public void preStart() {
                this.tokenBucket.init();
            }

            public void onUpstreamFinish() {
                if (!this.isAvailable(this.$outer.out()) || !this.isTimerActive(Throttle$TimerKey$.MODULE$)) {
                    this.completeStage();
                    return;
                }
            }

            public void onPush() {
                T elem = this.grab(this.$outer.in());
                int cost = BoxesRunTime.unboxToInt(this.$outer.costCalculation().apply(elem));
                long delayNanos = this.tokenBucket.offer(Int$.MODULE$.int2long(cost));
                if (delayNanos == 0L) {
                    this.push(this.$outer.out(), elem);
                    return;
                }
                if (this.$outer.mode() == ThrottleMode$Enforcing$.MODULE$) {
                    this.failStage(new RateExceededException("Maximum throttle throughput exceeded."));
                    return;
                }
                this.currentElement = elem;
                this.scheduleOnce((Object)Throttle$TimerKey$.MODULE$, new package.DurationLong(package$.MODULE$.DurationLong(delayNanos)).nanos());
            }

            public void onPull() {
                this.pull(this.$outer.in());
            }

            public void onTimer(Object key2) {
                this.push(this.$outer.out(), this.currentElement);
                this.currentElement = null;
                if (this.isClosed(this.$outer.in())) {
                    this.completeStage();
                    return;
                }
            }
        };
    }

    public String toString() {
        return "Throttle";
    }

    private static final Object $init$$$anonfun$1() {
        return "cost must be > 0";
    }

    private static final Object $init$$$anonfun$2() {
        return "per time must be > 0";
    }

    private static final Object $init$$$anonfun$3() {
        return "Rates larger than 1 unit / nanosecond are not supported";
    }

    private static final Object $init$$$anonfun$4() {
        return "maximumBurst must be > 0 in Enforcing mode";
    }
}

