/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import org.apache.pekko.NotUsed;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.FlowShape;
import org.apache.pekko.stream.Graph;
import org.apache.pekko.stream.SinkShape;
import org.apache.pekko.stream.scaladsl.Flow;
import org.apache.pekko.stream.scaladsl.Sink;
import org.apache.pekko.stream.scaladsl.SubFlow;
import scala.Function1;

@InternalApi
public class SubFlowImpl<In, Out, Mat, F, C>
implements SubFlow<Out, Mat, F, C> {
    private final Flow subFlow;
    private final MergeBack<In, F> mergeBackFunction;
    private final Function1<Sink<In, NotUsed>, C> finishFunction;

    public SubFlowImpl(Flow<In, Out, NotUsed> subFlow, MergeBack<In, F> mergeBackFunction, Function1<Sink<In, NotUsed>, C> finishFunction) {
        this.subFlow = subFlow;
        this.mergeBackFunction = mergeBackFunction;
        this.finishFunction = finishFunction;
    }

    public Flow<In, Out, NotUsed> subFlow() {
        return this.subFlow;
    }

    @Override
    public <T, Mat2> SubFlow<T, Mat, F, C> via(Graph<FlowShape<Out, T>, Mat2> flow) {
        return new SubFlowImpl<In, Out, Mat, F, C>(this.subFlow().via((Graph)flow), this.mergeBackFunction, this.finishFunction);
    }

    @Override
    public SubFlow<Out, Mat, F, C> withAttributes(Attributes attr) {
        return new SubFlowImpl<In, Out, Mat, F, C>(this.subFlow().withAttributes(attr), this.mergeBackFunction, this.finishFunction);
    }

    @Override
    public SubFlow<Out, Mat, F, C> addAttributes(Attributes attr) {
        return new SubFlowImpl<In, Out, Mat, F, C>(this.subFlow().addAttributes(attr), this.mergeBackFunction, this.finishFunction);
    }

    @Override
    public SubFlow<Out, Mat, F, C> named(String name) {
        return new SubFlowImpl<In, Out, Mat, F, C>(this.subFlow().named(name), this.mergeBackFunction, this.finishFunction);
    }

    @Override
    public SubFlow<Out, Mat, F, C> async() {
        return new SubFlowImpl<In, Out, Mat, F, C>(this.subFlow().async(), this.mergeBackFunction, this.finishFunction);
    }

    @Override
    public F mergeSubstreamsWithParallelism(int breadth) {
        return this.mergeBackFunction.apply(this.subFlow(), breadth);
    }

    @Override
    public <M> C to(Graph<SinkShape<Out>, M> sink) {
        return this.finishFunction.apply((Sink<In, NotUsed>)this.subFlow().to(sink));
    }

    public static interface MergeBack<In, F> {
        public <T> F apply(Flow<In, T, NotUsed> var1, int var2);
    }
}

