/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.Props;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.ActorAttributes;
import org.apache.pekko.stream.Attributes;
import org.apache.pekko.stream.InPort;
import org.apache.pekko.stream.OutPort;
import org.apache.pekko.stream.Shape;
import org.apache.pekko.stream.impl.PhaseIsland;
import org.apache.pekko.stream.impl.PhasedFusingActorMaterializer;
import org.apache.pekko.stream.impl.PhasedFusingActorMaterializer$;
import org.apache.pekko.stream.impl.Stages$DefaultAttributes$;
import org.apache.pekko.stream.impl.StreamLayout;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter;
import org.apache.pekko.stream.impl.fusing.ActorGraphInterpreter$;
import org.apache.pekko.stream.impl.fusing.GraphInterpreter;
import org.apache.pekko.stream.impl.fusing.GraphInterpreterShell;
import org.apache.pekko.stream.impl.fusing.GraphStageModule;
import org.apache.pekko.stream.stage.GraphStageLogic;
import org.apache.pekko.stream.stage.GraphStageWithMaterializedValue;
import org.apache.pekko.stream.stage.InHandler;
import org.apache.pekko.stream.stage.OutHandler;
import org.apache.pekko.util.OptionVal$;
import org.apache.pekko.util.OptionVal$Some$;
import org.reactivestreams.Publisher;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.math.package$;
import scala.reflect.ClassTag$;

@InternalApi
public final class GraphStageIsland
implements PhaseIsland<GraphStageLogic> {
    private final Attributes effectiveAttributes;
    private final PhasedFusingActorMaterializer materializer;
    private final String islandName;
    private final Function1 subflowFuser;
    private final GraphStageLogic[] logicArrayType;
    private final ArrayList<GraphStageLogic> logics;
    private GraphInterpreter.Connection[] connections;
    private int maxConnections;
    private List<GraphInterpreter.Connection> outConnections;
    private String fullIslandName;
    private final GraphInterpreterShell shell;

    public GraphStageIsland(Attributes effectiveAttributes, PhasedFusingActorMaterializer materializer, String islandName, Function1 subflowFuser) {
        this.effectiveAttributes = effectiveAttributes;
        this.materializer = materializer;
        this.islandName = islandName;
        this.subflowFuser = subflowFuser;
        this.logicArrayType = (GraphStageLogic[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(GraphStageLogic.class));
        this.logics = new ArrayList(16);
        this.connections = new GraphInterpreter.Connection[16];
        this.maxConnections = 0;
        this.outConnections = scala.package$.MODULE$.Nil();
        OptionVal$.MODULE$.None();
        this.fullIslandName = null;
        this.shell = new GraphInterpreterShell(null, null, effectiveAttributes, materializer);
    }

    public GraphInterpreterShell shell() {
        return this.shell;
    }

    @Override
    public String name() {
        return "Fusing GraphStages phase";
    }

    @Override
    public Tuple2<GraphStageLogic, Object> materializeAtomic(StreamLayout.AtomicModule<Shape, Object> mod, Attributes attributes) {
        Tuple2<GraphStageLogic, Object> matAndLogic;
        block0: {
            GraphStageModule stageModule = (GraphStageModule)mod;
            GraphStageWithMaterializedValue stage = stageModule.stage();
            matAndLogic = stage.createLogicAndMaterializedValue(attributes, this.materializer);
            GraphStageLogic logic = matAndLogic._1();
            logic.originalStage_$eq((GraphStageWithMaterializedValue)OptionVal$Some$.MODULE$.apply(stage));
            logic.attributes_$eq(attributes);
            this.logics.add(logic);
            logic.stageId_$eq(this.logics.size() - 1);
            String string2 = this.fullIslandName;
            OptionVal$.MODULE$.None();
            String string3 = string2;
            if (null != null ? !((Object)null).equals(string3) : string3 != null) break block0;
            Attributes attributes2 = logic.attributes();
            this.fullIslandName = (String)OptionVal$Some$.MODULE$.apply(new StringBuilder(1).append(this.islandName).append("-").append(attributes2.nameForActorRef(attributes2.nameForActorRef$default$1())).toString());
        }
        return matAndLogic;
    }

    public GraphInterpreter.Connection conn(int slot) {
        GraphInterpreter.Connection c2;
        GraphInterpreter.Connection c;
        this.maxConnections = package$.MODULE$.max(slot, this.maxConnections);
        if (this.maxConnections >= this.connections.length) {
            this.connections = Arrays.copyOf(this.connections, this.connections.length * 2);
        }
        if ((c = this.connections[slot]) != null) {
            return c;
        }
        this.connections[slot] = c2 = new GraphInterpreter.Connection(0, null, null, null, null);
        return c2;
    }

    public GraphInterpreter.Connection outConn() {
        GraphInterpreter.Connection connection = new GraphInterpreter.Connection(0, null, null, null, null);
        this.outConnections = this.outConnections.$colon$colon(connection);
        return connection;
    }

    @Override
    public void assignPort(InPort in, int slot, GraphStageLogic logic) {
        GraphInterpreter.Connection connection = this.conn(slot);
        connection.inOwner_$eq(logic);
        connection.id_$eq(slot);
        connection.inHandler_$eq((InHandler)logic.handlers()[in.id()]);
        if (connection.inHandler() == null) {
            this.failOnMissingHandler(logic);
        }
        logic.portToConn()[in.id()] = connection;
    }

    @Override
    public void assignPort(OutPort out, int slot, GraphStageLogic logic) {
        GraphInterpreter.Connection connection = this.conn(slot);
        connection.outOwner_$eq(logic);
        connection.id_$eq(slot);
        connection.outHandler_$eq((OutHandler)logic.handlers()[logic.inCount() + out.id()]);
        if (connection.outHandler() == null) {
            this.failOnMissingHandler(logic);
        }
        logic.portToConn()[logic.inCount() + out.id()] = connection;
    }

    @Override
    public Publisher<Object> createPublisher(OutPort out, GraphStageLogic logic) {
        GraphInterpreter.Connection connection;
        ActorGraphInterpreter.ActorOutputBoundary boundary2 = new ActorGraphInterpreter.ActorOutputBoundary(this.shell(), out.toString());
        this.logics.add(boundary2);
        boundary2.stageId_$eq(this.logics.size() - 1);
        boundary2.attributes_$eq(logic.attributes().and(Stages$DefaultAttributes$.MODULE$.outputBoundary()));
        boundary2.portToConn()[boundary2.in().id()] = connection = this.outConn();
        connection.inHandler_$eq((InHandler)boundary2.handlers()[0]);
        connection.inOwner_$eq(boundary2);
        connection.outOwner_$eq(logic);
        connection.id_$eq(-1);
        connection.outHandler_$eq((OutHandler)logic.handlers()[logic.inCount() + out.id()]);
        if (connection.outHandler() == null) {
            this.failOnMissingHandler(logic);
        }
        logic.portToConn()[logic.inCount() + out.id()] = connection;
        return boundary2.publisher();
    }

    @Override
    public void takePublisher(int slot, Publisher<Object> publisher, Attributes attributes) {
        GraphInterpreter.Connection connection = this.conn(slot);
        int bufferSize = ((Attributes.InputBuffer)connection.inOwner().attributes().mandatoryAttribute(ClassTag$.MODULE$.apply(Attributes.InputBuffer.class))).max();
        ActorGraphInterpreter.BatchingActorInputBoundary boundary2 = new ActorGraphInterpreter.BatchingActorInputBoundary(bufferSize, this.shell(), publisher, "publisher.in");
        this.logics.add(boundary2);
        boundary2.stageId_$eq(this.logics.size() - 1);
        boundary2.attributes_$eq(connection.inOwner().attributes().and(Stages$DefaultAttributes$.MODULE$.inputBoundary()));
        boundary2.portToConn()[boundary2.out().id() + boundary2.inCount()] = connection;
        connection.outHandler_$eq((OutHandler)boundary2.handlers()[0]);
        connection.outOwner_$eq(boundary2);
    }

    @Override
    public void onIslandReady() {
        String string2;
        String n;
        int totalConnections = this.maxConnections + this.outConnections.size() + 1;
        GraphInterpreter.Connection[] finalConnections = Arrays.copyOf(this.connections, totalConnections);
        List outConns = this.outConnections;
        for (int i = this.maxConnections + 1; i < totalConnections; ++i) {
            GraphInterpreter.Connection conn = (GraphInterpreter.Connection)outConns.head();
            outConns = (List)outConns.tail();
            if (conn.inHandler() == null) {
                this.failOnMissingHandler(conn.inOwner());
            } else if (conn.outHandler() == null) {
                this.failOnMissingHandler(conn.outOwner());
            }
            finalConnections[i] = conn;
            conn.id_$eq(i);
        }
        this.shell().connections_$eq(finalConnections);
        this.shell().logics_$eq(this.logics.toArray(this.logicArrayType));
        Function1 function1 = this.subflowFuser;
        Function1 function12 = (Function1)OptionVal$Some$.MODULE$.unapply(function1);
        if (!OptionVal$.MODULE$.isEmpty$extension(function12)) {
            Function1 function13;
            Function1 fuseIntoExistingInterpreter = function13 = (Function1)OptionVal$.MODULE$.get$extension(function12);
            fuseIntoExistingInterpreter.apply(this.shell());
            return;
        }
        Props props = ActorGraphInterpreter$.MODULE$.props(this.shell()).withDispatcher(((ActorAttributes.Dispatcher)this.effectiveAttributes.mandatoryAttribute(ClassTag$.MODULE$.apply(ActorAttributes.Dispatcher.class))).dispatcher()).withMailbox(PhasedFusingActorMaterializer$.MODULE$.MailboxConfigName());
        String string3 = this.fullIslandName;
        String string4 = (String)OptionVal$Some$.MODULE$.unapply(string3);
        String actorName = !OptionVal$.MODULE$.isEmpty$extension(string4) ? (n = (string2 = (String)OptionVal$.MODULE$.get$extension(string4))) : this.islandName;
        ActorRef ref = this.materializer.actorOf(props, actorName);
        if (PhasedFusingActorMaterializer$.MODULE$.Debug()) {
            Predef$.MODULE$.println(new StringBuilder(29).append("Spawned actor [").append(ref).append("] with shell: ").append(this.shell()).toString());
            return;
        }
    }

    private void failOnMissingHandler(GraphStageLogic logic) {
        String string2;
        Object object = Predef$.MODULE$.genericArrayOps(logic.handlers());
        int missingHandlerIdx = ArrayOps$.MODULE$.indexWhere$extension(object, (Function1<Object, boolean> & Serializable)_$5 -> _$5 == null, ArrayOps$.MODULE$.indexWhere$default$2$extension(object));
        boolean isIn = missingHandlerIdx < logic.inCount();
        GraphStageWithMaterializedValue graphStageWithMaterializedValue = logic.originalStage();
        GraphStageWithMaterializedValue graphStageWithMaterializedValue2 = (GraphStageWithMaterializedValue)OptionVal$Some$.MODULE$.unapply(graphStageWithMaterializedValue);
        if (!OptionVal$.MODULE$.isEmpty$extension(graphStageWithMaterializedValue2)) {
            GraphStageWithMaterializedValue graphStageWithMaterializedValue3;
            GraphStageWithMaterializedValue stage = graphStageWithMaterializedValue3 = (GraphStageWithMaterializedValue)OptionVal$.MODULE$.get$extension(graphStageWithMaterializedValue2);
            string2 = isIn ? new StringBuilder(10).append("in port [").append(((Shape)stage.shape()).inlets().apply(missingHandlerIdx)).append("]").toString() : new StringBuilder(10).append("out port [").append(((Shape)stage.shape()).outlets().apply(missingHandlerIdx - logic.inCount())).toString();
        } else {
            string2 = isIn ? new StringBuilder(13).append("in port id [").append(missingHandlerIdx).append("]").toString() : new StringBuilder(14).append("out port id [").append(missingHandlerIdx).append("]").toString();
        }
        String portLabel = string2;
        throw new IllegalStateException(new StringBuilder(148).append("No handler defined in stage [").append(logic.toString()).append("] for ").append(portLabel).append(".").append(" All inlets and outlets must be assigned a handler with setHandler in the constructor of your graph stage logic.").toString());
    }

    public String toString() {
        return "GraphStagePhase";
    }
}

