/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.annotation.InternalStableApi;
import org.apache.pekko.stream.impl.Buffer;
import org.apache.pekko.stream.impl.FixedSizeBuffer$;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@InternalApi
public final class FixedSizeBuffer {
    @InternalStableApi
    public static <T> FixedSizeBuffer<T> apply(int n) {
        return FixedSizeBuffer$.MODULE$.apply(n);
    }

    public static abstract class FixedSizeBuffer<T>
    implements Buffer<T> {
        private final int capacity;
        private final Object[] buffer;
        private long readIdx;
        private long writeIdx;

        public FixedSizeBuffer(int capacity) {
            this.capacity = capacity;
            this.buffer = new Object[capacity];
            this.readIdx = 0L;
            this.writeIdx = 0L;
        }

        @Override
        public int capacity() {
            return this.capacity;
        }

        public String toString() {
            return new StringBuilder(14).append("Buffer(").append(this.capacity()).append(", ").append(this.readIdx()).append(", ").append(this.writeIdx()).append(")(").append(((IterableOnceOps)new RichLong(Predef$.MODULE$.longWrapper(this.readIdx())).until(BoxesRunTime.boxToLong(this.writeIdx())).map((Function1<Object, Object> & Serializable)idx -> this.toString$$anonfun$1(BoxesRunTime.unboxToLong(idx)))).mkString(", ")).append(")").toString();
        }

        public long readIdx() {
            return this.readIdx;
        }

        public void readIdx_$eq(long x$1) {
            this.readIdx = x$1;
        }

        public long writeIdx() {
            return this.writeIdx;
        }

        public void writeIdx_$eq(long x$1) {
            this.writeIdx = x$1;
        }

        @Override
        public int used() {
            return (int)(this.writeIdx() - this.readIdx());
        }

        @Override
        public boolean isFull() {
            return this.used() == this.capacity();
        }

        public boolean nonFull() {
            return this.used() < this.capacity();
        }

        public int remainingCapacity() {
            return this.capacity() - this.used();
        }

        @Override
        public boolean isEmpty() {
            return this.used() == 0;
        }

        @Override
        public boolean nonEmpty() {
            return this.used() != 0;
        }

        @Override
        public void enqueue(T elem) {
            this.put(this.writeIdx(), elem, false);
            this.writeIdx_$eq(this.writeIdx() + 1L);
        }

        public abstract int toOffset(long var1, boolean var3);

        private void put(long idx, T elem, boolean maintenance) {
            this.buffer[this.toOffset((long)idx, (boolean)maintenance)] = elem;
        }

        private T get(long idx) {
            return (T)this.buffer[this.toOffset(idx, false)];
        }

        @Override
        public T peek() {
            return this.get(this.readIdx());
        }

        @Override
        public T dequeue() {
            T result = this.get(this.readIdx());
            this.dropHead();
            return result;
        }

        @Override
        public void clear() {
            Arrays.fill(this.buffer, null);
            this.readIdx_$eq(0L);
            this.writeIdx_$eq(0L);
        }

        @Override
        public void dropHead() {
            this.put(this.readIdx(), null, true);
            this.readIdx_$eq(this.readIdx() + 1L);
        }

        @Override
        public void dropTail() {
            this.writeIdx_$eq(this.writeIdx() - 1L);
            this.put(this.writeIdx(), null, false);
        }

        private final /* synthetic */ Object toString$$anonfun$1(long idx) {
            return this.get(idx);
        }
    }

    public static final class ModuloFixedSizeBuffer<T>
    extends FixedSizeBuffer<T> {
        public ModuloFixedSizeBuffer(int _size) {
            super(_size);
        }

        @Override
        public int toOffset(long idx, boolean maintenance) {
            if (maintenance && this.readIdx() > Integer.MAX_VALUE) {
                int shift = Integer.MAX_VALUE - Integer.MAX_VALUE % this.capacity();
                this.readIdx_$eq(this.readIdx() - (long)shift);
                this.writeIdx_$eq(this.writeIdx() - (long)shift);
            }
            return (int)(idx % (long)this.capacity());
        }
    }

    public static final class PowerOfTwoFixedSizeBuffer<T>
    extends FixedSizeBuffer<T> {
        private final int Mask = this.capacity() - 1;

        public PowerOfTwoFixedSizeBuffer(int _size) {
            super(_size);
        }

        @Override
        public int toOffset(long idx, boolean maintenance) {
            return (int)idx & this.Mask;
        }
    }
}

