/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.impl;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.stream.impl.ActorSubscriberMessage;
import org.apache.pekko.stream.impl.ActorSubscriberMessage$OnComplete$;
import org.apache.pekko.stream.impl.ActorSubscriberMessage$OnError$;
import org.apache.pekko.stream.impl.ActorSubscriberMessage$OnNext$;
import org.apache.pekko.stream.impl.ActorSubscriberMessage$OnSubscribe$;
import org.apache.pekko.stream.impl.DefaultInputTransferStates;
import org.apache.pekko.stream.impl.Inputs;
import org.apache.pekko.stream.impl.Pump;
import org.apache.pekko.stream.impl.ReactiveStreamsCompliance$;
import org.apache.pekko.stream.impl.SubReceive;
import org.apache.pekko.stream.impl.TransferState;
import org.reactivestreams.Subscription;
import scala.Function1;
import scala.Int$;
import scala.PartialFunction;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@InternalApi
public abstract class BatchingInputBuffer
implements Inputs,
DefaultInputTransferStates {
    private TransferState NeedsInput;
    private TransferState NeedsInputOrComplete;
    private final int size;
    private final Pump pump;
    private Subscription upstream;
    private final Object[] inputBuffer;
    private int inputBufferElements;
    private int nextInputElementCursor;
    private boolean upstreamCompleted;
    private final int IndexMask;
    private int batchRemaining;
    private final SubReceive subreceive;

    public BatchingInputBuffer(int size, Pump pump) {
        this.size = size;
        this.pump = pump;
        DefaultInputTransferStates.$init$(this);
        if (size < 1) {
            throw new IllegalArgumentException(new StringBuilder(36).append("buffer size must be positive (was: ").append(size).append(")").toString());
        }
        if ((size & size - 1) != 0) {
            throw new IllegalArgumentException(new StringBuilder(42).append("buffer size must be a power of two (was: ").append(size).append(")").toString());
        }
        this.inputBuffer = new Object[size];
        this.inputBufferElements = 0;
        this.nextInputElementCursor = 0;
        this.upstreamCompleted = false;
        this.IndexMask = size - 1;
        this.batchRemaining = this.requestBatchSize();
        this.subreceive = new SubReceive(this.waitingForUpstream());
        Statics.releaseFence();
    }

    @Override
    public TransferState NeedsInput() {
        return this.NeedsInput;
    }

    @Override
    public TransferState NeedsInputOrComplete() {
        return this.NeedsInputOrComplete;
    }

    @Override
    public void org$apache$pekko$stream$impl$DefaultInputTransferStates$_setter_$NeedsInput_$eq(TransferState x$0) {
        this.NeedsInput = x$0;
    }

    @Override
    public void org$apache$pekko$stream$impl$DefaultInputTransferStates$_setter_$NeedsInputOrComplete_$eq(TransferState x$0) {
        this.NeedsInputOrComplete = x$0;
    }

    public int size() {
        return this.size;
    }

    public Pump pump() {
        return this.pump;
    }

    private int requestBatchSize() {
        return package$.MODULE$.max(1, this.inputBuffer.length / 2);
    }

    public String toString() {
        return new StringBuilder(58).append("BatchingInputBuffer(size=").append(this.size()).append(", elems=").append(this.inputBufferElements).append(", completed=").append(this.upstreamCompleted).append(", remaining=").append(this.batchRemaining).append(")").toString();
    }

    @Override
    public SubReceive subreceive() {
        return this.subreceive;
    }

    @Override
    public Object dequeueInputElement() {
        Object elem = this.inputBuffer[this.nextInputElementCursor];
        this.inputBuffer[this.nextInputElementCursor] = null;
        --this.batchRemaining;
        if (this.batchRemaining == 0 && !this.upstreamCompleted) {
            this.upstream.request(Int$.MODULE$.int2long(this.requestBatchSize()));
            this.batchRemaining = this.requestBatchSize();
        }
        --this.inputBufferElements;
        ++this.nextInputElementCursor;
        this.nextInputElementCursor &= this.IndexMask;
        return elem;
    }

    public final void enqueueInputElement(Object elem) {
        if (this.isOpen()) {
            if (this.inputBufferElements == this.size()) {
                throw new IllegalStateException("Input buffer overrun");
            }
            this.inputBuffer[this.nextInputElementCursor + this.inputBufferElements & this.IndexMask] = elem;
            ++this.inputBufferElements;
        }
        this.pump().pump();
    }

    @Override
    public void cancel() {
        if (!this.upstreamCompleted) {
            this.upstreamCompleted = true;
            if (this.upstream != null) {
                this.upstream.cancel();
            }
            this.clear();
            return;
        }
    }

    @Override
    public boolean isClosed() {
        return this.upstreamCompleted;
    }

    private void clear() {
        Arrays.fill(this.inputBuffer, 0, this.inputBuffer.length, null);
        this.inputBufferElements = 0;
    }

    @Override
    public boolean inputsDepleted() {
        return this.upstreamCompleted && this.inputBufferElements == 0;
    }

    @Override
    public boolean inputsAvailable() {
        return this.inputBufferElements > 0;
    }

    public void onComplete() {
        this.upstreamCompleted = true;
        this.subreceive().become(this.completed());
        this.pump().pump();
    }

    public void onSubscribe(Subscription subscription) {
        ReactiveStreamsCompliance$.MODULE$.requireNonNullSubscription(subscription);
        if (this.upstreamCompleted) {
            subscription.cancel();
        } else {
            this.upstream = subscription;
            this.upstream.request(Int$.MODULE$.int2long(this.inputBuffer.length));
            this.subreceive().become(this.upstreamRunning());
        }
        this.pump().gotUpstreamSubscription();
    }

    public void onError(Throwable e) {
        this.upstreamCompleted = true;
        this.subreceive().become(this.completed());
        this.inputOnError(e);
    }

    public PartialFunction<Object, BoxedUnit> waitingForUpstream() {
        return new Serializable(this){
            private final /* synthetic */ BatchingInputBuffer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (ActorSubscriberMessage$OnComplete$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ActorSubscriberMessage.OnSubscribe) {
                    Subscription subscription;
                    ActorSubscriberMessage.OnSubscribe onSubscribe = ActorSubscriberMessage$OnSubscribe$.MODULE$.unapply((ActorSubscriberMessage.OnSubscribe)object);
                    Subscription subscription2 = subscription = onSubscribe._1();
                    return true;
                }
                if (object instanceof ActorSubscriberMessage.OnError) {
                    Throwable throwable;
                    ActorSubscriberMessage.OnError onError2 = ActorSubscriberMessage$OnError$.MODULE$.unapply((ActorSubscriberMessage.OnError)object);
                    Throwable cause = throwable = onError2._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (ActorSubscriberMessage$OnComplete$.MODULE$.equals(object)) {
                    this.$outer.onComplete();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ActorSubscriberMessage.OnSubscribe) {
                    Subscription subscription;
                    ActorSubscriberMessage.OnSubscribe onSubscribe = ActorSubscriberMessage$OnSubscribe$.MODULE$.unapply((ActorSubscriberMessage.OnSubscribe)object);
                    Subscription subscription2 = subscription = onSubscribe._1();
                    this.$outer.onSubscribe(subscription2);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ActorSubscriberMessage.OnError) {
                    Throwable throwable;
                    ActorSubscriberMessage.OnError onError2 = ActorSubscriberMessage$OnError$.MODULE$.unapply((ActorSubscriberMessage.OnError)object);
                    Throwable cause = throwable = onError2._1();
                    this.$outer.onError(cause);
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> upstreamRunning() {
        return new Serializable(this){
            private final /* synthetic */ BatchingInputBuffer $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ActorSubscriberMessage.OnNext) {
                    Object object2;
                    ActorSubscriberMessage.OnNext onNext = ActorSubscriberMessage$OnNext$.MODULE$.unapply((ActorSubscriberMessage.OnNext)object);
                    Object element = object2 = onNext._1();
                    return true;
                }
                if (ActorSubscriberMessage$OnComplete$.MODULE$.equals(object)) {
                    return true;
                }
                if (object instanceof ActorSubscriberMessage.OnError) {
                    Throwable throwable;
                    ActorSubscriberMessage.OnError onError2 = ActorSubscriberMessage$OnError$.MODULE$.unapply((ActorSubscriberMessage.OnError)object);
                    Throwable cause = throwable = onError2._1();
                    return true;
                }
                if (object instanceof ActorSubscriberMessage.OnSubscribe) {
                    Subscription subscription;
                    ActorSubscriberMessage.OnSubscribe onSubscribe = ActorSubscriberMessage$OnSubscribe$.MODULE$.unapply((ActorSubscriberMessage.OnSubscribe)object);
                    Subscription subscription2 = subscription = onSubscribe._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ActorSubscriberMessage.OnNext) {
                    Object object2;
                    ActorSubscriberMessage.OnNext onNext = ActorSubscriberMessage$OnNext$.MODULE$.unapply((ActorSubscriberMessage.OnNext)object);
                    Object element = object2 = onNext._1();
                    this.$outer.enqueueInputElement(element);
                    return BoxedUnit.UNIT;
                }
                if (ActorSubscriberMessage$OnComplete$.MODULE$.equals(object)) {
                    this.$outer.onComplete();
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ActorSubscriberMessage.OnError) {
                    Throwable throwable;
                    ActorSubscriberMessage.OnError onError2 = ActorSubscriberMessage$OnError$.MODULE$.unapply((ActorSubscriberMessage.OnError)object);
                    Throwable cause = throwable = onError2._1();
                    this.$outer.onError(cause);
                    return BoxedUnit.UNIT;
                }
                if (object instanceof ActorSubscriberMessage.OnSubscribe) {
                    Subscription subscription;
                    ActorSubscriberMessage.OnSubscribe onSubscribe = ActorSubscriberMessage$OnSubscribe$.MODULE$.unapply((ActorSubscriberMessage.OnSubscribe)object);
                    Subscription subscription2 = subscription = onSubscribe._1();
                    subscription2.cancel();
                    return BoxedUnit.UNIT;
                }
                return function1.apply(x);
            }
        };
    }

    public PartialFunction<Object, BoxedUnit> completed() {
        return new Serializable(){

            public final boolean isDefinedAt(Object x) {
                Object object = x;
                if (object instanceof ActorSubscriberMessage.OnSubscribe) {
                    ActorSubscriberMessage.OnSubscribe onSubscribe = ActorSubscriberMessage$OnSubscribe$.MODULE$.unapply((ActorSubscriberMessage.OnSubscribe)object);
                    Subscription subscription = onSubscribe._1();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Object x, Function1 function1) {
                Object object = x;
                if (object instanceof ActorSubscriberMessage.OnSubscribe) {
                    ActorSubscriberMessage.OnSubscribe onSubscribe = ActorSubscriberMessage$OnSubscribe$.MODULE$.unapply((ActorSubscriberMessage.OnSubscribe)object);
                    Subscription subscription = onSubscribe._1();
                    throw new IllegalStateException("onSubscribe called after onError or onComplete");
                }
                return function1.apply(x);
            }
        };
    }

    public void inputOnError(Throwable e) {
        this.clear();
    }
}

