/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.stream.connectors.csv.javadsl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.pekko.stream.connectors.csv.impl.CsvToMapAsStringsJavaStage;
import org.apache.pekko.stream.connectors.csv.impl.CsvToMapJavaStage;
import org.apache.pekko.stream.javadsl.Flow;
import org.apache.pekko.util.ByteString;

public class CsvToMap {
    public static Flow<Collection<ByteString>, Map<String, ByteString>, ?> toMap() {
        return CsvToMap.toMap(StandardCharsets.UTF_8);
    }

    public static Flow<Collection<ByteString>, Map<String, ByteString>, ?> toMap(Charset charset) {
        return Flow.fromGraph(new CsvToMapJavaStage(Optional.empty(), charset, false, Optional.empty(), Optional.empty()));
    }

    public static Flow<Collection<ByteString>, Map<String, String>, ?> toMapAsStrings(Charset charset) {
        return Flow.fromGraph(new CsvToMapAsStringsJavaStage(Optional.empty(), charset, false, Optional.empty(), Optional.empty()));
    }

    public static Flow<Collection<ByteString>, Map<String, ByteString>, ?> toMapCombineAll(Charset charset, Optional<ByteString> optional, Optional<String> optional2) {
        return Flow.fromGraph(new CsvToMapJavaStage(Optional.empty(), charset, true, optional, optional2));
    }

    public static Flow<Collection<ByteString>, Map<String, String>, ?> toMapAsStringsCombineAll(Charset charset, Optional<String> optional, Optional<String> optional2) {
        return Flow.fromGraph(new CsvToMapAsStringsJavaStage(Optional.empty(), charset, true, optional, optional2));
    }

    public static Flow<Collection<ByteString>, Map<String, ByteString>, ?> withHeaders(String ... stringArray) {
        return Flow.fromGraph(new CsvToMapJavaStage(Optional.of(Arrays.asList(stringArray)), StandardCharsets.UTF_8, false, Optional.empty(), Optional.empty()));
    }

    public static Flow<Collection<ByteString>, Map<String, String>, ?> withHeadersAsStrings(Charset charset, String ... stringArray) {
        return Flow.fromGraph(new CsvToMapAsStringsJavaStage(Optional.of(Arrays.asList(stringArray)), charset, false, Optional.empty(), Optional.empty()));
    }
}

